package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 客户经营-经营计划明细-参与者
 *
 * @author duwh
 * @date 2022/11/15
 */
@Entity
@Table(name = "crm_customer_operation_plan_detail_member", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_plan_detail_member", comment = "经营计划明细-参与者")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOperationPlanDetailMemberDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = 3973413763244270136L;

    @Comment("客户经营主键 crm_customer_operation.id")
    @Column()
    private Long operId;

    @Comment("经营计划明细主键 crm_customer_operation_plan_detail.id")
    @Column()
    private Long planDetailId;

    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name="planDetailId",referencedColumnName="id",insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private CrmOperationPlanDetailDO planDetailObj;

    @Comment("用户id")
    @Column()
    @FieldUpdateLog(fieldName = "参与者", selectionKey = "USER")
    @FieldCreateLog(fieldName = "参与者", selectionKey = "USER")
    private Long userId;

    @Comment("用户名字 冗余")
    @Column()
    private String userName;
    @Comment("用户头像 冗余")
    @Column()
    private String userLogo;

    @Comment("授权开始时间")
    @Column()
    private LocalDateTime startTime;

    @Comment("授权开始结束")
    @Column()
    private LocalDateTime endTime;

    @Column(
        name = "disabled_flag",
        columnDefinition = "int(10) default '0' comment '禁用标记，0：未禁用，1：已禁用' "
    )
    private Integer disabledFlag = 0;

    @Column(
        name = "read_flag",
        columnDefinition = "int(10) default '0' comment '已读标记，0：未读，1：已读' "
    )
    private Integer readFlag = 0;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    @Comment("拓展5")
    @Column()
    private String ext5;


    public CrmOperationPlanDetailMemberDO() {
    }

    public void copy(CrmOperationPlanDetailMemberDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
