package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serial;
import java.time.LocalDateTime;

/**
 * 客户经营-经营计划模板明细表
 *
 * @author duwh
 * @date 2022/11/15
 */
@Entity
@Table(name = "crm_customer_operation_plan_temp_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_plan_temp_detail", comment = "客户经营-经营计划模板明细")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOperationPlanTempDetailDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = -7582433185722132802L;

    @Comment("模板主表主键")
    @Column()
    private Long tempId;

    @Comment("计划名称")
    @Column()
    private String planName;

    @Comment("计划内容")
    @Column()
    private String planContent;

    @Comment("开始时间")
    @Column()
    private LocalDateTime startTime;

    @Comment("结束时间")
    @Column()
    private LocalDateTime endTime;

    @Comment("优先级 udc[crm:oper_plan:priority]")
    @Column()
    private String priority;

    @Comment("状态 udc[crm:oper_plan:status]")
    @Column()
    private String status;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    @Comment("拓展5")
    @Column()
    private String ext5;


    public CrmOperationPlanTempDetailDO() {
    }

    public void copy(CrmOperationPlanTempDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
