package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 商机（外包费用）
 *
 * @author duwh
 * @date 2022/09/07
 */
@Entity
@Table(name = "crm_opportunity_out_cost", indexes = {
        @Index(name = "oppo_index", columnList = "oppo_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_out_cost", comment = "商机（外包）费用表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityOutCostDO extends BaseModel {

    @Comment("商机ID")
    @Column(name = "oppo_id")
    private Long oppoId;

    @Comment("tw4.0商机外包费用ID")
    @Column(name = "out_cost_id_v4")
    private Long outCostIdV4;

    @Comment("排序")
    @Column()
    private Integer sortNo;

    @Comment("激活状态")
    @Column()
    private String activataStatus;

    @Comment("审批状态")
    @Column()
    private String approvalStatus;

    @Comment("费用描述")
    @Column()
    private String costDesc;

    @Comment("申请人id")
    @Column()
    private Long applyUserId;

    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;


}
