package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Author carl.wang
 * @Description 市场计划表
 * @Date
 **/
@Entity
@Table(name = "crm_opportunity_sales", indexes = {
        @Index(name = "oppo_index", columnList = "oppo_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_sales", comment = "商机销售清单表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunitySalesDO extends BaseModel {

    @Comment("商机ID")
    @Column(name = "oppo_id")
    private Long oppoId;

    @Comment("tw4.0商机销售清单ID")
    @Column(name = "sales_id_v4")
    private Long salesIdV4;

    @Comment("关联产品")
    @Column()
    private String relatedProduct;

    @Comment("产品大类")
    @Column()
    private String bigType;

    @Comment("产品小类")
    @Column()
    private String samllType;

    @Comment("销售项含税")
    @Column()
    private BigDecimal saleTaxedAmt;

    @Comment("销售税率")
    @Column()
    private BigDecimal saleTaxRate;

    @Comment("销售项不含税")
    @Column()
    private BigDecimal saleNetAmt;

    @Comment("采购项含税")
    @Column()
    private BigDecimal purTaxedAmt;

    @Comment("销售项含税")
    @Column()
    private BigDecimal purTaxRate;

    @Comment("采购项不含税")
    @Column()
    private BigDecimal purNetAmt;

    @Comment("有效销售额")
    @Column()
    private BigDecimal effectiveAmt;

    @Comment("供应商")
    @Column()
    private String supplier;

}
