package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Author carl.wang
 * @Description 市场计划表
 * @Date
 **/
@Entity
@Table(name = "crm_opportunity_stakeholder", indexes = {
        @Index(name = "oppo_index", columnList = "oppo_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_stakeholder", comment = "商机干系人表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityStakeholderDO extends BaseModel {

    @Comment("商机ID")
    @Column(name = "oppo_id")
    private Long oppoId;

    @Comment("tw4.0商机干系人ID")
    @Column(name = "stakeholder_id_v4")
    private Long stakeholderIdV4;

    @Comment("角色类型")
    @Column()
    private String roleType;

    @Comment("职务")
    @Column()
    private String position;

    @Comment("姓名")
    @Column()
    private String stakeholderName;

    @Comment("电话")
    @Column()
    private String stakeholderPhone;

    @Comment("社交账号")
    @Column()
    private String imAcc;

    @Comment("立场")
    @Column()
    private String standpoint;

}
