package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;
import java.time.LocalDate;

/**
 * 人脉
 *
 * @author carl
 * @date 2022/11/21
 */
@Entity
@Table(name = "crm_people", indexes = {@Index(name = "oper_index", columnList = "oper_id"), @Index(name = "customer_index", columnList = "customer_id")
})
@org.hibernate.annotations.Table(appliesTo = "crm_people", comment = " 人脉")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmPeopleDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = 7655285261129870145L;

    @Comment("人脉经营主键 crm_customer_operation.id")
    @Column(name = "oper_id")
    private Long operId;
    /**
     * 客户表主键
     */
    @Comment("客户表主键")
    @Column(name = "customer_id")
    private Long customerId;

    @FieldUpdateLog(fieldName = "名称")
    @FieldCreateLog(fieldName = "名称")
    @Comment("名称")
    @Column()
    private String peopleName;

    @FieldUpdateLog(fieldName = "公司")
    @FieldCreateLog(fieldName = "公司")
    @Comment("公司名称")
    @Column()
    private String companyName;

    @FieldUpdateLog(fieldName = "职业")
    @FieldCreateLog(fieldName = "职业")
    @Comment("职业")
    @Column()
    private String jobs;

    @FieldUpdateLog(fieldName = "生日")
    @FieldCreateLog(fieldName = "生日")
    @Comment("生日")
    @Column()
    private LocalDate birthday;

    @FieldUpdateLog(fieldName = "性别", selectionKey = "org:employee:sex")
    @FieldCreateLog(fieldName = "性别", selectionKey = "org:employee:sex")
    @Comment("性别")
    @Column()
    private String sex;

    @FieldUpdateLog(fieldName = "邮箱")
    @FieldCreateLog(fieldName = "邮箱")
    @Comment("邮箱")
    @Column()
    private String email;

    @FieldUpdateLog(fieldName = "手机号")
    @FieldCreateLog(fieldName = "手机号")
    @Comment("手机号")
    @Column()
    private String mobile;

    @FieldUpdateLog(fieldName = "爱好")
    @FieldCreateLog(fieldName = "爱好")
    @Comment("标签")
    @Column()
    private String tags;

    @FieldUpdateLog(fieldName = "籍贯")
    @FieldCreateLog(fieldName = "籍贯")
    @Comment("籍贯")
    @Column()
    private String birthplace;

    @FieldUpdateLog(fieldName = "现居地址")
    @FieldCreateLog(fieldName = "现居地址")
    @Comment("现居地址")
    @Column()
    private String locationDetail;
    /**
     * 爱心级别
     */
//    @FieldUpdateLog(fieldName = "爱心级别")
//    @FieldCreateLog(fieldName = "爱心级别")
    @Comment("爱心级别")
    @Column()
    private Integer loveLevel;

    /**
     * 微信
     */
    @FieldUpdateLog(fieldName = "微信")
    @FieldCreateLog(fieldName = "微信")
    @Comment("微信")
    @Column()
    private String weChat;

    /**
     * 岗位情况
     */
    @FieldUpdateLog(fieldName = "岗位情况")
    @FieldCreateLog(fieldName = "岗位情况")
    @Comment("岗位情况")
    @Column()
    private String jobDetail;
    /**
     * 行业
     */
    @FieldUpdateLog(fieldName = "行业", selectionKey = "crm:leads_customer_industry")
    @FieldCreateLog(fieldName = "行业", selectionKey = "crm:leads_customer_industry")
    @Comment("行业 udc[crm:leads_customer_industry]")
    @Column()
    private String industry;
    /**
     * 行业影响力
     */
    @FieldUpdateLog(fieldName = "行业影响力")
    @FieldCreateLog(fieldName = "行业影响力")
    @Comment("行业影响力")
    @Column()
    private String industryInfluence;

    /**
     * 部门
     */
    @FieldUpdateLog(fieldName = "部门")
    @FieldCreateLog(fieldName = "部门")
    @Comment("部门")
    @Column()
    private String bu;
    /**
     * 社会身份
     */
    @FieldUpdateLog(fieldName = "社会身份")
    @FieldCreateLog(fieldName = "社会身份")
    @Comment("社会身份")
    @Column()
    private String socialIdentity;

    /**
     * 婚姻状况
     */
    @FieldUpdateLog(fieldName = "婚姻状况")
    @FieldCreateLog(fieldName = "婚姻状况")
    @Comment("婚姻状况")
    @Column()
    private String marital;
    /**
     * 配偶岗位
     */
    @FieldUpdateLog(fieldName = "配偶岗位")
    @FieldCreateLog(fieldName = "配偶岗位")
    @Comment("配偶岗位")
    @Column()
    private String spouseJobs;
    /**
     * 孩子年龄
     */
    @FieldUpdateLog(fieldName = "孩子年龄")
    @FieldCreateLog(fieldName = "孩子年龄")
    @Comment("孩子年龄")
    @Column()
    private String childAge;
    /**
     * 父母健康
     */
    @FieldUpdateLog(fieldName = "父母健康")
    @FieldCreateLog(fieldName = "父母健康")
    @Comment("父母健康")
    @Column()
    private String parentHealth;
    /**
     * 父母居住地
     */
    @FieldUpdateLog(fieldName = "父母居住地")
    @FieldCreateLog(fieldName = "父母居住地")
    @Comment("父母居住地")
    @Column()
    private String parentHabitation;
    /**
     * 状态
     */

    @FieldUpdateLog(fieldName = "状态", selectionKey = "SYSTEM_BASIC:STATUS")
    @FieldCreateLog(fieldName = "状态", selectionKey = "SYSTEM_BASIC:STATUS")
    @Comment("状态")
    @Column()
    private String peopleStatus;

    public CrmPeopleDO() {
    }

    public void copy(CrmPeopleDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
