package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serial;
import java.time.LocalDate;

/**
 * 人脉-教育经历
 *
 * @author carl
 * @date 2022/12/07
 */
@Entity
@Table(name = "crm_people_educate", indexes = {@Index(name = "people_index", columnList = "people_id")
})
@org.hibernate.annotations.Table(appliesTo = "crm_people_educate", comment = "人脉-教育经历")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmPeopleEducateDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = 7655285261129870145L;

    @Comment("人脉主键")
    @Column(name = "people_id")
    private Long peopleId;

    @Comment("学校")
    @Column()
    private String school;

    @Comment("学历")
    @Column()
    private String education;
    /**
     * 专业
     */
    @Comment("专业")
    @Column()
    private String major;

    @Comment("开始")
    @Column()
    private LocalDate startDate;
    @Comment("结束")
    @Column()
    private LocalDate endDate;


    public CrmPeopleEducateDO() {
    }

    public void copy(CrmPeopleEducateDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
