package com.elitesland.tw.tw5.server.prd.crm.repo;

import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.*;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.lang.Nullable;

import java.util.List;
import java.util.Optional;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/19 - 14:13
 */
public interface CrmLeadsRepo extends JpaRepository<CrmLeadsDO,Long>, QuerydslPredicateExecutor<CrmLeadsDO>, JpaSpecificationExecutor<CrmLeadsDO> {

    @Override
    @EntityGraph(value = "offshore.leads.list")
    List<CrmLeadsDO> findAll(@Nullable Specification<CrmLeadsDO> spec);

    @Override
    @EntityGraph(value = "offshore.leads.list")
    Page<CrmLeadsDO> findAll(@Nullable Specification<CrmLeadsDO> spec, Pageable pageable);

    @Override
    @EntityGraph(value = "offshore.leads.detail")
    Optional<CrmLeadsDO> findById(Long id);

    @Query("select l.id from CrmLeadsDO l where l.deleteFlag=0 and l.formalCustomerId=?1")
    List<Long> queryByFormalCustomerId(Long customerId);

    @Query("select l.id from CrmLeadsDO l where l.deleteFlag=0 and l.formalCustomerId is null")
    List<Long> findNotBindLeads();

    @Modifying
    @Query("update CrmLeadsCustomerDO set customerGrade = ?2 where id in (select l.customer.id from CrmLeadsDO l where l.id in ?1)")
    void updateCustomerGrade(List<Long> leadsId, String grade);


//    @Query("select id from CrmLeadsDO where potentialCustomerId=?1")
    List<CrmLeadsDO> findByPotentialCustomerIdOrderByCreateTimeDesc(Long id);

    @Query("SELECT id FROM CrmLeadsDO WHERE formalCustomerId IS NULL and deleteFlag=0")
    List<Long> queryNotBindLeads();

////    //TODO:研究一下如何将两个查询结果糅合起来
//    @Query("select o.leads from CrmOffshoreDO o left join o.leads l where o.offshoreAdminId=?1")
//    List<CrmLeadsDO> queryOffshoreLeadsList(Long userId);

//    @Query("select o.leads as offshore_id from CrmOffshoreDO o left join o.leads l where o.offshoreAdminId=?1")
//    List<CrmOffshoreDO> queryOffshoreLeadsList(Long userId, Pageable pageable);

//    @Query(value = "select l.id,l.leads_no,l.leads_name,l.leads_stage,l.source_type,l.channel,l.sale_user_id," +
//            "lc.customer_name,lc.customer_industry,lc.customer_contacts,lc.contacts_department,lc.contacts_position,lc.contacts_phone," +
//            "o.id as offshore_id from crm_offshore o " +
//            "join crm_leads_offshore lo on lo.offshore_id= o.id " +
//            "join crm_leads l on lo.leads_id = l.id " +
//            "left join crm_leads_customer lc on lc.id=l.customer_id " +
//            "where o.offshore_admin_id=?1",nativeQuery = true)
//    List<CrmLeadsDO> queryOffshoreLeadsList(Long userId);
}
