package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCommonService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsOffshoreDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/8/17 - 17:53
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCommonSerciceImpl implements CrmCommonService {
    private final CrmLeadsOffshoreDAO leadsOffshoreDAO;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final CacheUtil cacheUtil;
    @Override
    public List<Map<String, Object>> checkRepeat(String type, String checkValue) {
        CrmPotentialCustomerQuery query = new CrmPotentialCustomerQuery();
        CrmLeadsOffshoreQuery leadsQuery = new CrmLeadsOffshoreQuery();
        List<CrmPotentialCustomerDO> crmPotentialCustomerDOs = new ArrayList<>();
        List<CrmLeadsOffshoreDO> leadsDOs = new ArrayList<>();
        List<Map<String,Object>> list = new ArrayList<>();
        switch (type){
            case "company":
                leadsQuery.setCustomerNameEqual(checkValue);
                query.setCustomerNameEqual(checkValue);
                crmPotentialCustomerDOs = queryPotentialCustomerList(query);
                leadsDOs = queryLeadsList(leadsQuery);
                break;
            case "phone":
                leadsQuery.setContactsPhone(checkValue);
                query.setCustomerPhone(checkValue);
                crmPotentialCustomerDOs = queryPotentialCustomerList(query);
                leadsDOs = queryLeadsList(leadsQuery);
                break;
        }
        if(crmPotentialCustomerDOs!=null && !crmPotentialCustomerDOs.isEmpty()){
            for (CrmPotentialCustomerDO customer : crmPotentialCustomerDOs) {
                Map<String,Object> map = new HashMap<>();
                map.put("repeatType","潜在客户");
                map.put("id",customer.getId());
                map.put("companyName",customer.getCustomerName());
                map.put("contactsName",customer.getCustomerContacts());
                map.put("contactsPhone",customer.getCustomerPhone());
                map.put("salesMan",null);
                list.add(map);
            }
        }
        if(leadsDOs!=null && !leadsDOs.isEmpty()){
            for (CrmLeadsOffshoreDO leadsOffshoreDO : leadsDOs) {
                Map<String,Object> map = new HashMap<>();
                map.put("repeatType","线索");
                map.put("id",leadsOffshoreDO.getId());
                map.put("companyName",leadsOffshoreDO.getLeads().getCustomer().getCustomerName());
                map.put("contactsName",leadsOffshoreDO.getLeads().getCustomer().getCustomerContacts());
                map.put("contactsPhone",leadsOffshoreDO.getLeads().getCustomer().getContactsPhone());
                Long saleUserId = leadsOffshoreDO.getLeads().getSaleUserId();
                if(saleUserId!=null){
                    map.put("salesMan", cacheUtil.getUserName(saleUserId));
                }else{
                    map.put("salesMan", null);
                }

                list.add(map);
            }
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> checkRepeatPro(Map<String, Object> param,
                                                    String type, String checkValue) {
        List<CrmPotentialCustomerDO> crmPotentialCustomerDOList = (List<CrmPotentialCustomerDO>) param.get("crmPotentialCustomerDOList");
        List<CrmLeadsOffshoreDO> crmLeadsOffshoreDOList = (List<CrmLeadsOffshoreDO>) param.get("crmLeadsOffshoreDOList");
        List<CrmPotentialCustomerDO> crmPotentialCustomerDOs = new ArrayList<>();
        List<CrmLeadsOffshoreDO> leadsDOs = new ArrayList<>();
        List<Map<String,Object>> list = new ArrayList<>();
        switch (type) {
            case "company":
                crmPotentialCustomerDOs = crmPotentialCustomerDOList.stream().filter(crmPotentialCustomerDO -> StringUtils.hasText(crmPotentialCustomerDO.getCustomerName()) && crmPotentialCustomerDO.getCustomerName().equals(checkValue)).collect(Collectors.toList());
                leadsDOs = crmLeadsOffshoreDOList.stream().filter(crmLeadsOffshoreDO -> crmLeadsOffshoreDO.getLeads().getCustomer().getCustomerName().equals(checkValue)).collect(Collectors.toList());
                break;
            case "phone":
                crmPotentialCustomerDOs = crmPotentialCustomerDOList.stream().filter(crmPotentialCustomerDO -> StringUtils.hasText(crmPotentialCustomerDO.getCustomerPhone()) && crmPotentialCustomerDO.getCustomerPhone().equals(checkValue)).collect(Collectors.toList());
                leadsDOs = crmLeadsOffshoreDOList.stream().filter(crmLeadsOffshoreDO -> crmLeadsOffshoreDO.getLeads().getCustomer().getContactsPhone()!=null && crmLeadsOffshoreDO.getLeads().getCustomer().getContactsPhone().equals(checkValue)).collect(Collectors.toList());
                break;
        }
        if(crmPotentialCustomerDOs!=null && !crmPotentialCustomerDOs.isEmpty()){
            for (CrmPotentialCustomerDO customer : crmPotentialCustomerDOs) {
                Map<String,Object> map = new HashMap<>();
                map.put("repeatType","潜在客户");
                map.put("id",customer.getId());
                map.put("companyName",customer.getCustomerName());
                map.put("contactsName",customer.getCustomerContacts());
                map.put("contactsPhone",customer.getCustomerPhone());
                map.put("salesMan",null);
                list.add(map);
            }
        }
        if(leadsDOs!=null && !leadsDOs.isEmpty()){
            for (CrmLeadsOffshoreDO leadsOffshoreDO : leadsDOs) {
                Map<String,Object> map = new HashMap<>();
                map.put("repeatType","线索");
                map.put("id",leadsOffshoreDO.getId());
                map.put("companyName",leadsOffshoreDO.getLeads().getCustomer().getCustomerName());
                map.put("contactsName",leadsOffshoreDO.getLeads().getCustomer().getCustomerContacts());
                map.put("contactsPhone",leadsOffshoreDO.getLeads().getCustomer().getContactsPhone());
                Long saleUserId = leadsOffshoreDO.getLeads().getSaleUserId();
                if(saleUserId!=null){
                    map.put("salesMan", cacheUtil.getUserName(saleUserId));
                }else{
                    map.put("salesMan", null);
                }

                list.add(map);
            }
        }
        return list;
    }

    public List<CrmLeadsOffshoreDO> queryLeadsList(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> content = leadsOffshoreDAO.findAll(spec);
        return content;
    }

    public List<CrmPotentialCustomerDO> queryPotentialCustomerList(CrmPotentialCustomerQuery query) {
        Specification<CrmPotentialCustomerDO> spec = potentialCustomerDAO.getSpec(query);
        return potentialCustomerDAO.findAll(spec);
    }
}
