package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustOperInfoSysPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustOperInfoSysQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustOperInfoSysService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustOperInfoSysVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustOperInfoSysConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustOperInfoSysDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustOperInfoSysDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustOperInfoSysRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustOperInfoSysServiceImpl implements CrmCustOperInfoSysService {
    private final CrmCustOperInfoSysRepo infoSysRepo;
    private final PrdSystemLogService logService;
    private final CrmCustOperInfoSysDAO infoSysDAO;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(CrmCustOperInfoSysPayload payload) {
        if (StringUtils.isBlank(payload.getSysType())) {
            throw new BusinessException("系统类型不能为空");
        }
        if (StringUtils.isBlank(payload.getSysName())) {
            throw new BusinessException("系统名称不能为空");
        }
        if (StringUtils.isBlank(payload.getBelongCompany())) {
            throw new BusinessException("系统所属公司不能为空");
        }
        CrmCustOperInfoSysDO saveDO;
        String name;
        if (payload.getId() == null) {
            //新增
            name = PrdSystemLogEnum.CREATE.getDesc();
            saveDO = infoSysRepo.save(CrmCustOperInfoSysConvert.INSTANCE.toDo(payload));
        } else {
            name = PrdSystemLogEnum.UPDATE.getDesc();
            var infoSysDO = infoSysRepo.findById(payload.getId()).orElseThrow(new BusinessException("根据id" + payload.getId() + "未查询到数据"));
            CrmCustOperInfoSysConvert.INSTANCE.copy(payload, infoSysDO);
            saveDO = infoSysRepo.save(infoSysDO);
        }

        logService.saveNewLog(saveDO.getOperId(),
                PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(),
                name + PrdSystemObjectEnum.CUSTOMER_OPERATION_INFO_SYS.getDesc());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(long id) {
        var optional = infoSysRepo.findById(id);
        infoSysRepo.deleteById(id);
        logService.saveNewLog(optional.get().getOperId(),
                PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(),
                PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_INFO_SYS.getDesc());
    }


    @Override
    public PagingVO<CrmCustOperInfoSysVO> paging(CrmCustOperInfoSysQuery query) {
        if (query.getOperId() == null) {
            throw TwException.error("", "operId不能为空，请核验！");
        }

        return infoSysDAO.paging(query);
    }
}
