package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationEnterpriseInfoQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationEnterpriseInfoService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationEnterpriseInfoVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationEnterpriseInfoConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationEnterpriseInfoDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationEnterpriseInfoRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
* 客户经营-企业基本信息
*
* @author duwh
* @date 2022-12-02
*/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustomerOperationEnterpriseInfoServiceImpl implements CrmCustomerOperationEnterpriseInfoService {

    private final CrmCustomerOperationEnterpriseInfoRepo crmCustomerOperationEnterpriseInfoRepo;

    @Override
    public PagingVO<CrmCustomerOperationEnterpriseInfoVO> paging(CrmCustomerOperationEnterpriseInfoQuery query){
        Page<CrmCustomerOperationEnterpriseInfoDO> page = crmCustomerOperationEnterpriseInfoRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmCustomerOperationEnterpriseInfoConvert.INSTANCE::toVo));
    }

    @Override
    public List<CrmCustomerOperationEnterpriseInfoVO> queryList(CrmCustomerOperationEnterpriseInfoQuery query){
        return CrmCustomerOperationEnterpriseInfoConvert.INSTANCE.toVoList(crmCustomerOperationEnterpriseInfoRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder)));
    }

    @Override
    public CrmCustomerOperationEnterpriseInfoVO queryByKey(Long key) {
        CrmCustomerOperationEnterpriseInfoDO entity = crmCustomerOperationEnterpriseInfoRepo.findById(key).orElseGet(CrmCustomerOperationEnterpriseInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmCustomerOperationEnterpriseInfoVO vo = CrmCustomerOperationEnterpriseInfoConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmCustomerOperationEnterpriseInfoVO insert(CrmCustomerOperationEnterpriseInfoPayload payload) {
        CrmCustomerOperationEnterpriseInfoDO entityDo = CrmCustomerOperationEnterpriseInfoConvert.INSTANCE.toDo(payload);
        return CrmCustomerOperationEnterpriseInfoConvert.INSTANCE.toVo(crmCustomerOperationEnterpriseInfoRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmCustomerOperationEnterpriseInfoVO update(CrmCustomerOperationEnterpriseInfoPayload payload) {
        CrmCustomerOperationEnterpriseInfoDO entity = crmCustomerOperationEnterpriseInfoRepo.findById(payload.getId()).orElseGet(CrmCustomerOperationEnterpriseInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmCustomerOperationEnterpriseInfoDO entityDo = CrmCustomerOperationEnterpriseInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmCustomerOperationEnterpriseInfoConvert.INSTANCE.toVo(crmCustomerOperationEnterpriseInfoRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<CrmCustomerOperationEnterpriseInfoDO> optional = crmCustomerOperationEnterpriseInfoRepo.findById(id);
                if (!optional.isEmpty()) {
                    CrmCustomerOperationEnterpriseInfoDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    crmCustomerOperationEnterpriseInfoRepo.save(entity);
                }
             });
        }
    }

    @Override
    public void download(List<CrmCustomerOperationEnterpriseInfoVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (CrmCustomerOperationEnterpriseInfoVO crmCustomerOperationEnterpriseInfo : all) {
            Map<String,Object> map = new LinkedHashMap<>();
            map.put("客户经营主键", crmCustomerOperationEnterpriseInfo.getOperId());
            map.put("启信宝id", crmCustomerOperationEnterpriseInfo.getIdQxb());
            map.put("企业名称（国家公示)", crmCustomerOperationEnterpriseInfo.getName());
            map.put(" formatName",  crmCustomerOperationEnterpriseInfo.getFormatName());
            map.put("企业类型", crmCustomerOperationEnterpriseInfo.getEconKind());
            map.put("企业类型代码", crmCustomerOperationEnterpriseInfo.getEconKindCode());
            map.put("注册资本（金额数字+1个空格+万+货币单位）", crmCustomerOperationEnterpriseInfo.getRegistCapi());
            map.put(" currencyUnit",  crmCustomerOperationEnterpriseInfo.getCurrencyUnit());
            map.put(" typeNew",  crmCustomerOperationEnterpriseInfo.getTypeNew());
            map.put("历史名字", crmCustomerOperationEnterpriseInfo.getHistoryNamesStr());
            map.put("地址", crmCustomerOperationEnterpriseInfo.getAddress());
            map.put("企业注册号", crmCustomerOperationEnterpriseInfo.getRegNo());
            map.put("经营范围", crmCustomerOperationEnterpriseInfo.getScope());
            map.put("营业开始日期", crmCustomerOperationEnterpriseInfo.getTermStart());
            map.put("营业结束日期", crmCustomerOperationEnterpriseInfo.getTermEnd());
            map.put("所属工商局", crmCustomerOperationEnterpriseInfo.getBelongOrg());
            map.put("企业法定代表人", crmCustomerOperationEnterpriseInfo.getOperName());
            map.put("公司代表人职务", crmCustomerOperationEnterpriseInfo.getTitle());
            map.put("成立日期", crmCustomerOperationEnterpriseInfo.getStartDate());
            map.put("注销日期", crmCustomerOperationEnterpriseInfo.getEndDate());
            map.put("核准日期", crmCustomerOperationEnterpriseInfo.getCheckDate());
            map.put("经营状态（旧字段，不建议使用）", crmCustomerOperationEnterpriseInfo.getStatus());
            map.put(" newStatus",  crmCustomerOperationEnterpriseInfo.getNewStatus());
            map.put("组织机构号", crmCustomerOperationEnterpriseInfo.getOrgNo());
            map.put("统一社会信用代码", crmCustomerOperationEnterpriseInfo.getCreditNo());
            map.put("地区代码", crmCustomerOperationEnterpriseInfo.getDistrictCode());
            map.put("实缴资本", crmCustomerOperationEnterpriseInfo.getActualCapi());
            map.put("企业二级分类", crmCustomerOperationEnterpriseInfo.getCategoryNew());
            map.put("四级行业", crmCustomerOperationEnterpriseInfo.getDomain());
            map.put("1-新三板； 6-主板上市公司； 40-暂停上市； 41-终止上市； 9-香港上市； 17-高新企业；", crmCustomerOperationEnterpriseInfo.getTagsStr());
            map.put(" revokeReason",  crmCustomerOperationEnterpriseInfo.getRevokeReason());
            map.put(" revokeDate",  crmCustomerOperationEnterpriseInfo.getRevokeDate());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}
