package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPartnersPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationPartnersQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationPartnersService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationPartnersVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationPartnersConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationPartnersDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationPartnersRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
* 客户经营-工商股东（含历史）
*
* @author duwh
* @date 2022-12-05
*/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustomerOperationPartnersServiceImpl implements CrmCustomerOperationPartnersService {

    private final CrmCustomerOperationPartnersRepo crmCustomerOperationPartnersRepo;

    @Override
    public PagingVO<CrmCustomerOperationPartnersVO> paging(CrmCustomerOperationPartnersQuery query){
        Page<CrmCustomerOperationPartnersDO> page = crmCustomerOperationPartnersRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmCustomerOperationPartnersConvert.INSTANCE::toVo));
    }

    @Override
    public List<CrmCustomerOperationPartnersVO> queryList(CrmCustomerOperationPartnersQuery query){
        return CrmCustomerOperationPartnersConvert.INSTANCE.toVoList(crmCustomerOperationPartnersRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder)));
    }

    @Override
    public CrmCustomerOperationPartnersVO queryByKey(Long key) {
        CrmCustomerOperationPartnersDO entity = crmCustomerOperationPartnersRepo.findById(key).orElseGet(CrmCustomerOperationPartnersDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmCustomerOperationPartnersVO vo = CrmCustomerOperationPartnersConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmCustomerOperationPartnersVO insert(CrmCustomerOperationPartnersPayload payload) {
        CrmCustomerOperationPartnersDO entityDo = CrmCustomerOperationPartnersConvert.INSTANCE.toDo(payload);
        return CrmCustomerOperationPartnersConvert.INSTANCE.toVo(crmCustomerOperationPartnersRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmCustomerOperationPartnersVO update(CrmCustomerOperationPartnersPayload payload) {
        CrmCustomerOperationPartnersDO entity = crmCustomerOperationPartnersRepo.findById(payload.getId()).orElseGet(CrmCustomerOperationPartnersDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmCustomerOperationPartnersDO entityDo = CrmCustomerOperationPartnersConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmCustomerOperationPartnersConvert.INSTANCE.toVo(crmCustomerOperationPartnersRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<CrmCustomerOperationPartnersDO> optional = crmCustomerOperationPartnersRepo.findById(id);
                if (!optional.isEmpty()) {
                    CrmCustomerOperationPartnersDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    crmCustomerOperationPartnersRepo.save(entity);
                }
             });
        }
    }

    @Override
    public void download(List<CrmCustomerOperationPartnersVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (CrmCustomerOperationPartnersVO crmCustomerOperationPartners : all) {
            Map<String,Object> map = new LinkedHashMap<>();
            map.put("客户经营主键", crmCustomerOperationPartners.getOperId());
            map.put("总实缴", crmCustomerOperationPartners.getTotalRealCapi());
            map.put("出资时间", crmCustomerOperationPartners.getDate());
            map.put("历史股东", crmCustomerOperationPartners.getIsHstory());
            map.put("股东类型", crmCustomerOperationPartners.getStockType());
            map.put("股东姓名", crmCustomerOperationPartners.getName());
            map.put("认缴出资列表", crmCustomerOperationPartners.getShouldCapiItems());
            map.put("总认缴", crmCustomerOperationPartners.getTotalShouldCapi());
            map.put("类型", crmCustomerOperationPartners.getIdentifyType());
            map.put("认缴出资额", crmCustomerOperationPartners.getCapi());
            map.put("实缴出资列表", crmCustomerOperationPartners.getRealCapiItems());
            map.put("出资方式", crmCustomerOperationPartners.getType());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}
