package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationSitesQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationSitesService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationSitesVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationSitesConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationSitesDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationSitesRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
* 客户经营-企业年报网址
*
* @author duwh
* @date 2022-12-05
*/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustomerOperationSitesServiceImpl implements CrmCustomerOperationSitesService {

    private final CrmCustomerOperationSitesRepo crmCustomerOperationSitesRepo;

    @Override
    public PagingVO<CrmCustomerOperationSitesVO> paging(CrmCustomerOperationSitesQuery query){
        Page<CrmCustomerOperationSitesDO> page = crmCustomerOperationSitesRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmCustomerOperationSitesConvert.INSTANCE::toVo));
    }

    @Override
    public List<CrmCustomerOperationSitesVO> queryList(CrmCustomerOperationSitesQuery query){
        return CrmCustomerOperationSitesConvert.INSTANCE.toVoList(crmCustomerOperationSitesRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder)));
    }

    @Override
    public CrmCustomerOperationSitesVO queryByKey(Long key) {
        CrmCustomerOperationSitesDO entity = crmCustomerOperationSitesRepo.findById(key).orElseGet(CrmCustomerOperationSitesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmCustomerOperationSitesVO vo = CrmCustomerOperationSitesConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmCustomerOperationSitesVO insert(CrmCustomerOperationSitesPayload payload) {
        CrmCustomerOperationSitesDO entityDo = CrmCustomerOperationSitesConvert.INSTANCE.toDo(payload);
        return CrmCustomerOperationSitesConvert.INSTANCE.toVo(crmCustomerOperationSitesRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmCustomerOperationSitesVO update(CrmCustomerOperationSitesPayload payload) {
        CrmCustomerOperationSitesDO entity = crmCustomerOperationSitesRepo.findById(payload.getId()).orElseGet(CrmCustomerOperationSitesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmCustomerOperationSitesDO entityDo = CrmCustomerOperationSitesConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmCustomerOperationSitesConvert.INSTANCE.toVo(crmCustomerOperationSitesRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<CrmCustomerOperationSitesDO> optional = crmCustomerOperationSitesRepo.findById(id);
                if (!optional.isEmpty()) {
                    CrmCustomerOperationSitesDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    crmCustomerOperationSitesRepo.save(entity);
                }
             });
        }
    }

    @Override
    public void download(List<CrmCustomerOperationSitesVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (CrmCustomerOperationSitesVO crmCustomerOperationSites : all) {
            Map<String,Object> map = new LinkedHashMap<>();
            //map.put("客户经营主键", crmCustomerOperationSites.getOperId());
            map.put("审核时间", crmCustomerOperationSites.getDate());
            map.put("网址", crmCustomerOperationSites.getUrl());
            map.put("企业网址名称", crmCustomerOperationSites.getName());
            map.put("网址类型", crmCustomerOperationSites.getType());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}
