package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbOrCompanyPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.*;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgCompanyVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.*;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5crm.api.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5crm.api.visit.service.VisitTaskService;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskPlanTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5crm.server.common.util.GeodesyUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author carl.wang
 * @Description 客户管理
 * @Date
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustomerServiceImpl extends BaseServiceImpl implements CrmCustomerService {
    private final CacheUtil cacheUtil;
    private final CrmCustomerDAO dao;
    private final CrmCustomerOperationDAO customerOperationDAO;
    private final PrdAbService abService;
    private final PrdAbDAO abDAO;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final ExcelUtil excelUtil;
    private final CrmLeadsDAO leadsDAO;
    private final CrmOpportunityDAO opportunityDAO;
    private final CrmFollowDAO followDAO;
    private final CrmFollowServiceImpl followService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final CrmActActivityDAO actActivityDAO;
    private final CrmCustomerRepo repo;
    private final TaskExecutor taskExecutor;
    private final GeodesyUtil geodesyUtil;

    @Autowired
    private VisitTaskService visitTaskService;

    @Value("${tw4.customer.operation}")
    private String customer_operation;

    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
    //private SysNumberRuleService numberRuleService;

//    @Value("${tw4.customer.update}")
//    private String customer_update;
//
//    @Value("${tw4.customer.updateStatus}")
//    private String customer_updateStatus;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CrmCustomerVO insert(CrmCustomerPayload payload) {

        String code = generateSeqNum("ADDRESS_BOOK_NO");
        //同步到4.0
        if (payload.getCustomerStatus() == null || payload.getCustomerStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            payload.setCustomerStatus("INACTIVE");
        }
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("bookNo", code);
        //String bookId = "";
        //try {
        //    String result = httpUtil.sendSyncPost(customer_operation, map);
        //    bookId = httpUtil.geResultData(result);
        //} catch (Exception e) {
        //    log.info("绑定失败！");
        //}
        long bookIdV4 = 0;
        //if (StringUtils.hasText(bookId)) {
        //    if (StringUtil.isInteger(bookId)) {
        //        bookIdV4 = Long.valueOf(bookId);
        //    }
        //}
        PrdAbOrCompanyPayload companyPayload = CrmCustomerConvert.INSTANCE.toPayload(payload);
        companyPayload.setBookNo(code);
        companyPayload.setBookType(SystemDefaultEnum.DefaultAbType.getCode());
        companyPayload.setRelateType(AddressBookEnum.RelateCustomer.getCode());
        companyPayload.setCompanyName(payload.getCustomerName());
        companyPayload.setBookIdV4(bookIdV4);
        PrdAbVO abVO = abService.saveAbOrCompany(companyPayload);

        CrmCustomerDO customerDO = CrmCustomerConvert.INSTANCE.toDo(payload);
        customerDO.setBookId(abVO.getId());
        if (payload.getCustomerStatus() == null) {
            customerDO.setCustomerStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        } else if (payload.getCustomerStatus().equals("INACTIVE")) {
            customerDO.setCustomerStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        }
        customerDO = dao.save(customerDO);
        logService.saveNewLog(customerDO.getId(), PrdSystemObjectEnum.Customer.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Customer.getDesc());

        // 销售拜访任务 客户 关系绑定  and  拜访任务状态提交
        if (StringUtils.hasText(payload.getFrom())
                && payload.getFrom().equals(VisitTaskPlanTypeEnum.sell_visit_plan.getCode())) {
            final Long visitTaskId = payload.getVisitTaskId();
            if (ObjectUtils.isEmpty(visitTaskId)) {
                throw TwException.error("", "visitTaskId不能为空");
            }
            VisitTaskPayload visitTaskPayload = new VisitTaskPayload();
            visitTaskPayload.setId(visitTaskId);
            visitTaskPayload.setStatus(VisitTaskStatusEnum.OK.getCode());
            visitTaskPayload.setCustomerId(customerDO.getId());
            visitTaskService.update(visitTaskPayload);
        }
        return CrmCustomerConvert.INSTANCE.toVo(customerDO);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public Long update(CrmCustomerPayload payload) {
        PrdAbVO abVO = dao.queryAbVOBykey(payload.getId());
        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("bookId", abVO.getBookIdV4());
        //String result = httpUtil.sendSyncPost(customer_operation, map);
        //httpUtil.geResultData(result);

        if (payload.getUpdateType() == 0) {
            PrdAbOrCompanyPayload companyPayload = CrmCustomerConvert.INSTANCE.toPayload(payload);
            companyPayload.setId(abVO.getId());
            companyPayload.setCompanyName(payload.getCustomerName());
            abService.updateAbOrCompany(companyPayload);
            //   Long companyId = dao.queryCompany(customerDO.getBookId());
            logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Customer.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Customer.getDesc());
        } else {
            logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Customer.getCode(), PrdSystemLogEnum.UPDATE_MANAGE.getDesc());

        }

        dao.updateByKeyDynamic(payload);

        return 0L;
    }

    /**
     * 根据客户主键查询地址簿主键
     *
     * @param customerId 客户id
     * @return {@link Long}
     */
    @Override
    public Long getBookIdByCustomerId(Long customerId) {
        PrdAbVO abVO = dao.queryAbVOBykey(customerId);
        if (null == abVO) {
            log.error("数据异常，客户对应地址簿数据不存在；客户主键：{}", customerId);
        } else {
            return abVO.getId();
        }
        return null;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public Long updateProvinceCityDistrict(CrmCustomerPayload payload) {
        //查询地址簿
        PrdAbVO abVO = dao.queryAbVOBykey(payload.getId());
        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("bookId", abVO.getBookIdV4());
        //String result = httpUtil.sendSyncPost(customer_operation, map);
        //httpUtil.geResultData(result);

        PrdAbOrCompanyPayload companyPayload = CrmCustomerConvert.INSTANCE.toPayload(payload);
        companyPayload.setId(abVO.getId());
        abDAO.setProvinceCityDistrictForCompany(companyPayload);

        logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Customer.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Customer.getDesc());
        return 0L;
    }

    @Override
    public void operPermissionFlag(CrmCustomerQuery query) {
        // 获取当前登录用户
        Long userId = GlobalUtil.getLoginUserId();
        Boolean marketAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
        Boolean marketUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
        Boolean saleAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
        Boolean saleUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode()));
        query.setCreateUserId(userId);
        // Boolean isPerm = false;
        if (saleUserIdsByRole || saleAdminUserIdsByRole) {
            query.setFilterType("sales");
            //isPerm = true;
        } else if (marketAdminUserIdsByRole || marketUserIdsByRole) {
            query.setFilterType("market");
            query.setCustomerGrades(Arrays.asList("important", "normal"));
            //   isPerm = true;
        }
        if (marketAdminUserIdsByRole) {
            List<Long> marketUserIdsByRole0 = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
            query.setCreateUserIds(marketUserIdsByRole0);
        }
//        if (!isPerm) {
//            //如果没有权限通过创建人筛选
//            query.setCreateUserId(userId);
//        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateLongitudeLatitude() {
        List<PrdOrgCompanyVO> prdOrgCompanyVOS = dao.queryCompanys();
        if (!ObjectUtils.isEmpty(prdOrgCompanyVOS)) {
            for (PrdOrgCompanyVO vo : prdOrgCompanyVOS) {
                //开启线程执行
                //  taskExecutor.execute(() -> {
                String addressByLocation = geodesyUtil.getLongitudeAndLatitudeByAddress(vo.getCompanyAddress());
                dao.updateCompany(vo.getId(), addressByLocation);
                // });

            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    void updata(PrdOrgCompanyVO vo) {
        String addressByLocation = geodesyUtil.getAddressByLocation(vo.getCompanyAddress());
        dao.updateCompany(vo.getId(), addressByLocation);
    }

    @Override
    public PagingVO<CrmCustomerVO> paging(CrmCustomerQuery query) {
        // 判断当前登录人是否是系统管理员
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode()));
        if (!rolePermission) {
            //完善权限
            operPermissionFlag(query);
        }
        PagingVO<CrmCustomerVO> customerVOPagingVO = dao.queryPaging(query);
//        // 判断当前登录人是否是市场管理员
//        List<Long> marketAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
//        List<Long> marketUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
//        List<Long> saleAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
//        List<Long> saleUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_RES.getCode()));
//        //过滤不符合要求的客户
//        if ((saleUserIdsByRole != null && !saleUserIdsByRole.isEmpty() && saleUserIdsByRole.contains(userId)) ||
//                (saleAdminUserIdsByRole != null && !saleAdminUserIdsByRole.isEmpty() && saleAdminUserIdsByRole.contains(userId))
//        ) {
//            query.setFilterType("sales");
//        } else if ((marketUserIdsByRole != null && !marketUserIdsByRole.isEmpty() && marketUserIdsByRole.contains(userId)) ||
//                (marketAdminUserIdsByRole != null && !marketAdminUserIdsByRole.isEmpty() && marketAdminUserIdsByRole.contains(userId))
//        ) {
//            query.setFilterType("market");
//            query.setCustomerGrades(Arrays.asList("important", "normal"));
//        }
//        if (marketAdminUserIdsByRole != null && !marketAdminUserIdsByRole.isEmpty() && marketAdminUserIdsByRole.contains(userId)) {
//            if (customerVOPagingVO == null) {
//                //市场管理员能看到市场人员建的客户
////                query.setCustomerGrades(Arrays.asList("important","normal"));
//                query.setCreateUserIds(marketUserIdsByRole);
//                customerVOPagingVO = dao.queryPaging(query);
//            }
//        }
//        if (customerVOPagingVO == null) {
//            query.setCreateUserId(userId);
//            customerVOPagingVO = dao.queryPaging(query);
//        }
//        customerVOPagingVO = dao.queryPaging(query);
        List<CrmCustomerVO> crmCustomerVOS = customerVOPagingVO.getRecords();
//        customerVOPagingVO.setTotal(Long.parseLong(String.valueOf(crmCustomerVOS.size())));
        List<Long> userIds = new ArrayList<>();
        crmCustomerVOS.forEach(crmCustomerVO -> getUserIds(userIds, crmCustomerVO));
        List<Map<String, Object>> employees = dao.queryEmployees(userIds);
        Map<Long, String> employeeMap = new HashMap<>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf(employee.get("userId") + ""), (String) employee.get("employeeName")));
        crmCustomerVOS.forEach(crmCustomerVO -> transferCustomerDatas(employeeMap, crmCustomerVO, query.getFilterType()));
        return customerVOPagingVO;
    }


    @Override
    public CrmCustomerVO queryDetail(Long key) {
        CrmCustomerVO crmCustomerVO = dao.queryDetail(key);
        List<Long> userIds = new ArrayList<>();
        getUserIds(userIds, crmCustomerVO);
        List<Map<String, Object>> employees = dao.queryEmployees(userIds);
        Map<Long, String> employeeMap = new HashMap<>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf(employee.get("userId") + ""), (String) employee.get("employeeName")));
        transferCustomerDatas(employeeMap, crmCustomerVO, null);
        var customerOperationVO = customerOperationDAO.queryCrmCustomerOperationVOByCustomerId(key);
        crmCustomerVO.setCustomerOperationVO(customerOperationVO);
        return crmCustomerVO;
    }

    @Override
    public CrmCustomerVO queryDetailByBookId(Long bookId) {
        CrmCustomerVO crmCustomerVO = dao.queryDetailByBookId(bookId);
        List<Long> userIds = new ArrayList<>();
        getUserIds(userIds, crmCustomerVO);
        List<Map<String, Object>> employees = dao.queryEmployees(userIds);
        Map<Long, String> employeeMap = new HashMap<>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf(employee.get("userId") + ""), (String) employee.get("employeeName")));
        transferCustomerDatas(employeeMap, crmCustomerVO, null);
        return crmCustomerVO;
    }

    @Override
    public List<CrmCustomerDataVO> queryList() {
        List<CrmCustomerDataVO> crmCustomerDataVOS = dao.queryList();
        crmCustomerDataVOS.forEach(vo -> {
            vo.setCompanyIndustryName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCompanyIndustry()));
        });
        return dao.queryList();
    }

    @Override
    public boolean deleteSoft(List<Long> keys) {
        return false;
    }

    @Transactional
    @Override
    public boolean updateStatus(Long key, String status) {
        PrdAbVO abVO = dao.queryAbVOBykey(key);
        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("bookId", abVO.getBookIdV4());
        //map.put("customerStatus", status);
        //String result = httpUtil.sendSyncPost(customer_operation, map);
        //httpUtil.geResultData(result);

        dao.updateStatus(key, status);
        logService.saveNewLog(key, PrdSystemObjectEnum.Customer.getCode(), cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), status) + PrdSystemObjectEnum.Customer.getDesc());

        return true;
    }

    @Override
    public PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Customer.getCode());

        return logService.pageLog(query);
    }

    /**
     * 获取所有相关用户id
     *
     * @param userIds
     * @param vo
     */
    void getUserIds(List<Long> userIds, CrmCustomerVO vo) {
        Set<Long> users = new HashSet<>();
        users.add(vo.getCreateUserId());
        users.add(vo.getServiceUserId());
        users.add(vo.getBusinessUserId());
        users.add(vo.getCareUserId());
        users.add(vo.getOperationUserId());
        userIds.addAll(users);
    }

    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferCustomerDatas(Map<Long, String> employeeMap, CrmCustomerVO vo, String filterType) {
        vo.setCreateUserName(employeeMap.get(vo.getCreateUserId()));
        vo.setServiceUserName(employeeMap.get(vo.getServiceUserId()));
        vo.setBusinessUserName(employeeMap.get(vo.getBusinessUserId()));
        vo.setCareUserName(employeeMap.get(vo.getCareUserId()));
        vo.setOperationUserName(employeeMap.get(vo.getOperationUserId()));

        vo.setCustomerStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getCustomerStatus()));
        vo.setCustomerGradeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), vo.getCustomerGrade()));
        vo.setCustomerSourceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerSource.getCode(), vo.getCustomerSource()));
        vo.setCompanyIndustryName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCompanyIndustry()));

        vo.setCompanyScaleName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerScale.getCode(), vo.getCompanyScale()));
        vo.setCurrencyName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrency()));
        vo.setLanguageName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemLANGUAGE.getCode(), vo.getLanguage()));
        vo.setCompanyNatureName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustProp.getCode(), vo.getCompanyNature()));
        if (filterType != null) {
            if (filterType.equals("market")) {
                vo.setCustomerGradeEditFlag(false);
            } else {
                vo.setCustomerGradeEditFlag(true);
            }
        }


    }


    @Override
    public void downloadBatch(HttpServletResponse response, CrmCustomerQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmCustomerBatch.xlsx");
        PagingVO<CrmCustomerVO> paging = paging(query);
        List<CrmCustomerVO> records = paging.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("客户数据");
            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                int nextRow = 1;
                for (CrmCustomerVO dataPayload : records) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    excelUtil.setCellValue(row, 1, dataPayload.getBookNo());// 地址簿编号
                    excelUtil.setCellValue(row, 2, dataPayload.getCustomerName());// 客户名称
                    excelUtil.setCellValue(row, 3, dataPayload.getCustomerStatusName());// 客户状态
                    excelUtil.setCellValue(row, 4, dataPayload.getCustomerGradeName());// 客户级别
                    excelUtil.setCellValue(row, 5, dataPayload.getCustomerSourceName());// 客户来源

                    excelUtil.setCellValue(row, 6, dataPayload.getCompanyIndustryName());// 客户行业
                    excelUtil.setCellValue(row, 7, dataPayload.getCompanyPhone());// 客户电话
                    excelUtil.setCellValue(row, 8, dataPayload.getCompanyEmail());// 客户邮箱
                    excelUtil.setCellValue(row, 9, dataPayload.getCompanyFax());// 传真
                    excelUtil.setCellValue(row, 10, dataPayload.getProvinceName());// 省
                    excelUtil.setCellValue(row, 11, dataPayload.getCityName());// 市
                    excelUtil.setCellValue(row, 12, dataPayload.getDistrictName());// 区
                    excelUtil.setCellValue(row, 13, dataPayload.getCompanyAddress());// 详细地址
                    excelUtil.setCellValue(row, 14, dataPayload.getCompanyWebsite());// 网址

                    excelUtil.setCellValue(row, 15, dataPayload.getCompanyScaleName());// 规模
                    excelUtil.setCellValue(row, 16, dataPayload.getTaxNo());// 税号
                    excelUtil.setCellValue(row, 17, dataPayload.getCurrencyName());// 交易货币
                    excelUtil.setCellValue(row, 18, dataPayload.getLanguageName());// 语言
                    excelUtil.setCellValue(row, 19, dataPayload.getCompanyNatureName());// 公司性质
                    excelUtil.setCellValue(row, 20, dataPayload.getServiceUserName());// 服务负责人
                    excelUtil.setCellValue(row, 21, dataPayload.getBusinessUserName());// 商务负责人
                    excelUtil.setCellValue(row, 22, dataPayload.getCareUserName());//关怀负责人
                    excelUtil.setCellValue(row, 23, dataPayload.getOperationUserName());//运维售后负责人
                    excelUtil.setCellValue(row, 24, dataPayload.getCreateUserName());// 创建人
                    nextRow++;
                }
            }
            String fileName = "客户数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<CrmFollowVO> queryFollowList(Long customerId, Boolean withAcitityFollows) {
        //分别查询并排序
        List<CrmFollowVO> followVOS = new ArrayList<>();
        //客户关联的线索列表
        List<Long> leadIds = leadsDAO.queryByFormalCustomerId(customerId);
        //客户关联的商机列表
        List<Long> oppoIds = opportunityDAO.queryByFormalCustomerId(customerId);


//        //商机关联的市场活动列表
//        List<Long> activityIdsByOppoId = actActivityDAO.queryByOppoIds(oppoIds);
//        for (Long leadId : leadIds) {
        List<CrmFollowDO> leadsFollowDos = followDAO.queryByObjectIdsAndObjectType(leadIds, CrmFollowObjectEnum.Leads.getCode());
        followVOS.addAll(followService.toListVo(CrmFollowObjectEnum.Leads, leadsFollowDos));
//        }
//        for (Long oppoId : oppoIds) {
        List<CrmFollowDO> oppoFollowDos = followDAO.queryByObjectIdsAndObjectType(oppoIds, CrmFollowObjectEnum.Opportunity.getCode());
        followVOS.addAll(followService.toListVo(CrmFollowObjectEnum.Opportunity, oppoFollowDos));

        if (withAcitityFollows != null && withAcitityFollows) {
            //线索关联的市场活动列表
            List<Long> activiyProjIds = actActivityDAO.queryByLeadsIds(leadIds);
            List<Long> actIds = actActivityDAO.queryByIds(activiyProjIds);
            if (actIds != null && !actIds.isEmpty()) {
                List<CrmFollowVO> activityFollowVOS = new ArrayList<>();
                List<CrmActDynamicVO> dynamicVOS = actActivityDAO.queryActDynamicByPrjIds(actIds);
                for (CrmActDynamicVO dynamicVO : dynamicVOS) {
                    CrmFollowVO followVO = new CrmFollowVO();
                    followVO.setCreateTime(dynamicVO.getCreateTime());
                    followVO.setCreateUserId(dynamicVO.getCreateUserId());
                    followVO.setCreateUserName(dynamicVO.getEmployeeName());
                    followVO.setFollowContent(dynamicVO.getDynamicContent());
                    followVO.setFollowObject("activity");
                    followVO.setFollowObjectDesc("市场活动");
                    followVO.setFollowType(dynamicVO.getDynamicType());
                    followVO.setFollowTypeDesc(dynamicVO.getDynamicTypeName());
                    followVO.setId(dynamicVO.getId());
                    followVO.setModifyTime(dynamicVO.getModifyTime());
                    followVO.setModifyUserId(dynamicVO.getModifyUserId());
                    activityFollowVOS.add(followVO);
                }
                followVOS.addAll(activityFollowVOS);
            }


        }

//        }
        //按时间正序排序
        List<CrmFollowVO> collect = followVOS.stream().sorted((u1, u2) -> u1.getCreateTime().compareTo(u2.getCreateTime())).collect(Collectors.toList());
        return collect;
    }


    /**
     * 跟进级别的升降档操作
     *
     * @param customerId
     * @param grade
     */
    @Override
    @Transactional
    public void changeCustomerGrade(Long customerId, String grade) {
        //更新客户跟进级别
        dao.updateCustomerGrade(customerId, grade);
        //更新线索跟进级别
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setFormalCustomerId(customerId);
        Specification<CrmLeadsDO> spec = leadsDAO.getSpec(leadsQuery);
        List<CrmLeadsDO> leadsDOS = leadsDAO.findAll(spec);
        List<Long> leadsIds = leadsDOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        leadsDAO.updateCustomerGrade(leadsIds, grade);
        //更新潜在客户跟进级别(筛选出关联了潜在客户的线索)
        List<CrmLeadsDO> collect = leadsDOS.stream().filter(e -> e.getPotentialCustomerId() != null).collect(Collectors.toList());
        List<Long> potentialCustomerIds = collect.stream().map(e -> e.getPotentialCustomerId()).collect(Collectors.toList());
        potentialCustomerDAO.updateCustomerGrade(potentialCustomerIds, grade);
    }

    @Override
    public int checkCustNameUnique(String custName) {
        return repo.countByCustomerNameAndDeleteFlag(custName, 0);
    }


    @Override
    public String queryCompanyAddress(Long key) {
        CrmCustomerVO crmCustomerVO = dao.queryDetail(key);
        return crmCustomerVO.getCompanyAddress();
    }

    /**
     * 客户详情简版查询
     *
     * @param id id
     * @return {@link CrmCustomerSimpleVO}
     */
    @Override
    public CrmCustomerSimpleVO querySimpleByKey(Long id) {
        CrmCustomerVO crmCustomerVO = dao.queryDetail(id);
        Assert.notNull(crmCustomerVO, "客户不存在");
        return CrmCustomerConvert.INSTANCE.voToSimple(crmCustomerVO);
    }

    @Override
    public List<CrmCustomerDataVO> queryCustomer() {
        List<CrmCustomerDataVO> crmCustomerDataVOS = dao.queryList();
        return crmCustomerDataVOS;
    }


}
