package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmFollowQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmFollowConvert;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmFollowDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/17 - 15:09
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmFollowServiceImpl implements CrmFollowService {
    private final CrmFollowDAO followDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;



    public List<CrmFollowVO> toListVo(CrmFollowObjectEnum followObjectEnum, List<CrmFollowDO> followDOS){
        List<CrmFollowVO> collect = followDOS.stream().map(e -> {
            CrmFollowVO vo = CrmFollowConvert.INSTANCE.toVo(e);
            vo.setFollowObjectDesc(followObjectEnum.getDesc());
            vo.setFollowTypeDesc(cacheUtil.transferSystemSelection(followObjectEnum.getTypeEnum().getCode(),vo.getFollowType()));
            if(!ObjectUtils.isEmpty(vo.getCreateUserId())){
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            vo.setFileDatas(fileUtil.getFileDatas(vo.getFileCodes()));
            return vo;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<CrmFollowVO> queryFollowList(Long objectId, String followObjectType) {
        CrmFollowObjectEnum crmFollowObjectEnum = CrmFollowObjectEnum.valueOf(followObjectType);
        List<CrmFollowDO> followDOS = followDAO.queryByObjectIdAndObjectType(objectId, crmFollowObjectEnum.getCode());
        FunctionSelectionEnum typeEnum = crmFollowObjectEnum.getTypeEnum();
        List<CrmFollowVO> collect = followDOS.stream().map(e -> {
            CrmFollowVO vo = CrmFollowConvert.INSTANCE.toVo(e);
            vo.setFollowObjectDesc(crmFollowObjectEnum.getDesc());
            vo.setFollowTypeDesc(cacheUtil.transferSystemSelection(typeEnum.getCode(),vo.getFollowType()));
            if(!ObjectUtils.isEmpty(vo.getCreateUserId())){
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            vo.setFileDatas(fileUtil.getFileDatas(vo.getFileCodes()));
            return vo;
        }).collect(Collectors.toList());
        return collect;


//        String followTypeCode="";
//        switch (type){
//            case "activity":
//                followDOS=followDAO.queryByMarketId(objectId);
//                followTypeCode = FunctionSelectionEnum.CrmActDynamicType.getCode();
//                break;
//            case "potential_customer":
//                followTypeCode = FunctionSelectionEnum.CrmFollowMethod.getCode();
//                followDOS=followDAO.queryByPotentialCustomerId(objectId);
//                break;
//            case "opportunity":
//                followTypeCode = FunctionSelectionEnum.CrmFollowMethod.getCode();
//                followDOS=followDAO.queryByOpportunityId(objectId);
//                break;
//            case "customer":
//                followTypeCode = FunctionSelectionEnum.CrmFollowMethod.getCode();
//                followDOS=followDAO.queryByCustomerId(objectId);
//                break;
//            case "contacts":
//                followTypeCode = FunctionSelectionEnum.CrmFollowMethod.getCode();
//                followDOS=followDAO.queryByContactsId(objectId);
//                break;
//            case "leads":
//                followTypeCode = FunctionSelectionEnum.CrmFollowMethod.getCode();
//                followDOS=followDAO.queryByLeadsId(objectId);
//                break;
//        }

    }

    @Override
    public PagingVO<CrmFollowVO> listPage(CrmFollowQuery query) {
        CrmFollowObjectEnum crmFollowObjectEnum = CrmFollowObjectEnum.valueOf(query.getFollowObject());
        PagingVO<CrmFollowVO> followVOPagingVO = followDAO.listPage(query);
        FunctionSelectionEnum typeEnum = crmFollowObjectEnum.getTypeEnum();
        followVOPagingVO.getRecords().forEach(e -> {
            e.setFollowObjectDesc(crmFollowObjectEnum.getDesc());
            e.setFollowTypeDesc(cacheUtil.transferSystemSelection(typeEnum.getCode(), e.getFollowType()));
            if (!ObjectUtils.isEmpty(e.getCreateUserId())) {
                e.setCreateUserName(cacheUtil.getUserName(e.getCreateUserId()));
            }
            e.setFileDatas(fileUtil.getFileDatas(e.getFileCodes()));
        });
        return followVOPagingVO;
    }

    @Override
    public List<CrmFollowVO> list(CrmFollowQuery query) {
        final List<CrmFollowVO> list = followDAO.list(query);
        return list;
    }

    /**
     * 新建跟进
     * @param payload
     */
    @Transactional
    @Override
    public void addFollow(CrmFollowPayload payload) {
        CrmFollowDO ado = CrmFollowConvert.INSTANCE.toDo(payload);
        followDAO.save(ado);
    }

    /**
     * 更新跟进
     * @param payload
     */
    @Transactional
    @Override
    public void updateFollow(CrmFollowPayload payload) {
        followDAO.updateByKeyDynamic(payload);
    }

}
