package com.elitesland.tw.tw5.server.prd.crm.service;


import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.crm.payload.*;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmFollowQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.*;
import com.elitesland.tw.tw5.api.prd.crm.vo.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import com.elitesland.tw.tw5.api.prd.prj.query.PrjProjectQuery;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmLeadsConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmLeadsMembersConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmLeadsOffshoreConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOffshoreConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.*;
import com.elitesland.tw.tw5.server.prd.crm.entity.*;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemLogDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 16:32
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmLeadsServiceImpl extends BaseServiceImpl implements CrmLeadsService {
    private final CrmLeadsDAO dao;
    private final CrmLeadsMembersDAO membersDAO;
    private final PrdSystemLogDAO logDAO;
    private final CacheUtil cacheUtil;
    private final PrjProjectDAO marketDAO;
    private final CrmOffshoreService offshoreService;
    private final CrmOffshoreRuleAttrExcludeDAO offshoreRuleAttrExcludeDAO;
    private final CrmOffshoreDAO offshoreDAO;
    private final CrmLeadsOffshoreDAO leadsOffshoreDAO;
    private final PrdMessageConfigService messageConfigService;
    private final CrmFollowService followService;
    private final PrdSystemLogService logService;
    private final ExcelUtil excelUtil;
    private final PrdSystemSelectionService selectionService;
    private final PrjProjectDAO prjProjectDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final CrmOpportunityService opportunityService;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdOrgEmployeeService employeeService;
    private final FileService fileService;
    private final CrmCommonService crmCommonService;
    private final CrmCustomerDAO crmCustomerDAO;
    private final CrmCustomerService customerService;
    private final CrmFollowService crmFollowService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final PrdOrgOrganizationService organizationService;
    private final PrdMessageConfigRepo repoMessage;
    private final PrdOrgOrganizationDAO daoOrg;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
//    //private SysNumberRuleService numberRuleService;

    @Value("${tw4.leads.operation}")
    private String leads_operation;

    @Value("${tw4.url}")
    private String tw4_url;

    @Transactional
    @Override
    public CrmLeadsVO saveOne(CrmLeadsPayload payload) {
        CrmLeadsDO oldEntity = null;
//        payload.setCreateUserId(null);
//        payload.setModifyUserId(null);
        //4.0字段翻译
        if (payload.getCreateUserIdV4() != null) {
            payload.setCreateUserId(employeeDAO.getUserIdByV4(payload.getCreateUserIdV4()));
        }
        if (payload.getSaleUserIdV4() != null) {
            payload.setSaleUserId(employeeDAO.getUserIdByV4(payload.getSaleUserIdV4()));
        }
        if (payload.getSourceUserIdV4() != null) {
            payload.setSourceUserId(employeeDAO.getUserIdByV4(payload.getSaleUserIdV4()));
        }
        if (payload.getBonusDistributeToV4() != null) {
            if (payload.getBonusDistributeType() != null) {
                switch (payload.getBonusDistributeType()) {
                    case "personal":
                        payload.setBonusDistributeTo(employeeDAO.getUserIdByV4(payload.getBonusDistributeToV4()));
                        break;
                    case "department":
                        payload.setBonusDistributeTo(orgOrganizationDAO.getOrgIdByV4(payload.getBonusDistributeToV4()));
                        break;
                }
            }
        }
        // 获取当前登录用户
//        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
//        String userName = userDetails == null ? "" : userDetails.getUser().getUsername();
        if (payload.getId() == null) {
            String leadsNo = generateSeqNum("LEADS");
            // 生成编号
            payload.setLeadsNo(leadsNo);
            payload.setLeadsStage("leads");
            payload.setLeadsStatus("undistributed");
            if (payload.getLeadsType() != null && payload.getLeadsType() == 1) {
//                Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
                payload.setSaleUserId(payload.getSaleUserId() == null ? payload.getCreateUserId() == null ? null : payload.getCreateUserId() : payload.getSaleUserId());
                payload.setLeadsStage("sql");
                payload.setLeadsStatus("follow");
            }
        } else {
            oldEntity = dao.queryById(payload.getId());
        }
        CrmLeadsDO ado = CrmLeadsConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        List<CrmLeadsOffshoreDO> leadsOffshoreDOS = new ArrayList<>();
        //分开存，单独存关联表
        if (payload.getOffshoreIds() != null && !payload.getOffshoreIds().isEmpty()) {
            List<Long> offshoreIds = payload.getOffshoreIds();
            for (int i = 0; i < offshoreIds.size(); i++) {
                Long offshoreId = offshoreIds.get(i);
                CrmOffshoreDO offshoreDO = offshoreDAO.queryById(offshoreId);
                CrmLeadsOffshorePayload leadsOffshore = new CrmLeadsOffshorePayload();
                CrmOffshorePayload offshorePayload = new CrmOffshorePayload();
                offshorePayload.setId(offshoreId);
                CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
                leadsPayload.setId(ado.getId());
                leadsOffshore.setOffshore(offshorePayload);
                leadsOffshore.setLeads(leadsPayload);
                Long distributeLeadsRemindTime = offshoreDO.getOffshoreRule() == null ? null : offshoreDO.getOffshoreRule().getDistributeLeadsRemindTime();
                LocalDateTime triggerTime = LocalDateTime.now().plusSeconds((distributeLeadsRemindTime == null || distributeLeadsRemindTime < 1) ? 10800 : distributeLeadsRemindTime);
                leadsOffshore.setNotDistributeLeadsRemindTime(triggerTime);
                CrmLeadsOffshoreDO leadsOffshoreDO = leadsOffshoreDAO.save(CrmLeadsOffshoreConvert.INSTANCE.toDo(leadsOffshore));
                leadsOffshoreDOS.add(leadsOffshoreDO);
                //写一个原生sql,把排序写进去
//                leadsOffshoreDAO.setLeadsOffshoresOrder(leadsOffshoreDO.getId(), i);
                //查询和更新线索总数
                int num = offshoreDAO.countLeads(offshoreId);
                offshorePayload.setLeadsNum(num);
                offshoreDAO.updateByKeyDynamic(offshorePayload);
//                //新线索提醒(近海管理员)
//                List<CrmOffshoreAdminDO> offshoreAdmins = offshoreDO.getOffshoreAdmins();
//                for (CrmOffshoreAdminDO offshoreAdmin : offshoreAdmins) {
////                    LocalDateTime triggerTime = LocalDateTime.now().plusSeconds(300);
//                    PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20220711001503");
//                    Map<String, Object> result = new HashMap<>();
//                    result.put("offshoreName", offshoreDO.getOffshoreName());
//                    result.put("leadsName", payload.getLeadsName());
//                    result.put("url", "/leadsManager/offshore");
//                    messageConfigService.sendMessageConfig(configVO, result, "appoint_people", offshoreAdmin.getUserId().toString());
////                    messageConfigService.addJobMessage(ado.getId(),"newRemind",null,"管理员",offshoreAdmin.getUserId().toString(), "新线索通知",String.format("近海%s中新增了一条线索，请及时分配",offshoreDO.getOffshoreName()),"进入分配","/leadsManager/offshore");
//                }
            }
        }
        //保存默认近海
        if (payload.getLeadsType() != null) {
            CrmLeadsOffshorePayload leadsOffshore = new CrmLeadsOffshorePayload();
            CrmOffshorePayload offshorePayload = new CrmOffshorePayload();
            CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
            leadsPayload.setId(ado.getId());
            CrmOffshoreDO offshoreDO = new CrmOffshoreDO();
            if (payload.getLeadsType() == 0) {
                //到个人员工近海
                offshoreDO = offshoreDAO.queryByOffshoreName("员工近海");
                leadsPayload.setOffshoreId(offshoreDO.getId());
                dao.updateByKeyDynamic(leadsPayload);
                //新线索提醒(近海管理员)
//                List<CrmOffshoreAdminDO> offshoreAdmins = offshoreDO.getOffshoreAdmins();
//                for (CrmOffshoreAdminDO offshoreAdmin : offshoreAdmins) {
//                    PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20220711001503");
//                    Map<String, Object> result = new HashMap<>();
//                    result.put("offshoreName", offshoreDO.getOffshoreName());
//                    result.put("leadsName", payload.getLeadsName());
//                    result.put("url", "/leadsManager/offshore");
//                    messageConfigService.sendMessageConfig(configVO, result, "appoint_people", offshoreAdmin.getUserId().toString());
////                    messageConfigService.addJobMessage(ado.getId(),"newRemind",null,"管理员",offshoreAdmin.getUserId().toString(), "新线索通知",String.format("近海%s中新增了一条线索，请及时分配",offshoreDO.getOffshoreName()),"进入分配","/leadsManager/offshore");
//                }
                Long distributeLeadsRemindTime = offshoreDO.getOffshoreRule().getDistributeLeadsRemindTime();
                LocalDateTime triggerTime = LocalDateTime.now().plusSeconds((distributeLeadsRemindTime == null || distributeLeadsRemindTime < 1) ? 10800 : distributeLeadsRemindTime);
                leadsOffshore.setNotDistributeLeadsRemindTime(triggerTime);
                offshorePayload.setId(offshoreDO.getId());
                leadsOffshore.setOffshore(offshorePayload);
                leadsOffshore.setLeads(leadsPayload);
                CrmLeadsOffshoreDO save = leadsOffshoreDAO.save(CrmLeadsOffshoreConvert.INSTANCE.toDo(leadsOffshore));
                leadsOffshoreDOS.add(save);
                //写一个原生sql,把排序写进去
                leadsOffshoreDAO.setLeadsOffshoresOrder(save.getId(), 0);
            } else {
                //到无近海
//                offshoreDO = offshoreDAO.queryByOffshoreName("无近海");
//                leadsPayload.setOffshoreId(offshoreDO.getId());
                if (payload.getLeadsType() == 1) {
                    //同步数据到4.0
                    //Map<String, Object> map = BeanUtil.beanToMap(payload);
                    //String result = httpUtil.sendPost(tw4_url + leads_operation, map);
                    //String leadsId = httpUtil.geResultData(result);
                    //long leadsIdV4 = 0;
                    //if (StringUtils.hasText(leadsId)) {
                    //    if (StringUtil.isInteger(leadsId)) {
                    //        leadsIdV4 = Long.valueOf(leadsId);
                    //        leadsPayload.setLeadsIdV4(leadsIdV4);
                    //    }
                    //}
                }
                dao.updateByKeyDynamic(leadsPayload);
                //将销售人员加为团队成员
                CrmLeadsMembersPayload membersPayload = new CrmLeadsMembersPayload();
                membersPayload.setUserId(payload.getSaleUserId());
                CrmLeadsPayload leadsPayload1 = new CrmLeadsPayload();
                leadsPayload1.setId(ado.getId());
                membersPayload.setLeads(leadsPayload1);
                updateMembers(Collections.singletonList(membersPayload));
            }
        }
        //变更日志
        String fieldsLog = "";
        if (payload.getId() == null) {
            logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Leads.getCode(), "新建 " + ado.getLeadsName());
            // 获取新增日志
            fieldsLog = changeFieldLogUtil.getFieldsCreateLog(ado);
            CrmLeadsCustomerDO customer = ado.getCustomer();
            fieldsLog = fieldsLog + changeFieldLogUtil.getFieldsCreateLog(customer);
        } else {
            // 获取变更日志
            fieldsLog = changeFieldLogUtil.getFieldsUpdateLog(ado, oldEntity);
            fieldsLog = fieldsLog + changeFieldLogUtil.getFieldsUpdateLog(ado.getCustomer(), oldEntity.getCustomer());
        }
        if (fieldsLog != null && fieldsLog.length() > 0) {
            logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Leads.getCode(), fieldsLog);
        }
        //添加log
//        logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Leads.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Leads.getDesc());

        //TODO:超时未分配提醒
//        List<CrmOffshoreDO> offshores = ado.getOffshores();
//        for (CrmOffshoreDO offshore : offshores) {
//            Long distributeLeadsRemindTime = offshore.getOffshoreRule().getDistributeLeadsRemindTime();
//            String cron = TimeUtil.getCron(new Date(System.currentTimeMillis() + distributeLeadsRemindTime));
//            TimedTaskDO timedTaskDO = new TimedTaskDO();
//            timedTaskDO.setStatus(1);
//            timedTaskDO.setCron(cron);//执行日期
//            timedTaskDO.setJobName("提醒近海管理员分配线索");
//            timedTaskDO.setClassName("com.elitesland.tw.tw5crm.server.common.scheduling.ScheduleMethodsConfig");
//            timedTaskDO.setMethod("distributeLeadsRemind");
//            timedTaskDO.setObjectId(ado.getId());
//            TimedTaskDO add = jobService.add(timedTaskDO);
//            jobService.start(add);
//        }
        return CrmLeadsConvert.INSTANCE.toVo(ado);
    }


    @Transactional
    @Override
    public List<CrmOffshoreListVO> getOffshoreList(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();

        int i = offshoreDAO.countByOffshoreAdmin(userId);
        //TODO:先这样处理后面优化
        // 判断当前登录人是否是系统管理员or市场管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            CrmOffshoreQuery offshoreQuery = new CrmOffshoreQuery();
            Specification<CrmOffshoreDO> spec = offshoreDAO.getSpec(offshoreQuery);
            List<CrmOffshoreDO> all = offshoreDAO.findAll(spec);
            List<CrmOffshoreListVO> collect = all.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo(e)).filter(e -> !e.getOffshoreName().equals("无近海")).distinct().collect(Collectors.toList());
            return collect;
        } else if (i > 0) {//管理员视角近海列表
            CrmOffshoreQuery offshoreQuery = new CrmOffshoreQuery();
            offshoreQuery.setOffshoreAdminId(userId);
            Specification<CrmOffshoreDO> spec = offshoreDAO.getSpec(offshoreQuery);
            List<CrmOffshoreDO> all = offshoreDAO.findAll(spec);
            List<CrmOffshoreListVO> collect = all.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo(e)).filter(e -> !e.getOffshoreName().equals("无近海")).distinct().collect(Collectors.toList());
            return collect;
        } else {//销售视角线索列表
            //分配领取类型为all,当前登录人是近海成员，且线索状态为已退回或者未分配
            List<String> statusList = Arrays.asList("undistributed", "back");
            leadsOffshoreQuery.setLeadsStatusList(statusList);
            leadsOffshoreQuery.setMemberId(userId);
            leadsOffshoreQuery.setDistributeReceiveRule("all");
            Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
            List<CrmLeadsOffshoreDO> all = leadsOffshoreDAO.findAll(spec);
            List<CrmOffshoreListVO> collect = all.stream().map(e -> CrmOffshoreConvert.INSTANCE.toListVo(e.getOffshore())).filter(e -> !e.getOffshoreName().equals("无近海")).distinct().collect(Collectors.toList());
            return collect;
        }
    }


    @Override
    public PagingVO<CrmLeadsListVO> pagingOffshoreLeads(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        // 最新跟进时间筛选
        if (null != leadsOffshoreQuery.getFollowCreateTimeStart() || null != leadsOffshoreQuery.getFollowCreateTimeEnd()) {
            // 默认查询不到数据
            List<Long> de = new ArrayList<>();
            de.add(9999L);
            leadsOffshoreQuery.setLeadsIdsForFollow(de);
            // 跟进时间筛选
            CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
            //默认按照时间倒叙排序
            OrderItem orderItem = OrderItem.desc("createTime");
            crmFollowQuery.defaultOrder(orderItem);
            crmFollowQuery.setCreateTimeStart(leadsOffshoreQuery.getFollowCreateTimeStart());
            crmFollowQuery.setCreateTimeEnd(leadsOffshoreQuery.getFollowCreateTimeEnd());
            crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Leads.name());
            final List<CrmFollowVO> crmFollowVOList = crmFollowService.list(crmFollowQuery);
            final List<Long> potentialCustomerIdsForFollow = crmFollowVOList.stream().map(crmFollowVO ->
                    crmFollowVO.getObjectId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(potentialCustomerIdsForFollow)) {
                leadsOffshoreQuery.setLeadsIdsForFollow(potentialCustomerIdsForFollow);
            }
        }
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
        //TODO:这里应该用角色去判断
        int i = offshoreDAO.countByOffshoreAdmin(userId);
        Specification<CrmLeadsOffshoreDO> spec;
        // 判断当前登录人是否是系统管理员or市场管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        } else if (i > 0) {//管理员视角线索列表
//            leadsOffshoreQuery.setOffshoreAdminId(userId);
            spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        } else {//销售视角线索列表
            //分配领取类型为all,当前登录人是近海成员，且线索状态为已退回或者未分配

            List<String> statusList = Arrays.asList("undistributed", "back");
            leadsOffshoreQuery.setLeadsStatusList(statusList);
            leadsOffshoreQuery.setMemberId(userId);
            leadsOffshoreQuery.setDistributeReceiveRule("all");
            leadsOffshoreQuery.setFilterOffshore(true);
            spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        }
        PageRequest pageRequest = leadsOffshoreQuery.getPageRequest();
        Page<CrmLeadsOffshoreDO> all = leadsOffshoreDAO.findAll(spec, pageRequest);
        List<CrmLeadsOffshoreDO> content = all.getContent();
        List<CrmLeadsListVO> collect = transLeadsOffshoreDoToListVO(content);
        if (i < 1) {
            filterFields(collect);
        }
        //类型转化
        PagingVO pagingVO = new PagingVO<>(all.getTotalElements(), collect);
        return pagingVO;
    }


    @Override
    public List<CrmLeadsListVO> queryListMarketLeads(CrmLeadsQuery leadsQuery) {
        leadsQuery.setLeadsStageNotEqual("oppo");
        Specification<CrmLeadsDO> spec = dao.getSpec(leadsQuery);
        List<CrmLeadsDO> all = dao.findAll(spec);
        List<CrmLeadsListVO> collect = all.stream().map(e -> CrmLeadsConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
        transferList(collect);
        return collect;
    }


    @Override
    public PagingVO<CrmLeadsListVO> pageListMarketLeads(CrmLeadsQuery leadsQuery) {
        leadsQuery.setLeadsStageNotEqual("oppo");
        return pageByQuery(leadsQuery);
    }


    @Override
    public long countNotReceivedLeadsByUserId(long userId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setSaleUserId(userId);
        leadsOffshoreQuery.setLeadsStage("mql");
        leadsOffshoreQuery.setLeadsStatus("distributed");
        leadsOffshoreQuery.setFilterLeadsOffshore(true);
//        leadsOffshoreQuery.setFilterOffshore(true);
//        leadsOffshoreQuery.setCreateUserIdNotEqual(userId);
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = leadsOffshoreDAO.countBySpec(spec);
        return Integer.parseInt(num.toString());
    }


    @Override
    public PagingVO<CrmLeadsListVO> queryListNotReceivedLeadsByUserId(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
        leadsOffshoreQuery.setSaleUserId(userId);
        leadsOffshoreQuery.setLeadsStage("mql");
        leadsOffshoreQuery.setLeadsStatus("distributed");
        leadsOffshoreQuery.setFilterLeadsOffshore(true);
//        leadsOffshoreQuery.setFilterOffshore(true);
//        leadsOffshoreQuery.setCreateUserIdNotEqual(userId);
        PagingVO<CrmLeadsListVO> crmLeadsListVOPagingVO = pageByQuery(leadsOffshoreQuery);
        //隐藏销售人员字段
        List<CrmLeadsListVO> records = crmLeadsListVOPagingVO.getRecords();
        //records=records.stream().map(e->{e.setSaleUserId(-1l); return e;}).collect(Collectors.toList());
        crmLeadsListVOPagingVO.setRecords(records);
        return crmLeadsListVOPagingVO;
    }

    @Override
    public long countNotDistributedLeadsByUserId(long userId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setOffshoreAdminId(userId);
        List<String> statusList = Arrays.asList("undistributed", "back");
        leadsOffshoreQuery.setLeadsStatusList(statusList);
        leadsOffshoreQuery.setLeadsStage("mql");
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = leadsOffshoreDAO.countBySpec(spec);
        return num;
    }


    @Override
    public PagingVO<CrmLeadsListVO> queryListNotDistributedLeadsByUserId(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
        leadsOffshoreQuery.setOffshoreAdminId(userId);
        List<String> statusList = Arrays.asList("undistributed", "back");
        leadsOffshoreQuery.setLeadsStatusList(statusList);
        leadsOffshoreQuery.setLeadsStage("mql");
        return pageByQuery(leadsOffshoreQuery);
    }

    private PagingVO<CrmLeadsListVO> pageByQuery(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Page<CrmLeadsOffshoreDO> all = leadsOffshoreDAO.findAll(spec, leadsOffshoreQuery.getPageRequest());
        List<CrmLeadsOffshoreDO> content = all.getContent();
        List<CrmLeadsListVO> collect = transLeadsOffshoreDoToListVO(content);
        //类型转化
        PagingVO pagingVO = new PagingVO<>(all.getTotalElements(), collect);
        return pagingVO;
    }


    private PagingVO<CrmLeadsListVO> pageByQuery(CrmLeadsQuery leadsQuery) {
        Specification<CrmLeadsDO> spec = dao.getSpec(leadsQuery);
        Page<CrmLeadsDO> all = dao.findAll(spec, leadsQuery.getPageRequest());
        List<CrmLeadsDO> content = all.getContent();
        List<CrmLeadsListVO> collect = content.stream().map(e -> CrmLeadsConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
        transferList(collect);
        //类型转化
        PagingVO pagingVO = new PagingVO<>(all.getTotalElements(), collect);
        return pagingVO;
    }

    @Transactional
    public List<CrmLeadsListVO> transLeadsOffshoreDoToListVO(List<CrmLeadsOffshoreDO> leadsOffshoreDOS) {
        List<CrmLeadsDO> content = new ArrayList<>();
        for (CrmLeadsOffshoreDO crmLeadsOffshoreDO : leadsOffshoreDOS) {
            CrmLeadsDO leads = crmLeadsOffshoreDO.getLeads();
            CrmLeadsDO leadsClone = (CrmLeadsDO) leads.clone();
            leadsClone.setOffshore(crmLeadsOffshoreDO.getOffshore());
            content.add(leadsClone);
        }
        List<CrmLeadsListVO> collect = content.stream().map(e -> CrmLeadsConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
        transferList(collect);
        return collect;
    }


    /**
     * 查询市场活动下的线索个数
     *
     * @param marketId
     * @return
     */
    public Integer countMarketLeads(Long marketId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setMarketId(marketId);
        leadsOffshoreQuery.setLeadsStageNotEqual("oppo");
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = leadsOffshoreDAO.countBySpec(spec);
        return Integer.parseInt(num.toString());
    }

    /**
     * 查询市场活动下的跟进中的线索个数
     *
     * @param marketId
     * @return
     */
    public Integer countMarketLeadsSql(Long marketId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setMarketId(marketId);
        leadsOffshoreQuery.setLeadsStage("sql");
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = leadsOffshoreDAO.countBySpec(spec);
        return Integer.parseInt(num.toString());
    }

    /**
     * 查询市场活动下的已退回的线索个数
     *
     * @param marketId
     * @return
     */
    public Integer countMarketLeadsBack(Long marketId) {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setMarketId(marketId);
        leadsOffshoreQuery.setLeadsStage("mql");
        leadsOffshoreQuery.setLeadsStatus("back");
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        Long num = leadsOffshoreDAO.countBySpec(spec);
        return Integer.parseInt(num.toString());
    }

    /**
     * 线索跟进率
     *
     * @param projectId
     * @return
     */
    public BigDecimal countMarketLeadsFollowPercent(Integer marketLeads, Long projectId) {
        if (marketLeads.equals(0)) {
            return BigDecimal.ZERO;
        } else {
            Integer sqlLeads = countMarketLeadsSql(projectId);
            return new BigDecimal(sqlLeads).divide(new BigDecimal(marketLeads), 4, RoundingMode.UP).multiply(new BigDecimal(100));
        }
    }

    /**
     * 线索退回率
     *
     * @param projectId
     * @return
     */
    public BigDecimal countMarketLeadsBackPercent(Long projectId) {
        Integer backLeads = countMarketLeadsBack(projectId);
        Integer sqlLeads = countMarketLeadsSql(projectId);
        if (backLeads + sqlLeads == 0) {
            return BigDecimal.ZERO;
        } else {
            return new BigDecimal(backLeads).divide(new BigDecimal(sqlLeads + backLeads), 4, RoundingMode.UP).multiply(new BigDecimal(100));
        }
    }


    @Override
    public List<CrmLeadsListVO> queryListOffshoreLeads(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
        //TODO:这里应该用角色去判断
        int i = offshoreDAO.countByOffshoreAdmin(userId);
        Specification<CrmLeadsOffshoreDO> spec;
        if (i > 0) {//管理员视角线索列表
            leadsOffshoreQuery.setOffshoreAdminId(userId);
            spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        } else {//销售视角线索列表
            //分配领取类型为all,当前登录人是近海成员，且线索状态为已退回或者未分配
            List<String> statusList = Arrays.asList("undistributed", "back");
            leadsOffshoreQuery.setLeadsStage("sql");
            leadsOffshoreQuery.setLeadsStatusList(statusList);
            leadsOffshoreQuery.setMemberId(userId);
            leadsOffshoreQuery.setDistributeReceiveRule("all");
            spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        }
        List<CrmLeadsOffshoreDO> content = leadsOffshoreDAO.findAll(spec);
        List<CrmLeadsListVO> collect = transLeadsOffshoreDoToListVO(content);
        if (i < 1) {
            filterFields(collect);
        }
//        transferList(collect);
        return collect;
    }

    @Transactional
    @Override
    public PagingVO<CrmLeadsListVO> paging(CrmLeadsQuery leadsQuery) {
        if (leadsQuery.getFormalCustomerId() != null) {
            //默认需要权限
            if (leadsQuery.getIsPermission()) {
//                List<Long> marketUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
//                List<Long> saleUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_RES.getCode()));
//                List<Long> marketAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
//                List<Long> saleAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));

                Boolean marketAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
                Boolean marketUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
                Boolean saleAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
                Boolean saleUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode()));
                // 获取当前登录用户
                GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
                Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
                //过滤不符合要求的客户
//                if ((saleUserIdsByRole != null && !saleUserIdsByRole.isEmpty() && saleUserIdsByRole.contains(userId)) ||
//                        (saleAdminUserIdsByRole != null && !saleAdminUserIdsByRole.isEmpty() && saleAdminUserIdsByRole.contains(userId))
//                ) {
//                    leadsQuery.setSourceType("personal");
//                } else if ((marketUserIdsByRole != null && !marketUserIdsByRole.isEmpty() && marketUserIdsByRole.contains(userId)) ||
//                        (marketAdminUserIdsByRole != null && !marketAdminUserIdsByRole.isEmpty() && marketAdminUserIdsByRole.contains(userId))
//                ) {
//                    leadsQuery.setSourceType("market");
//                }

                if (saleUserIdsByRole || saleAdminUserIdsByRole) {
                    leadsQuery.setSourceType("personal");
                } else if (marketAdminUserIdsByRole || marketUserIdsByRole) {
                    leadsQuery.setSourceType("market");
                } else {
                    leadsQuery.setCreateUserId(GlobalUtil.getLoginUserId());
                }
            }

            return pageByQuery(leadsQuery);
        } else {
            leadsQuery.setLeadsStatusNotIn(Arrays.asList("undistributed", "back"));
            // 跟进时间筛选
            if (null != leadsQuery.getFollowCreateTimeStart() || null != leadsQuery.getFollowCreateTimeEnd()) {
                // 默认查询不到数据
                List<Long> de = new ArrayList<>();
                de.add(9999L);
                leadsQuery.setLeadsIdsForFollow(de);
                // 跟进时间筛选
                CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
                //默认按照时间倒叙排序
                OrderItem orderItem = OrderItem.desc("createTime");
                crmFollowQuery.defaultOrder(orderItem);
                crmFollowQuery.setCreateTimeStart(leadsQuery.getFollowCreateTimeStart());
                crmFollowQuery.setCreateTimeEnd(leadsQuery.getFollowCreateTimeEnd());
                crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Leads.name());
                final List<CrmFollowVO> crmFollowVOList = crmFollowService.list(crmFollowQuery);
                final List<Long> potentialCustomerIdsForFollow = crmFollowVOList.stream().map(crmFollowVO ->
                        crmFollowVO.getObjectId()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(potentialCustomerIdsForFollow)) {
                    leadsQuery.setLeadsIdsForFollow(potentialCustomerIdsForFollow);
                }
            }

            // 获取当前登录用户
            GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
            Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
            // 判断当前登录人是否是系统管理员or销售管理员
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
            if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
//            leadsQuery.setLeadsStage("sql");
                leadsQuery.setLeadsStageIn(Arrays.asList("oppo", "sql"));
                return pageByQuery(leadsQuery);
            }
            // 部门下的成员包括当前登录人本人
            List<Long> userIds = new ArrayList<>();
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
            if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                Long orgId = prdOrgEmployeeRefVO.getOrgId();
                //查询部门下的成员
                List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = orgOrganizationDAO.queryEmployeeList(orgId);
                userIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            } else {
                userIds = Collections.singletonList(userId);
            }
            //当前登录人做为成员的所有线索
            List<CrmLeadsMembersDO> crmLeadsMembersDOS = membersDAO.queryByUserIds(userIds);
            List<Long> ids = crmLeadsMembersDOS.stream().map(e -> e.getLeads().getId()).collect(Collectors.toList());
            leadsQuery.setIds(ids);
            //调整，转移出去的线索不能再看到
            leadsQuery.setSaleUserId(userId);
            leadsQuery.setLeadsStageNotIn(Arrays.asList("leads", "mql"));
//        leadsQuery.setSaleOrCreateUserId(userId);
//        leadsQuery.setLeadsStageNotEqual("leads");
            leadsQuery.setLeadsStatusNotIn(Arrays.asList("undistributed", "back"));
//        Specification<CrmLeadsDO> spec = dao.getSpec(leadsQuery);
            return pageByQuery(leadsQuery);
        }


    }


//    @Override
//    public PagingVO<CrmLeadsListVO> paging(CrmLeadsQuery leadsQuery) {
//        // 获取当前登录用户
//        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
//        Long userId = userDetails==null?0:userDetails.getUser().getId();
//        //调整，转移出去的线索不能再看到
//        leadsQuery.setSaleUserId(userId);
//        leadsQuery.setLeadsStageNotIn(Arrays.asList("leads","mql"));
////        leadsQuery.setSaleOrCreateUserId(userId);
////        leadsQuery.setLeadsStageNotEqual("leads");
//        leadsQuery.setLeadsStatusNotIn(Arrays.asList("undistributed","back"));
//        Specification<CrmLeadsDO> spec = dao.getSpec(leadsQuery);
//        List<CrmLeadsDO> all = dao.findAll(spec);
//        List<CrmLeadsListVO> collect = all.stream().map(e -> CrmLeadsConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
//        transferList(collect);
////        collect=collect.stream().filter(e->{
////            Long createUserId = e.getCreateUserId();
////            boolean flag=true;
////            if(!createUserId.equals(userId)){
////                //如果当前登录人不是线索的创建人，要受到状态的约束
////                flag= (e.getLeadsStage().equals("sql") ||  e.getLeadsStage().equals("oppo"));
////            }
////            return flag;
////        }).collect(Collectors.toList());
//        PageRequest pageRequest = leadsQuery.getPageRequest();
//        int pageSize = pageRequest.getPageSize();
//        int pageNumber = pageRequest.getPageNumber();
//        int size = collect.size();
//        int  i = pageSize * pageNumber;
//        List<CrmLeadsListVO> pageCollect=CollectionUtil.sub(collect, i, i+pageSize);
////        List<CrmLeadsListVO> pageCollect=collect.subList(i,i+pageSize);
//        PagingVO pagingVO= new PagingVO<>(size,pageCollect);
//        return pagingVO;
//    }

    @Override
    public PagingVO<CrmLeadsListVO> pagingPersonalLeads(CrmLeadsQuery leadsQuery) {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
        leadsQuery.setCreateUserId(userId);
        return pageByQuery(leadsQuery);

    }


    @Override
    public List<CrmLeadsListVO> queryList(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
//        // 获取当前登录用户
//        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
//        Long userId = userDetails==null?0:userDetails.getUser().getId();
        //leadsOffshoreQuery.setSaleOrCreateUserId(userId);
//        if(leadsOffshoreQuery.getSaleUserId()>-1){
//            leadsOffshoreQuery.setSaleUserId(userId);
//        }
//        leadsOffshoreQuery.setLeadsStage("sql");
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> content = leadsOffshoreDAO.findAll(spec);
        List<CrmLeadsListVO> collect = transLeadsOffshoreDoToListVO(content);
//        transferList(collect);
        return collect;
    }


    /**
     * 字段权限处理
     *
     * @return
     */
    private void filterFields(List<CrmLeadsListVO> leadsListVOS) {

        for (CrmLeadsListVO leadsListVO : leadsListVOS) {
            CrmLeadsCustomerVO customer = leadsListVO.getCustomer();
            CrmOffshoreListVO offshore = leadsListVO.getOffshore();
            List<CrmOffshoreRuleAttrExcludeDO> crmOffshoreRuleAttrExcludeDOS = offshoreRuleAttrExcludeDAO.queryByOffshoreId(offshore.getId());
            for (CrmOffshoreRuleAttrExcludeDO excludeDO : crmOffshoreRuleAttrExcludeDOS) {
                switch (excludeDO.getLeadsAttribute()) {
                    case "customerName":
                    case "customerIndustry":
                    case "customerContacts":
                    case "contactsDepartment":
                    case "contactsPosition":
                    case "contactsPhone":
                        //根据这些属性名赋空的属性值
                        BeanUtil.setFieldValueByFieldName(excludeDO.getLeadsAttribute(), null, customer);
                        break;
                    default:
                        //根据这些属性名赋空的属性值
                        BeanUtil.setFieldValueByFieldName(excludeDO.getLeadsAttribute(), null, leadsListVO);
                }
            }
        }
    }


    @Override
    public List<CrmLeadsMembersVO> queryMembersList(Long leadsId) {
        List<CrmLeadsMembersDO> crmLeadsMembersDOS = membersDAO.queryByLeadsId(leadsId);
        List<CrmLeadsMembersVO> collect = crmLeadsMembersDOS.stream().map(e -> {
            CrmLeadsMembersVO vo = CrmLeadsMembersConvert.INSTANCE.toVo(e);
            if (!ObjectUtils.isEmpty(vo.getUserId())) {
                String userName = cacheUtil.getUserName(vo.getUserId());
                vo.setUserName(userName);
//                SysUserDTO byId = sysUserService.getById(vo.getUserId());
//                if (byId!=null){
//                    vo.setUserName(byId.getFirstName());
//                }
            }
            return vo;
        }).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<PrdSystemLogVO> queryLogList(Long leadsId, String stage) {
        List<PrdSystemLogVO> prdSystemLogVOS = logService.queryLogList(leadsId, PrdSystemObjectEnum.Leads.getCode());
        //近海线索详情页不能看到销售阶段的操作记录，操作阶段的更新记录都打上标记，这里过滤掉
        if (stage != null && stage.equals("market")) {
            prdSystemLogVOS = prdSystemLogVOS.stream().filter(e -> (e.getExtString1() == null || (e.getExtString1() != null && !e.getExtString1().equals("saleLog")))).collect(Collectors.toList());
        }
        return prdSystemLogVOS;
    }


    @Override
    public PagingVO<PrdSystemLogVO> pageLog(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Leads.getCode());
        return logService.pageLog(query);
    }

//    @Override
//    public List<CrmFollowVO> queryFollowList(Long leadsId) {
//        List<CrmFollowDO> followDOS = followDAO.queryByLeadsId(leadsId);
//        List<CrmFollowVO> collect = followDOS.stream().map(e -> {
//            CrmFollowVO vo = CrmFollowConvert.INSTANCE.toVo(e);
//            vo.setFollowTypeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmFollowLeads.getCode(),vo.getFollowType()));
//            if(!ObjectUtils.isEmpty(vo.getCreateUserId())){
//                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
////                SysUserDTO byId = sysUserService.getById(vo.getCreateUserId());
////                if (byId!=null){
////                    vo.setCreateUserName(byId.getFirstName());
////                }
//            }
//            return vo;
//        }).collect(Collectors.toList());
//        return collect;
//    }

    @Override
    public boolean isOffshoreAdmin() {
        boolean flag = false;
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
        int i = offshoreDAO.countByOffshoreAdmin(userId);
        if (i > 0) {
            flag = true;
        }
        return flag;
    }

    @Transactional
    @Override
    public void deleteOffshoreSoft(Long offshoreId, Long newOffshoreId) {
        //查询近海下面的线索
        List<CrmLeadsOffshoreDO> leadsOffshoreDOS = offshoreDAO.queryOffshoreLeads(offshoreId);
        if (leadsOffshoreDOS == null || leadsOffshoreDOS.isEmpty()) {

        } else {
            for (CrmLeadsOffshoreDO leadsOffshoreDO : leadsOffshoreDOS) {
                CrmLeadsDO leads = leadsOffshoreDO.getLeads();
                CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
                leadsPayload.setId(leads.getId());
                leadsPayload.setOffshoreId(offshoreId);
                leadsPayload.setNewOffshoreId(newOffshoreId);
                leadsPayload.setTransferReason("原近海删除，线索转移到本近海");
                //转移线索到目标近海
                transferLeadsOffshore(leadsPayload);
            }
            CrmOffshorePayload offshorePayload = new CrmOffshorePayload();
            offshorePayload.setId(newOffshoreId);
            //查询和更新线索总数
            int num = offshoreDAO.countLeads(newOffshoreId);
            offshorePayload.setLeadsNum(num);
            offshoreDAO.updateByKeyDynamic(offshorePayload);
        }
        CrmOffshorePayload payload = new CrmOffshorePayload();
        payload.setId(offshoreId);
        payload.setDeleteFlag(1);
        offshoreService.dynamicUpdate(payload);
    }

    /**
     * 更新成员列表
     *
     * @param members
     */
    @Override
    public void updateMembers(List<CrmLeadsMembersPayload> members) {
        for (CrmLeadsMembersPayload member : members) {
            CrmLeadsMembersDO crmLeadsMembersDO = CrmLeadsMembersConvert.INSTANCE.toDo(member);
            if (crmLeadsMembersDO.getDeleteFlag() != null && crmLeadsMembersDO.getDeleteFlag() == 1) {
                //保证下次新增不会重复
                crmLeadsMembersDO.setUserId(crmLeadsMembersDO.getUserId() + System.currentTimeMillis() / 1000);
            }
            try {
                membersDAO.save(crmLeadsMembersDO);
            } catch (Exception ex) {
                continue;
            }
        }
    }

    @SneakyThrows
    @Transactional
    @Override
    public void dynamicUpdate(CrmLeadsPayload payload, String action) {
        CrmLeadsDO crmLeadsDO = dao.queryById(payload.getId());
        //将旧值克隆出来
        CrmLeadsDO entityLog = new CrmLeadsDO();
        BeanUtils.copyProperties(crmLeadsDO, entityLog);
        CrmLeadsCustomerDO oldCustomerDO = new CrmLeadsCustomerDO();
        BeanUtils.copyProperties(crmLeadsDO.getCustomer(), oldCustomerDO);
        if (payload.getCustomer() != null && payload.getCustomer().getCustomerGrade() != null && crmLeadsDO.getFormalCustomerId() != null) {
            //更新关联客户的级别
            customerService.changeCustomerGrade(crmLeadsDO.getFormalCustomerId(), payload.getCustomer().getCustomerGrade());
        }
//        String oldName = crmLeadsDO.getCustomer().getCustomerContacts();
//        String oldPhone = crmLeadsDO.getCustomer().getContactsPhone();
//        String newName = null;
//        String newPhone = null;
//        if (payload.getCustomer() != null) {
//            newName = payload.getCustomer().getCustomerContacts();
//            newPhone = payload.getCustomer().getContactsPhone();
//        }
//        String detail = GlobalUtil.getContantsLog(action + PrdSystemObjectEnum.Leads.getDesc(), oldName, newName, oldPhone, newPhone);

//        logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), detail);
        //先更新日志
//        saveLog(payload);
//        logService.saveLog(payload,CrmLeadsDO.class);
        //执行更新
        dao.updateByKeyDynamic(payload);
        //重新查询一遍获得新值
        crmLeadsDO = dao.queryById(payload.getId());
        String fieldsLog = "";
        if (payload.getPreSaleUserId() != null) {
            //线索人员之间的转移
            fieldsLog = "将 " + crmLeadsDO.getLeadsName() + " 由 " + cacheUtil.getUserName(crmLeadsDO.getPreSaleUserId()) + " 转移给 " + cacheUtil.getUserName(crmLeadsDO.getSaleUserId());
        } else if (payload.getNewOffshoreId() != null) {
            Long oldOffshore = payload.getOldOffshoreId();
            Long newOffshore = crmLeadsDO.getLeadsOffshores().get(0).getOffshore().getId();
            //近海之间的转移
            fieldsLog = "将 " + crmLeadsDO.getLeadsName() + " 由 " + offshoreDAO.queryById(oldOffshore).getOffshoreName() + " 转移到 " + offshoreDAO.queryById(newOffshore).getOffshoreName();
        } else if (payload.getBackReason() != null) {
            //已退回的线索
            fieldsLog = "退回 " + crmLeadsDO.getLeadsName() + "\n" + "退回原因：" + crmLeadsDO.getBackReason();
        } else if (payload.getWithdrawReason() != null) {
            //已收回的线索
            fieldsLog = "收回 " + crmLeadsDO.getLeadsName() + "\n" + "收回原因：" + crmLeadsDO.getWithdrawReason();
        } else {
            fieldsLog = changeFieldLogUtil.getFieldsUpdateLog(crmLeadsDO, entityLog);
            fieldsLog = fieldsLog + changeFieldLogUtil.getFieldsUpdateLog(crmLeadsDO.getCustomer(), oldCustomerDO);
        }
        if (fieldsLog != null && fieldsLog.length() > 0) {
            //根据当前的阶段给给扩展字段1赋值
            String leadsStage = crmLeadsDO.getLeadsStage();
            if (leadsStage != null && (leadsStage.equals("oppo") || leadsStage.equals("sql"))) {
                logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), fieldsLog, "saleLog");
            } else {
                logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), fieldsLog);
            }
        }
    }

//    private void saveLog(CrmLeadsPayload payload){
//        //翻译系统选择项
//        Map<String,String> selections=new HashMap<>();
//        selections.put("leadsStatus",FunctionSelectionEnum.CrmLeadsStatus.getCode());
//        selections.put("leadsStage",FunctionSelectionEnum.CrmLeadsStage.getCode());
//        selections.put("sourceType",FunctionSelectionEnum.CrmLeadsSourceType.getCode());
//        selections.put("closeReason",FunctionSelectionEnum.CrmLeadsCloseReason.getCode());
//        selections.put("bonusDistributeType",FunctionSelectionEnum.CrmLeadsBonusDistributeType.getCode());
//
//
//
//        //翻译关联表的name字段
//        List<Object[]> joinObjects=new ArrayList<>();
//        Object[] marketTrans=new Object[3];
//        marketTrans[0]="marketId";
//        marketTrans[1]=PrjProjectDO.class;
//        marketTrans[2]="project_name";
//
//        joinObjects.add(marketTrans);
//
//        //特殊变更动作名称（"更改","分配,"转移"等等）
//        Map<String,String> changeNames=new HashMap<>();
//        if(payload.getLeadsStatus()!=null && payload.getLeadsStatus().equals("distributed")){
//            changeNames.put("saleUserId","分配至");
//        }else{
//            changeNames.put("saleUserId","转移至");
//        }
//        changeNames.put("offshoreId","转移至");
//
//        //翻译用户
//        List<String> transUserIds=Arrays.asList("bonusDistributeTo","saleUserId");
//
//        logService.saveLog(PrdSystemObjectEnum.Potential_customer.getCode(), payload, payload.getId(), CrmPotentialCustomerDO.class, selections, transUserIds,joinObjects,changeNames);
//
//        //子表字段修改
//        CrmLeadsCustomerPayload customerPayload = payload.getCustomer();
//        logService.saveLog(PrdSystemObjectEnum.Potential_customer.getCode(), customerPayload, payload.getId(), CrmCustomerDO.class, null, null,null,null);
//
//    }

    @Transactional
    @Override
    public Object distributeLeads(CrmLeadsPayload payload) {
        Long offshoreId = payload.getOffshoreId();
        //读取规则
        CrmOffshoreDO offshoreDO = offshoreDAO.queryById(offshoreId);
        CrmOffshoreRuleDO offshoreRule = offshoreDO.getOffshoreRule();
        String distributeReceiveRule = offshoreRule.getDistributeReceiveRule();
        List<CrmOffshoreMembersDO> offshoreMembers = offshoreDO.getOffshoreMembers();
        distributeReceiveRule = distributeReceiveRule == null ? "distribute_all" : distributeReceiveRule;
        if (distributeReceiveRule.equals("distribute_all")) {
            //可以分配给非成员
        } else {
            boolean flag = false;
            //只能分配给成员
            for (CrmOffshoreMembersDO offshoreMember : offshoreMembers) {
                if (offshoreMember.getUserId().equals(payload.getSaleUserId())) {
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                throw TwException.error("", "根据当前近海的规则，线索不能分配给近海成员以外的人员");
            }
        }
        //更新状态为已分配
        payload.setLeadsStatus("distributed");
        payload.setDistributeDate(LocalDate.now());
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setLeadsId(payload.getId());
        //将销售人员加为团队成员
        CrmLeadsMembersPayload membersPayload = new CrmLeadsMembersPayload();
        membersPayload.setUserId(payload.getSaleUserId());
        membersPayload.setLeads(payload);
        updateMembers(Collections.singletonList(membersPayload));
        //查询当前线索所有关联的近海
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> leadsOffshoreDOS = leadsOffshoreDAO.findAll(spec);
        for (CrmLeadsOffshoreDO leadsOffshoreDO : leadsOffshoreDOS) {
            CrmLeadsOffshorePayload crmLeadsOffshorePayload = new CrmLeadsOffshorePayload();
            crmLeadsOffshorePayload.setId(leadsOffshoreDO.getId());
            crmLeadsOffshorePayload.setNullFields(Arrays.asList("notDistributeLeadsRemindTime"));
            leadsOffshoreDAO.updateByKeyDynamic(crmLeadsOffshorePayload);
        }
//        List<PrdMessageConfigVO> messageConfig= messageConfigService.queryByObjectIdAndAction(payload.getId(),"distributeRemind");
//        if(messageConfig!=null && !messageConfig.isEmpty()){
//            List<Long> collect = messageConfig.stream().map(e -> e.getId()).collect(Collectors.toList());
//            messageConfigService.recall(collect);
//        }
        //开启超时未跟进提醒
        Long followLeadsRemindTime = (offshoreDO.getOffshoreRule().getFollowLeadsRemindTime() == null || offshoreDO.getOffshoreRule().getFollowLeadsRemindTime() < 1) ? 10800 : offshoreDO.getOffshoreRule().getFollowLeadsRemindTime();
//        List<CrmOffshoreAdminDO> offshoreAdmins = offshoreDO.getOffshoreAdmins();
        LocalDateTime remindTime = LocalDateTime.now().plusSeconds(followLeadsRemindTime);
        payload.setNotFollowLeadsRemindTime(remindTime);

//        for (CrmOffshoreAdminDO offshoreAdmin : offshoreAdmins) {
//            messageConfigService.addJobMessage(payload.getId(),"followRemind",LocalDateTime.now().plusSeconds(followLeadsRemindTime),cacheUtil.getUserName(offshoreAdmin.getUserId()),payload.getSaleUserId().toString(), "线索超时未跟进通知",String.format("近海%s中有一条线索尚未跟进，请及时跟进",offshoreDO.getOffshoreName()),"进入跟进","/leadsManager/management");
//        }
        dynamicUpdate(payload, PrdSystemLogEnum.DISTRIBUTE.getDesc());

        //线索分配邮件通知
        return sendLeadsMessage("distribute", dao.queryById(payload.getId()));

    }

    @Transactional
    @Override
    public void batchDistributeLeads(List<CrmLeadsPayload> payloads) {
        for (CrmLeadsPayload payload : payloads) {
            distributeLeads(payload);
        }
    }


    @Transactional
    @Override
    public void withdrawLeads(CrmLeadsPayload payload) {
        CrmLeadsVO crmLeadsVO = dao.queryByKey(payload.getId());
        CrmLeadsVO crmLeadsVOCopy = new CrmLeadsVO();
        BeanUtils.copyProperties(crmLeadsVO, crmLeadsVOCopy);
        payload.setLeadsStatus("undistributed");
        payload.setLeadsStage("mql");
        List<String> nullFields = Arrays.asList("saleUserId", "distributeDate");
        payload.setNullFields(nullFields);
        dynamicUpdate(payload, PrdSystemLogEnum.WITHDRAW.getDesc());

        crmLeadsVO = dao.queryByKey(payload.getId());
        //发送消息通知
        PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20220711001505");
        Map<String, Object> result = new HashMap<>();
        result.put("leadsName", crmLeadsVO.getLeadsName());
        result.put("withdrawReason", crmLeadsVO.getWithdrawReason());
        result.put("url", "/leadsManager/detail?id=" + payload.getId() + "&offshoreId=-1&from=leads&canEdit=false");
        messageConfigService.sendMessageConfig(configVO, result, "appoint_people", crmLeadsVOCopy.getSaleUserId().toString());
    }

    @Override
    public void receiveLeads(Long key) {
        CrmLeadsPayload payload = new CrmLeadsPayload();
        //只更新阶段为sql
        payload.setLeadsStage("sql");
        payload.setLeadsStatus("follow");
        payload.setId(key);
        dynamicUpdate(payload, PrdSystemLogEnum.RECEIVE.getDesc());
        //线索分配邮件通知
        sendLeadsMessage("receive", dao.queryById(payload.getId()));
    }


    @Transactional
    @Override
    public void backLeads(CrmLeadsPayload payload) {
        Long leadsId = payload.getId();
        CrmLeadsDO leadsDO = dao.queryById(leadsId);
//        List<CrmLeadsOffshoreDO> leadsOffshores = leadsDO.getLeadsOffshores();
//        for (CrmLeadsOffshoreDO leadsOffshore : leadsOffshores) {
//            if(leadsOffshore.getOffshore().getOffshoreName().equals("无近海")){
//                throw TwException.error("","销售人员报备的线索不能退回！");
//            }
//        }
        Long preSaleUserId = leadsDO.getPreSaleUserId();
        String action = "";
        if (preSaleUserId != null) {
            payload.setSaleUserId(preSaleUserId);
            List<String> nullFields = Arrays.asList("distributeDate");
            payload.setNullFields(nullFields);
            action = "拒绝";
            //将上一个销售设为团队成员
            CrmLeadsMembersPayload membersPayload = new CrmLeadsMembersPayload();
            membersPayload.setUserId(preSaleUserId);
            membersPayload.setLeads(payload);
            updateMembers(Collections.singletonList(membersPayload));
        } else {
            //更新状态为已退回
            payload.setLeadsStatus("back");
            payload.setLeadsStage("mql");
//            payload.setSourceType("personal");
//            payload.setNullFields(Arrays.asList("market"));
//            payload.setOffshoreId(585574794225788164L);// 默认近海
            List<String> nullFields = Arrays.asList("saleUserId", "distributeDate");
            payload.setNullFields(nullFields);
            action = "退回";
            //清空团队成员
            List<CrmLeadsMembersDO> crmLeadsMembersDOS = membersDAO.queryByLeadsId(payload.getId());
            if (crmLeadsMembersDOS != null && crmLeadsMembersDOS.size() > 0) {
                membersDAO.deleteSoft(crmLeadsMembersDOS.stream().map(e -> e.getId()).collect(Collectors.toList()));
            }
            int existNum = leadsOffshoreDAO.getExist(leadsId, 585574794225788164L);
            if (leadsDO.getSourceType() != null && leadsDO.getSourceType().equals("personal") && existNum < 1) {
                // 线索报备的线索退回后 进入到“默认近海”近海池，且“来源类型”为“个人”、“市场活动”为空、来源类型条件搜索同步
                CrmLeadsOffshoreDO crmLeadsOffshoreDO = new CrmLeadsOffshoreDO();
                CrmLeadsDO crmLeadsDO = new CrmLeadsDO();
                crmLeadsDO.setId(leadsId);
                CrmOffshoreDO newOffshoreDO = new CrmOffshoreDO();
                newOffshoreDO.setId(585574794225788164L);// 默认近海
                crmLeadsOffshoreDO.setOffshore(newOffshoreDO);
                crmLeadsOffshoreDO.setLeads(crmLeadsDO);
                leadsOffshoreDAO.save(crmLeadsOffshoreDO);
            }
            //线索分配邮件通知
            sendLeadsMessage("back", dao.queryById(payload.getId()));
        }
        dynamicUpdate(payload, PrdSystemLogEnum.BACK.getDesc());
    }

    @Transactional
    @Override
    public void transferLeadsUser(CrmLeadsPayload payload) {
//        if(payload.getSaleUserId().equals(payload.getCreateUserId())){
//            payload.setLeadsStage("sql");
//        }else{
        payload.setLeadsStage("mql");
//        }
        CrmLeadsDO leadsDO = dao.queryById(payload.getId());
        payload.setLeadsStatus("distributed");
        payload.setPreSaleUserId(leadsDO.getSaleUserId());
        dynamicUpdate(payload, PrdSystemLogEnum.TRANSFER.getDesc());
        //清空团队成员
        List<CrmLeadsMembersDO> crmLeadsMembersDOS = membersDAO.queryByLeadsId(payload.getId());
        if (crmLeadsMembersDOS != null && crmLeadsMembersDOS.size() > 0) {
            membersDAO.deleteSoft(crmLeadsMembersDOS.stream().map(e -> e.getId()).collect(Collectors.toList()));
        }
        //将新销售人员加为团队成员
        CrmLeadsMembersPayload membersPayload = new CrmLeadsMembersPayload();
        membersPayload.setUserId(payload.getSaleUserId());
        membersPayload.setLeads(payload);
        updateMembers(Collections.singletonList(membersPayload));
    }

    @Transactional
    @Override
    public void transferLeadsOffshore(CrmLeadsPayload payload) {

        CrmLeadsDO leadsDO = dao.queryById(payload.getId());
        CrmOffshoreDO offshore = leadsDO.getLeadsOffshores().get(0).getOffshore();
        //将旧值克隆出来
        CrmOffshoreDO offshoreCopy = new CrmOffshoreDO();
        BeanUtils.copyProperties(offshore, offshoreCopy);
        payload.setOldOffshoreId(offshoreCopy.getId());

        //查询对应关系，查询当前线索对应的近海
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setOffshoreId(payload.getOffshoreId());
        leadsOffshoreQuery.setLeadsId(payload.getId());
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> content = leadsOffshoreDAO.findAll(spec);
        CrmLeadsOffshoreDO crmLeadsOffshoreDO = content.get(0);
        Long newOffshoreId = payload.getNewOffshoreId();
        CrmOffshoreDO newOffshoreDO = new CrmOffshoreDO();
        newOffshoreDO.setId(newOffshoreId);
        crmLeadsOffshoreDO.setOffshore(newOffshoreDO);
        try {
            leadsOffshoreDAO.save(crmLeadsOffshoreDO);
        } catch (Exception e) {
            //删除本条记录
            leadsOffshoreDAO.deleteSoft(crmLeadsOffshoreDO.getId());
        }
        payload.setLeadsStatus("undistributed");
//        payload.setLeadsStage("sql");
        payload.setOffshoreId(newOffshoreId);
        dynamicUpdate(payload, PrdSystemLogEnum.TRANSFER.getDesc());
        //清空团队成员
        List<CrmLeadsMembersDO> crmLeadsMembersDOS = membersDAO.queryByLeadsId(payload.getId());
        if (crmLeadsMembersDOS != null && crmLeadsMembersDOS.size() > 0) {
            membersDAO.deleteSoft(crmLeadsMembersDOS.stream().map(e -> e.getId()).collect(Collectors.toList()));
        }
    }


    @Transactional
    @Override
    public void transferLeadsOffshoreBatch(List<CrmLeadsPayload> payloads) {
        for (CrmLeadsPayload payload : payloads) {
            transferLeadsOffshore(payload);
        }
    }

    @Override
    public void closeLeads(CrmLeadsPayload payload) {
        //更新状态为已关闭
        payload.setLeadsStatus("closed");
//        dynamicUpdate(payload);
        dynamicUpdate(payload, PrdSystemLogEnum.CLOSE.getDesc());
        CrmLeadsDO leadsDO = dao.queryById(payload.getId());
        if (leadsDO != null) {
            logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), "关闭 " + leadsDO.getLeadsName());
        }
    }


    @Transactional
    @Override
    public void remarkLeads(CrmLeadsPayload payload) {
        String remark = "";
//        if(payload.getLeadsStage().equals("oppo")){
//            //关闭线索
//            payload.setLeadsStatus("closed");
//            remark = "已转为商机";
//        }else{
        remark = PrdSystemLogEnum.REMARK.getDesc() + "为" + payload.getLeadsStage();
//        }
        dynamicUpdate(payload, remark);
    }


    @Transactional
    @Override
    public void batchRemarkLeads(List<CrmLeadsPayload> payloads) {
        for (CrmLeadsPayload payload : payloads) {
            remarkLeads(payload);
        }
    }


    @Transactional
    @Override
    public Long toOpportunity(Long id, CrmOpportunityPayload opportunityPayload) {
        CrmLeadsPayload payload = new CrmLeadsPayload();
        payload.setId(id);
        payload.setLeadsStatus("closed");
        payload.setCloseReason("oppo");
        payload.setLeadsStage("oppo");
        String remark = "已转为商机";
        dynamicUpdate(payload, remark);
        // 保存商机
        CrmOpportunityVO insert = opportunityService.insert(opportunityPayload);
        logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Leads.getCode(), dao.queryById(id).getLeadsName() + " 已转为商机");
        return insert.getId();
    }


    @Override
    public Map<String, String> queryFields() {
        List<String> withChildrenFields = new ArrayList<>();
        withChildrenFields.add("customer");
        Map<String, String> value = BeanUtil.getAllFieldsAndName(CrmLeadsDO.class, withChildrenFields);
        return value;
    }


    /**
     * 更新跟进
     *
     * @param payload
     */
    @Transactional
    @Override
    public void updateFollow(CrmFollowPayload payload) {
        payload.setFollowObject(CrmFollowObjectEnum.Leads.getCode());
        followService.addFollow(payload);
        // 关闭提醒
        CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
        Long leadsId = payload.getObjectId();
        leadsPayload.setId(leadsId);
        leadsPayload.setNullFields(Arrays.asList("notFollowLeadsRemindTime"));
        dao.updateByKeyDynamic(leadsPayload);
    }

    @Transactional
    @Override
    public CrmLeadsVO queryDetail(Long offshoreId, Long id) {
        CrmLeadsDO detail = dao.queryById(id);
        CrmLeadsVO crmLeadsVO = CrmLeadsConvert.INSTANCE.toVo(detail);
        CrmOffshoreDO offshoreDO = new CrmOffshoreDO();
        if (offshoreId != -1) {
            offshoreDO = offshoreDAO.queryById(offshoreId);
            CrmOffshoreListVO crmOffshoreListVO = CrmOffshoreConvert.INSTANCE.toListVo(offshoreDO);
            crmLeadsVO.setOffshore(crmOffshoreListVO);
        }
//        else {
//            List<CrmLeadsOffshoreDO> leadsOffshores = detail.getLeadsOffshores();
//            if (leadsOffshores != null && !leadsOffshores.isEmpty()) {
//                offshoreDO = leadsOffshores.get(0).getOffshore();
//            }
//        }
//        CrmOffshoreListVO crmOffshoreListVO = CrmOffshoreConvert.INSTANCE.toListVo(offshoreDO);
//        if (crmOffshoreListVO.getOffshoreName().equals("无近海")) {
//            crmOffshoreListVO.setOffshoreName("");
//        }
        //添加可编辑状态(前端判断)
//        String leadsStatus = detail.getLeadsStatus();
//        String leadsStage = detail.getLeadsStage();
//        if(leadsStage!=null &&  (leadsStage.equals("sql") || leadsStage.equals("oppo"))){
//            crmLeadsVO.setCanEditFlag(true);
//        }else{
//            crmLeadsVO.setCanEditFlag(false);
//        }
        Map<Long, String> orgMap = organizationService.queryOrgs(Arrays.asList(crmLeadsVO.getDemandProductOrg()));

        transferDetail(crmLeadsVO, orgMap);
        return crmLeadsVO;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> asList) {

        //校验当前登录人的角色是不是市场管理员
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
        } else {
            throw TwException.error("", "您没有权限删除近海线索，请联系管理员！");
        }
        //线索状态校验，未分配的线索才可以删除
        for (Long aLong : asList) {
            CrmLeadsDO leadsDO = dao.queryById(aLong);
            String leadsStatus = leadsDO.getLeadsStatus();
            if (!leadsStatus.equals("undistributed")) {
                throw TwException.error("", "只有未分配状态的线索才可以删除！");
            }
        }
        dao.deleteSoft(asList);
        //删除近海线索列表
        leadsOffshoreDAO.deleteSoftByLeadsIds(asList);
    }


    private void transferDetail(CrmLeadsVO vo, Map<Long, String> orgMap) {
//        for (CrmLeadsVO vo : list) {
        //城市
        if (vo.getArea() != null) {
            vo.setAreaName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), vo.getArea()));
        }
        //线索状态
        vo.setLeadsStageDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsStage.getCode(), vo.getLeadsStage()));
        //线索阶段
        vo.setLeadsStatusDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsStatus.getCode(), vo.getLeadsStatus()));
        //线索奖金分配类型
        final String bonusDistributeType = vo.getBonusDistributeType();
        vo.setBonusDistributeTypeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsBonusDistributeType.getCode(), bonusDistributeType));
        //线索来源类型
        vo.setSourceTypeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsSourceType.getCode(), vo.getSourceType()));
        //关闭原因
        vo.setCloseReasonDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsCloseReason.getCode(), vo.getCloseReason()));
        // 需求产品
        vo.setDemandProductDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), vo.getDemandProduct()));
        // 需求产品关联部门
        vo.setDemandProductOrgName(orgMap.get(vo.getDemandProductOrg()));
        // 年营业额
        vo.setAnnualTurnoverDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsAnnualTurnover.getCode(), vo.getAnnualTurnover()));
        //客户行业
        CrmLeadsCustomerVO customer = vo.getCustomer();
        if (customer != null) {
            customer.setCustomerIndustryDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), customer.getCustomerIndustry()));
            customer.setCustRegionDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerRegion.getCode(), customer.getCustRegion()));
        }
        // 市场渠道
        if (vo.getMarketChannel() != null) {
            String marketChannel = vo.getMarketChannel();
            String[] split = marketChannel.split(",");
            if (split.length < 2) {
                vo.setMarketChannelDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
            } else {
                String s1 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                String s2 = "";
                switch (split[0]) {
                    case "baidu":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                        break;
                    case "sem_360":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                        break;
                    case "offline_activity":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                        break;
                    case "thrid_party_data":
                        s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                        break;
                }
                vo.setMarketChannelDesc(s2.equals("") ? s1 : s1 + "/" + s2);
            }
        }
//            List<CrmFollowVO> leadsFollows = vo.getLeadsFollows();
//            for (CrmFollowVO leadsFollow : leadsFollows) {
//                leadsFollow.setFollowType(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmFollow.getCode(),customer.getCustomerIndustry()));
//            }
        if (!ObjectUtils.isEmpty(vo.getBonusDistributeTo())) {
            vo.setBonusDistributeToUserName("");
            if ("personal".equals(bonusDistributeType)) {
                vo.setBonusDistributeToUserName(cacheUtil.getUserName(vo.getBonusDistributeTo()));
                // 奖金分配类型  部门
            } else if ("department".equals(bonusDistributeType)) {
                // 奖金分配对象
                final PrdOrgOrganizationVO prdOrgOrganizationVO = orgOrganizationDAO.queryOrgById(vo.getBonusDistributeTo());
                vo.setBonusDistributeToUserName(null != prdOrgOrganizationVO ? prdOrgOrganizationVO.getOrgName() : "");
            }
        }
        if (!ObjectUtils.isEmpty(vo.getSaleUserId())) {
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(vo.getSaleUserId());
            if (employee != null) {
                vo.setSaleUserName(employee.getEmployeeName());
                vo.setSaleEmployeeNo(employee.getEmployeeNo());
            }
        }
        if (!ObjectUtils.isEmpty(vo.getSourceUserId())) {
            PrdOrgEmployeeVO employee = cacheUtil.getEmployee(vo.getSourceUserId());
            if (employee != null) {
                vo.setSourceUserName(employee.getEmployeeName());
                vo.setSourceEmployeeNo(employee.getEmployeeNo());
            }
        }
        if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
            vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
        }
//        }

    }

    private void transferList(List<CrmLeadsListVO> list) {
        for (CrmLeadsListVO vo : list) {
            //城市
            if (vo.getArea() != null) {
                vo.setAreaName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.PCD.getCode(), vo.getArea()));
            }
            //线索状态
            vo.setLeadsStageDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsStage.getCode(), vo.getLeadsStage()));
            //线索阶段
            vo.setLeadsStatusDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsStatus.getCode(), vo.getLeadsStatus()));
            //线索来源类型
            vo.setSourceTypeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsSourceType.getCode(), vo.getSourceType()));
            // 需求产品
            vo.setDemandProductDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), vo.getDemandProduct()));
            // 年营业额
            vo.setAnnualTurnoverDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsAnnualTurnover.getCode(), vo.getAnnualTurnover()));
            // 市场渠道
            if (vo.getMarketChannel() != null) {
                String marketChannel = vo.getMarketChannel();
                String[] split = marketChannel.split(",");
                if (split.length < 2) {
                    vo.setMarketChannelDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
                } else {
                    String s1 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                    String s2 = "";
                    switch (split[0]) {
                        case "baidu":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                            break;
                        case "sem_360":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                            break;
                        case "offline_activity":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                            break;
                        case "thrid_party_data":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                            break;
                    }
                    vo.setMarketChannelDesc(s2.equals("") ? s1 : s1 + "/" + s2);
                }
            }
            //客户行业 stores管理系统
            CrmLeadsCustomerVO customer = vo.getCustomer();
            if (customer != null) {
                customer.setCustomerIndustryDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), customer.getCustomerIndustry()));
                customer.setCustRegionDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerRegion.getCode(), customer.getCustRegion()));
                customer.setCustomerGradeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), customer.getCustomerGrade()));
            }
            if (!ObjectUtils.isEmpty(vo.getSaleUserId())) {
                vo.setSaleUserName(cacheUtil.getUserName(vo.getSaleUserId()));
            }
            if (!ObjectUtils.isEmpty(vo.getSourceUserId())) {
                vo.setSourceUserName(cacheUtil.getUserName(vo.getSourceUserId()));
            }
            if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            //翻译标签列表
            String leadsTagIds = vo.getLeadsTagIds();
            List<PrdSystemTagVO> leadsTags = new ArrayList<>();
            if (leadsTagIds != null && !leadsTagIds.isEmpty()) {
                String[] tags = leadsTagIds.split(",");
                for (String tag : tags) {
                    List<PrdSystemTagVO> systemTags = cacheUtil.getSystemTag(Long.parseLong(tag));
                    leadsTags.addAll(systemTags);
                }
            }
            vo.setLeadsTags(leadsTags);
//            if(vo.getSaleUserBu()!=null){
//                vo.setSaleUserBuId(vo.getSaleUserBu().getId());
//                vo.setSaleUserBuName(vo.getSaleUserBu().getOrgName());
//            }
            //销售负责人部门
            if (vo.getSaleUserId() != null) {
                Long saleUserId = vo.getSaleUserId();
                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(saleUserId);
                if (prdOrgEmployeeRefVO != null) {
                    vo.setSaleUserBuId(prdOrgEmployeeRefVO.getOrgId());
                    vo.setSaleUserBuName(prdOrgEmployeeRefVO.getOrgName());
                }
            }

            // 最新跟进情况
            CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
            crmFollowQuery.setObjectId(vo.getId());
            crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Leads.name());
            crmFollowQuery.setSize(1);
            //默认按照时间倒叙排序
            OrderItem orderItem = OrderItem.desc("createTime");
            crmFollowQuery.defaultOrder(orderItem);
            final PagingVO<CrmFollowVO> crmFollowVOPagingVO = crmFollowService.listPage(crmFollowQuery);
            if (crmFollowVOPagingVO.getRecords() != null && crmFollowVOPagingVO.getRecords().size() == 1) {
                final CrmFollowVO crmFollowVO = crmFollowVOPagingVO.getRecords().get(0);
                vo.setFollow(crmFollowVO);
            }
        }
    }


//    private void transactionLeadsOffshore(List<CrmLeadsOffshoreVO> list) {
//        for (CrmLeadsOffshoreVO vo : list) {
//            CrmLeadsListVO leadsListVO=vo.getLeads();
//            transferList(Collections.singletonList(leadsListVO));
//        }
//    }

//    private Specification<CrmLeadsDO> receiveSpec(CrmLeadsQuery query){
//        // 获取当前登录用户
//        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
//        Long userId = userDetails==null?0:userDetails.getUser().getId();
//        //分配领取类型为all,当前登录人是近海成员，且线索状态为已退回或者未分配
//        CrmOffshoreQuery offshoreQuery= new CrmOffshoreQuery();
//        offshoreQuery.setDistributeReceiveRule("all");
//        offshoreQuery.setMemberId(userId);
//        List<CrmOffshoreListVO> crmOffshoreListVOS = offshoreService.queryList(offshoreQuery);
//        List<Long> offshoreIds = crmOffshoreListVOS.stream().map(e -> e.getId()).collect(Collectors.toList());
//        if(offshoreIds.isEmpty()){
//            query.setOffshoreIds(Collections.singletonList(-1l));
//        }else{
//            query.setOffshoreIds(offshoreIds);
//        }
//        //or查询条件
//        Specification<CrmLeadsDO> querySpecifi = (root, criteriaQuery, criteriaBuilder) -> {
//            List<Predicate> predicates = new ArrayList<>();
//            Predicate pred1 = criteriaBuilder.equal(root.get("leadsStatus"), "undistributed");
//            Predicate pred2 = criteriaBuilder.equal(root.get("leadsStatus"), "back");
//            predicates.add(criteriaBuilder.or(pred1, pred2));
//            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
//        };
//        Specification<CrmLeadsDO> spec = dao.getSpec(query).and(querySpecifi);
//        return spec;
//    }


    @Override
    public void downloadBatchOffshore(HttpServletResponse response, CrmLeadsOffshoreQuery query) {
        if (StringUtils.hasText(query.getDownloadType()) && query.getDownloadType().equals("model")) {
            downloadModel(response);
        } else {
            PagingVO<CrmLeadsListVO> paging = pagingOffshoreLeads(query);
            download(paging.getRecords(), "近海池数据", response, 1);
        }
    }


    @Override
    public void downloadBatch(HttpServletResponse response, CrmLeadsQuery query) {
        if (StringUtils.hasText(query.getDownloadType()) && query.getDownloadType().equals("model")) {
            downloadModel(response);
        } else {
            PagingVO<CrmLeadsListVO> paging = paging(query);
            download(paging.getRecords(), "线索数据", response, 2);
        }
    }


    @Override
    public Map<String, Object> importBatch(HttpServletResponse response, MultipartFile file, Boolean force) {
        Map<String, Object> resultMap = new HashMap<>();
        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet("线索数据");
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        int dataStartRow = 1;
        List<CrmLeadsPayload> leadsPayloads = new ArrayList<>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            String importError = "";
            String importWarn = "";
            CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
            Row row = sheet.getRow(i);
            String leadsName = ExcelUtil.getCellFormatValue(row.getCell(3));
            if (StringUtils.hasText(leadsName) && leadsName.length() > 0) {
                leadsPayload.setLeadsName(leadsName);
            } else {
                importError += "线索名称为空;";
            }
            String offshoreIdsStr = ExcelUtil.getCellFormatValue(row.getCell(37));
            if (StringUtils.hasText(offshoreIdsStr) && offshoreIdsStr.length() > 0) {
                List<Long> offshoreIds = Arrays.asList(offshoreIdsStr.split(",")).stream().map(e -> Long.parseLong(e)).collect(Collectors.toList());
//                List<Long> offshoreIds = offshoreDAO.queryOffshoreIdsByName(Arrays.stream(offshoreList).toList());
                leadsPayload.setOffshoreIds(offshoreIds);
                leadsPayload.setOffshoreIdsStr(offshoreIdsStr);
                leadsPayload.setOffshoreIdsDesc(ExcelUtil.getCellFormatValue(row.getCell(1)));
            } else {
                importError += "近海不能为空;";
            }
            String marketId = ExcelUtil.getCellFormatValue(row.getCell(38));
            if (StringUtils.hasText(marketId) && marketId.length() > 0) {
                PrjProjectPayload prjProjectPayload = new PrjProjectPayload();
                prjProjectPayload.setId(Long.parseLong(marketId));
                leadsPayload.setMarket(prjProjectPayload);
                leadsPayload.setMarketId(marketId);
                leadsPayload.setMarketIdDesc(ExcelUtil.getCellFormatValue(row.getCell(2)));
            } else {
//                importError+="市场活动不能为空;";
            }
            leadsPayload.setSourceTypeDesc(ExcelUtil.getCellFormatValue(row.getCell(4)));
            leadsPayload.setSourceType(ExcelUtil.getCellFormatValue(row.getCell(39)));
            leadsPayload.setMarketChannel(ExcelUtil.getCellFormatValue(row.getCell(5)));

            String saleUserId = ExcelUtil.getCellFormatValue(row.getCell(40));
            if (StringUtils.hasText(saleUserId) && saleUserId.length() > 0) {
                leadsPayload.setSaleUserId(Long.parseLong(saleUserId));
                leadsPayload.setSaleUserName(ExcelUtil.getCellFormatValue(row.getCell(6)));
            }
            String sourceUserId = ExcelUtil.getCellFormatValue(row.getCell(41));
            if (StringUtils.hasText(sourceUserId) && sourceUserId.length() > 0) {
                leadsPayload.setSourceUserId(Long.parseLong(sourceUserId));
                leadsPayload.setSourceUserName(ExcelUtil.getCellFormatValue(row.getCell(7)));
            }
            leadsPayload.setCloseReason(ExcelUtil.getCellFormatValue(row.getCell(8)));
            leadsPayload.setExtString1(ExcelUtil.getCellFormatValue(row.getCell(19)));
            leadsPayload.setExtString2(ExcelUtil.getCellFormatValue(row.getCell(20)));
            String createTime = ExcelUtil.getCellFormatValue(row.getCell(21));
            if (createTime != null && createTime != "") {
                try {
                    LocalDate parse = LocalDate.parse(createTime);
                    leadsPayload.setCreateTime(parse.atStartOfDay());
                } catch (Exception e) {
                    importError += "创建时间必须是日期类型";
                }
            }
            leadsPayload.setRemark(ExcelUtil.getCellFormatValue(row.getCell(22)));
            CrmLeadsCustomerPayload customerPayload = new CrmLeadsCustomerPayload();
            String customerName = ExcelUtil.getCellFormatValue(row.getCell(9));
            List<Map<String, Object>> company = new ArrayList<>();
            if (customerName != null && customerName.length() > 0) {
                company = crmCommonService.checkRepeat("company", customerName);
                if (company != null && !company.isEmpty()) {
                    for (Map<String, Object> stringObjectMap : company) {
                        stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                        importWarn += "重复类型：" + stringObjectMap.get("repeatType") + ",企业名称：" + stringObjectMap.get("companyName") + ",联系人：" + stringObjectMap.get("contactsName") + ",联系人电话：" + stringObjectMap.get("contactsPhone") + "，销售人员：" + stringObjectMap.get("salesMan") + ";";
                    }
                }
            }
            customerPayload.setCustomerName(customerName);
            customerPayload.setCustomerIndustryDesc(ExcelUtil.getCellFormatValue(row.getCell(10)));
            customerPayload.setCustomerIndustry(ExcelUtil.getCellFormatValue(row.getCell(42)));
            customerPayload.setCustomerGradeDesc(ExcelUtil.getCellFormatValue(row.getCell(11)));
            customerPayload.setCustomerGrade(ExcelUtil.getCellFormatValue(row.getCell(43)));
            customerPayload.setCustRegionDesc(ExcelUtil.getCellFormatValue(row.getCell(12)));
            customerPayload.setCustRegion(ExcelUtil.getCellFormatValue(row.getCell(44)));
            String customerContacts = ExcelUtil.getCellFormatValue(row.getCell(13));
            if (StringUtils.hasText(customerContacts) && customerContacts.length() > 0) {
                customerPayload.setCustomerContacts(customerContacts);
            } else {
                importError += "客户联系人为空;";
            }
            customerPayload.setContactsDepartment(ExcelUtil.getCellFormatValue(row.getCell(14)));
            String customerPhone = ExcelUtil.getCellFormatValue(row.getCell(15));
            if (customerPhone != null && customerPhone.length() > 0) {
                List<Map<String, Object>> phone = crmCommonService.checkRepeat("phone", customerPhone);
                if (phone != null && !phone.isEmpty()) {
                    for (Map<String, Object> stringObjectMap : phone) {
                        boolean repeatFlag = false;
                        //先去重
                        for (Map<String, Object> companyMap : company) {
                            if (companyMap.get("id").equals(stringObjectMap.get("id")) && companyMap.get("repeatType").equals(stringObjectMap.get("repeatType"))) {
                                repeatFlag = true;
                                break;
                            }
                        }
                        if (!repeatFlag) {
                            stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                            importWarn += "重复类型：" + stringObjectMap.get("repeatType") + ",企业名称：" + stringObjectMap.get("companyName") + ",联系人：" + stringObjectMap.get("contactsName") + ",联系人电话：" + stringObjectMap.get("contactsPhone") + "，销售人员：" + stringObjectMap.get("salesMan") + ";";
                        }
                    }
                }
            } else {
                importError += "联系人电话为空;";
            }
            customerPayload.setContactsPhone(customerPhone);
            customerPayload.setContactsPosition(ExcelUtil.getCellFormatValue(row.getCell(17)));
            customerPayload.setContactsEmail(ExcelUtil.getCellFormatValue(row.getCell(16)));
            customerPayload.setSaleProduct(ExcelUtil.getCellFormatValue(row.getCell(18)));
            leadsPayload.setCustomer(customerPayload);
            leadsPayload.setImoprtError(importError);
            leadsPayload.setImportWarn(importWarn);
            leadsPayloads.add(leadsPayload);
        }
        int warnNum = 0;
        int errorNum = 0;
        for (CrmLeadsPayload leadsPayload : leadsPayloads) {
            if (StringUtils.hasText(leadsPayload.getImoprtError()) && leadsPayload.getImoprtError().length() > 0) {
                errorNum++;
            }
            //如果是force则不校验警告，直接保存
            if ((StringUtils.hasText(leadsPayload.getImportWarn()) || leadsPayload.getImportWarn().length() > 0) && !force) {
                warnNum++;
            }
        }
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", downloadModelWithData(leadsPayloads));
        } else if (warnNum > 0) {
            resultMap.put("ok", "warn");
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", downloadModelWithData(leadsPayloads));
        } else {
            List<Long> leadsIds = new ArrayList<>();
            for (CrmLeadsPayload leadsPayload : leadsPayloads) {
                CrmLeadsVO crmLeadsVO = saveOne(leadsPayload);
                leadsIds.add(crmLeadsVO.getId());
            }
            resultMap.put("ok", "ok");
            resultMap.put("leadsIds", leadsIds);

        }
        return resultMap;
    }

//    public void insertLOVdata(Sheet lovSheet,List<PrdSystemSelectionVO> data,int columnNum){
//        if (!CollectionUtils.isEmpty(data) && lovSheet != null) {
//            int nextRow = 1;
//            for (PrdSystemSelectionVO selection: data) {
//                String selectionValue = selection.getSelectionValue();
//                String selectionName = selection.getSelectionName();
//                if (StringUtils.hasText(selectionName) && selectionValue != null) {
//                    //判断当前row是否存在
//                    Row row = lovSheet.getRow(nextRow);
//                    if(row == null){
//                        row = lovSheet.createRow(nextRow);
//                    }
//                    excelUtil.setCellValue(row, columnNum, selectionName);
//                    excelUtil.setCellValue(row, columnNum+1, selectionValue + "");
//                    nextRow++;
//                }
//            }
//        }
//    }


    public Workbook getVol() {
        ClassPathResource classPathResource = new ClassPathResource("template/crmLeadsBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet leadsSheet = (XSSFSheet) workbook.getSheet("线索数据");
            Sheet lovSheet = workbook.getSheet("LOV");
            Sheet offshoreSheet = workbook.getSheet("近海列表");
            Sheet marketSheet = workbook.getSheet("市场活动列表");
            Sheet employeeSheet = workbook.getSheet("人员下拉");
            //udc数据查询
            //线索状态
            List<PrdSystemSelectionVO> leadsStatusSelectionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmLeadsStatus.getCode());
            excelUtil.insertLOVdata(lovSheet, leadsStatusSelectionVOS, 0);
            //线索阶段
            List<PrdSystemSelectionVO> leadsStageSelectionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmLeadsStage.getCode());
            excelUtil.insertLOVdata(lovSheet, leadsStageSelectionVOS, 2);
            //来源类型
            List<PrdSystemSelectionVO> sourceTypeSelectionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmLeadsSourceType.getCode());
            excelUtil.insertLOVdata(lovSheet, sourceTypeSelectionVOS, 4);
            //客户行业
            List<PrdSystemSelectionVO> customerIndustrySelectionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerIndustry.getCode());
            excelUtil.insertLOVdata(lovSheet, customerIndustrySelectionVOS, 6);
            //客户级别
            List<PrdSystemSelectionVO> customerGradeSelectionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerGrade.getCode());
            excelUtil.insertLOVdata(lovSheet, customerGradeSelectionVOS, 8);
            //客户区域
            List<PrdSystemSelectionVO> custRegionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerRegion.getCode());
            excelUtil.insertLOVdata(lovSheet, custRegionVOS, 10);

            //近海列表
            List<CrmOffshoreListVO> crmOffshoreListVOS = offshoreService.queryList(new CrmOffshoreQuery());
            excelUtil.insertListData(offshoreSheet, crmOffshoreListVOS, "id", "offshoreName", 0);
            //市场活动列表
            List<PrjProjectVO> prjProjectVOS = marketDAO.queryListDynamic(new PrjProjectQuery());
            excelUtil.insertListData(marketSheet, prjProjectVOS, "id", "projectName", 0);
            //人员列表
            List<PrdOrgEmployeeVO> prdOrgEmployeeVOS = employeeService.queryList(new PrdOrgEmployeeQuery());
            excelUtil.insertListData(employeeSheet, prdOrgEmployeeVOS, "userId", "employeeName", 0);


            excelUtil.generateRangeList(leadsSheet, 1, 1, "近海列表", 2, "A");
            excelUtil.generateRangeList(leadsSheet, 2, 1, "市场活动列表", 2, "A");
            excelUtil.generateRangeList(leadsSheet, 4, 1, "LOV", 2, "E");
            excelUtil.generateRangeList(leadsSheet, 6, 1, "人员下拉", 2, "A");
            excelUtil.generateRangeList(leadsSheet, 7, 1, "人员下拉", 2, "A");
            excelUtil.generateRangeList(leadsSheet, 10, 1, "LOV", 2, "G");
            excelUtil.generateRangeList(leadsSheet, 11, 1, "LOV", 2, "I");
            excelUtil.generateRangeList(leadsSheet, 12, 1, "LOV", 2, "K");

//            excelUtil.setCellFormulas(leadsSheet.getRow(1)==null?leadsSheet.createRow(1):leadsSheet.getRow(1), 1, "VLOOKUP(B" + excelUtil.formulasReplace + ",LOV!A:B,2,FALSE)");//线索阶段编号
            excelUtil.setCellFormulas(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1), 37, "VLOOKUP(B" + ExcelUtil.formulasReplace + ",近海列表!A:B,2,FALSE)");//市场活动
            excelUtil.setCellFormulas(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1), 38, "VLOOKUP(C" + ExcelUtil.formulasReplace + ",市场活动列表!A:B,2,FALSE)");//市场活动

            excelUtil.setCellFormulas(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1), 39, "VLOOKUP(E" + ExcelUtil.formulasReplace + ",LOV!E:F,2,FALSE)");//来源类型编号
            excelUtil.setCellFormulas(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1), 40, "VLOOKUP(G" + ExcelUtil.formulasReplace + ",人员下拉!A:B,2,FALSE)");//销售负责人
            excelUtil.setCellFormulas(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1), 41, "VLOOKUP(H" + ExcelUtil.formulasReplace + ",人员下拉!A:B,2,FALSE)");//来源人
            excelUtil.setCellFormulas(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1), 42, "VLOOKUP(K" + ExcelUtil.formulasReplace + ",LOV!G:H,2,FALSE)");//客户行业
            excelUtil.setCellFormulas(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1), 43, "VLOOKUP(L" + ExcelUtil.formulasReplace + ",LOV!I:J,2,FALSE)");//客户级别
            excelUtil.setCellFormulas(leadsSheet.getRow(1) == null ? leadsSheet.createRow(1) : leadsSheet.getRow(1), 44, "VLOOKUP(M" + ExcelUtil.formulasReplace + ",LOV!K:L,2,FALSE)");//客户区域

//            String fileName = "线索数据"+"-" + LocalDate.now();
//            ExcelUtil.writeResponse(response, fileName, workbook);
            return workbook;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    private void downloadModel(HttpServletResponse response) {
        Workbook workbook = getVol();
        String fileName = "线索导入模板-" + LocalDate.now();
        ExcelUtil.writeResponse(response, fileName, workbook);
    }


    private Object downloadModelWithData(List<CrmLeadsPayload> records) {
        Workbook workbook = getVol();
        try {
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("线索数据");
            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                XSSFCell errorCell = batchProjectSheet.getRow(0).getCell(23);
                errorCell.setCellValue("导入错误");
                XSSFCell warnCell = batchProjectSheet.getRow(0).getCell(24);
                warnCell.setCellValue("导入警告");
                int nextRow = 1;
                for (CrmLeadsPayload dataPayload : records) {
                    Row row = batchProjectSheet.getRow(nextRow);
                    if (row == null) {
                        row = batchProjectSheet.createRow(nextRow);
                    }
                    excelUtil.setCellValueNew(row, 0, nextRow); // 序号
//                    List<Long> offshoreIds = dataPayload.getOffshoreIds();
//                    List<String> collect = offshoreIds.stream().map(e -> offshoreDAO.queryById(e).getOffshoreName()).collect(Collectors.toList());
//                    String join = String.join(",", collect);
                    excelUtil.setCellValueNew(row, 1, dataPayload.getOffshoreIdsDesc());
                    excelUtil.setCellValueNew(row, 37, dataPayload.getOffshoreIdsStr());

                    excelUtil.setCellValueNew(row, 2, dataPayload.getMarketIdDesc());// 市场活动
                    excelUtil.setCellValueNew(row, 38, dataPayload.getMarketId());// 市场活动

                    excelUtil.setCellValueNew(row, 3, dataPayload.getLeadsName());// 线索名称
                    excelUtil.setCellValueNew(row, 4, dataPayload.getSourceTypeDesc());// 来源类型
                    excelUtil.setCellValueNew(row, 39, dataPayload.getSourceType());// 来源类型编号

                    excelUtil.setCellValueNew(row, 5, dataPayload.getMarketChannel());// 渠道

                    excelUtil.setCellValueNew(row, 6, dataPayload.getSaleUserName());//销售负责人
                    excelUtil.setCellValueNew(row, 40, dataPayload.getSaleUserId());//销售负责人
                    excelUtil.setCellValueNew(row, 7, dataPayload.getSourceUserName());//来源人
                    excelUtil.setCellValueNew(row, 41, dataPayload.getSourceUserId());//来源人

                    excelUtil.setCellValueNew(row, 8, dataPayload.getCloseReason());//关闭原因
                    excelUtil.setCellValueNew(row, 19, dataPayload.getExtString1());// 扩展字段1
                    excelUtil.setCellValueNew(row, 20, dataPayload.getExtString2());// 扩展字段2
                    excelUtil.setCellValueNew(row, 21, dataPayload.getCreateTime());//创建时间
                    excelUtil.setCellValueNew(row, 22, dataPayload.getRemark());//备注
                    excelUtil.setCellValueNew(row, 23, dataPayload.getImoprtError());//导入错误
                    excelUtil.setCellValueNew(row, 24, dataPayload.getImportWarn());//导入警告
                    CrmLeadsCustomerPayload customer = dataPayload.getCustomer();
                    if (customer != null) {
                        excelUtil.setCellValueNew(row, 9, customer.getCustomerName());//客户名称
                        excelUtil.setCellValueNew(row, 10, customer.getCustomerIndustryDesc());// 客户行业
                        excelUtil.setCellValueNew(row, 42, customer.getCustomerIndustry());// 客户行业
                        excelUtil.setCellValueNew(row, 11, customer.getCustomerGradeDesc());// 客户级别
                        excelUtil.setCellValueNew(row, 43, customer.getCustomerGrade());// 客户级别
                        excelUtil.setCellValueNew(row, 12, customer.getCustRegionDesc());// 客户区域
                        excelUtil.setCellValueNew(row, 44, customer.getCustRegion());// 客户区域

                        excelUtil.setCellValueNew(row, 13, customer.getCustomerContacts());// 联系人姓名
                        excelUtil.setCellValueNew(row, 14, customer.getContactsDepartment());// 联系人部门
                        excelUtil.setCellValueNew(row, 15, customer.getContactsPhone());// 联系人电话
                        excelUtil.setCellValueNew(row, 16, customer.getContactsEmail());// 联系人邮箱
                        excelUtil.setCellValueNew(row, 17, customer.getContactsPosition());// 联系人岗位
                        excelUtil.setCellValueNew(row, 18, customer.getSaleProduct());// 产品
                    }
                    nextRow++;
                }
            }
            String fileName = "线索数据导入-" + UUID.randomUUID();
            File file = ExcelUtil.workbookToFile(workbook, fileName);
            ApiResult upload = fileService.upload(file);
            return upload.getData();
        } catch (Exception e) {
            e.printStackTrace();

        }
        return -1;
    }


    private void download(List<CrmLeadsListVO> records, String type, HttpServletResponse response, int fromType) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmLeadsDownloadBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("线索数据");
            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                int nextRow = 1;
                for (CrmLeadsListVO dataPayload : records) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    if (fromType == 2 && dataPayload.getOffshoreId() != null) {//需要翻译
                        CrmOffshoreDO offshoreDO = offshoreDAO.queryById(dataPayload.getOffshoreId());
                        excelUtil.setCellValue(row, 1, offshoreDO.getOffshoreName());// 近海名称
                    }
                    if (fromType == 1 && dataPayload.getOffshore() != null) {//无需翻译
                        excelUtil.setCellValue(row, 1, dataPayload.getOffshore().getOffshoreName());// 近海名称
                    }
//                    if (fromType == 3 && dataPayload.getOffshoreIds()!=null){
//                        List<Long> offshoreIds = dataPayload.getOffshoreIds();
//                        List<String> collect = offshoreIds.stream().map(e -> offshoreDAO.queryById(e).getOffshoreName()).collect(Collectors.toList());
//                        String join = String.join(",", collect);
//                        excelUtil.setCellValue(row,1,join);
//                    }
                    excelUtil.setCellValue(row, 2, dataPayload.getMarket() == null ? null : dataPayload.getMarket().getProjectName());// 市场活动
//                    excelUtil.setCellValue(row, 3, dataPayload.getMarket() == null ? null : dataPayload.getMarket().getProjectNo());// 市场活动编号

                    excelUtil.setCellValue(row, 3, dataPayload.getLeadsName());// 线索名称
//                    excelUtil.setCellValue(row, 5, dataPayload.getLeadsNo());// 线索编号

                    excelUtil.setCellValue(row, 4, dataPayload.getLeadsStatusDesc());// 线索状态
                    //查询udc线索状态列表
                    excelUtil.setCellValue(row, 5, dataPayload.getLeadsStageDesc());// 线索阶段
//                    excelUtil.setCellFormulas(row, 9, "VLOOKUP(I" + excelUtil.formulasReplace + ",LOV!C:D,2,FALSE)");//线索阶段编号
                    excelUtil.setCellValue(row, 6, dataPayload.getSourceTypeDesc());//来源类型
//                    excelUtil.setCellFormulas(row, 11, "VLOOKUP(K" + excelUtil.formulasReplace + ",LOV!E:F,2,FALSE)");//来源类型编号
                    excelUtil.setCellValue(row, 7, dataPayload.getMarketChannelDesc());//市场渠道
                    excelUtil.setCellValue(row, 8, dataPayload.getSaleUserName());//销售负责人
                    excelUtil.setCellValue(row, 9, dataPayload.getSourceUserName());//来源人

                    excelUtil.setCellValue(row, 10, dataPayload.getCloseReason());//关闭原因
                    excelUtil.setCellValue(row, 15, dataPayload.getAreaName());     //城市
                    excelUtil.setCellValue(row, 22, dataPayload.getExtString1());// 扩展字段1
                    excelUtil.setCellValue(row, 23, dataPayload.getExtString2());// 扩展字段2
                    excelUtil.setCellValue(row, 24, dataPayload.getCreateTime());//创建时间
                    excelUtil.setCellValue(row, 25, dataPayload.getRemark());//备注
                    CrmLeadsCustomerVO customer = dataPayload.getCustomer();
                    if (customer != null) {
                        excelUtil.setCellValue(row, 11, customer.getCustomerName());//客户名称
                        excelUtil.setCellValue(row, 12, customer.getCustomerIndustryDesc());// 客户行业
                        excelUtil.setCellValue(row, 13, customer.getCustomerGradeDesc());// 客户级别
                        excelUtil.setCellValue(row, 14, customer.getCustRegionDesc());// 客户区域
                        excelUtil.setCellValue(row, 16, customer.getCustomerContacts());// 联系人姓名
                        excelUtil.setCellValue(row, 17, customer.getContactsDepartment());// 联系人部门
                        excelUtil.setCellValue(row, 18, customer.getContactsPhone());// 联系人电话
                        excelUtil.setCellValue(row, 19, customer.getContactsEmail());// 联系人邮箱
                        excelUtil.setCellValue(row, 20, customer.getContactsPosition());// 联系人岗位
                        excelUtil.setCellValue(row, 21, customer.getSaleProduct());// 产品
                    }
//                    logService.saveNewLog(dataPayload.getId(), PrdSystemObjectEnum.Leads.getCode(), "导出 "+dataPayload.getLeadsName() );
                    nextRow++;
                }
            }
            String fileName = type + "-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public boolean leadsNotFollowRemind() {
//        CrmOffshoreQuery offshoreQuery = new CrmOffshoreQuery();
//        offshoreQuery.setOffshoreNameNotEqual("无近海");
//        //1.查询所有的近海排除无近海
//        List<CrmOffshoreListVO> crmOffshoreListVOS = offshoreService.queryList(offshoreQuery);
//        for (CrmOffshoreListVO crmOffshoreListVO : crmOffshoreListVOS) {
//            CrmOffshoreVO crmOffshoreVO = offshoreService.queryDetail(crmOffshoreListVO.getId());
//            Long distributeLeadsRemindTime = crmOffshoreVO.getOffshoreRule().getDistributeLeadsRemindTime();
//
//            //2.查询所有的线索
//            CrmLeadsQuery query = new CrmLeadsQuery();
//            query.setLeadsStatus("follow");
//
//            LocalDateTime triggerTime=LocalDateTime.now().plusSeconds((distributeLeadsRemindTime==null || distributeLeadsRemindTime<1)?10800:distributeLeadsRemindTime);
//
//
//        }
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setNotFollowLeadsRemindTimeNotNull(true);
        Specification<CrmLeadsDO> spec = dao.getSpec(leadsQuery);
        List<CrmLeadsDO> all = dao.findAll(spec);
        XxlJobLogger.log("数据：：：：：：：" + all.stream().map(e -> e.getSaleUserId()).collect(Collectors.toList()));
        for (CrmLeadsDO leadsDO : all) {
            LocalDateTime notFollowLeadsRemindTime = leadsDO.getNotFollowLeadsRemindTime();
            if (leadsDO.getNotFollowLeadsRemindTime() != null && notFollowLeadsRemindTime.isBefore(LocalDateTime.now()) && leadsDO.getSaleUserId() != null) {
                PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20220711001502");
                Map<String, Object> result = new HashMap<>();
                result.put("leadsName", leadsDO.getLeadsName());
                result.put("url", "/leadsManager/management");

                messageConfigService.sendMessageConfig(configVO, result, "appoint_people", leadsDO.getSaleUserId().toString());
//                messageConfigService.addJobMessage(leadsDO.getId(),"followRemind", null , "管理员", leadsDO.getSaleUserId().toString(), "线索超时未跟进通知", String.format("线索%s已经超时未跟进，请及时跟进", leadsDO.getLeadsName()), "进入跟进", "/leadsManager/management");
                //关闭提醒
                CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
                Long leadsId = leadsDO.getId();
                leadsPayload.setId(leadsId);
                leadsPayload.setNullFields(Arrays.asList("notFollowLeadsRemindTime"));
                dao.updateByKeyDynamic(leadsPayload);
            }
        }
        return true;

    }


    @Override
    @Transactional
    public boolean leadsNotReceiveRemind(int days) {
        //分配日期+传入日期=当前日期
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
        leadsOffshoreQuery.setLeadsStage("mql");
        leadsOffshoreQuery.setLeadsStatus("distributed");
        leadsOffshoreQuery.setFilterLeadsOffshore(true);
        leadsOffshoreQuery.setExpireDays(days);
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> all = leadsOffshoreDAO.findAll(spec);
        List<PrdMessageConfigDO> messageConfigDOS = new ArrayList<>();
        if (!ObjectUtils.isEmpty(all)) {
            for (CrmLeadsOffshoreDO leadsOffshoreDO : all) {
                PrdMessageConfigVO configVO = null;
                if (days == 7) {
                    configVO = messageConfigService.queryByMessageCode("MC20221129001502");
                } else if (days == 10) {
                    configVO = messageConfigService.queryByMessageCode("MC20221129001503");
                }
                Map<String, Object> result = new HashMap<>();
                CrmLeadsDO leads = leadsOffshoreDO.getLeads();
                CrmLeadsCustomerDO customer = leadsOffshoreDO.getLeads().getCustomer();
                result.put("customerName", customer.getCustomerName());
                result.put("customerContacts", customer.getCustomerContacts());
                result.put("contactsPhone", customer.getContactsPhone());
                result.put("saleUserName", cacheUtil.getUserName(leads.getSaleUserId()));
                result.put("remark", leads.getRemark());
                result.put("distributeDate", leads.getDistributeDate().toString());
                //确定邮件范围
                List<String> noticeSourceList = new ArrayList<>();
                Long saleUserId = leads.getSaleUserId();
                noticeSourceList.add(saleUserId.toString());
                noticeSourceList.add("579786564415129367");//李浩
                if (days == 7) {
                    //销售本人+李浩
                } else if (days == 10) {
                    //销售本人+销售上级+李浩（销售本人<>销售总监）
                    PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(saleUserId);
                    Long parentId = prdOrgEmployeeRefVO.getParentId();
                    if (parentId != null && !parentId.toString().equals("579786152370897074")) {//刘志军
                        noticeSourceList.add(parentId.toString());
                    }
                }
                result.put("customerName", customer.getCustomerName());//+";(邮件接收人列表："+noticeSourceList.stream().map(e->cacheUtil.getUserName(Long.parseLong(e))).collect(Collectors.toList())+")");
                if (!ObjectUtils.isEmpty(noticeSourceList)) {
                    String noticeSource = String.join(",", noticeSourceList);
//                    messageConfigService.sendMessageConfig(configVO, result, "appoint_people", "579786372043377650,620007601710695362,579786483406340223");
                    messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
                }
            }
        }
        return true;
    }


    public Object sendLeadsMessage(String messageType, CrmLeadsDO leadsdo) {
        CrmLeadsCustomerDO customer = leadsdo.getCustomer();
        //确定邮件范围
        Set<String> noticeSourceList = new HashSet<>();

        Map<String, Object> result = new HashMap<>();
        result.put("customerName", customer.getCustomerName());
        result.put("saleUserName", cacheUtil.getUserName(leadsdo.getSaleUserId()));
        result.put("remark", leadsdo.getRemark());
        String messageCode = "";

        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(leadsdo.getSaleUserId());
        if (prdOrgEmployeeRefVO == null) {
            // 一般 租户管理员会出问题（创建新租户的时候出问题的）
            log.error("查询不到人员信息");
            return null;
        }
        Long parentId = prdOrgEmployeeRefVO.getParentId();
        switch (messageType) {
            case "distribute":
                messageCode = "MC20221129001501";
                result.put("customerContacts", customer.getCustomerContacts());
                result.put("contactsPhone", customer.getContactsPhone());
                result.put("distributeDate", leadsdo.getDistributeDate().toString());
                noticeSourceList.add(leadsdo.getSaleUserId().toString());//发送给销售
                //销售本人+销售上级+李浩（销售本人<>销售总监）
                if (parentId != null) {//刘志军
                    noticeSourceList.add(parentId.toString());
                }
//                noticeSourceList.add("579786621575104237");//Eva
//                noticeSourceList.add("579786152370897074");//刘志军
//                noticeSourceList.add("579786650192841178");//冯江云
////                noticeSourceList.add("579785831934460429");//盖莉珊
////                noticeSourceList.add("579785846660664966");//傅晓峰
//                noticeSourceList.add("579786564415129367");//李浩

                break;
            case "receive":
                messageCode = "MC20221129001504";
                // 需求产品
                result.put("demandProduct", cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), leadsdo.getDemandProduct()));
                //销售上级
                if (parentId != null && !parentId.toString().equals("579786152370897074")) {//刘志军
                    noticeSourceList.add(parentId.toString());
                }
                //需求产品归属部门事业部负责人
                if (leadsdo.getDemandProductOrg() != null) {
                    Long manageUserId = daoOrg.queryManageIdById(leadsdo.getDemandProductOrg());
                    if (manageUserId != null) {
                        noticeSourceList.add(manageUserId.toString());//需求产品部门负责人
                    }
                }

                //noticeSourceList.add("579786152370897074");//刘志军
                //noticeSourceList.add("579786621575104237");//Eva
                //noticeSourceList.add("579786564415129367");//李浩
                //noticeSourceList.add("579786650192841178");//冯江云
                //noticeSourceList.add("579785831934460429");//盖莉珊
                //noticeSourceList.add("579785846660664966");//傅晓峰
                break;
            case "back":
                messageCode = "MC20221129001505";
                // 需求产品
                result.put("demandProduct", cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), leadsdo.getDemandProduct()));
                //noticeSourceList.add("579786564415129367");//李浩
                //noticeSourceList.add("579786650192841178");//冯江云
                //noticeSourceList.add("579786621575104237");//Eva
                break;
        }
        PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode(messageCode);
        if (null == configVO) {
            log.error("【消息模版未配置】，租户：" + currentTenantId() + ";  模版CODE:" + messageCode);
            return null;
        }

        result.put("customerName", customer.getCustomerName());//+";(邮件接收人列表："+noticeSourceList.stream().map(e->cacheUtil.getUserName(Long.parseLong(e))).collect(Collectors.toList())+")");
        if (!ObjectUtils.isEmpty(noticeSourceList)) {
            String noticeSource = String.join(",", noticeSourceList);
//            messageConfigService.sendMessageConfig(configVO, result, "appoint_people", "579786372043377650,620007601710695362,579786483406340223");
            return messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSource);
        }
        return null;
    }


    @Override
    public boolean leadsToDistributeRemind() {
        CrmLeadsOffshoreQuery leadsOffshoreQuery = new CrmLeadsOffshoreQuery();
//        leadsOffshoreQuery.setNotDistributeLeadsRemindTimeNotNull(true);
        leadsOffshoreQuery.setLeadsStatus("undistributed");
        leadsOffshoreQuery.setLeadsStage("mql");
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> all = leadsOffshoreDAO.findAll(spec);
        //通知人--暂写死为李浩
        PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20220711001503");
        Map<String, Object> result = new HashMap<>();
        result.put("numToDistribute", all.size());
        result.put("url", "/leadsManager/offshore?remindFlag=true");
        messageConfigService.sendMessageConfig(configVO, result, "appoint_people", "579786564415129367");

//        for (CrmLeadsOffshoreDO crmLeadsOffshoreDO : all) {
//            LocalDateTime notDistributeLeadsRemindTime = crmLeadsOffshoreDO.getNotDistributeLeadsRemindTime();
//            //如果当前时间大于等于触发时间
//            if (notDistributeLeadsRemindTime != null && notDistributeLeadsRemindTime.isBefore(LocalDateTime.now())) {
//                CrmOffshoreDO offshoreDO = offshoreDAO.queryById(crmLeadsOffshoreDO.getOffshore().getId());
//                List<CrmOffshoreAdminDO> offshoreAdmins = offshoreDO.getOffshoreAdmins();
//                // 发消息
//                if (offshoreAdmins != null && !offshoreAdmins.isEmpty()) {
//                    for (CrmOffshoreAdminDO offshoreAdmin : offshoreAdmins) {
//                        PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20220711001503");
//                        Map<String, Object> result = new HashMap<>();
//                        result.put("offshoreName", offshoreDO.getOffshoreName());
//                        result.put("leadsName", crmLeadsOffshoreDO.getLeads().getLeadsName());
//                        result.put("url", "/leadsManager/offshore");
//                        messageConfigService.sendMessageConfig(configVO, result, "appoint_people", offshoreAdmin.getUserId().toString());
////                        messageConfigService.addJobMessage(crmLeadsOffshoreDO.getLeads().getId(),"distributeRemind", null , "管理员", offshoreAdmin.getUserId().toString(), "线索超时未分配通知", String.format("近海%s中有一条线索尚未分配，请及时分配", offshoreDO.getOffshoreName()), "进入分配", "/leadsManager/offshore");
//                        //关闭提醒
//                        CrmLeadsOffshorePayload crmLeadsOffshorePayload = new CrmLeadsOffshorePayload();
//                        crmLeadsOffshorePayload.setId(crmLeadsOffshoreDO.getId());
//                        crmLeadsOffshorePayload.setNullFields(Arrays.asList("notDistributeLeadsRemindTime"));
//                        leadsOffshoreDAO.updateByKeyDynamic(crmLeadsOffshorePayload);
//                    }
//                }
//            }
//        }
        return true;
    }


    @Override
    public void batchAddTags(Long[] keys, String leadsTagIds) {
        String newTags = "";
        for (Long key : keys) {
            CrmLeadsPayload payload = new CrmLeadsPayload();
            payload.setId(key);
            CrmLeadsDO leadsDO = dao.queryById(key);
            String leadsTagIds1 = leadsDO.getLeadsTagIds();
            if (leadsTagIds != null && !leadsTagIds.isEmpty() && leadsTagIds1 != null && !leadsTagIds1.isEmpty()) {
                List<String> leadsTagIdList = new ArrayList<>(Arrays.asList(leadsTagIds.split(",")));
                leadsTagIdList.addAll(new ArrayList<>(Arrays.asList(leadsTagIds1.split(","))));
                newTags = String.join(",", leadsTagIdList.stream().distinct().collect(Collectors.toList()));
            } else {
                newTags = leadsTagIds;
            }
            payload.setLeadsTagIds(newTags);
            dao.updateByKeyDynamic(payload);
        }
    }


    @Override
    public void batchDelTags(Long[] keys, String leadsTagIds) {
        String newTags = "";
        for (Long key : keys) {
            CrmLeadsPayload payload = new CrmLeadsPayload();
            payload.setId(key);
            CrmLeadsDO leadsDO = dao.queryById(key);
            String existingTags = leadsDO.getLeadsTagIds();
            if (existingTags != null && !existingTags.isEmpty()) {
                if (leadsTagIds != null && !leadsTagIds.isEmpty()) {
                    List<String> leadsTagIdList = new ArrayList<>(Arrays.asList(existingTags.split(",")));
                    leadsTagIdList.removeAll(new ArrayList<>(Arrays.asList(leadsTagIds.split(","))));
                    newTags = String.join(",", leadsTagIdList.stream().distinct().collect(Collectors.toList()));
                } else {
                    newTags = existingTags;
                }
            } else {
                newTags = null;
            }
            payload.setLeadsTagIds(newTags);
            dao.updateByKeyDynamic(payload);
        }
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public Map<String, Object> bindCustomer(Long id) {
        Map<String, Object> result = new HashMap<>();
        Boolean isNewCust = false;
        CrmLeadsDO leadsDO = dao.queryById(id);
        String customerName = leadsDO.getCustomer().getCustomerName();
        String customerGrade = leadsDO.getCustomer().getCustomerGrade();
        //近海线索只有线索的跟进级别为一档和二档时才绑定客户；普通线索报备直接创建客户
//        if((customerGrade!=null && (customerGrade.equals("important") || customerGrade.equals("normal"))) || leadsDO.getSaleUserId()!=null){
        //绑定客户
        //用客户名称匹配当前客户是否存在
        int num = crmCustomerDAO.countByName(customerName);
        CrmLeadsPayload leadsPayload = new CrmLeadsPayload();
        leadsPayload.setId(id);
        if (num > 0) {
            List<CrmCustomerDO> customerDOS = crmCustomerDAO.findByName(customerName);
            leadsPayload.setFormalCustomerId(customerDOS.get(0).getId());
            CrmCustomerPayload customerPayload = new CrmCustomerPayload();
            customerPayload.setId(customerDOS.get(0).getId());
            customerPayload.setCustomerGrade(leadsDO.getCustomer().getCustomerGrade());
            customerService.update(customerPayload);
        } else {
            CrmCustomerPayload customerPayload = new CrmCustomerPayload();
            CrmLeadsCustomerDO customer = leadsDO.getCustomer();
            customerPayload.setCustomerName(customerName);
            customerPayload.setCustomerGrade(customer.getCustomerGrade());
            customerPayload.setCompanyIndustry(customer.getCustomerIndustry());
            customerPayload.setCompanyEmail(customer.getContactsEmail());
            customerPayload.setCompanyPhone(customer.getContactsPhone());
            customerPayload.setCustomerStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
            //根据当前的线索信息创建客户
            try {
                CrmCustomerVO insert = customerService.insert(customerPayload);
                leadsPayload.setFormalCustomerId(insert.getId());
            } catch (Exception e) {
                e.printStackTrace();
            }
            isNewCust = true;
        }
        dao.updateByKeyDynamic(leadsPayload);
        if (customerGrade == null || (customerGrade != null && (customerGrade.equals("general") || customerGrade.equals("plain") || customerGrade.equals("null")))) {
            result.put("showBindMess", false);
        } else {
            result.put("showBindMess", true);
        }
        result.put("isNewCust", isNewCust);

//        }else{
//            result.put("needBind",false);
//        }
        return result;
    }

    @Override
    @Transactional
    public void bindCustomerBatch(Long[] ids) {
        for (Long id : ids) {
            try {
                bindCustomer(id);
            } catch (Exception e) {
                //删除
                deleteSoft(Collections.singletonList(id));
            }
        }
    }

    @Override
    @Transactional
    public void bindCustomerNotBind() {
        List<Long> ids = dao.queryNotBindLeads();
        for (Long id : ids) {
            try {
                bindCustomer(id);
            } catch (Exception e) {
                continue;
            }
        }
    }



    @Override
    public Map<String, Object> bindCustomers() {
        //查询所有未绑定客户的线索
        List<Long> notBindLeads = dao.findNotBindLeads();
        for (Long notBindLead : notBindLeads) {
            bindCustomer(notBindLead);
        }
        return new HashMap<>();
    }

    @Override
    public List<CrmLeadsListVO> queryListByCustomName(String customName){
        CrmLeadsQuery query = new CrmLeadsQuery();
        query.setCustomerName(customName);
        Specification<CrmLeadsDO> spec = dao.getSpec(query);
        List<CrmLeadsDO> list = dao.findAll(spec);
        return list.stream().map(CrmLeadsConvert.INSTANCE::toListVo).toList();
    }
}
