package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanTempDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempDetailVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOperationPlanTempDetailConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOperationPlanTempDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanTempDetailRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 客户经营 - 经营计划模板明细
 *
 * @author duwh
 * @date 2022/11/17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOperationPlanTempDetailServiceImpl implements CrmOperationPlanTempDetailService {

    private final CrmOperationPlanTempDetailRepo repo;
    private final PrdSystemLogService logService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmOperationPlanTempDetailVO insert(CrmOperationPlanTempDetailPayload payload) {
        // 默认值
        setDefaultValue(payload);

        CrmOperationPlanTempDetailDO entityDo = CrmOperationPlanTempDetailConvert.INSTANCE.toDo(payload);
        repo.save(entityDo);

        return CrmOperationPlanTempDetailConvert.INSTANCE.toVo(entityDo);
    }

    /**
     * 设置默认值
     *
     * @param payload 有效载荷
     */
    private void setDefaultValue(CrmOperationPlanTempDetailPayload payload) {
        if (!StringUtils.hasText(payload.getPriority())) {
            // 优先级默认较低
            payload.setPriority("10");
        }
        if (!StringUtils.hasText(payload.getStatus())) {
            // 状态默认已规划
            payload.setStatus("PLAN");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmOperationPlanTempDetailVO update(CrmOperationPlanTempDetailPayload payload) {
        CrmOperationPlanTempDetailDO entity = repo.findById(payload.getId()).orElseGet(CrmOperationPlanTempDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmOperationPlanTempDetailDO entityDo = CrmOperationPlanTempDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmOperationPlanTempDetailConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    public CrmOperationPlanTempDetailVO queryByKey(Long key) {
        CrmOperationPlanTempDetailDO entity = repo.findById(key).orElseGet(CrmOperationPlanTempDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        final CrmOperationPlanTempDetailVO crmCustomerOperationVO = CrmOperationPlanTempDetailConvert.INSTANCE.toVo(entity);
        return crmCustomerOperationVO;
    }

    @Override
    public List<CrmOperationPlanTempDetailVO> queryList(CrmOperationPlanTempDetailQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("createTime");
        query.defaultOrder(orderItem);
        return CrmOperationPlanTempDetailConvert.INSTANCE.toVoList(repo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public PagingVO<CrmOperationPlanTempDetailVO> paging(CrmOperationPlanTempDetailQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("createTime");
        query.defaultOrder(orderItem);
        Page<CrmOperationPlanTempDetailDO> page = repo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmOperationPlanTempDetailConvert.INSTANCE::toVo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<CrmOperationPlanTempDetailDO> optional = repo.findById(id);
                if (!optional.isEmpty()) {
                    CrmOperationPlanTempDetailDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    repo.save(entity);
                }
            });
        }
    }

    @Override
    public void deleteSoftByTempId(Long tempId) {
        CrmOperationPlanTempDetailQuery query = new CrmOperationPlanTempDetailQuery();
        query.setTempId(tempId);
        final List<CrmOperationPlanTempDetailDO> planTempDetailDOList = repo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
        final List<Long> keys = planTempDetailDOList.stream().map(CrmOperationPlanTempDetailDO::getId).collect(Collectors.toList());
        deleteSoft(keys);
    }

    @Override
    public void saveAll(List<CrmOperationPlanTempDetailPayload> detailList) {
        detailList.forEach(crmOperationPlanTempDetailPayload -> {
            insert(crmOperationPlanTempDetailPayload);
        });
    }

}
