package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanTempService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanTempVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOperationPlanTempConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOperationPlanTempDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanTempRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * 客户经营 - 经营计划模板
 *
 * @author duwh
 * @date 2022/11/17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOperationPlanTempServiceImpl implements CrmOperationPlanTempService {

    private final CrmOperationPlanTempRepo repo;
    private final CrmOperationPlanTempDetailService detailService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmOperationPlanTempVO insert(CrmOperationPlanTempPayload payload) {
        if (StringUtils.isEmpty(payload.getCustType())) {
            throw TwException.error("", "类型不能为空");
        }
        if (StringUtils.isEmpty(payload.getCustGrade())) {
            throw TwException.error("", "级别不能为空");
        }
        // 校验唯一 类型、客户级别 确定唯一
        CrmOperationPlanTempQuery query = new CrmOperationPlanTempQuery();
        query.setCustType(payload.getCustType());
        query.setCustGrade(payload.getCustGrade());
        if (count(query) > 0) {
            throw TwException.error("", "重复数据");
        }
        CrmOperationPlanTempDO entityDo = CrmOperationPlanTempConvert.INSTANCE.toDo(payload);
        repo.save(entityDo);
        // 明细新增
        if (!CollectionUtils.isEmpty(payload.getDetailList())) {
            payload.getDetailList().forEach(crmOperationPlanTempDetailPayload -> crmOperationPlanTempDetailPayload.setTempId(entityDo.getId()));
            detailService.saveAll(payload.getDetailList());
        }
        return CrmOperationPlanTempConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmOperationPlanTempVO update(CrmOperationPlanTempPayload payload) {
        CrmOperationPlanTempDO entity = repo.findById(payload.getId()).orElseGet(CrmOperationPlanTempDO::new);
        final Long tempId = entity.getId();
        Assert.notNull(tempId, "不存在");
        CrmOperationPlanTempDO entityDo = CrmOperationPlanTempConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        final CrmOperationPlanTempDO save = repo.save(entity);

        // 明细处理
        // 先删除已存在的明细数据；
        detailService.deleteSoftByTempId(tempId);
        // 再新增
        if (!CollectionUtils.isEmpty(payload.getDetailList())) {
            payload.getDetailList().forEach(crmOperationPlanTempDetailPayload -> crmOperationPlanTempDetailPayload.setTempId(entityDo.getId()));
            detailService.saveAll(payload.getDetailList());
        }
        return CrmOperationPlanTempConvert.INSTANCE.toVo(save);
    }

    @Override
    public CrmOperationPlanTempVO queryByKey(Long key) {
        CrmOperationPlanTempDO entity = repo.findById(key).orElseGet(CrmOperationPlanTempDO::new);
        Assert.notNull(entity.getId(), "不存在");
        final CrmOperationPlanTempVO crmCustomerOperationVO = CrmOperationPlanTempConvert.INSTANCE.toVo(entity);

        // 明细数据
        CrmOperationPlanTempDetailQuery planTempDetailQuery = new CrmOperationPlanTempDetailQuery();
        planTempDetailQuery.setTempId(key);
        final List<CrmOperationPlanTempDetailVO> planTempDetailVOList = detailService.queryList(planTempDetailQuery);
        crmCustomerOperationVO.setDetailList(planTempDetailVOList);
        return crmCustomerOperationVO;
    }

    @Override
    public List<CrmOperationPlanTempVO> queryList(CrmOperationPlanTempQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("createTime");
        query.defaultOrder(orderItem);
        return CrmOperationPlanTempConvert.INSTANCE.toVoList(repo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public long count(CrmOperationPlanTempQuery query) {
        return repo.count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    @Override
    public PagingVO<CrmOperationPlanTempVO> paging(CrmOperationPlanTempQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("createTime");
        query.defaultOrder(orderItem);
        Page<CrmOperationPlanTempDO> page = repo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmOperationPlanTempConvert.INSTANCE::toVo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<CrmOperationPlanTempDO> optional = repo.findById(id);
                if (!optional.isEmpty()) {
                    CrmOperationPlanTempDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    repo.save(entity);
                    // 删除明细
                    // detailService.deleteSoftByTempId(id);
                }
            });
        }
    }

}
