package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityCompetitorPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityCompetitorService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityCompetitorVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityCompetitorConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityCompetitorDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityCompetitorDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description 商机竞争对手管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityCompetitorServiceImpl implements CrmOpportunityCompetitorService {
    private final CacheUtil cacheUtil;
    private final CrmOpportunityCompetitorDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final CrmOpportunityDAO opportunityDAO;

    @Value("${tw4.opportunity.competitor_operation}")
    private String competitor_operation;

    @Value("${tw4.opportunity.competitor_del}")
    private String competitor_del;

    @Transactional
    @Override
    public CrmOpportunityCompetitorVO insert(CrmOpportunityCompetitorPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getCompeIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getCompeIdV4()));
        }
        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //String result = httpUtil.sendSyncPost(competitor_operation, map);
        //String competitorId = httpUtil.geResultData(result);
        //long competitorIdV4 = 0;
        //if (StringUtils.hasText(competitorId)) {
        //    if (StringUtil.isInteger(competitorId)) {
        //        competitorIdV4 = Long.valueOf(competitorId);
        //    }
        //}
        CrmOpportunityCompetitorDO ado = CrmOpportunityCompetitorConvert.INSTANCE.toDo(payload);
        //ado.setCompetitorIdV4(competitorIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "竞争对手");

        return CrmOpportunityCompetitorConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(CrmOpportunityCompetitorPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getCompeIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getCompeIdV4()));
        }
        //同步到4.0
        //Long competitorIdV4 = dao.queryTW4IdById(payload.getId());
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("id", competitorIdV4);
        //String result = httpUtil.sendSyncPost(competitor_operation, map);
        //httpUtil.geResultData(result);
        CrmOpportunityCompetitorDO ado = CrmOpportunityCompetitorConvert.INSTANCE.toDo(payload);
        //ado.setCompetitorIdV4(competitorIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "竞争对手");

        return 0L;
    }

    @Override
    public List<CrmOpportunityCompetitorVO> queryList(Long oppoId) {

        return dao.queryList(oppoId);
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
        //String result = httpUtil.sendSyncGet(competitor_del, map);
        //httpUtil.geResultData(result);
        dao.deleteSoft(keys);
        logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "竞争对手");
        return true;
    }
}
