package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPartnerPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityPartnerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityPartnerVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityPartnerConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityPartnerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityPartnerDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description 商机合作伙伴管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityPartnerServiceImpl implements CrmOpportunityPartnerService {
    private final CacheUtil cacheUtil;
    private final CrmOpportunityPartnerDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final CrmOpportunityDAO opportunityDAO;

    @Value("${tw4.opportunity.partner_operation}")
    private String partner_operation;

    @Value("${tw4.opportunity.partner_del}")
    private String partner_del;

    @Transactional
    @Override
    public CrmOpportunityPartnerVO insert(CrmOpportunityPartnerPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getPartnerIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getPartnerIdV4()));
        }
        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //String result = httpUtil.sendSyncPost(partner_operation, map);
        //String partnerId = httpUtil.geResultData(result);
        //long partnerIdV4 = 0;
        //if (StringUtils.hasText(partnerId)) {
        //    if (StringUtil.isInteger(partnerId)) {
        //        partnerIdV4 = Long.valueOf(partnerId);
        //    }
        //}
        CrmOpportunityPartnerDO ado = CrmOpportunityPartnerConvert.INSTANCE.toDo(payload);
        //ado.setPartnerIdV4(partnerIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "合作伙伴");
        return CrmOpportunityPartnerConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(CrmOpportunityPartnerPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getPartnerIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getPartnerIdV4()));
        }
        //同步到4.0
        //Long partnerIdV4 = payload.getPartnerIdV4()==null?dao.queryTW4IdById(payload.getId()):payload.getPartnerIdV4();
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("id", partnerIdV4);
        //String result = httpUtil.sendSyncPost(partner_operation, map);
        //httpUtil.geResultData(result);

        CrmOpportunityPartnerDO ado = CrmOpportunityPartnerConvert.INSTANCE.toDo(payload);
        //ado.setPartnerIdV4(partnerIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "合作伙伴");

        return 0L;
    }

    @Override
    public List<CrmOpportunityPartnerVO> queryList(Long oppoId) {

        return dao.queryList(oppoId);
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
        //String result = httpUtil.sendSyncGet(partner_del, map);
        //httpUtil.geResultData(result);
        dao.deleteSoft(keys);
        logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "合作伙伴");
        return true;
    }
}
