package com.elitesland.tw.tw5.server.prd.crm.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.*;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.ListCompareUtil;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.crm.constant.CrmOpportunityCheckStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectMemberDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.dto.CreateFolderDTO;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author carl.wang
 * @Description 商机管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityServiceImpl extends BaseServiceImpl implements CrmOpportunityService {
    private final CacheUtil cacheUtil;
    private final PrjProjectDAO projectDAO;
    private final CrmOpportunityDAO dao;
    private final CrmOpportunityRepo repo;
    private final CrmActActivityDAO activityDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;

    private final CrmFollowService followService;
    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
    //private SysNumberRuleService numberRuleService;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final CrmCustomerDAO crmCustomerDAO;
    @Autowired
    private CrmCustomerService customerService;
    private final PrdAbDAO abDAO;
    private final YeedocService yeedocService;
    private final YeedocProperties yeedocProperties;
    private final CrmLeadsDAO leadsDAO;
    private final UdcUtil udcUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    @Value("${tw4.opportunity.operation}")
    private String opportunity_operation;

    @Value("${tw4.opportunity.operation_close}")
    private String opportunity_operation_close;

    @Value("${tw4.opportunity.operation_change_status}")
    private String opportunity_operation_updateStatus;

    private static final String[] sapBuSystemRoleCodes = {"BD0020", "BD0031", "BD0035", "BD0037", "BD0036", "BD0030"};


    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public CrmOpportunityVO insert(CrmOpportunityPayload payload) {
        //翻译4.0相关字段
        payload = transferV4(payload);
        if (payload.getIsNeedPartner() == null) {
            payload.setIsNeedPartner(0);
        }
        //获取编号
        String code = generateSeqNum("OPPORTUNITY");
        payload.setProjectNo(code);
        Map<String, Object> map = new HashMap<>();
        //同步到4.0
//        if(payload.getInternalUserIdV4()!=null){
//            //如果从4.0请求过来的数据,直接转
//            map = BeanUtil.beanToMap(payload);
//        }else{
        map = transferUtilService.beanToMap(payload);
        //翻译关联的线索id
        Long leadsId = payload.getLeadsId();
        if (leadsId != null) {
            CrmLeadsDO leadsDO = leadsDAO.queryById(leadsId);
            map.put("leadsId", leadsDO.getLeadsIdV4());
        }

//        }
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
        map.put("createUserId", employeeDAO.getV4UserId(userId));

        //String result = httpUtil.sendSyncPost(opportunity_operation, map);
        //String oppoId = httpUtil.geResultData(result);
        //long oppoIdV4 = 0;
        //if (StringUtils.hasText(oppoId)) {
        //    if (StringUtil.isInteger(oppoId)) {
        //        oppoIdV4 = Long.valueOf(oppoId);
        //    }
        //}
//
        //保存项目
        PrjProjectDO ado = CrmOpportunityConvert.INSTANCE.toProjectDo(payload);
        ado.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        ado.setProjectType(CrmFollowObjectEnum.Opportunity.getCode());
        ado.setProjectNo(code);
        ado = projectDAO.save(ado);

        CrmOpportunityDO crmOpportunityDO = CrmOpportunityConvert.INSTANCE.toDo(payload);
        crmOpportunityDO.setProjectId(ado.getId());
        //crmOpportunityDO.setOppoIdV4(oppoIdV4);
        crmOpportunityDO.setCheckStatus(CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode());
        crmOpportunityDO = dao.save(crmOpportunityDO);

        logService.saveNewLog(crmOpportunityDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc());
        //把创建人和负责人等添加为团队成员
        List<Long> userIds = new ArrayList<>();
        userIds.add(ado.getCreateUserId());
        userIds.add(ado.getManageUserId());
        userIds.add(crmOpportunityDO.getPreSaleUserId());
        userIds.add(crmOpportunityDO.getDeliUserId());
        userIds.add(crmOpportunityDO.getCoUserId());
        userIds.add(crmOpportunityDO.getCodeliUserId());
        addProjectMember(ado.getId(), userIds, null);

        return CrmOpportunityConvert.INSTANCE.toVo(crmOpportunityDO);
    }

    private CrmOpportunityPayload transferV4(CrmOpportunityPayload payload) {
        if (payload.getCustBookIdV4() != null) {
            payload.setCustBookId(abDAO.getIdByV4(payload.getCustBookIdV4()));
        }
        if (payload.getOrgIdV4() != null) {
            payload.setOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getOrgIdV4()));
        }
        if (payload.getManageUserIdV4() != null) {
            payload.setManageUserId(employeeDAO.getUserIdByV4(payload.getManageUserIdV4()));
        }
        if (payload.getCoOrgIdV4() != null) {
            payload.setCoOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getCodeliOrgIdV4()));
        }
        if (payload.getCoUserIdV4() != null) {
            payload.setCoUserId(employeeDAO.getUserIdByV4(payload.getCoUserIdV4()));
        }
        if (payload.getDeliOrgIdV4() != null) {
            payload.setDeliOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getDeliOrgIdV4()));
        }
        if (payload.getDeliUserIdV4() != null) {
            payload.setDeliUserId(employeeDAO.getUserIdByV4(payload.getDeliUserIdV4()));
        }
        if (payload.getDeliOrgIdV4() != null) {
            payload.setDeliOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getDeliOrgIdV4()));
        }
        if (payload.getCodeliOrgIdV4() != null) {
            payload.setCodeliOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getCodeliOrgIdV4()));
        }
        if (payload.getCodeliUserIdV4() != null) {
            payload.setCodeliUserId(employeeDAO.getUserIdByV4(payload.getCodeliUserIdV4()));
        }
        if (payload.getInternalUserIdV4() != null) {
            payload.setInternalUserId(employeeDAO.getUserIdByV4(payload.getInternalUserIdV4()));
        }
        if (payload.getInternalOrgIdV4() != null) {
            payload.setInternalOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getInternalOrgIdV4()));
        }
        if (payload.getPreSaleOrgIdV4() != null) {
            payload.setPreSaleOrgId(orgOrganizationDAO.getOrgIdByV4(payload.getPreSaleOrgIdV4()));
        }
        if (payload.getPreSaleUserIdV4() != null) {
            payload.setPreSaleUserId(employeeDAO.getUserIdByV4(payload.getPreSaleUserIdV4()));
        }
        return payload;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public Long update(CrmOpportunityPayload payload) {
        transferV4(payload);
        CrmActProjectVO project = dao.queryProjectBykey(payload.getId());
        checkUpdate(project);
        Long userId = 0L;
        try {
            userId = GlobalUtil.getLoginUserId();
        } catch (Exception e) {
        }

        Map<String, List<Long>> userMangeIds = getUserMangeIds(payload, project);
        List<Long> addIds = userMangeIds.get("addIds");
        List<Long> deleteIds = userMangeIds.get("deleteIds");
        //TODO 后续完善
//        if (updateUserIds.size() > 0 && project.getCreateUserId().longValue() != userId.longValue() && !userId.equals(0l)) {
//            throw TwException.error("", "创建人可进行负责人变更");
//        }
        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("id", project.getOppoIdV4());
        //String result = httpUtil.sendSyncPost(opportunity_operation, map);
        //httpUtil.geResultData(result);

        dao.updateProjectByKeyDynamic(payload, project.getId());

//        CrmOpportunityVO opportunityVO = dao.queryByKey(payload.getId());
//        String detail = GlobalUtil.getContantsLog(PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc(), opportunityVO.getContactName(), payload.getContactName(), opportunityVO.getContactPhone(), payload.getContactPhone());
        CrmOpportunityDO oppoDO = repo.findById(payload.getId()).get();
        CrmOpportunityDO oldEntity = new CrmOpportunityDO();
        BeanUtils.copyProperties(oppoDO, oldEntity);

        CrmOpportunityConvert.INSTANCE.copy(payload, oppoDO);
        oppoDO.setProjectId(project.getId());
        oppoDO.setOppoIdV4(project.getOppoIdV4());
        oppoDO = dao.save(oppoDO);

        String changeLog = changeFieldLogUtil.getFieldsUpdateLog(oppoDO, oldEntity);
        if (StringUtils.hasText(changeLog)) {
            logService.saveNewLog(oppoDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), changeLog);
        }

        deleteProjectMember(project.getId(), deleteIds, project.getOppoIdV4());
        addProjectMember(project.getId(), addIds, project.getOppoIdV4());

        return 0L;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void toggleCheckStatus(List<Long> ids) {
        List<CrmOpportunityDO> doList = repo.findAllById(ids);
        for (var oppoDO : doList) {
            CrmOpportunityDO oldEntity = new CrmOpportunityDO();
            BeanUtils.copyProperties(oppoDO, oldEntity);

            String newCheckStatus = toggleCheckStatus(oppoDO.getCheckStatus());
            oppoDO.setCheckStatus(newCheckStatus);
            repo.save(oppoDO);

            //获取变更日志
            String changeLog = changeFieldLogUtil.getFieldsUpdateLog(oppoDO, oldEntity);
            if (StringUtils.hasText(changeLog)) {
                logService.saveNewLog(oppoDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), changeLog);
            }
        }
    }

    private String toggleCheckStatus(String checkStatus) {
        if (CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode().equals(checkStatus)) {
            return CrmOpportunityCheckStatusEnum.CHECKED.getCode();
        } else if (CrmOpportunityCheckStatusEnum.CHECKED.getCode().equals(checkStatus)) {
            return CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode();
        } else {
            return checkStatus;
        }
    }

    @Override
    public PagingVO<CrmOpportunityVO> paging(CrmOpportunityQuery query) {
        PagingVO<CrmOpportunityVO> opportunityVO = null;
        if (query.getFormalCustomerId() != null) {
            //默认需要权限
            if (query.getIsPermission()) {
//                List<Long> marketUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
//                List<Long> saleUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_RES.getCode()));
//                List<Long> marketAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
//                List<Long> saleAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));

                Boolean marketAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
                Boolean marketUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
                Boolean saleAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
                Boolean saleUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode()));
                // 获取当前登录用户
//                GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
//                Long userId = userDetails == null ? 0 : userDetails.getUser().getId();

                //过滤不符合要求的客户
//                if ((saleUserIdsByRole != null && !saleUserIdsByRole.isEmpty() && saleUserIdsByRole.contains(userId)) ||
//                        (saleAdminUserIdsByRole != null && !saleAdminUserIdsByRole.isEmpty() && saleAdminUserIdsByRole.contains(userId))
//                ) {
//                    query.setSourceType("INTERNAL");
//                } else if ((marketUserIdsByRole != null && !marketUserIdsByRole.isEmpty() && marketUserIdsByRole.contains(userId)) ||
//                        (marketAdminUserIdsByRole != null && !marketAdminUserIdsByRole.isEmpty() && marketAdminUserIdsByRole.contains(userId))
//                ) {
//                    query.setSourceType("EXTERNAL");
//                }
                if (saleUserIdsByRole || saleAdminUserIdsByRole) {
                    query.setSourceType("INTERNAL");
                } else if (marketAdminUserIdsByRole || marketUserIdsByRole) {
                    query.setSourceType("EXTERNAL");
                } else {
                    query.setCreateUserId(GlobalUtil.getLoginUserId());
                }

            }
            opportunityVO = dao.queryPaging(query, null, null, null);
        } else {
            Long userId = GlobalUtil.getLoginUserId();

            List<Long> sapPermissionOrgIdList = null;
            List<Long> orgManageIds = orgOrganizationDAO.queryByManageIdOrgIds(userId);
            // 部门下的成员包括当前登录人本人
            List<Long> oppoUserIds = new ArrayList<>();
            // 判断当前登录人是否是系统管理员or销售管理员
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
            if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
                oppoUserIds = null;
            } else {
                boolean hasSapBuPermission = cacheUtil.hasSystemRolePermission(Arrays.asList(sapBuSystemRoleCodes));
                if (hasSapBuPermission) {
                    List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(userId);
                    List<String> userSapBuSystemRoleCodes = Arrays.stream(sapBuSystemRoleCodes).filter(s -> userSystemRoleCodes.contains(s)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(userSapBuSystemRoleCodes)) {
                        sapPermissionOrgIdList = orgOrganizationDAO.queryByOrgCode(userSapBuSystemRoleCodes).stream().map(BaseModel::getId).collect(Collectors.toList());
                    }
                }
                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
                if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                    Long orgId = prdOrgEmployeeRefVO.getOrgId();
                    //查询部门下的成员
                    List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = orgOrganizationDAO.queryEmployeeList(orgId);
                    oppoUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
                } else {
                    oppoUserIds = Collections.singletonList(userId);
                }
            }
            opportunityVO = dao.queryPaging(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        }
        List<CrmOpportunityVO> opportunitys = opportunityVO.getRecords();
        Set<Long> userIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();
        Set<Long> bookIds = new HashSet<>();
        for (CrmOpportunityVO vo : opportunitys) {
            transferSystemSelection(vo);
            getIdDatas(userIds, orgIds, bookIds, vo);
        }
        List<Map<String, Object>> employees = dao.queryEmployees(userIds);
        Map<Long, String> employeeMap = new HashMap<>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf(employee.get("userId") + ""), (String) employee.get("employeeName")));
        List<Map<String, Object>> orgs = dao.queryOrgs(orgIds);
        Map<Long, String> orgMap = new HashMap<>();
        orgs.forEach(org -> orgMap.put(Long.valueOf(org.get("id") + ""), (String) org.get("orgName")));
        List<Map<String, Object>> books = dao.queryBooks(bookIds);
        Map<Long, String> bookMap = new HashMap<>();
        books.forEach(book -> bookMap.put(Long.valueOf(book.get("id") + ""), (String) book.get("bookName")));

        opportunitys.forEach(opportunity -> transferOpportunityDatas(employeeMap, orgMap, bookMap, opportunity));
        return opportunityVO;
    }

    /**
     * 查询列表简单 用于下拉选择
     *
     * @return {@link List}<{@link CrmOpportunityVO}>
     */
    @Override
    public List<CrmOpportunitySimpleVO> queryListSimple(CrmOpportunityQuery query) {
        List<CrmOpportunitySimpleVO> opportunityList;
        if (query.getFormalCustomerId() != null) {
            //默认需要权限
            if (query.getIsPermission()) {
//                List<Long> marketUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
//                List<Long> saleUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_RES.getCode()));
//                List<Long> marketAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
//                List<Long> saleAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));

                Boolean marketAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
                Boolean marketUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
                Boolean saleAdminUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
                Boolean saleUserIdsByRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode()));
                // 获取当前登录用户
//                GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
//                Long userId = userDetails == null ? 0 : userDetails.getUser().getId();

                //过滤不符合要求的客户
//                if ((saleUserIdsByRole != null && !saleUserIdsByRole.isEmpty() && saleUserIdsByRole.contains(userId)) ||
//                        (saleAdminUserIdsByRole != null && !saleAdminUserIdsByRole.isEmpty() && saleAdminUserIdsByRole.contains(userId))
//                ) {
//                    query.setSourceType("INTERNAL");
//                } else if ((marketUserIdsByRole != null && !marketUserIdsByRole.isEmpty() && marketUserIdsByRole.contains(userId)) ||
//                        (marketAdminUserIdsByRole != null && !marketAdminUserIdsByRole.isEmpty() && marketAdminUserIdsByRole.contains(userId))
//                ) {
//                    query.setSourceType("EXTERNAL");
//                }
                if (saleUserIdsByRole || saleAdminUserIdsByRole) {
                    query.setSourceType("INTERNAL");
                } else if (marketAdminUserIdsByRole || marketUserIdsByRole) {
                    query.setSourceType("EXTERNAL");
                } else {
                    query.setCreateUserId(GlobalUtil.getLoginUserId());
                }

            }
            opportunityList = dao.queryListSimple(query, null, null, null);
        } else {
            Long userId = GlobalUtil.getLoginUserId();

            List<Long> sapPermissionOrgIdList = null;
            List<Long> orgManageIds = orgOrganizationDAO.queryByManageIdOrgIds(userId);
            // 部门下的成员包括当前登录人本人
            List<Long> oppoUserIds = new ArrayList<>();
            // 判断当前登录人是否是系统管理员or销售管理员
            List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
            if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
                oppoUserIds = null;
            } else {
                boolean hasSapBuPermission = cacheUtil.hasSystemRolePermission(Arrays.asList(sapBuSystemRoleCodes));
                if (hasSapBuPermission) {
                    List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(userId);
                    List<String> userSapBuSystemRoleCodes = Arrays.stream(sapBuSystemRoleCodes).filter(s -> userSystemRoleCodes.contains(s)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(userSapBuSystemRoleCodes)) {
                        sapPermissionOrgIdList = orgOrganizationDAO.queryByOrgCode(userSapBuSystemRoleCodes).stream().map(BaseModel::getId).collect(Collectors.toList());
                    }
                }
                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
                if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                    Long orgId = prdOrgEmployeeRefVO.getOrgId();
                    //查询部门下的成员
                    List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = orgOrganizationDAO.queryEmployeeList(orgId);
                    oppoUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
                } else {
                    oppoUserIds = Collections.singletonList(userId);
                }
            }
            opportunityList = dao.queryListSimple(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        }
        return opportunityList;
    }


    private void allChildrenOrgId(Long parentOrgId, List<Long> childrenOrgIdList) {
        List<PrdOrgOrganizationRefDO> childrenOrgRefList = orgOrganizationDAO.queryAllByParentId(parentOrgId);
        if (CollectionUtils.isEmpty(childrenOrgRefList)) {
            return;
        }
        for (var orgRef : childrenOrgRefList) {
            childrenOrgIdList.add(orgRef.getOrgId());
            allChildrenOrgId(orgRef.getOrgId(), childrenOrgIdList);
        }
    }

    @Override
    public List<CrmActProjectVO> queryList() {
        return null;
    }


    @Override
    public CrmOpportunityVO queryByKey(Long key) {
        CrmOpportunityVO vo = dao.queryByKey(key);
        Set<Long> userIds = new HashSet<>();
        Set<Long> orgIds = new HashSet<>();
        transferSystemSelection(vo);
        Set<Long> bookIds = new HashSet<>();
        getIdDatas(userIds, orgIds, bookIds, vo);
        List<Map<String, Object>> employees = dao.queryEmployees(userIds);
        Map<Long, String> employeeMap = new HashMap<>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf(employee.get("userId") + ""), (String) employee.get("employeeName")));
        List<Map<String, Object>> orgs = dao.queryOrgs(orgIds);
        Map<Long, String> orgMap = new HashMap<>();
        orgs.forEach(org -> orgMap.put(Long.valueOf(org.get("id") + ""), (String) org.get("orgName")));

        List<Map<String, Object>> books = dao.queryBooks(bookIds);
        Map<Long, String> bookMap = new HashMap<>();
        books.forEach(book -> bookMap.put(Long.valueOf(book.get("id") + ""), (String) book.get("bookName")));

        transferOpportunityDatas(employeeMap, orgMap, bookMap, vo);
        vo.setMemberVOS(activityDAO.queryProjectMember(vo.getProjectId()));
        /**
         * 商机外包费用权限控制
         * 1.管理员和平台角色可看所有
         * 2.签单bu可以看
         */
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode()));
        String isShow1 = "0";
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            isShow1 = "1";
        }
        if (isShow1.equals("0")) {
            PrdOrgOrganizationDO prdOrgOrganizationDO = orgOrganizationDAO.queryById(vo.getOrgId());
            if (prdOrgOrganizationDO.getManageId() != null && prdOrgOrganizationDO.getManageId().longValue() == userId.longValue()) {
                isShow1 = "1";
            }
        }
        vo.setIsShow1(isShow1);

        return vo;
    }

    /**
     * 简单查询关键
     *
     * @param key 关键
     * @return {@link CrmOpportunityVO}
     */
    @Override
    public CrmOpportunityVO queryByKeySimple(Long key) {
        return dao.queryByKey(key);
    }

    @Transactional
    @Override
    public boolean changeStatus(Long key) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        String status = "";
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            status = WorkFlowStatusEnum.PENDING_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            CrmOpportunityPayload payload = new CrmOpportunityPayload();
            payload.setNullFields(Arrays.asList("closeReason"));
            dao.updateProjectByKeyDynamic(payload, project.getId());
        } else {
            throw TwException.error("", "活动状态为激活/暂挂/关闭才可进行该操作");
        }
        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("id", project.getOppoIdV4());
        //map.put("projectStatus", status);
        //String result = httpUtil.sendSyncPost(opportunity_operation_updateStatus, map);
        //httpUtil.geResultData(result);

        logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), status) + PrdSystemObjectEnum.Opportunity.getDesc());

        dao.updateStatus(project.getId(), status);
        return true;
    }

    @Transactional
    @Override
    public boolean closeOpportunity(Long key, String closeReason, String loseReson, String clsoeRemark) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        checkUpdate(project);

        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("id", project.getOppoIdV4());
        //map.put("closeReason", closeReason);
        //map.put("loseReason", loseReson);
        //map.put("clsoeRemark", clsoeRemark);
        //map.put("projectStatus", WorkFlowStatusEnum.CLOSED_WORK.getCode());
        //String result = httpUtil.sendSyncPost(opportunity_operation_close, map);
        //httpUtil.geResultData(result);


        CrmOpportunityPayload payload = new CrmOpportunityPayload();
        payload.setProjectStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
        payload.setCloseReason(closeReason);
        payload.setLoseReason(loseReson);
        payload.setClsoeRemark(clsoeRemark);
        dao.updateProjectByKeyDynamic(payload, project.getId());
        logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.CLOSE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc());

        return true;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public List<PrjProjectMemberVO> addMember(Long key, List<Long> userIds) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        checkUpdate(project);
        List<Long> updateUserIds = getUserMangeIds(project);
        Long userId = GlobalUtil.getLoginUserId();
        if (!updateUserIds.contains(userId)) {
            throw TwException.error("", "无添加团队成员权限");
        }
        logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemObjectEnum.Opportunity.getDesc() + PrdSystemLogEnum.ADD.getDesc() + "团队成员");
        addProjectMember(project.getId(), userIds, project.getOppoIdV4());
        return activityDAO.queryProjectMember(project.getId());

    }

    /**
     * 执行数据库删除团队成员操作
     *
     * @param projectId
     * @param userIds
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public void deleteProjectMember(Long projectId, List<Long> userIds, Long tw4Oppid) {
//        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        map.put("id", tw4Oppid);
//        map.put("userIds", transferUtilService.queryEmployeeTw4Ids(userIds));
//        String result = httpUtil.sendSyncPost(opportunity_deleteMember, map);
//        httpUtil.geStrItem(result, "opportunity_id", "同步数据失败！");

        projectDAO.deleteMemberByUserId(projectId, userIds);
    }

    /**
     * 执行数据库添加团队成员操作
     *
     * @param projectId
     * @param userIds
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public void addProjectMember(Long projectId, List<Long> userIds, Long tw4Oppid) {
        List<PrjProjectMemberVO> memberVOS = activityDAO.queryProjectMember(projectId);
        List<Long> collect = userIds.stream().filter(userId -> memberVOS.stream().noneMatch(memberVO -> memberVO.getUserId().longValue() == userId.longValue())).collect(Collectors.toList());
        List<PrdOrgEmployeeVO> employeeVOS = activityDAO.queryEmployee(collect);
        List<PrjProjectMemberDO> memberDOS = new ArrayList<>();
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            PrjProjectMemberDO memberDO = new PrjProjectMemberDO();
            memberDO.setProjectId(projectId);
            memberDO.setUserId(employeeVO.getUserId());
            memberDO.setEmployeeName(employeeVO.getEmployeeName());
            memberDOS.add(memberDO);
        }
        if (memberDOS.size() > 0) {
            //同步到4.0
//            Map<String, Object> map = new HashMap<>();
//            map.put("id", tw4Oppid);
//            map.put("userIds", transferUtilService.queryEmployeeTw4Ids(collect));
//            String result = httpUtil.sendSyncPost(opportunity_addMember, map);
//            httpUtil.geStrItem(result, "opportunity_id", "同步数据失败！");

            projectDAO.saveMemberAll(memberDOS);

        }
    }

    /**
     * 获取负责人ids
     *
     * @param project
     * @return
     */
    List<Long> getUserMangeIds(CrmActProjectVO project) {
        List<Long> updateUserIds = new ArrayList<>();
        //系统管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
        updateUserIds.addAll(userIdsByRole);
        if (project.getManageUserId() != null) {//签单
            updateUserIds.add(project.getManageUserId());
        }
        if (project.getCodeliUserId() != null) {//副交付
            updateUserIds.add(project.getCodeliUserId());
        }
        if (project.getCoUserId() != null) {//副签单
            updateUserIds.add(project.getCoUserId());
        }
        if (project.getDeliUserId() != null) {//交付
            updateUserIds.add(project.getDeliUserId());
        }
        if (project.getPreSaleUserId() != null) {//售前
            updateUserIds.add(project.getPreSaleUserId());
        }
        if (project.getCreateUserId() != null) {//报备人
            updateUserIds.add(project.getCreateUserId());
        }
        return updateUserIds;
    }

    @Transactional
    @Override
    public boolean deleteMember(Long oppoId, List<Long> keys) {
        CrmActProjectVO project = dao.queryProjectBykey(oppoId);
        checkUpdate(project);
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> updateUserIds = getUserMangeIds(project);
        if (!updateUserIds.contains(userId)) {
            throw TwException.error("", "无删除团队成员权限");
        }
        List<Long> userMemberIds = projectDAO.getUserIds(keys);

        if (updateUserIds.size() > 0 && updateUserIds.contains(userMemberIds.get(0))) {
            throw TwException.error("", "创建人或负责人不可删除");
        }
        //activityDAO.queryProjectMember(project.getId());
//        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        map.put("id", project.getOppoIdV4());
//        map.put("userIds", transferUtilService.queryEmployeeTw4Ids(projectDAO.getUserIds(keys)));
//        String result = httpUtil.sendSyncPost(opportunity_deleteMember, map);
//        httpUtil.geStrItem(result, "opportunity_id", "同步数据失败！");
        projectDAO.deleteMemberSoft(keys, updateUserIds);
        logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemObjectEnum.Opportunity.getDesc() + PrdSystemLogEnum.DELETE.getDesc() + "团队成员");

        return true;
    }

    @Override
    public void addFollow(CrmFollowPayload payload) {
        CrmActProjectVO project = dao.queryProjectBykey(payload.getObjectId());
        checkUpdate(project);
        payload.setFollowObject(CrmFollowObjectEnum.Opportunity.getCode());
//        //同步到4.0
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        map.put("id", project.getOppoIdV4());
//        String result = httpUtil.sendSyncPost(opportunity_addFollow, map);
//        httpUtil.geStrItem(result, "opportunity_id", "同步数据失败！");


        followService.addFollow(payload);
        logService.saveNewLog(payload.getObjectId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }

    @Override
    public void updateFollow(CrmFollowPayload payload) {
        CrmActProjectVO project = dao.queryProjectBykey(payload.getObjectId());
        checkUpdate(project);
        payload.setFollowObject(CrmFollowObjectEnum.Opportunity.getCode());
        followService.updateFollow(payload);
        logService.saveNewLog(payload.getObjectId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }


    @Override
    public List<CrmFollowVO> queryListFollow(Long objectId) {
        return followService.queryFollowList(objectId, CrmFollowObjectEnum.Opportunity.name());
    }

    @Override
    public PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Opportunity.getCode());
        return logService.pageLog(query);
    }


    /**
     * 判断是否可操作
     *
     * @param project
     */
    void checkUpdate(CrmActProjectVO project) {
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            throw TwException.error("", "该活动已暂挂");
        }
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "活动已关闭");
        }
    }

    /**
     * 获取删除和添加的团队成员id
     *
     * @param payload
     * @param project
     */
    private Map<String,List<Long>> getUserMangeIds(CrmOpportunityPayload payload, CrmActProjectVO project) {
        Long manageUserId = project.getManageUserId();
        Long preSaleUserId = project.getPreSaleUserId();
        Long deliUserId = project.getDeliUserId();
        Long coUserId = project.getCoUserId();
        Long codeliUserId = project.getCodeliUserId();
        List <Long> existGroupIds= Arrays.asList(manageUserId,preSaleUserId,deliUserId,coUserId,codeliUserId).stream().filter(e->e!=null).collect(Collectors.toList());
        Long manageUserIdNew = payload.getManageUserId();
        Long preSaleUserIdNew = payload.getPreSaleUserId();
        Long deliUserIdNew = payload.getDeliUserId();
        Long coUserIdNew = payload.getCoUserId();
        Long codeliUserIdNew = payload.getCodeliUserId();
        List <Long> newGroupIds= Arrays.asList(manageUserIdNew,preSaleUserIdNew,deliUserIdNew,coUserIdNew,codeliUserIdNew).stream().filter(e->e!=null).collect(Collectors.toList());
        List<Long> deleteIds = ListCompareUtil.getDeleteList(newGroupIds, existGroupIds);
        List<Long> addIds = ListCompareUtil.getInsertList(newGroupIds, existGroupIds);
        Map<String,List<Long>> result = new HashMap<>();
        result.put("addIds",addIds);
        result.put("deleteIds",deleteIds);
        return result;
//        List<Long> updateUserIds = new ArrayList<>();
//        if (ObjectUtils.isEmpty(payload.getManageUserId())) {
//            if (!ObjectUtils.isEmpty(project.getManageUserId())) {
//                deleteIds.add(project.getManageUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getManageUserId())) {
//                if (payload.getManageUserId().longValue() != project.getManageUserId().longValue()) {
//                    addIds.add(payload.getManageUserId());
//                    deleteIds.add(project.getManageUserId());
//                    updateUserIds.add(payload.getManageUserId());
//                }
//            } else {
//                addIds.add(payload.getManageUserId());
//                updateUserIds.add(payload.getManageUserId());
//            }
//        }
//
//        if (ObjectUtils.isEmpty(payload.getPreSaleUserId())) {
//            if (!ObjectUtils.isEmpty(project.getPreSaleUserId())) {
//                deleteIds.add(project.getPreSaleUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getPreSaleUserId())) {
//                if (payload.getPreSaleUserId().longValue() != project.getPreSaleUserId().longValue()) {
//                    addIds.add(payload.getPreSaleUserId());
//                    deleteIds.add(project.getPreSaleUserId());
//                    updateUserIds.add(payload.getPreSaleUserId());
//                }
//            } else {
//                addIds.add(payload.getPreSaleUserId());
//                updateUserIds.add(payload.getPreSaleUserId());
//            }
//        }
//
//        if (ObjectUtils.isEmpty(payload.getDeliUserId())) {
//            if (!ObjectUtils.isEmpty(project.getDeliUserId())) {
//                deleteIds.add(project.getDeliUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getDeliUserId())) {
//                if (payload.getDeliUserId().longValue() != project.getDeliUserId().longValue()) {
//                    addIds.add(payload.getDeliUserId());
//                    deleteIds.add(project.getDeliUserId());
//                    updateUserIds.add(payload.getDeliUserId());
//                }
//            } else {
//                addIds.add(payload.getDeliUserId());
//                updateUserIds.add(payload.getDeliUserId());
//            }
//        }
//
//        if (ObjectUtils.isEmpty(payload.getCoUserId())) {
//            if (!ObjectUtils.isEmpty(project.getCoUserId())) {
//                deleteIds.add(project.getCoUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getCoUserId())) {
//                if (payload.getCoUserId().longValue() != project.getCoUserId().longValue()) {
//                    addIds.add(payload.getCoUserId());
//                    deleteIds.add(project.getCoUserId());
//                    updateUserIds.add(payload.getCoUserId());
//                }
//            } else {
//                addIds.add(payload.getCoUserId());
//                updateUserIds.add(payload.getCoUserId());
//            }
//        }
//
//        if (ObjectUtils.isEmpty(payload.getCodeliUserId())) {
//            if (!ObjectUtils.isEmpty(project.getCodeliUserId())) {
//                deleteIds.add(project.getCodeliUserId());
//            }
//        } else {
//
//            if (!ObjectUtils.isEmpty(project.getCodeliUserId())) {
//                if (payload.getCodeliUserId().longValue() != project.getCodeliUserId().longValue()) {
//                    addIds.add(payload.getCodeliUserId());
//                    deleteIds.add(project.getCodeliUserId());
//                    updateUserIds.add(payload.getCodeliUserId());
//                }
//            } else {
//                addIds.add(payload.getCodeliUserId());
//                updateUserIds.add(payload.getCodeliUserId());
//            }
//        }

//        return updateUserIds;
    }

    /**
     * 为数值赋值
     *
     * @param employeeMap
     * @param orgMap
     * @param vo
     */
    void transferOpportunityDatas(Map<Long, String> employeeMap, Map<Long, String> orgMap, Map<Long, String> bookMap, CrmOpportunityVO vo) {
        vo.setManageUserName(employeeMap.get(vo.getManageUserId()));
        vo.setPreSaleUserName(employeeMap.get(vo.getPreSaleUserId()));
        vo.setDeliUserName(employeeMap.get(vo.getDeliUserId()));
        vo.setCoUserName(employeeMap.get(vo.getCoUserId()));
        vo.setCodeliUserName(employeeMap.get(vo.getCodeliUserId()));
        vo.setInternalUserName(employeeMap.get(vo.getInternalUserId()));
        vo.setCreateUserName(employeeMap.get(vo.getCreateUserId()));

        vo.setOrgName(orgMap.get(vo.getOrgId()));
        vo.setPreSaleOrgName(orgMap.get(vo.getPreSaleOrgId()));
        vo.setDeliOrgName(orgMap.get(vo.getDeliOrgId()));
        vo.setCoOrgName(orgMap.get(vo.getCoOrgId()));
        vo.setCodeliOrgName(orgMap.get(vo.getCodeliOrgId()));
        vo.setInternalOrgName(orgMap.get(vo.getInternalOrgId()));
        if (vo.getIsOldCust() == 0 && !ObjectUtils.isEmpty(vo.getCustBookId())) {
            vo.setCustBookName(bookMap.get(vo.getCustBookId()));
        }
        if (vo.getIsNeedPartner() == 0 && !ObjectUtils.isEmpty(vo.getCoopBookId())) {
            vo.setCoopBookName(bookMap.get(vo.getCoopBookId()));
        }
    }

    /**
     * 获取所有相关用户id和组织id
     *
     * @param userIds
     * @param orgIds
     * @param vo
     */
    void getIdDatas(Set<Long> userIds, Set<Long> orgIds, Set<Long> bookIds, CrmOpportunityVO vo) {
        Set<Long> users = new HashSet<>();
        users.add(vo.getManageUserId());
        users.add(vo.getPreSaleUserId());
        users.add(vo.getDeliUserId());
        users.add(vo.getCoUserId());
        users.add(vo.getCodeliUserId());
        users.add(vo.getInternalUserId());
        users.add(vo.getCreateUserId());
        userIds.addAll(users);

        Set<Long> orgs = new HashSet<>();
        orgs.add(vo.getOrgId());
        orgs.add(vo.getPreSaleOrgId());
        orgs.add(vo.getDeliOrgId());
        orgs.add(vo.getCoOrgId());
        orgs.add(vo.getCodeliOrgId());
        orgs.add(vo.getInternalOrgId());
        orgIds.addAll(orgs);

        Set<Long> books = new HashSet<>();
        if (vo.getIsOldCust() == 0 && !ObjectUtils.isEmpty(vo.getCustBookId())) {
            books.add(vo.getCustBookId());
        }
        if (vo.getIsNeedPartner() == 0 && !ObjectUtils.isEmpty(vo.getCoopBookId())) {
            books.add(vo.getCoopBookId());
        }
        bookIds.addAll(books);
    }


    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferSystemSelection(CrmOpportunityVO vo) {
        vo.setProjectStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getProjectStatus()));
        vo.setCustRegionName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustRegion.getCode(), vo.getCustRegion()));
        vo.setCustPropName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustProp.getCode(), vo.getCustProp()));
        vo.setCustIdstName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCustIdst()));
        vo.setProbabilityName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmProbability.getCode(), vo.getProbability()));
        vo.setCurrCodeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrCode()));
        vo.setSalePhaseName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmSalePhase.getCode(), vo.getSalePhase()));
        vo.setOppoLevelName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLevel.getCode(), vo.getOppoLevel()));
        vo.setProjectDifficultName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoDifficult.getCode(), vo.getProjectDifficult()));
        vo.setProjectImportanceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoImportance.getCode(), vo.getProjectImportance()));
        vo.setSolutionDifficultyName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoDifficult.getCode(), vo.getSolutionDifficulty()));
        vo.setSolutionImportanceName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoImportance.getCode(), vo.getSolutionImportance()));
        vo.setLoseReasonName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLoseReson.getCode(), vo.getLoseReason()));
        vo.setCloseReasonName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoCloseReson.getCode(), vo.getCloseReason()));
//        vo.setCloseReasonName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoCloseReson.getCode(), vo.getSourceType()));
    }


    @Override
    public void downloadBatch(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        if (query.getProjectStatusType() == null) {
            query.setProjectStatusType("0");
        }

        //定义文件名称
        String sheetName = "商机数据";
        PagingVO<CrmOpportunityVO> paging = paging(query);
        List<CrmOpportunityVO> records = paging.getRecords();
        int order = 1;
        for (CrmOpportunityVO record : records) {
            record.setOrder(String.valueOf(order));
            record.setForecastWinDateStr(String.valueOf(record.getForecastWinDate()));
            Integer isNeedPartner = record.getIsNeedPartner();
            String isNeedPartnerStr = isNeedPartner == null ? "否" : isNeedPartner == 0 ? "是" : "否";
            record.setIsNeedPartnerStr(isNeedPartnerStr);
            record.setSourceType(record.getSourceType() == null ? null : record.getSourceType().equals("inside") ? "内部" : "外部");

            List<PrjProjectMemberVO> memberVOS = record.getMemberVOS();
            if (memberVOS != null && !memberVOS.isEmpty()) {
                List<String> collect = memberVOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList());
                String members = String.join(",", collect);
                record.setMembers(members);
            }
            order++;
        }
        List<CrmOpportunityExcelExport> resultList = CrmOpportunityConvert.INSTANCE.voListVoExcelExport(records);
        resultList = udcUtil.translateList(resultList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmOpportunityExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, CrmOpportunityExcelExport.class, null);
        //写入
        sheet.doWrite(resultList);

//        ClassPathResource classPathResource = new ClassPathResource("template/crmOpportunityBatch.xlsx");
//        PagingVO<CrmOpportunityVO> paging = paging(query);
//        List<CrmOpportunityVO> records = paging.getRecords();
//        InputStream inputStream = null;
//        try {
//            inputStream = new BufferedInputStream(classPathResource.getInputStream());
//            Workbook workbook = XSSFWorkbookFactory.create(inputStream);
//            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("商机数据");
//            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
//                int nextRow = 1;
//                for (CrmOpportunityVO dataPayload : records) {
//                    Row row = batchProjectSheet.createRow(nextRow);
//                    excelUtil.setCellValue(row, 0, nextRow); // 序号
//                    excelUtil.setCellValue(row, 1, dataPayload.getProjectName());// 项目名称
//                    excelUtil.setCellValue(row, 2, dataPayload.getProjectNo());// 项目编号
//                    excelUtil.setCellValue(row, 3, dataPayload.getManageUserName());// 签单负责人
//                    excelUtil.setCellValue(row, 4, dataPayload.getOrgName());// 签单bu
//                    excelUtil.setCellValue(row, 5, dataPayload.getProjectStatusName());// 项目状态
//
//                    excelUtil.setCellValue(row, 6, dataPayload.getCloseReasonName());// 关闭原因
//                    excelUtil.setCellValue(row, 7, dataPayload.getClsoeRemark());// 关闭备注
//                    excelUtil.setCellValue(row, 8, dataPayload.getLoseReasonName());// 丢单原因
//                    excelUtil.setCellValue(row, 9, dataPayload.getLeadsName());// 线索名称
//                    excelUtil.setCellValue(row, 10, dataPayload.getSaleProduct());// 销售产品
//                    excelUtil.setCellValue(row, 11, dataPayload.getCustRegionName());// 客户区域
//                    Integer isOldCust = dataPayload.getIsOldCust();
//                    String isOldCUstStr = isOldCust == null ? "否" : isOldCust == 0 ? "是" : "否";
//                    excelUtil.setCellValue(row, 12, isOldCUstStr);// 是否老客户
//                    excelUtil.setCellValue(row, 13, dataPayload.getCustBookName());// 客户名称
//                    excelUtil.setCellValue(row, 14, dataPayload.getCustProject());// 客户项目
//
//                    excelUtil.setCellValue(row, 15, dataPayload.getContactName());// 客户联系人
//                    excelUtil.setCellValue(row, 16, dataPayload.getContactDept());// 客户联系人部门
//                    excelUtil.setCellValue(row, 17, dataPayload.getContactPosition());// 客户联系人岗位
//                    excelUtil.setCellValue(row, 18, dataPayload.getContactWebsite());// 企业主页
//                    excelUtil.setCellValue(row, 19, dataPayload.getCustPropName());//客户性质
//                    excelUtil.setCellValue(row, 20, dataPayload.getCustIdstName());//客户行业
//                    excelUtil.setCellValue(row, 21, dataPayload.getForecastWinDate());// 预计成单日期
//                    excelUtil.setCellValue(row, 22, dataPayload.getForecastAmount());// 预计签单金额
//                    excelUtil.setCellValue(row, 23, dataPayload.getProbabilityName());// 成单概率
//                    excelUtil.setCellValue(row, 24, dataPayload.getCurrCodeName());//币种
//                    excelUtil.setCellValue(row, 25, dataPayload.getSalePhaseName());//销售阶段
//                    excelUtil.setCellValue(row, 26, dataPayload.getDeliveryAddress());// 交付地点
//                    excelUtil.setCellValue(row, 27, dataPayload.getOppoLevelName());// 商机级别
//                    Integer isNeedPartner = dataPayload.getIsNeedPartner();
//                    String isNeedPartnerStr = isNeedPartner == null ? "否" : isNeedPartner == 0 ? "是" : "否";
//                    excelUtil.setCellValue(row, 28, isNeedPartnerStr);// 是否需要合作伙伴
//                    excelUtil.setCellValue(row, 29, dataPayload.getCoopBookName());// 关联合作伙伴名称
//                    excelUtil.setCellValue(row, 30, dataPayload.getPartnerDesc());// 合作伙伴描述
//                    excelUtil.setCellValue(row, 31, dataPayload.getPreSaleOrgName());//售前bu
//                    excelUtil.setCellValue(row, 32, dataPayload.getPreSaleUserName());// 售前负责人
//                    excelUtil.setCellValue(row, 33, dataPayload.getProjectDifficultName());// 项目难度
//                    excelUtil.setCellValue(row, 34, dataPayload.getProjectImportanceName());// 项目重要度
//                    excelUtil.setCellValue(row, 35, dataPayload.getDeliOrgName());// 交付bu
//                    excelUtil.setCellValue(row, 36, dataPayload.getDeliUserName());// 交付负责人
//                    excelUtil.setCellValue(row, 37, dataPayload.getSolutionDifficultyName());// 方案难度
//                    excelUtil.setCellValue(row, 38, dataPayload.getSolutionImportanceName());// 方案重要度
//                    excelUtil.setCellValue(row, 39, dataPayload.getCoOrgName());// 合作(副)签单BU
//                    excelUtil.setCellValue(row, 40, dataPayload.getCoUserName());// 合作(副)签单负责人
//                    excelUtil.setCellValue(row, 41, dataPayload.getCodeliOrgName());// 合作(副)交付BU
//                    excelUtil.setCellValue(row, 42, dataPayload.getCodeliUserName());// 合作(副)交付负责人
//                    excelUtil.setCellValue(row, 43, dataPayload.getSourceType() == null ? null : dataPayload.getSourceType().equals("inside") ? "内部" : "外部");// 来源类型
//                    excelUtil.setCellValue(row, 44, dataPayload.getInternalOrgName());// 内部来源BU
//                    excelUtil.setCellValue(row, 45, dataPayload.getInternalUserName());// 内部来源人
//                    excelUtil.setCellValue(row, 46, dataPayload.getExternalIden());// 外部线索来源
//                    excelUtil.setCellValue(row, 47, dataPayload.getExternalName());// 外部来源人
//                    excelUtil.setCellValue(row, 48, dataPayload.getExternalPhone());// 外部来源电话
//                    excelUtil.setCellValue(row, 49, dataPayload.getProfitDesc());// 利益承诺
//                    List<PrjProjectMemberVO> memberVOS = dataPayload.getMemberVOS();
//                    if (memberVOS != null && !memberVOS.isEmpty()) {
//                        List<String> collect = memberVOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList());
//                        String members = String.join(",", collect);
//                        excelUtil.setCellValue(row, 50, members);// 团队成员
//                    }
//                    excelUtil.setCellValue(row, 51, dataPayload.getExtString1());// 扩展字段1
//                    excelUtil.setCellValue(row, 52, dataPayload.getExtString2());// 扩展字段2
//                    excelUtil.setCellValue(row, 53, dataPayload.getExtString3());// 扩展字段3
//                    excelUtil.setCellValue(row, 54, dataPayload.getExtString4());// 扩展字段4
//                    excelUtil.setCellValue(row, 55, dataPayload.getExtString5());// 扩展字段5
//                    excelUtil.setCellValue(row, 56, dataPayload.getFileCodes());// 附件地址
//                    nextRow++;
//                }
//            }
//            String fileName = "商机数据-" + LocalDate.now();
//            ExcelUtil.writeResponse(response, fileName, workbook);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }finally {
//            if(inputStream !=null){
//                try {
//                    inputStream.close();
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public Map<String, Object> bindCustomer(Long id) {
        Boolean isNewCust = false;
        CrmOpportunityVO crmOpportunityVO = dao.queryByKey(id);
        String customerName = crmOpportunityVO.getCustBookName();
        Long custBookId = crmOpportunityVO.getCustBookId();
        Integer isOldCust = crmOpportunityVO.getIsOldCust();
        //用客户名称匹配当前客户是否存在
        int num = crmCustomerDAO.countByName(customerName);
        CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
        opportunityPayload.setId(id);
        if (num > 0 || isOldCust == 0) {
            List<CrmCustomerDO> customerDOS = crmCustomerDAO.findByName(customerName);
            if (num > 0) {
                opportunityPayload.setFormalCustomerId(customerDOS.get(0).getId());
            } else {
                //通过bookId查询客户地址簿信息
//                PrdAbVO prdAbVO = abDAO.queryCompanyByBookId(custBookId);
                Long customerId = crmCustomerDAO.queryIdByBookId(custBookId);
                opportunityPayload.setFormalCustomerId(customerId);
            }
        } else {
            CrmCustomerPayload customerPayload = new CrmCustomerPayload();
            customerPayload.setCustomerName(customerName);
            customerPayload.setCompanyIndustry(crmOpportunityVO.getCustIdst());
            customerPayload.setCompanyPhone(crmOpportunityVO.getContactPhone());
            customerPayload.setCustomerStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
            //根据当前的线索信息创建客户
            try {
                CrmCustomerVO insert = customerService.insert(customerPayload);
                opportunityPayload.setFormalCustomerId(insert.getId());
            } catch (Exception e) {
                e.printStackTrace();
            }
            isNewCust = true;
        }
        if (opportunityPayload.getFormalCustomerId() != null) {
            dao.updateByKeyDynamic(opportunityPayload);
        }
        Map<String, Object> result = new HashMap<>();
        result.put("isNewCust", isNewCust);
        return result;
    }


    @Override
    public Map<String, Object> bindCustomers() {
        //查询所有未绑定客户的商机
        List<Long> notBindOppos = dao.findNotBindOppos();
        int i = 0;
        for (Long notBindOppo : notBindOppos) {
            i++;
            if (i > 1000) {
                break;
            }
            bindCustomer(notBindOppo);
        }
        List<Long> notBindOppos1 = dao.findNotBindOppos();
        Map<String, Object> map = new HashMap<>();
        map.put("restNum", notBindOppos1 == null ? 0 : notBindOppos1.size());
        return new HashMap<>();
    }

    @Override
    public Long getIdByV4(Long oppoIdV4) {
        return dao.getIdByV4(oppoIdV4);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public String yeedocGetUri(Long id) {
        CrmOpportunityVO opportunityVO = dao.queryByKey(id);
        Assert.notNull(opportunityVO.getId(), "商机不存在！");
        // 已经在易稻壳创建过文件夹的情况下，只需获取易稻壳链接
        final String itemIdDb = opportunityVO.getItemId();
        if (StringUtils.hasText(itemIdDb)) {
            final String preViewItemStr = yeedocService.preViewItem(itemIdDb);
            if (org.apache.commons.lang3.StringUtils.isEmpty(preViewItemStr)) {
                log.error("易道壳返回链接为空,docItemId:{}", itemIdDb);
                throw TwException.error("", "易道壳返回链接为空！");
            }
            JSONObject resultJson = JSONObject.parseObject(preViewItemStr);
            Object data = resultJson.get("value");
            if (ObjectUtils.isEmpty(data)) {
                throw TwException.error("", "易道壳返回链接为空！");
            }
            String prewUri = (String) data;
            return prewUri;
        }
        // 文件夹名称 = 商机名称 + 商机编号
        String folderName = opportunityVO.getProjectName() + "+" + opportunityVO.getProjectNo();
        // 没有创建过的情况下  1、创建文件夹；2、赋权；3、c取链接；4、存储itemId到商机主数据
        //1、创建文件夹
        List<String> pathArr = new ArrayList<>();
        pathArr.add("/" + folderName);
        CreateFolderDTO createFolderDTO = CreateFolderDTO.builder()
                .libraryId(yeedocProperties.getOppoFolder().getLibraryId())
                .itemId(yeedocProperties.getOppoFolder().getItemId())
                .permissionLevel(yeedocProperties.getOppoFolder().getPermissionLevel())
                .pathArry(pathArr)
                .isInheritance(false)
                .build();
        String resultStr = yeedocService.createFolder(createFolderDTO);
        if (org.apache.commons.lang3.StringUtils.isEmpty(resultStr)) {
            throw TwException.error("", "易道壳返回为空！");
        }
        // 解析itemId
        String itemId = getItemId(resultStr);
        if (!StringUtils.hasText(itemId)) {
            throw TwException.error("", "易道壳创建文件夹失败！");
        }

        // 易道壳赋权
        String permissionsStr = yeedocService.setPermission(itemId, yeedocProperties.getOppoFolder().getPermissionLevel());
        if (org.apache.commons.lang3.StringUtils.isEmpty(permissionsStr)) {
            log.error("易道壳赋权失败! permissionsStr:{} ;docItemId:{}", permissionsStr, itemId);
            throw TwException.error("", "易道壳赋权失败！");
        }
        if ((int) JSONObject.parseObject(permissionsStr).get("statusCode") != 200) {
            log.error("易道壳赋权失败! permissionsStr:{} ;docItemId:{}", permissionsStr, itemId);
            throw TwException.error("", "易道壳赋权失败！");
        }

        // 易道壳返回链接
        String preViewItemStr = yeedocService.preViewItem(itemId);
        if (org.apache.commons.lang3.StringUtils.isEmpty(preViewItemStr)) {
            log.error("易道壳返回链接为空,docItemId:{}", itemId);
            throw TwException.error("", "易道壳返回链接为空！");
        }
        JSONObject resultJson = JSONObject.parseObject(preViewItemStr);
        Object data = resultJson.get("value");
        if (ObjectUtils.isEmpty(data)) {
            throw TwException.error("", "易道壳返回链接为空！");
        }
        String prewUri = (String) data;

        // 存储itemId到商机
        CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
        opportunityPayload.setId(opportunityVO.getId());
        opportunityPayload.setItemId(itemId);
        dao.updateByKeyDynamic(opportunityPayload);
        return prewUri;
    }

    private String getItemId(String resultStr) {
        Object data = null;
        try {
            JSONObject resultJson = JSONObject.parseObject(resultStr);
            data = resultJson.get("data");
        } catch (Exception e) {
            log.error("易道壳创建文件夹失败!resultStr = {" + resultStr + "}", e);
        }
        if (ObjectUtils.isEmpty(data)) {
            throw TwException.error("", "易道壳创建文件夹失败！");
        }
        JSONArray arrayDate = JSONArray.parseArray(data.toString());
        String itemId = "";
        for (int i = 0; i < arrayDate.size(); i++) {
            JSONObject jsonObject = JSONObject.parseObject(arrayDate.get(i).toString());
            // 取最后一级目录
            itemId = (String) jsonObject.get("itemId");
        }
        return itemId;
    }


    @Override
    public void deleteSoft(Long id) {
        dao.deleteSoft(id);
    }

    @Override
    public Map<Long, Long> getV4AndV5OppoIds() {
        Map<Long, Long> oppoMap = new HashMap<>();
        //查询用户列表
        List<Map<String, Object>> v4AndV5OppoIds = dao.getV4AndV5OppoIds();
        for (Map<String, Object> v4AndV5OppoId : v4AndV5OppoIds) {
            Long oppoId = (Long) v4AndV5OppoId.get("oppoId");
            Long oppoIdV4 = (Long) v4AndV5OppoId.get("oppoIdV4");
            oppoMap.put(oppoIdV4, oppoId);
        }
        return oppoMap;
    }

    @Override
    public List<CrmActProjectVO> queryListByCustomId(Long customId){
        return dao.queryListByCustomId(customId);
    }

}
