package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityStakeholderPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityStakeholderService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityStakeholderVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityStakeholderConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityStakeholderDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityStakeholderDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description 商机干系人管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityStakeholderServiceImpl implements CrmOpportunityStakeholderService {
    private final CacheUtil cacheUtil;
    private final CrmOpportunityStakeholderDAO dao;
    private final CrmOpportunityDAO opportunityDAO;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;

    @Value("${tw4.opportunity.stakeholder_operation}")
    private String stakeholder_operation;

    @Value("${tw4.opportunity.stakeholder_del}")
    private String stakeholder_del;

    @Transactional
    @Override
    public CrmOpportunityStakeholderVO insert(CrmOpportunityStakeholderPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getShsIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getShsIdV4()));
        }
        //同步到4.0
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //String result = httpUtil.sendSyncPost(stakeholder_operation, map);
        //String stakeholderId = httpUtil.geResultData(result);
        //long stakeholderIdV4 = 0;
        //if (StringUtils.hasText(stakeholderId)) {
        //    if (StringUtil.isInteger(stakeholderId)) {
        //        stakeholderIdV4 = Long.valueOf(stakeholderId);
        //    }
        //}
        CrmOpportunityStakeholderDO ado = CrmOpportunityStakeholderConvert.INSTANCE.toDo(payload);
        //ado.setStakeholderIdV4(stakeholderIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "干系人");
        return CrmOpportunityStakeholderConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(CrmOpportunityStakeholderPayload payload) {
        if(payload.getOppoIdV4()!=null){
            payload.setOppoId(opportunityDAO.getIdByV4(payload.getOppoIdV4()));
        }
        if(payload.getShsIdV4()!=null){
            payload.setId(dao.getIdByV4(payload.getShsIdV4()));
        }
        //同步到4.0
        //Long stakeholderIdV4 = dao.queryTW4IdById(payload.getId());
        //Map<String, Object> map = transferUtilService.beanToMap(payload);
        //map.put("id", stakeholderIdV4);
        //String result = httpUtil.sendSyncPost(stakeholder_operation, map);
        //httpUtil.geResultData(result);
        CrmOpportunityStakeholderDO ado = CrmOpportunityStakeholderConvert.INSTANCE.toDo(payload);
        //ado.setStakeholderIdV4(stakeholderIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "干系人");
        return 0L;
    }

    @Override
    public List<CrmOpportunityStakeholderVO> queryList(Long oppoId) {
        List<CrmOpportunityStakeholderVO> stakeholderVOS = dao.queryList(oppoId);
        stakeholderVOS.forEach(stakeholderVO -> transferSystemSelection(stakeholderVO));
        return stakeholderVOS;
    }

    @Transactional
    @Override
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        //同步到4.0
        //Map<String, Object> map = new HashMap<>();
        //map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
        //String result = httpUtil.sendSyncGet(stakeholder_del, map);
        //httpUtil.geResultData(result);
        dao.deleteSoft(keys);
        logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "干系人");
        return true;
    }

    /**
     * 全局翻译
     *
     * @param vo
     */
    void transferSystemSelection(CrmOpportunityStakeholderVO vo) {
        vo.setRoleTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoRoleType.getCode(), vo.getRoleType()));
        vo.setStandpointName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoStandpoint.getCode(), vo.getStandpoint()));

    }
}
