package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleEducatePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleEducateService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleEducateVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmPeopleEducateConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleEducateDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPeopleEducateDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleEducateRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 人脉-教育经历
 *
 * @author carl
 * @date 2022/12/07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmPeopleEducateServiceImpl implements CrmPeopleEducateService {

    private final CrmPeopleEducateRepo repo;
    private final CrmPeopleEducateDAO dao;

    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CrmPeopleEducateVO insertOrUpdate(CrmPeopleEducatePayload payload) {
        check(payload);
        CrmPeopleEducateDO entityDo = CrmPeopleEducateConvert.INSTANCE.toDo(payload);
        String name = PrdSystemLogEnum.UPDATE.getDesc();
        if (ObjectUtils.isEmpty(payload.getId())) {
            name = PrdSystemLogEnum.CREATE.getDesc();
        }
        entityDo = repo.save(entityDo);
        logService.saveNewLog(entityDo.getPeopleId(),
                PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(),
                name + PrdSystemObjectEnum.CRM_PEOPLE_EDUCATE.getDesc());
        return CrmPeopleEducateConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    public CrmPeopleEducateVO queryByKey(Long key) {
        CrmPeopleEducateVO educateVO = dao.queryByKey(key);
        transferData(educateVO);
        return educateVO;
    }

    @Override
    public List<CrmPeopleEducateVO> queryList(Long peopleId) {
        List<CrmPeopleEducateVO> peopleEducateVOS = dao.queryList(peopleId);
        peopleEducateVOS.forEach(peopleEducate -> transferData(peopleEducate));
        return peopleEducateVOS;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteSoft(List<Long> keys) {
        CrmPeopleEducateVO educateVO = dao.queryByKey(keys.get(0));
        logService.saveNewLog(educateVO.getPeopleId(),
                PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(),
                PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CRM_PEOPLE_EDUCATE.getDesc());
        dao.deleteSoft(keys);


    }

    /**
     * 核验工作经历数据
     *
     * @param payload
     */
    void check(CrmPeopleEducatePayload payload) {
        if (ObjectUtils.isEmpty(payload.getPeopleId())) {
            throw TwException.error("", "关联人脉不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getSchool())) {
            throw TwException.error("", "学校不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getEducation())) {
            throw TwException.error("", "学历不能为空，请核验！");
        }
//        if (ObjectUtils.isEmpty(payload.getMajor())) {
//            throw TwException.error("", "专业不能为空，请核验！");
//        }
        if (ObjectUtils.isEmpty(payload.getStartDate())) {
            throw TwException.error("", "起始时间不能为空，请核验！");
        }
    }

    /**
     * 数据翻译
     *
     * @param educateVO
     */
    void transferData(CrmPeopleEducateVO educateVO) {

        educateVO.setEducationDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPeopleEducate.getCode(), educateVO.getEducation()));

    }
}
