package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleWorkPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.*;
import com.elitesland.tw.tw5.api.prd.crm.vo.*;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleWorkService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.BusinessFollowServiceImpl;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.DataUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmPeopleConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOperationPlanDetailConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleWorkDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPeopleDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanDetailRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleRepo;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人脉
 *
 * @author carl
 * @date 2022/11/21
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmPeopleServiceImpl implements CrmPeopleService {
    private final CrmCustomerService customerService;
    private final CrmLeadsService leadsService;
    private final BusinessFollowServiceImpl globalUtilService;
    private final CrmPeopleRepo repo;
    private final CrmCustomerOperationRepo repoCustomerOperation;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CrmPeopleDAO dao;
    private final CrmPeopleWorkDAO peopleWorkDAO;
    private final CrmCustomerOperationDAO customerOperationDAO;
    private final CrmPeopleWorkService workService;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final CrmOperationPlanDetailRepo repoOperationPlanDetail;
    private final TransactionUtilService transactionUtilService;
    private final ExcelUtil excelUtil;
    private final PrdUserDAO daoUser;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;

    @Transactional(rollbackFor = Exception.class)
    @Override

    public CrmPeopleVO insertOrUpdate(CrmPeoplePayload payload) {
        // 校验
        check(payload);
        CrmPeopleDO entityDo = CrmPeopleConvert.INSTANCE.toDo(payload);
        String name = PrdSystemLogEnum.UPDATE.getDesc();
        if (ObjectUtils.isEmpty(payload.getId())) {
            name = PrdSystemLogEnum.CREATE.getDesc();
            entityDo.setLoveLevel(0);
            entityDo.setPeopleStatus(SystemDefaultEnum.DefaultHrStatus.getCode());
            entityDo = repo.save(entityDo);
            // 新建日志
            final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entityDo);
            logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(), fieldsCreateLog);
            // 创建工作经历
            savePeople(entityDo);
        } else {
            CrmPeopleDO peopleDO = dao.findByIdAndDeleteFlag(payload.getId());
            if (!ObjectUtils.isEmpty(peopleDO)) {
                CrmPeopleDO entityLog = new CrmPeopleDO();
                BeanUtils.copyProperties(peopleDO, entityLog);
                peopleDO.copy(entityDo);
                // 修改NULL值特殊处理
                final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, peopleDO);

                repo.save(peopleDO);
                //获取变更日志
                fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
                if (StringUtils.hasText(fieldsUpdateLog)) {
                    logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(), fieldsUpdateLog.toString());
                }
            } else {
                throw TwException.error("", "更新数据不存在，请核验！");
            }
        }
        //判断是否是客户经营添加的人脉
        if (!ObjectUtils.isEmpty(payload.getOperId())) {
            logService.saveNewLog(entityDo.getOperId(),
                    PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(),
                    name + PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getDesc());
        }


        return CrmPeopleConvert.INSTANCE.toVo(entityDo);
    }


    @Override
    public CrmPeopleVO queryByKey(Long key) {
        CrmPeopleVO crmPeopleVO = dao.queryByKey(key);
        //翻译数据
        transferData(crmPeopleVO);
        return crmPeopleVO;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateLoveLevel(Long key, Integer level) {
        if (level > 5) {
            throw TwException.error("", "提交数据错误，请核验！");
        }
        long loveLevel = dao.updateLoveLevel(key, level);
        if (loveLevel == 0) {
            throw TwException.error("", "提交数据错误，请核验！");
        }
    }

    @Override
    public List<CrmPeopleVO> queryList(Long operId) {
//        if (ObjectUtils.isEmpty(operId)) {
//            throw TwException.error("", "operId不能为空，请核验！");
//        }

        CrmCustomerOperationDO entity = repoCustomerOperation.findById(operId).orElseGet(CrmCustomerOperationDO::new);
        Assert.notNull(entity.getId(), "不存在");

        List<CrmPeopleVO> peopleVOS = dao.queryList(operId, entity.getCustomerId());
        peopleVOS.forEach(peopleVO -> transferData(peopleVO));
        return peopleVOS;
    }

    @Override
    public PagingVO<CrmPeopleVO> paging(CrmPeopleQuery query) {
        if (!ObjectUtils.isEmpty(query.getOperId())) {
            CrmCustomerOperationDO entity = repoCustomerOperation.findById(query.getOperId()).orElseGet(CrmCustomerOperationDO::new);
            Assert.notNull(entity.getId(), "不存在");
            query.setCustomerId(entity.getCustomerId());
        }
        Boolean rolePermission = false;
        if (ObjectUtils.isEmpty(query.getOperId()) && ObjectUtils.isEmpty(query.getCustomerId())) {
            rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
            if (!rolePermission) {
                //赋值拥有权限的客户经营id和客户id
                updateQuery(query);
            }
        } else {
            rolePermission = true;
        }
        query.setNoPermissionFlag(rolePermission);
        PagingVO<CrmPeopleVO> paging = dao.paging(query);
        paging.getRecords().forEach(peopleVO -> transferData(peopleVO));
        return paging;
    }

    @Override
    public List<Long>   queryPermitOperationIds(Long userId) {
        //客户经营权限获取
        //查出来userId的所有下级userId
        final List<PrdOrgEmployeeRefVO> empRef = daoUser.queryLowListByKey(null, userId);
        final Set<Long> empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
        // 组织的组织负责人是当前登录人的 组织集合结果
        final List<PrdOrgOrganizationDO> organizationDOList = prdOrgOrganizationDAO.queryByManagerId(userId);
        Set<Long> orgIdList = null;
        if (!CollectionUtils.isEmpty(organizationDOList)) {
            orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
        }
        //获取拥有权限的客户经营id
        return dao.queryOperationIds(userId, empRefUserIdList, orgIdList);
    }

    /**
     * 赋值拥有权限的客户经营id和客户id
     *
     * @param query
     */
    void updateQuery(CrmPeopleQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        //获取拥有权限的客户经营id
        List<Long> operationIds = queryPermitOperationIds(userId);
        //客户相关权限获取
        CrmCustomerQuery queryCustomer = new CrmCustomerQuery();
        //权限封装
        customerService.operPermissionFlag(queryCustomer);
        //获取拥有权限的客户id
        List<Long> customerIds = dao.queryCustomerIds(queryCustomer);
        operationIds.removeAll(Collections.singleton(null));
        Set<Long> longs = repo.queryByOperIds(operationIds);
        longs.removeAll(Collections.singleton(null));
        longs.addAll(customerIds);
        query.setOperIds(operationIds);
        query.setCustomerIds(new ArrayList<>(longs));
        query.setCreateUserId(userId);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteSoft(List<Long> keys, String type) {
        // 记录日志
        if (!keys.isEmpty()) {
            Long sourceId = null;
            String title = "";
            Optional<CrmPeopleDO> optional = repo.findById(keys.get(0));
            if (!optional.isEmpty()) {
                CrmPeopleDO entity = optional.get();
                if (!ObjectUtils.isEmpty(entity.getCustomerId())) {
                    sourceId = entity.getCustomerId();
                    title = PrdSystemObjectEnum.Customer.getCode();
                }
                if (!ObjectUtils.isEmpty(entity.getOperId())) {
                    sourceId = entity.getOperId();
                    title = PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode();
                }
            }
            if (StringUtils.hasText(type) && "1".equals(type)) {
                //表示是从客户或客户经营删除的，仅删除关系
                dao.removeAllByIdIn(keys);
                //把人脉当前工作变成离职
                peopleWorkDAO.updateWorkStatusByPeopleIds(keys);
            } else {
                dao.deleteByIdIn(keys);
            }
            if (sourceId != null) {
                logService.saveNewLog(sourceId, title, PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getDesc());
            }

        }
    }

    @Override
    public void deleteSoftByOperIds(List<Long> operIds) {
        List<CrmPeopleVO> crmPeopleVOS = dao.queryListByOperIds(operIds);
        if (crmPeopleVOS.size() > 0) {
            //需要结束工作的
            List<Long> delIds = new ArrayList<>();
            //仅去除客户经营关系
            List<Long> removeIds = new ArrayList<>();
            for (CrmPeopleVO crmPeopleVO : crmPeopleVOS) {
                if (crmPeopleVO.getCustomerId() != null) {
                    removeIds.add(crmPeopleVO.getId());
                } else {
                    delIds.add(crmPeopleVO.getId());
                }
            }
            if (removeIds.size() > 0) {
                //仅删除人脉与客户经营关系
                dao.removeOperByIdIn(removeIds);
            }
            if (delIds.size() > 0) {
                //表示是从客户或客户经营删除的，仅删除关系
                dao.removeAllByIdIn(delIds);
                //把人脉当前工作变成离职
                peopleWorkDAO.updateWorkStatusByPeopleIds(delIds);
            }
        }

    }


    @Override
    public List<CrmPeopleVO> queryRefPeopleList(Long key, String searchStr, String type) {
        CrmPeopleVO crmPeopleVO = dao.queryByKey(key);
        List<CrmPeopleVO> vos = new ArrayList<>();
        //同行人脉
        if ("1".equals(type)) {
            if (StringUtils.hasText(crmPeopleVO.getIndustry())) {
                vos = dao.queryPeopleVOType1(crmPeopleVO.getId(), crmPeopleVO.getIndustry(), searchStr);
            }

        }
        //现在同事
        if ("2".equals(type)) {
            //人脉归属不为空才有现在的同事
            if (crmPeopleVO.getOperId() != null || crmPeopleVO.getCustomerId() != null || StringUtils.hasText(crmPeopleVO.getCompanyName())) {
                vos = dao.queryPeopleVOType2(crmPeopleVO.getId(), crmPeopleVO.getOperId(), crmPeopleVO.getCustomerId(), crmPeopleVO.getCompanyName(), searchStr);
            }
        }
        //过往同事
        if ("3".equals(type)) {
            List<Long> customerIds = new ArrayList<>();
            List<String> companyNames = new ArrayList<>();
            //获取过往公司
            queryOldWork(key, customerIds, companyNames);
            if (customerIds.size() > 0 || companyNames.size() > 0) {
                vos = dao.queryPeopleVOType3(crmPeopleVO.getId(), customerIds, companyNames, searchStr);
            }

        }
        vos.forEach(peopleVO -> transferData(peopleVO));
        return vos;
    }


    @Override
    public List<CrmFollowVO> queryOperateFollowList(Long peopleId) {
        CrmPeopleVO crmPeopleVO = dao.queryByKey(peopleId);
        if (!ObjectUtils.isEmpty(crmPeopleVO.getCustomerId())) {
            List<CrmFollowVO> crmFollowVOS = customerService.queryFollowList(crmPeopleVO.getCustomerId(), true);

            //   List<CrmFollowVO> followVOS = crmFollowVOS.stream().filter(crmFollowVO -> crmFollowVO.getFollowContent().contains(crmPeopleVO.getPeopleName())).collect(Collectors.toList());
            return crmFollowVOS;
        }
        return null;
    }

    @Override
    public void relationCustomer(Long operId, Long customerId) {
        //查询客户经营下的所有人脉主键
        List<Long> peopleIds = dao.findByOperIdAndDeleteFlag(operId);
        //把客户经营下人脉绑定关联客户
        dao.relationCustomer(peopleIds, customerId);
        //把人脉的在职工作岗位换成关联客户
        peopleWorkDAO.updateCustomerIdByPeopleIds(peopleIds, customerId);
    }

    @Override
    public Object queryBusinessFollowPaging(CrmCustomerOperationBusinessQuery query) {
        Object resultData = new Object();
        CrmPeopleVO crmPeopleVO = dao.queryByKey(query.getId());
        //校验数据
        checkeRelation(crmPeopleVO);
        //合同业务往来
        if ("1".equals(query.getBusinessType())) {
            resultData = globalUtilService.queryContractFollow(query, crmPeopleVO.getCustomerId());
        }
        //商机业务往来
        if ("2".equals(query.getBusinessType())) {
            resultData = globalUtilService.queryOppoFollow(query, crmPeopleVO.getCustomerId());
        }
        //线索业务往来
        if ("3".equals(query.getBusinessType())) {
            resultData = globalUtilService.queryLeadsFollow(query, crmPeopleVO.getCustomerId());
        }
        return resultData;
    }

    @Override
    public List<PrdSystemLogVO> queryLogList(Long id) {
        return logService.queryLogList(id, PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode());
    }

    @Override
    public Object queryPeopleView(Long peopleId) {
        CrmPeopleVO crmPeopleVO = dao.queryByKey(peopleId);
        if (crmPeopleVO == null) {
            throw TwException.error("", "数据不存在，请核验！");
        }
        long peopleCount = queryPeopleCount(crmPeopleVO);

        Object contractCount = 0L;
        long opportunityCount = 0;
        long leadsCount = 0;
        if (crmPeopleVO.getCustomerId() != null) {
            CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
            leadsQuery.setFormalCustomerId(crmPeopleVO.getCustomerId());
            leadsQuery.setIsPermission(false);
            PagingVO<CrmLeadsListVO> leadsPagingVO = leadsService.paging(leadsQuery);
            //获取线索数量
            leadsCount = leadsPagingVO.getTotal();
            //获取合同数量
            contractCount = globalUtilService.queryContractNum(crmPeopleVO.getCustomerId());
            //获取商机数量
            opportunityCount = customerOperationDAO.queryOpportunityCount(crmPeopleVO.getCustomerId());
        }
        Map<String, Object> map = new HashMap<>();
        map.put("contractCount", contractCount);
        map.put("leadsCount", leadsCount);
        map.put("opportunityCount", opportunityCount);
        map.put("peopleCount", peopleCount);
        return map;
    }

    @Override
    public List<CrmOperationPlanDetailVO> queryOperationPlanDetailList(Long peopleId) {
        CrmOperationPlanDetailQuery query = new CrmOperationPlanDetailQuery();
        query.setExt1(peopleId + "");
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("createTime");
        query.defaultOrder(orderItem);
        return CrmOperationPlanDetailConvert.INSTANCE.toVoList(repoOperationPlanDetail.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));

    }

    @Override
    public void downloadBatch(HttpServletResponse response, CrmPeopleQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmPeopleBatch.xlsx");
        List<CrmPeopleVO> vos = null;
        if (query.getPeopleIds() != null && query.getPeopleIds().length > 0) {
            vos = dao.queryListByKeys(Arrays.asList(query.getPeopleIds()));
            vos.forEach(peopleVO -> transferData(peopleVO));
        } else {
            vos = paging(query).getRecords();
        }
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("人脉数据");
            if (vos.size() > 0) {
                int nextRow = 1;
                for (CrmPeopleVO dataPayload : vos) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    excelUtil.setCellValue(row, 1, dataPayload.getPeopleName());//
                    excelUtil.setCellValue(row, 2, dataPayload.getCompanyName());//
                    excelUtil.setCellValue(row, 3, dataPayload.getJobs());//
                    excelUtil.setCellValue(row, 4, dataPayload.getSexName());//
                    excelUtil.setCellValue(row, 5, dataPayload.getEmail());//

                    excelUtil.setCellValue(row, 6, dataPayload.getMobile());//
                    excelUtil.setCellValue(row, 7, dataPayload.getWeChat());//
                    excelUtil.setCellValue(row, 8, dataPayload.getBirthplace());//
                    excelUtil.setCellValue(row, 9, dataPayload.getBirthday());//
                    excelUtil.setCellValue(row, 10, dataPayload.getLocationDetail());
                    excelUtil.setCellValue(row, 11, dataPayload.getTags());//
                    excelUtil.setCellValue(row, 12, dataPayload.getSocialIdentity());
                    excelUtil.setCellValue(row, 13, dataPayload.getMarital());
                    excelUtil.setCellValue(row, 14, dataPayload.getBu());

                    excelUtil.setCellValue(row, 15, dataPayload.getJobDetail());
                    excelUtil.setCellValue(row, 16, dataPayload.getIndustryDesc());
                    excelUtil.setCellValue(row, 17, dataPayload.getIndustryInfluence());
                    excelUtil.setCellValue(row, 18, dataPayload.getSpouseJobs());
                    excelUtil.setCellValue(row, 19, dataPayload.getChildAge());
                    excelUtil.setCellValue(row, 20, dataPayload.getParentHealth());
                    excelUtil.setCellValue(row, 21, dataPayload.getParentHabitation());
                    excelUtil.setCellValue(row, 22, dataPayload.getPeopleStatusDesc());
                    excelUtil.setCellValue(row, 23, dataPayload.getCreateTime());
                    nextRow++;
                }
            }
            String fileName = "人脉数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 获取人脉数量
     *
     * @param crmPeopleVO
     * @return
     */
    long queryPeopleCount(CrmPeopleVO crmPeopleVO) {
        //查询职位相同和现在同事人脉id
        List<Long> ids1 = new ArrayList<>();
        if (crmPeopleVO.getOperId() != null || crmPeopleVO.getCustomerId() != null || StringUtils.hasText(crmPeopleVO.getCompanyName()) || crmPeopleVO.getIndustry() != null) {
            ids1 = dao.queryPeopleIds1(crmPeopleVO.getId(), crmPeopleVO.getOperId(), crmPeopleVO.getCustomerId(), crmPeopleVO.getCompanyName(), crmPeopleVO.getIndustry());
        }
        List<Long> customerIds = new ArrayList<>();
        List<String> companyNames = new ArrayList<>();
        //获取过往公司
        queryOldWork(crmPeopleVO.getId(), customerIds, companyNames);
        List<Long> ids2 = new ArrayList<>();
        if (customerIds.size() > 0 || companyNames.size() > 0) {
            ids2 = dao.queryPeopleIds2(crmPeopleVO.getId(), customerIds, companyNames);
        }
        Set<Long> ids = new HashSet<>();
        ids.addAll(ids1);
        ids.addAll(ids2);
        return ids.size();
    }

    /**
     * 获取过往公司
     *
     * @param peopleId
     * @param customerIds
     * @param companyNames
     */
    void queryOldWork(Long peopleId, List<Long> customerIds, List<String> companyNames) {
        CrmPeopleWorkQuery query = new CrmPeopleWorkQuery();
        query.setPeopleId(peopleId);
        query.setWorkStatus("0");
        List<CrmPeopleWorkVO> peopleWorkVOS = peopleWorkDAO.queryList(query);

        peopleWorkVOS.forEach(peopleWorkVO -> {
            if (!ObjectUtils.isEmpty(peopleWorkVO.getCustomerId())) {
                customerIds.add(peopleWorkVO.getCustomerId());
            }
            if (StringUtils.hasText(peopleWorkVO.getCompanyName())) {
                companyNames.add(peopleWorkVO.getCompanyName());
            }
        });
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(CrmPeoplePayload payload) {
//        if (null == payload.getOperId() && null == payload.getCustomerId()) {
//            throw TwException.error("", "归属客户和客户经营不能同时为空，请核验！");
//        }
        if (null == payload.getPeopleName()) {
            throw TwException.error("", "名称不能为空，请核验！");
        }
    }

    /**
     * 初始化创建人脉工作
     *
     * @param entityDo
     */
    void savePeople(CrmPeopleDO entityDo) {
        Long id = entityDo.getId();
        transactionUtilService.executeWithCallable(
                () -> {
                    CrmPeopleVO crmPeopleVO = dao.queryByKey(id);

                    CrmPeopleWorkPayload workPayload = new CrmPeopleWorkPayload();
                    workPayload.setCompanyName(crmPeopleVO.getCompanyName());

                    if (StringUtils.hasText(crmPeopleVO.getOperationName())) {
                        workPayload.setCompanyName(crmPeopleVO.getOperationName());
                    }
                    if (StringUtils.hasText(crmPeopleVO.getCustomerName())) {
                        workPayload.setCompanyName(crmPeopleVO.getCustomerName());
                    }
                    String custType = "enterprise";
                    if (StringUtils.hasText(crmPeopleVO.getCustType())) {
                        custType = crmPeopleVO.getCustType();
                    }
                    workPayload.setPeopleId(id);
                    workPayload.setCustomerId(crmPeopleVO.getCustomerId());
                    workPayload.setCustType(custType);
                    workPayload.setWorkStatus("1");
                    workPayload.setJobs(crmPeopleVO.getJobs());
                    workPayload.setIsInitia(true);
                    workService.insertOrUpdate(workPayload);
                    return null;
                });
    }

    /**
     * 核验是否关联客户
     *
     * @param crmPeopleVO
     */
    void checkeRelation(CrmPeopleVO crmPeopleVO) {
        if (ObjectUtils.isEmpty(crmPeopleVO)) {
            throw TwException.error("", "数据不存在，请核验！");
        }
        if (crmPeopleVO.getCustomerId() == null) {
            throw TwException.error("", "暂未关联客户，请核验！");
        }
    }

    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(CrmPeopleVO vo) {
        vo.setSexName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
        Map<String, String> map = DataUtil.getConstellation(vo.getBirthday());
        vo.setAge(map.get("age"));
        vo.setCsonstel(map.get("csonste"));
        vo.setDayOfMonth(map.get("dayOfMonth"));
        vo.setIndustryDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getIndustry()));

        if (StringUtils.hasText(vo.getOperationName())) {
            vo.setCompanyName(vo.getOperationName());
        }
        if (StringUtils.hasText(vo.getCustomerName())) {
            vo.setCompanyName(vo.getCustomerName());
        }
        vo.setPeopleStatusDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), vo.getPeopleStatus()));
        //vo.setMaritalDesc((StringUtils.hasText(vo.getMarital()) && "1".equals(vo.getMarital())) ? "已婚" : "未婚");
    }

}
