package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.payload.*;
import com.elitesland.tw.tw5.api.prd.crm.service.*;
import com.elitesland.tw.tw5.api.prd.crm.vo.*;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmFollowQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import com.elitesland.tw.tw5.api.prd.prj.query.PrjProjectQuery;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.ExcelEntityDataListener;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.*;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemLogDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmLeadsConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmPotentialCustomerConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOffshoreDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPotentialCustomerDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/14 - 12:25
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmPotentialCustomerServiceImpl extends BaseServiceImpl implements CrmPotentialCustomerService {

    private final CrmPotentialCustomerDAO dao;
    private final CacheUtil cacheUtil;
    private final PrdSystemLogService logService;
    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
    //private SysNumberRuleService numberRuleService;
    private final CrmLeadsService leadsService;
    private final CrmLeadsDAO leadsDAO;
    private final PrdSystemLogDAO logDAO;
    private final PrjProjectDAO marketDAO;
    private final CrmOpenseaDAO openseaDAO;
    private final CrmOpenseaService openseaService;
    private final CrmFollowService followService;
    private final ExcelUtil excelUtil;
    private final PrdSystemSelectionService selectionService;
    private final FileService fileService;
    private final CrmCommonService crmCommonService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final CrmFollowService crmFollowService;
    private final CrmLeadsOffshoreDAO leadsOffshoreDAO;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final CrmCustomerService customerService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CrmOffshoreDAO offshoreDAO;
    private final UdcUtil udcUtil;

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public CrmPotentialCustomerVO saveOne(CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerDO ado = new CrmPotentialCustomerDO();
        CrmOpenseaPayload opensea = new CrmOpenseaPayload();
        CrmPotentialCustomerDO oldEntity = null;
//        try{
        if (payload.getId() == null) {
            String customerNo = generateSeqNum("PCUSTOMER");
            PrjProjectPayload market = new PrjProjectPayload();
            market.setId(payload.getMarketId());
            opensea.setId(payload.getOpenseaId());
            // 生成编号
            payload.setCustomerNo(customerNo);
            payload.setMarket(market);
            payload.setOpensea(opensea);
            payload.setCustomerStatus("new");
        } else {
            oldEntity = dao.findById(payload.getId());
        }
        ado = CrmPotentialCustomerConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        countPotentialCustomers(opensea);
        String fieldsLog = "";
        if (payload.getId() == null) {
            logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), "新建 " + ado.getCustomerName());
            // 获取变更日志
            fieldsLog = changeFieldLogUtil.getFieldsCreateLog(ado);
        } else {
            fieldsLog = changeFieldLogUtil.getFieldsUpdateLog(ado, oldEntity);
        }
        if (fieldsLog != null && fieldsLog.length() > 0) {
            logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), fieldsLog);
        }
//        logService.saveNewLog(ado.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Potential_customer.getDesc());
//        }catch (Exception e){
//            TwException.error("","潜在客户不能重复！");
//        }

        return CrmPotentialCustomerConvert.INSTANCE.toVo(ado);
    }

    public void saveAll(List<CrmPotentialCustomerPayload> crmPotentialCustomerPayloadList) throws InterruptedException {
        Snowflake snowflake = IdUtil.getSnowflake(16, 16);
        List<CrmPotentialCustomerDO> resList = new ArrayList<>();
        crmPotentialCustomerPayloadList.forEach(p ->{
            resList.add(conver(p,snowflake));
        });
        dao.batchInsert(resList);
        for (CrmPotentialCustomerDO potentialCustomerDO : resList) {
            logService.saveNewLog(potentialCustomerDO.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), "导入 " + potentialCustomerDO.getCustomerName());
            //具体字段log
            String fieldsLog = changeFieldLogUtil.getFieldsCreateLog(potentialCustomerDO);
            if (fieldsLog != null && fieldsLog.length() > 0) {
                logService.saveNewLog(potentialCustomerDO.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), fieldsLog);
            }
        }
        final List<Long> openSeaIdList = resList.stream()
                .map(crmPotentialCustomerDO -> crmPotentialCustomerDO.getOpensea().getId())
                .distinct()
                .collect(Collectors.toList());
        for (Long openSeaId : openSeaIdList) {
            int num = openseaDAO.countPotentialCustomers(openSeaId);
            CrmOpenseaPayload openseaPayload = new CrmOpenseaPayload();
            openseaPayload.setId(openSeaId);
            openseaPayload.setCustomerNum(num);
            openseaDAO.updateByKeyDynamic(openseaPayload);
        }
    }

    private CrmPotentialCustomerDO conver(CrmPotentialCustomerPayload payload, Snowflake snowflake) {
        CrmOpenseaPayload opensea = new CrmOpenseaPayload();
        if (payload.getId() == null) {
            //String customerNo = generateSeqNum("PCUSTOMER", null);
            //TODO 待架构组提供批量生产发号器的方法
            String customerNo = snowflake.nextIdStr();
            PrjProjectPayload market = new PrjProjectPayload();
            market.setId(payload.getMarketId());
            opensea.setId(payload.getOpenseaId());
            // 生成编号
            payload.setCustomerNo(customerNo);
            payload.setMarket(market);
            payload.setOpensea(opensea);
            payload.setCustomerStatus("new");
        }
        return CrmPotentialCustomerConvert.INSTANCE.toDo(payload);
    }

    /**
     * 查询和更新线索总数
     */
    private void countPotentialCustomers(CrmOpenseaPayload openseaPayload) {
        int num = openseaDAO.countPotentialCustomers(openseaPayload.getId());
        openseaPayload.setCustomerNum(num);
        openseaDAO.updateByKeyDynamic(openseaPayload);
    }

//    /**
//     * 保存日志，如果主子表同时修改，分开调用
//     * @param payload
//     */
//    private void saveLog(CrmPotentialCustomerPayload payload){
//        //翻译系统选择项
//        Map<String,String> selections=new HashMap<>();
//        selections.put("customerStatus",FunctionSelectionEnum.CrmPotentialCustomerStatus.getCode());
//        selections.put("customerGrade",FunctionSelectionEnum.CrmCustomerGrade.getCode());
//        selections.put("customerIndustry",FunctionSelectionEnum.CrmCustomerIndustry.getCode());
//
//        //翻译关联表的name字段
//        List<Object[]> joinObjects=new ArrayList<>();
//        Object[] marketTrans=new Object[3];
//        marketTrans[0]="marketId";
//        marketTrans[1]=PrjProjectDO.class;
//        marketTrans[2]="project_name";
//
//        joinObjects.add(marketTrans);
//
//        Object[] openseaTrans=new Object[3];
//        openseaTrans[0]="openseaId";
//        openseaTrans[1]=CrmOpenseaDO.class;
//        openseaTrans[2]="opensea_name";
//        joinObjects.add(openseaTrans);
//
//
//        //特殊变更动作名称（"更改","分配,"转移"等等）
//        Map<String,String> changeNames=new HashMap<>();
//        changeNames.put("openseaId","转移至");
//
//        //翻译用户
//        List<String> transUserIds=Arrays.asList();
//
//
//        logService.saveLog(PrdSystemObjectEnum.Potential_customer.getCode(), payload, payload.getId(), CrmPotentialCustomerDO.class, selections, transUserIds,joinObjects,changeNames);
//        //TODO:如果有子表需要修改，重新调用
//    }

    @Override
    public List<PrdSystemLogVO> queryLogList(Long potentialCustomerId) {
        return logService.queryLogList(potentialCustomerId, PrdSystemObjectEnum.Potential_customer.getCode());
    }

    @Override
    public PagingVO<PrdSystemLogVO> pageLog(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Potential_customer.getCode());
        return logService.pageLog(query);
    }


    @Transactional
    @Override
    public List<CrmPotentialCustomerListVO> queryList(CrmPotentialCustomerQuery query) {
        Specification<CrmPotentialCustomerDO> spec = dao.getSpec(query);
        List<CrmPotentialCustomerDO> all = dao.findAll(spec);
        return all.stream().map(e -> CrmPotentialCustomerConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
    }

    /**
     * 查询市场活动下的潜在客户数量
     *
     * @param activityId 市场活动项目id
     * @return
     */
    @Override
    public long countByActivityId(Long activityId) {
        CrmPotentialCustomerQuery query = new CrmPotentialCustomerQuery();
        query.setMarketId(activityId);
        Specification<CrmPotentialCustomerDO> spec = dao.getSpec(query);
        return dao.countAll(spec);
    }


    /**
     * 公海池列表、潜在客户 分页
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link CrmPotentialCustomerListVO}>
     */
    @Transactional(readOnly = true)
    @Override
    public PagingVO<CrmPotentialCustomerListVO> paging(CrmPotentialCustomerQuery query) {
        // 跟进时间筛选
        if (null != query.getFollowCreateTimeStart() || null != query.getFollowCreateTimeEnd()) {
            // 默认查询不到数据
            List<Long> de = new ArrayList<>();
            de.add(9999L);
            query.setPotentialCustomerIdsForFollow(de);
            // 跟进时间筛选
            CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
            //默认按照时间倒叙排序
            OrderItem orderItem = OrderItem.desc("createTime");
            crmFollowQuery.defaultOrder(orderItem);
            crmFollowQuery.setCreateTimeStart(query.getFollowCreateTimeStart());
            crmFollowQuery.setCreateTimeEnd(query.getFollowCreateTimeEnd());
            crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Potential_customer.name());
            final List<CrmFollowVO> crmFollowVOList = crmFollowService.list(crmFollowQuery);
            final List<Long> potentialCustomerIdsForFollow = crmFollowVOList.stream().map(crmFollowVO ->
                    crmFollowVO.getObjectId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(potentialCustomerIdsForFollow)) {
                query.setPotentialCustomerIdsForFollow(potentialCustomerIdsForFollow);
            }
        }

        Specification<CrmPotentialCustomerDO> spec = dao.getSpec(query);
        Page<CrmPotentialCustomerDO> all = dao.findAll(spec, query.getPageRequest());
        List<CrmPotentialCustomerDO> content = all.getContent();
        List<CrmPotentialCustomerListVO> collect = content.stream().map(e -> CrmPotentialCustomerConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
        transferList(collect, query.getQueryFirstFollow());
        //类型转化
        all.getTotalPages();
        PagingVO pagingVO = new PagingVO<>(all.getTotalElements(), collect);
        return pagingVO;
    }

    @Override
    @Transactional
    public void transferPotentialCustomerOpensea(CrmPotentialCustomerPayload payload) {
//        logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), PrdSystemLogEnum.TRANSFER.getDesc() + PrdSystemObjectEnum.Potential_customer.getDesc());
        CrmPotentialCustomerDO potentialCustomerDO = dao.queryById(payload.getId());
        CrmOpenseaPayload oldOpensea = new CrmOpenseaPayload();
        //新旧公海都count一遍
        if (potentialCustomerDO.getOpensea() != null) {
            oldOpensea.setId(potentialCustomerDO.getOpensea().getId());
            int num = openseaDAO.countPotentialCustomers(oldOpensea.getId());
            oldOpensea.setCustomerNum(num - 1);
            openseaDAO.updateByKeyDynamic(oldOpensea);
        }
//        dao.updateByKeyDynamic(payload);
        dynamicUpdate(payload);
        if (payload.getOpenseaId() != null) {
            CrmOpenseaPayload newOpensea = new CrmOpenseaPayload();
            newOpensea.setId(payload.getOpenseaId());
            countPotentialCustomers(newOpensea);
        }
    }

    @Transactional
    @Override
    public void transferPotentialCustomerOpenseaBatch(List<CrmPotentialCustomerPayload> payloads) {
        for (CrmPotentialCustomerPayload payload : payloads) {
            transferPotentialCustomerOpensea(payload);
        }
    }

    @Override
    @Transactional
    public Long transferPotentialCustomerOffshore(CrmLeadsDetailPayload payload) {
        CrmPotentialCustomerPayload potentialCustomer = new CrmPotentialCustomerPayload();
        potentialCustomer.setId(payload.getPotentialCustomerId());
        potentialCustomer.setTransferReason(payload.getPotentialCustomerTransferReason());
        potentialCustomer.setCustomerStatus("offshore");
//        saveLog(potentialCustomer);
        dao.updateByKeyDynamic(potentialCustomer);
        //保存一条线索
        CrmLeadsPayload leadsPayload = CrmLeadsConvert.INSTANCE.toPayLoad(payload);
        CrmLeadsCustomerPayload leadsCustomerPayload = new CrmLeadsCustomerPayload();
        leadsCustomerPayload.setCustomerName(payload.getCustomerName());
        leadsCustomerPayload.setCustomerIndustry(payload.getCustomerIndustry());
        leadsCustomerPayload.setCustomerGrade(payload.getCustomerGrade());
        leadsCustomerPayload.setCustomerContacts(payload.getCustomerContacts());
        leadsCustomerPayload.setContactsPhone(payload.getCustomerPhone());
        leadsCustomerPayload.setContactsEmail(payload.getCustomerEmail());
        leadsCustomerPayload.setContactsPosition(payload.getContactsPosition());
        leadsCustomerPayload.setContactsDepartment(payload.getContactsDepartment());
        leadsCustomerPayload.setCustRegion(payload.getCustRegion());
        leadsPayload.setCustomer(leadsCustomerPayload);
        leadsPayload.setLeadsTagIds(payload.getTagIds());
        PrjProjectPayload market = new PrjProjectPayload();
        Long marketId = payload.getMarketId();
        market.setId(marketId);
        leadsPayload.setMarket(market);
        CrmLeadsVO crmLeadsVO = leadsService.saveOne(leadsPayload);
        //潜在客户A 由 公海池A 转移到 近海池B
        //线索A 由 公海池A 转移到 近海池B
        CrmPotentialCustomerDO potentialCustomerDO = dao.queryById(payload.getPotentialCustomerId());
        List<Long> offshoreIds = payload.getOffshoreIds();
        if (!ObjectUtils.isEmpty(offshoreIds)) {
            CrmOffshoreDO offshoreDO = offshoreDAO.queryById(offshoreIds.get(0));
            logService.saveNewLog(payload.getPotentialCustomerId(), PrdSystemObjectEnum.Potential_customer.getCode(), potentialCustomerDO.getCustomerName() + " 由 " + potentialCustomerDO.getOpensea().getOpenseaName() + " 转移到 " + offshoreDO.getOffshoreName());
            logService.saveNewLog(crmLeadsVO.getId(), PrdSystemObjectEnum.Leads.getCode(), crmLeadsVO.getLeadsName() + " 由 " + potentialCustomerDO.getOpensea().getOpenseaName() + " 转移到 " + offshoreDO.getOffshoreName());
        }
        return crmLeadsVO.getId();
    }

    @Override
    public void updateFollow(CrmFollowPayload payload) {
        payload.setFollowObject(CrmFollowObjectEnum.Potential_customer.getCode());
        followService.addFollow(payload);
    }


    @Transactional
    @Override
    public CrmPotentialCustomerVO queryDetail(Long id) {
        CrmPotentialCustomerDO detail = dao.queryById(id);
        CrmPotentialCustomerVO potentialCustomerVO = CrmPotentialCustomerConvert.INSTANCE.toVo(detail);
        transferDetail(Collections.singletonList(potentialCustomerVO));
        return potentialCustomerVO;
    }

    @Override
    @Transactional
    public void dynamicUpdate(CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerDO crmPotentialCustomerDO = dao.queryById(payload.getId());
        //将旧值克隆出来
        CrmPotentialCustomerDO entityLog = new CrmPotentialCustomerDO();
        BeanUtils.copyProperties(crmPotentialCustomerDO, entityLog);

        if (payload.getCustomerGrade() != null) {
            //查询潜在客户关联的线索
            CrmLeadsDO leadsDO = leadsDAO.findByPotentialCustomerId(crmPotentialCustomerDO.getId());
            if (leadsDO != null && leadsDO.getFormalCustomerId() != null) {
                //更新关联客户的级别
                customerService.changeCustomerGrade(leadsDO.getFormalCustomerId(), payload.getCustomerGrade());
            }
        }
        // String detail = PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Potential_customer.getDesc();
//        String detail = GlobalUtil.getContantsLog(PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Potential_customer.getDesc(), crmPotentialCustomerDO.getCustomerContacts(), payload.getCustomerContacts(), crmPotentialCustomerDO.getCustomerPhone(), payload.getCustomerPhone());

//        saveLog(payload);
        //执行更新
        dao.updateByKeyDynamic(payload);
        //重新查询一遍获得新值
        crmPotentialCustomerDO = dao.queryById(payload.getId());
        String fieldsLog = changeFieldLogUtil.getFieldsUpdateLog(crmPotentialCustomerDO, entityLog);
        if (fieldsLog != null && fieldsLog.length() > 0) {
            logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), fieldsLog);
        }
    }

    @Override
    @Transactional
    public void updateProvinceCityDistrict(CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerDO crmPotentialCustomerDO = dao.queryById(payload.getId());
        //将旧值克隆出来
        CrmPotentialCustomerDO entityLog = new CrmPotentialCustomerDO();
        BeanUtils.copyProperties(crmPotentialCustomerDO, entityLog);

        //执行更新
        dao.updateProvinceCityDistrict(payload);
        //重新查询一遍获得新值
        crmPotentialCustomerDO = dao.queryById(payload.getId());
        String fieldsLog = changeFieldLogUtil.getFieldsUpdateLog(crmPotentialCustomerDO, entityLog);
        if (fieldsLog != null && fieldsLog.length() > 0) {
            logService.saveNewLog(payload.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), fieldsLog);
        }
    }

    @Override
    @Transactional
    public void deletePotentialCustomerSoft(Long[] asList) {
        //校验当前登录人的角色是不是市场管理员
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
        } else {
            throw TwException.error("", "您没有权限删除近海线索，请联系管理员！");
        }
        //新建状态的潜在客户方可删除
        for (Long aLong : asList) {
            CrmPotentialCustomerDO potentialCustomerDO = dao.queryById(aLong);
            String customerStatus = potentialCustomerDO.getCustomerStatus();
            if (!customerStatus.equals("new")) {
                throw TwException.error("", "只有新建状态的潜在客户才可以删除！");
            }
        }
        dao.deleteSoft(asList);
    }


    private void transferList(List<CrmPotentialCustomerListVO> list, Boolean queryFirstFollow) {
        for (CrmPotentialCustomerListVO vo : list) {
            if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            //状态
            vo.setCustomerStatusDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPotentialCustomerStatus.getCode(), vo.getCustomerStatus()));
            //客户级别
            vo.setCustomerGradeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), vo.getCustomerGrade()));
            //客户行业
            vo.setCustomerIndustryDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCustomerIndustry()));
            // 需求产品
            vo.setDemandProductDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsDemandProduct.getCode(), vo.getDemandProduct()));
            // 区域
            vo.setCustRegionDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerRegion.getCode(), vo.getCustRegion()));
            // 市场渠道
//            vo.setMarketChannelDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), vo.getMarketChannel()));
            // 市场渠道
            if (vo.getMarketChannel() != null) {
                String marketChannel = vo.getMarketChannel();
                String[] split = marketChannel.split(",");
                if (split.length < 2) {
                    vo.setMarketChannelDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
                } else {
                    String s1 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                    String s2 = "";
                    switch (split[0]) {
                        case "baidu":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                            break;
                        case "sem_360":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                            break;
                        case "offline_activity":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                            break;
                        case "thrid_party_data":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                            break;
                    }
                    vo.setMarketChannelDesc(s2.equals("") ? s1 : s1 + "/" + s2);
                }
            }
            //翻译标签列表
            String tagIds = vo.getTagIds();
            List<PrdSystemTagVO> tagVOS = new ArrayList<>();
            if (tagIds != null && !tagIds.isEmpty()) {
                String[] tags = tagIds.split(",");
                for (String tag : tags) {
                    List<PrdSystemTagVO> systemTags = cacheUtil.getSystemTag(Long.parseLong(tag));
                    tagVOS.addAll(systemTags);
                }
            }
            vo.setTags(tagVOS);

            if (queryFirstFollow == null || (queryFirstFollow != null && queryFirstFollow)) {
                CrmFollowQuery crmFollowQuery = new CrmFollowQuery();
                crmFollowQuery.setObjectId(vo.getId());
                crmFollowQuery.setFollowObject(CrmFollowObjectEnum.Potential_customer.name());
                crmFollowQuery.setSize(1);
                //默认按照时间倒叙排序
                OrderItem orderItem = OrderItem.desc("createTime");
                crmFollowQuery.defaultOrder(orderItem);
                final PagingVO<CrmFollowVO> crmFollowVOPagingVO = crmFollowService.listPage(crmFollowQuery);
                if (crmFollowVOPagingVO.getRecords() != null && crmFollowVOPagingVO.getRecords().size() == 1) {
                    final CrmFollowVO crmFollowVO = crmFollowVOPagingVO.getRecords().get(0);
                    vo.setFollow(crmFollowVO);
                }
            }
        }
    }

    private void transferDetail(List<CrmPotentialCustomerVO> list) {
        for (CrmPotentialCustomerVO vo : list) {
            if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            //状态
            vo.setCustomerStatusDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPotentialCustomerStatus.getCode(), vo.getCustomerStatus()));
            //客户级别
            vo.setCustomerGradeDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerGrade.getCode(), vo.getCustomerGrade()));
            //客户行业
            vo.setCustomerIndustryDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCustomerIndustry()));
            // 区域
            vo.setCustRegionDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerRegion.getCode(), vo.getCustRegion()));
            // 市场渠道
//            vo.setMarketChannelDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), vo.getMarketChannel()));
            // 市场渠道
            if (vo.getMarketChannel() != null) {
                String marketChannel = vo.getMarketChannel();
                String[] split = marketChannel.split(",");
                if (split.length < 2) {
                    vo.setMarketChannelDesc(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]));
                } else {
                    String s1 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel.getCode(), split[0]);
                    String s2 = "";
                    switch (split[0]) {
                        case "baidu":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelBaidu.getCode(), split[1]);
                            break;
                        case "sem_360":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannel360.getCode(), split[1]);
                            break;
                        case "offline_activity":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelOfflineActivity.getCode(), split[1]);
                            break;
                        case "thrid_party_data":
                            s2 = cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmLeadsChannelThirdPartyData.getCode(), split[1]);
                            break;
                    }
                    vo.setMarketChannelDesc(s2.equals("") ? s1 : s1 + "/" + s2);
                }
            }
        }
    }


    @Override
    public void deleteOpenseaSoft(Long openseaId, Long newOpenseaId) {
        //查询公海下面的潜在客户
        List<CrmPotentialCustomerDO> potentialCustomerDOS = dao.queryByOpenseaId(openseaId);
        if (potentialCustomerDOS == null || potentialCustomerDOS.isEmpty()) {

        } else {
            if (newOpenseaId == null) {
                throw TwException.error("", "未接收到新的公海，无法转移当前公海的潜在客户");
            }
            for (CrmPotentialCustomerDO potentialCustomerDO : potentialCustomerDOS) {
                CrmPotentialCustomerPayload potentialCustomerPayload = new CrmPotentialCustomerPayload();
                potentialCustomerPayload.setId(potentialCustomerDO.getId());
                potentialCustomerPayload.setOpenseaId(newOpenseaId);
                potentialCustomerPayload.setTransferReason("原公海删除，线索转移到本公海");
                //转移线索到目标近海
                transferPotentialCustomerOpensea(potentialCustomerPayload);
            }
        }
        //执行删除
        openseaDAO.deleteSoft(Collections.singletonList(openseaId));
    }


    public Workbook getVol() {
        ClassPathResource classPathResource = new ClassPathResource("template/crmPotentialCustomerBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet pCustomerSheet = (XSSFSheet) workbook.getSheet("潜在客户数据");
            Sheet lovSheet = workbook.getSheet("LOV");
            Sheet openseaSheet = workbook.getSheet("公海列表");
            Sheet marketSheet = workbook.getSheet("市场活动列表");
            //udc数据查询
//            //潜在客户状态
//            List<PrdSystemSelectionVO> customerStatusSelectionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmPotentialCustomerStatus.getCode());
//            excelUtil.insertLOVdata(lovSheet,customerStatusSelectionVOS,0);
            //潜在客户级别
            List<PrdSystemSelectionVO> customerGradeSelectionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerGrade.getCode());
            excelUtil.insertLOVdata(lovSheet, customerGradeSelectionVOS, 2);
            //潜在客户行业
            List<PrdSystemSelectionVO> customerIndustrySelectionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerIndustry.getCode());
            excelUtil.insertLOVdata(lovSheet, customerIndustrySelectionVOS, 4);
            //客户区域
            List<PrdSystemSelectionVO> custRegionVOS = selectionService.selectByCondition(FunctionSelectionEnum.CrmCustomerRegion.getCode());
            excelUtil.insertLOVdata(lovSheet, custRegionVOS, 6);
            //市场渠道
            List<PrdSystemSelectionVO> leadsChannelVOs = selectionService.selectByCondition(FunctionSelectionEnum.CrmLeadsChannel.getCode());
            excelUtil.insertLOVdata(lovSheet, leadsChannelVOs, 8);

            //公海列表
            List<CrmOpenseaListVO> crmOpenseaListVOS = openseaService.queryList(new CrmOpenseaQuery());
            excelUtil.insertListData(openseaSheet, crmOpenseaListVOS, "id", "openseaName", 0);
            //市场活动列表
            List<PrjProjectVO> prjProjectVOS = marketDAO.queryListDynamic(new PrjProjectQuery());
            excelUtil.insertListData(marketSheet, prjProjectVOS, "id", "projectName", 0);


            excelUtil.generateRangeList(pCustomerSheet, 1, 1, "公海列表", 2, "A");
            excelUtil.generateRangeList(pCustomerSheet, 2, 1, "市场活动列表", 2, "A");

            excelUtil.generateRangeList(pCustomerSheet, 4, 1, "LOV", 2, "C");
            excelUtil.generateRangeList(pCustomerSheet, 5, 1, "LOV", 2, "E");
            excelUtil.generateRangeList(pCustomerSheet, 9, 1, "LOV", 2, "G");
            excelUtil.generateRangeList(pCustomerSheet, 11, 1, "LOV", 2, "I");


            excelUtil.setCellFormulas(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1), 25, "VLOOKUP(B" + ExcelUtil.formulasReplace + ",公海列表!A:B,2,FALSE)");//公海列表
            excelUtil.setCellFormulas(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1), 26, "VLOOKUP(C" + ExcelUtil.formulasReplace + ",市场活动列表!A:B,2,FALSE)");//市场活动

            excelUtil.setCellFormulas(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1), 27, "VLOOKUP(E" + ExcelUtil.formulasReplace + ",LOV!C:D,2,FALSE)");
            excelUtil.setCellFormulas(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1), 28, "VLOOKUP(F" + ExcelUtil.formulasReplace + ",LOV!E:F,2,FALSE)");
            excelUtil.setCellFormulas(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1), 29, "VLOOKUP(J" + ExcelUtil.formulasReplace + ",LOV!G:H,2,FALSE)");
            excelUtil.setCellFormulas(pCustomerSheet.getRow(1) == null ? pCustomerSheet.createRow(1) : pCustomerSheet.getRow(1), 30, "VLOOKUP(L" + ExcelUtil.formulasReplace + ",LOV!I:J,2,FALSE)");

            return workbook;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    @Override
    public void downloadBatch(HttpServletResponse response, CrmPotentialCustomerQuery query) {
        try {
            Workbook workbook = null;
            String fileName = "";
            //  excelUtil.generateRangeList(batchProjectSheet, 2, 2, "活动类型", 2, "A"); // 最终客户 数据验证
            if (StringUtils.hasText(query.getDownloadType()) && query.getDownloadType().equals("model")) {
                workbook = getVol();
                fileName = "潜在客户导入模板-" + LocalDate.now();
                ExcelUtil.writeResponse(response, fileName, workbook);
            } else {
                fileName = "潜在客户数据-" + LocalDate.now();
                List<OrderItem> orderItems = new ArrayList<>();
                OrderItem openseaId = OrderItem.desc("opensea_id");
                orderItems.add(openseaId);
                query.setOrders(orderItems);
                query.setQueryFirstFollow(false);
                log.info("=============================开始查询=======================================");
                log.info("=============================开始查询=======================================");
                log.info("=============================开始查询=======================================");
                log.info("=============================开始查询=======================================");
                log.info("=============================开始查询=======================================");
                log.info("=============================开始查询=======================================");
                log.info("=============================开始查询=======================================");
                log.info("=============================开始查询=======================================");
                PagingVO<CrmPotentialCustomerListVO> paging = paging(query);
                log.info("=============================结束查询=======================================");
                log.info("=============================结束查询=======================================");
                log.info("=============================结束查询=======================================");
                log.info("=============================结束查询=======================================");
                log.info("=============================结束查询=======================================");
                log.info("=============================结束查询=======================================");
                log.info("=============================结束查询=======================================");
                log.info("=============================结束查询=======================================");
                log.info("=============================结束查询=======================================");
                List<CrmPotentialCustomerListVO> records = paging.getRecords();
                download(records, response);
            }
//            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<CrmPotentialCustomerListVO> records, HttpServletResponse response) throws IOException {
        int order = 1;
        //定义文件名称
        String sheetName = "潜在客户数据";
        for (CrmPotentialCustomerListVO record : records) {
            record.setOpenseaName(record.getOpensea().getOpenseaName());
            record.setMarketName(record.getMarket().getProjectName());
            record.setOrder(String.valueOf(order));
            order++;
        }

        List<CrmPotentialCustomerListExcelExport> resultList = CrmPotentialCustomerConvert.INSTANCE.voListVoExcelExport(records);
        resultList = udcUtil.translateList(resultList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), CrmPotentialCustomerListExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, CrmPotentialCustomerListExcelExport.class, null);
        //写入
        sheet.doWrite(resultList);

//        ClassPathResource classPathResource = new ClassPathResource("template/crmPotentialCustomerDownloadBatch.xlsx");
//        try {
//            InputStream inputStream = classPathResource.getInputStream();
//            Workbook workbook = WorkbookFactory.create(inputStream);
//            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("潜在客户数据");
//            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
//                int nextRow = 1;
//                for (CrmPotentialCustomerListVO dataPayload : records) {
//                    Row row = batchProjectSheet.createRow(nextRow);
//                    excelUtil.setCellValue(row, 0, nextRow); // 序号
//                    excelUtil.setCellValue(row, 1, dataPayload.getOpensea().getOpenseaName());// 公海名称
//                    excelUtil.setCellValue(row, 2, dataPayload.getMarket().getProjectName());// 市场活动
//                    excelUtil.setCellValue(row, 3, dataPayload.getCustomerName());// 客户名称
//                    excelUtil.setCellValue(row, 4, dataPayload.getCustomerNo());// 客户编号
//
//                    excelUtil.setCellValue(row, 5, dataPayload.getCustomerStatusDesc());// 客户状态
//                    excelUtil.setCellValue(row, 6, dataPayload.getCustomerGradeDesc());// 客户级别
//                    excelUtil.setCellValue(row, 7, dataPayload.getCustomerIndustryDesc());// 客户行业
//                    excelUtil.setCellValue(row, 8, dataPayload.getCustomerContacts());// 联系人姓名
//                    excelUtil.setCellValue(row, 9, dataPayload.getCustomerPhone());// 客户电话
//                    excelUtil.setCellValue(row, 10, dataPayload.getCustomerEmail());// 客户邮箱
//
//                    excelUtil.setCellValue(row, 11, dataPayload.getCustRegionDesc());// 客户区域
//                    excelUtil.setCellValue(row, 12, dataPayload.getCustomerLocationCityName());// 市
//                    excelUtil.setCellValue(row, 13, dataPayload.getMarketChannelDesc());// 市场渠道
//                    excelUtil.setCellValue(row, 14, dataPayload.getCustomerLocationDetail());// 详细地址
//                    excelUtil.setCellValue(row, 15, dataPayload.getCreateUserName());// 创建人
//                    excelUtil.setCellValue(row, 16, dataPayload.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));// 创建时间
//                    excelUtil.setCellValue(row, 17, dataPayload.getRemark());// 备注
//                    excelUtil.setCellValue(row, 18, dataPayload.getContactsDepartment());// 联系人部门
//                    excelUtil.setCellValue(row, 19, dataPayload.getContactsPosition());// 联系人岗位
//                    nextRow++;
////                    logService.saveNewLog(dataPayload.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), "导出 "+dataPayload.getCustomerName() );
//                }
//            }
//            String fileName = "潜在客户数据-" + LocalDate.now();
//            ExcelUtil.writeResponse(response, fileName, workbook);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public Map<String, Object> importBatch(HttpServletResponse response, MultipartFile file, Boolean force) {
        Map<String, Object> resultMap = new HashMap<>();
        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet("潜在客户数据");
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        int dataStartRow = 1;
        List<CrmPotentialCustomerPayload> potentialCustomerPayloads = new ArrayList<>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            String importError = "";
            String importWarn = "";
            Row row = sheet.getRow(i);
            CrmPotentialCustomerPayload potentialCustomerPayload = new CrmPotentialCustomerPayload();
            String openseaIdStr = ExcelUtil.getCellFormatValue(row.getCell(25));
            if (StringUtils.hasText(openseaIdStr) && openseaIdStr.length() > 0) {
                potentialCustomerPayload.setOpenseaId(Long.parseLong(openseaIdStr));
                potentialCustomerPayload.setOpenseaName(ExcelUtil.getCellFormatValue(row.getCell(1)));
            } else {
                importError += "公海不能为空;";
            }
            String marketId = ExcelUtil.getCellFormatValue(row.getCell(26));
            if (StringUtils.hasText(marketId) && marketId.length() > 0) {
                PrjProjectPayload prjProjectPayload = new PrjProjectPayload();
                prjProjectPayload.setId(Long.parseLong(marketId));
                potentialCustomerPayload.setMarket(prjProjectPayload);
                potentialCustomerPayload.setMarketId(Long.parseLong(marketId));
                potentialCustomerPayload.setMarketIdDesc(ExcelUtil.getCellFormatValue(row.getCell(2)));
            } else {
//                importError+="市场活动不能为空;";
            }
            String customerName = ExcelUtil.getCellFormatValue(row.getCell(3));
            List<Map<String, Object>> company = new ArrayList<>();
            if (customerName != null && customerName.length() > 0) {
                company = crmCommonService.checkRepeat("company", customerName);
                if (company != null && !company.isEmpty()) {
                    for (Map<String, Object> stringObjectMap : company) {
                        stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                        importWarn += "重复类型：" + stringObjectMap.get("repeatType") + ",企业名称：" + stringObjectMap.get("companyName") + ",联系人：" + stringObjectMap.get("contactsName") + ",联系人电话：" + stringObjectMap.get("contactsPhone") + "，销售人员：" + stringObjectMap.get("salesMan") + ";";
                    }
                }
            }
            potentialCustomerPayload.setCustomerName(customerName);
            potentialCustomerPayload.setCustomerGrade(ExcelUtil.getCellFormatValue(row.getCell(27)));
            potentialCustomerPayload.setCustomerGradeDesc(ExcelUtil.getCellFormatValue(row.getCell(4)));

            potentialCustomerPayload.setCustomerIndustry(ExcelUtil.getCellFormatValue(row.getCell(28)));
            potentialCustomerPayload.setCustomerIndustryDesc(ExcelUtil.getCellFormatValue(row.getCell(5)));

            potentialCustomerPayload.setCustomerContacts(ExcelUtil.getCellFormatValue(row.getCell(6)));
            String customerPhone = ExcelUtil.getCellFormatValue(row.getCell(7));
            if (customerPhone != null && customerPhone.length() > 0) {
                List<Map<String, Object>> phone = crmCommonService.checkRepeat("phone", customerPhone);
                if (phone != null && !phone.isEmpty()) {
                    for (Map<String, Object> stringObjectMap : phone) {
                        boolean repeatFlag = false;
                        //先去重
                        for (Map<String, Object> companyMap : company) {
                            if (companyMap.get("id").equals(stringObjectMap.get("id")) && companyMap.get("repeatType").equals(stringObjectMap.get("repeatType"))) {
                                repeatFlag = true;
                                break;
                            }
                        }
                        if (!repeatFlag) {
                            stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                            importWarn += "重复类型：" + stringObjectMap.get("repeatType") + ",企业名称：" + stringObjectMap.get("companyName") + ",联系人：" + stringObjectMap.get("contactsName") + ",联系人电话：" + stringObjectMap.get("contactsPhone") + "，销售人员：" + stringObjectMap.get("salesMan") + ";";
                        }
                    }
                }
            }
            potentialCustomerPayload.setCustomerPhone(ExcelUtil.getCellFormatValue(row.getCell(7)));
            potentialCustomerPayload.setCustomerEmail(ExcelUtil.getCellFormatValue(row.getCell(8)));

            potentialCustomerPayload.setCustRegion(ExcelUtil.getCellFormatValue(row.getCell(29)));
            potentialCustomerPayload.setCustomerLocationCityName(ExcelUtil.getCellFormatValue(row.getCell(10)));
            potentialCustomerPayload.setMarketChannel(ExcelUtil.getCellFormatValue(row.getCell(30)));
            potentialCustomerPayload.setCustomerLocationDetail(ExcelUtil.getCellFormatValue(row.getCell(12)));
            String createTime = ExcelUtil.getCellFormatValue(row.getCell(13));
            if (createTime != null && createTime != "") {
                try {
                    LocalDate parse = LocalDate.parse(createTime);
                    potentialCustomerPayload.setCreateTime(parse.atStartOfDay());
                } catch (Exception e) {
                    importError += "创建时间必须是日期类型";
                }
            }
            potentialCustomerPayload.setRemark(ExcelUtil.getCellFormatValue(row.getCell(14)));
            potentialCustomerPayload.setContactsDepartment(ExcelUtil.getCellFormatValue(row.getCell(15)));
            potentialCustomerPayload.setContactsPosition(ExcelUtil.getCellFormatValue(row.getCell(16)));
            potentialCustomerPayload.setImoprtError(importError);
            potentialCustomerPayload.setImportWarn(importWarn);
            potentialCustomerPayloads.add(potentialCustomerPayload);
//            saveOne(potentialCustomerPayload);
        }

        int warnNum = 0;
        int errorNum = 0;
        for (CrmPotentialCustomerPayload potentialCustomerPayload : potentialCustomerPayloads) {
            if (StringUtils.hasText(potentialCustomerPayload.getImoprtError()) && potentialCustomerPayload.getImoprtError().length() > 0) {
                errorNum++;
            }
            if ((StringUtils.hasText(potentialCustomerPayload.getImportWarn()) || potentialCustomerPayload.getImportWarn().length() > 0) && !force) {
                warnNum++;
            }
        }
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", downloadModelWithData(potentialCustomerPayloads));
        } else if (warnNum > 0) {
            resultMap.put("ok", "warn");
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", downloadModelWithData(potentialCustomerPayloads));
        } else {
            for (CrmPotentialCustomerPayload potentialCustomerPayload : potentialCustomerPayloads) {
                CrmPotentialCustomerVO crmPotentialCustomerVO = saveOne(potentialCustomerPayload);
                logService.saveNewLog(crmPotentialCustomerVO.getId(), PrdSystemObjectEnum.Potential_customer.getCode(), "导入 " + crmPotentialCustomerVO.getCustomerName());
            }
            resultMap.put("ok", "ok");
        }
        return resultMap;
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public Map<String, Object> importBatchPro(MultipartFile file, Boolean force) throws InterruptedException {
        ExcelEntityDataListener<CrmPotentialCustomerPayload> dataListener = new ExcelEntityDataListener<>();
        try {
            EasyExcel.read(file.getInputStream(), CrmPotentialCustomerPayload.class, dataListener).sheet(0).headRowNumber(1).doRead();
        } catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据异常，请检查导入 excel的列值是否与模板对应");
        }
        List<CrmPotentialCustomerPayload> crmPotentialCustomerPayloadList = dataListener.getDatas();
        if (CollectionUtils.isEmpty(crmPotentialCustomerPayloadList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据不能为空！");
        }
        CrmPotentialCustomerQuery crmPotentialCustomerQuery = new CrmPotentialCustomerQuery();
        CrmLeadsOffshoreQuery leadsQuery = new CrmLeadsOffshoreQuery();
        final List<CrmPotentialCustomerDO> crmPotentialCustomerDOList = queryPotentialCustomerList(crmPotentialCustomerQuery);
        final List<CrmLeadsOffshoreDO> crmLeadsOffshoreDOList = queryLeadsList(leadsQuery);
        Map<String, Object> map = new HashMap<>();
        map.put("crmLeadsOffshoreDOList", crmLeadsOffshoreDOList);
        map.put("crmPotentialCustomerDOList", crmPotentialCustomerDOList);
        for (CrmPotentialCustomerPayload payload : crmPotentialCustomerPayloadList) {
            StringBuilder importError = new StringBuilder();
            StringBuilder importWarn = new StringBuilder();
            if (null == payload.getOpenseaId()) {
                importError.append("公海id不能为空;");
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty(payload.getOpenseaName())) {
                importError.append("公海名称不能为空;");
            }

            List<Map<String, Object>> company = new ArrayList<>();
            String customerName = payload.getCustomerName();
            if (StringUtils.hasText(customerName)) {
                company = crmCommonService.checkRepeatPro(map, "company", customerName);
                if (company != null && !company.isEmpty()) {
                    for (Map<String, Object> stringObjectMap : company) {
                        stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                        importWarn.append("重复类型：" + stringObjectMap.get("repeatType") + ",企业名称：" + stringObjectMap.get("companyName") + ",联系人：" + stringObjectMap.get("contactsName") + ",联系人电话：" + stringObjectMap.get("contactsPhone") + "，销售人员：" + stringObjectMap.get("salesMan") + ";");
                    }
                }
            }
            String customerPhone = payload.getCustomerPhone();
            if (StringUtils.hasText(customerPhone)) {
                List<Map<String, Object>> phone = crmCommonService.checkRepeatPro(map, "phone", customerPhone);
                if (phone != null && !phone.isEmpty()) {
                    for (Map<String, Object> stringObjectMap : phone) {
                        boolean repeatFlag = false;
                        //先去重
                        for (Map<String, Object> companyMap : company) {
                            if (companyMap.get("id").equals(stringObjectMap.get("id")) && companyMap.get("repeatType").equals(stringObjectMap.get("repeatType"))) {
                                repeatFlag = true;
                                break;
                            }
                        }
                        if (!repeatFlag) {
                            stringObjectMap.put("salesMan", stringObjectMap.get("salesMan") == null ? "" : stringObjectMap.get("salesMan"));
                            importWarn.append("重复类型：" + stringObjectMap.get("repeatType") + ",企业名称：" + stringObjectMap.get("companyName") + ",联系人：" + stringObjectMap.get("contactsName") + ",联系人电话：" + stringObjectMap.get("contactsPhone") + "，销售人员：" + stringObjectMap.get("salesMan") + ";");
                        }
                    }
                }
            }

            String createTimeStr = payload.getCreateTimeStr();
            if (StringUtils.hasText(createTimeStr)) {
                try {
                    LocalDate parse = LocalDate.parse(createTimeStr);
                    payload.setCreateTime(parse.atStartOfDay());
                } catch (Exception e) {
                    importError.append("创建时间必须是日期类型");
                }
            }

            payload.setImoprtError(importError.toString());
            payload.setImportWarn(importWarn.toString());

        }

        int warnNum = 0;
        int errorNum = 0;
        for (CrmPotentialCustomerPayload potentialCustomerPayload : crmPotentialCustomerPayloadList) {
            if (StringUtils.hasText(potentialCustomerPayload.getImoprtError())) {
                errorNum++;
            }
            if ((StringUtils.hasText(potentialCustomerPayload.getImportWarn())) && !force) {
                warnNum++;
            }
        }

        Map<String, Object> resultMap = new HashMap<>();
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", downloadModelWithData(crmPotentialCustomerPayloadList));
        } else if (warnNum > 0) {
            resultMap.put("ok", "warn");
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", downloadModelWithData(crmPotentialCustomerPayloadList));
        } else {
            saveAll(crmPotentialCustomerPayloadList);
            resultMap.put("ok", "ok");
        }
        return resultMap;
    }

    public List<CrmLeadsOffshoreDO> queryLeadsList(CrmLeadsOffshoreQuery leadsOffshoreQuery) {
        Specification<CrmLeadsOffshoreDO> spec = leadsOffshoreDAO.getSpec(leadsOffshoreQuery);
        List<CrmLeadsOffshoreDO> content = leadsOffshoreDAO.findAll(spec);
        return content;
    }

    public List<CrmPotentialCustomerDO> queryPotentialCustomerList(CrmPotentialCustomerQuery query) {
        Specification<CrmPotentialCustomerDO> spec = potentialCustomerDAO.getSpec(query);
        return potentialCustomerDAO.findAll(spec);
    }

    private Object downloadModelWithData(List<CrmPotentialCustomerPayload> records) {
        Workbook workbook = getVol();
        try {
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("潜在客户数据");
            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                XSSFCell errorCell = batchProjectSheet.getRow(0).getCell(17) == null ? batchProjectSheet.getRow(0).createCell(17) : batchProjectSheet.getRow(0).getCell(17);
                errorCell.setCellValue("导入错误");
                XSSFCell warnCell = batchProjectSheet.getRow(0).getCell(18) == null ? batchProjectSheet.getRow(0).createCell(18) : batchProjectSheet.getRow(0).getCell(18);
                warnCell.setCellValue("导入警告");
                int nextRow = 1;
                for (CrmPotentialCustomerPayload dataPayload : records) {
//                    Row row = batchProjectSheet.createRow(nextRow);
                    Row row = batchProjectSheet.getRow(nextRow);
                    if (row == null) {
                        row = batchProjectSheet.createRow(nextRow);
                    }
                    excelUtil.setCellValueNew(row, 0, nextRow); // 序号
                    excelUtil.setCellValueNew(row, 1, dataPayload.getOpenseaName());// 公海名称
                    excelUtil.setCellValueNew(row, 25, dataPayload.getOpenseaId());// 公海名称
                    excelUtil.setCellValueNew(row, 2, dataPayload.getMarketIdDesc());// 市场活动
                    excelUtil.setCellValueNew(row, 26, dataPayload.getMarketId());// 市场活动
                    excelUtil.setCellValueNew(row, 3, dataPayload.getCustomerName());// 客户名称
                    excelUtil.setCellValueNew(row, 4, dataPayload.getCustomerGradeDesc());// 客户级别
                    excelUtil.setCellValueNew(row, 27, dataPayload.getCustomerGrade());// 客户级别
                    excelUtil.setCellValueNew(row, 5, dataPayload.getCustomerIndustryDesc());// 客户行业
                    excelUtil.setCellValueNew(row, 28, dataPayload.getCustomerIndustry());// 客户行业

                    excelUtil.setCellValueNew(row, 6, dataPayload.getCustomerContacts());// 联系人姓名
                    excelUtil.setCellValueNew(row, 7, dataPayload.getCustomerPhone());// 客户电话
                    excelUtil.setCellValueNew(row, 8, dataPayload.getCustomerEmail());// 客户邮箱

                    excelUtil.setCellValueNew(row, 29, dataPayload.getCustRegion());// 省
                    excelUtil.setCellValueNew(row, 10, dataPayload.getCustomerLocationCityName());// 市
                    excelUtil.setCellValueNew(row, 30, dataPayload.getMarketChannel());// 区
                    excelUtil.setCellValueNew(row, 12, dataPayload.getCustomerLocationDetail());// 详细地址
                    excelUtil.setCellValueNew(row, 13, dataPayload.getCreateTime());// 创建时间
                    excelUtil.setCellValueNew(row, 14, dataPayload.getRemark());// 备注
                    excelUtil.setCellValueNew(row, 15, dataPayload.getContactsDepartment());//
                    excelUtil.setCellValueNew(row, 16, dataPayload.getContactsPosition());//
                    excelUtil.setCellValueNew(row, 17, dataPayload.getImoprtError());//导入错误
                    excelUtil.setCellValueNew(row, 18, dataPayload.getImportWarn());//导入警告
                    nextRow++;
                }
            }
            String fileName = "潜在客户数据导入-" + UUID.randomUUID() + ".xlsx";
            File file = ExcelUtil.workbookToFile(workbook, fileName);
            ApiResult upload = fileService.upload(file);
            return upload.getData();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }


    @Override
    public void batchAddTags(Long[] keys, String tagIds) {
        String newTags = "";
        for (Long key : keys) {
            CrmPotentialCustomerPayload payload = new CrmPotentialCustomerPayload();
            payload.setId(key);
            CrmPotentialCustomerDO potentialCustomerDO = dao.queryById(key);
            String existingTagIds = potentialCustomerDO.getTagIds();
            if (existingTagIds != null && !existingTagIds.isEmpty() && tagIds != null && !tagIds.isEmpty()) {
                List<String> tagIdList = new ArrayList<>(Arrays.asList(existingTagIds.split(",")));
                tagIdList.addAll(new ArrayList<>(Arrays.asList(tagIds.split(","))));
                newTags = String.join(",", tagIdList.stream().distinct().collect(Collectors.toList()));
            } else {
                newTags = tagIds;
            }
            payload.setTagIds(newTags);
            dao.updateByKeyDynamic(payload);
        }
    }


    @Override
    public void batchDelTags(Long[] keys, String tagIds) {
        String newTags = "";
        for (Long key : keys) {
            CrmPotentialCustomerPayload payload = new CrmPotentialCustomerPayload();
            payload.setId(key);
            CrmPotentialCustomerDO potentialCustomerDO = dao.queryById(key);
            String existingTagIds = potentialCustomerDO.getTagIds();
            if (existingTagIds != null && !existingTagIds.isEmpty()) {
                if (tagIds != null && !tagIds.isEmpty()) {
                    List<String> tagIdList = new ArrayList<>(Arrays.asList(existingTagIds.split(",")));
                    tagIdList.removeAll(new ArrayList<>(Arrays.asList(tagIds.split(","))));
                    newTags = String.join(",", tagIdList.stream().distinct().collect(Collectors.toList()));
                } else {
                    newTags = existingTagIds;
                }
            } else {
                newTags = null;
            }
            payload.setTagIds(newTags);
            dao.updateByKeyDynamic(payload);
        }
    }


}
