package com.elitesland.tw.tw5.server.prd.file.service;

import com.elitesland.tw.tw5.api.prd.file.payload.PrdFileFolderPayload;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileFolderQuery;
import com.elitesland.tw.tw5.api.prd.file.service.PrdFileFolderService;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileFolderVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.file.entity.PrdFileFolderDO;
import com.elitesland.tw.tw5.server.prd.file.repo.PrdFileFolderRepo;
import com.elitesland.tw.tw5.server.prd.file.convert.PrdFileFolderConvert;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 附件-文件夹
 *
 * @author duwh
 * @date 2022/09/23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdFileFolderServiceImpl implements PrdFileFolderService {

    private final PrdFileFolderRepo prdFileRefRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdFileFolderVO insert(PrdFileFolderPayload payload) {
        PrdFileFolderDO entityDo = PrdFileFolderConvert.INSTANCE.toDo(payload);
        prdFileRefRepo.save(entityDo);
        return PrdFileFolderConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdFileFolderVO update(PrdFileFolderPayload payload) {
        PrdFileFolderDO entity = prdFileRefRepo.findById(payload.getId()).orElseGet(PrdFileFolderDO::new);
        Assert.notNull(entity.getId(), "文件夹不存在");
        PrdFileFolderDO entityDo = PrdFileFolderConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdFileFolderConvert.INSTANCE.toVo(prdFileRefRepo.save(entity));
    }

    @Override
    public PrdFileFolderVO queryByKey(Long key) {
        PrdFileFolderDO entity = prdFileRefRepo.findById(key).orElseGet(PrdFileFolderDO::new);
        Assert.notNull(entity.getId(), "文件夹不存在");
        return PrdFileFolderConvert.INSTANCE.toVo(entity);
    }

    @Override
    public List<PrdFileFolderVO> queryList(PrdFileFolderQuery query) {
        return PrdFileFolderConvert.INSTANCE.toVoList(prdFileRefRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public PagingVO<PrdFileFolderVO> paging(PrdFileFolderQuery query) {
        Page<PrdFileFolderDO> page = prdFileRefRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(PrdFileFolderConvert.INSTANCE::toVo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<PrdFileFolderDO> optional = prdFileRefRepo.findById(id);
                if (!optional.isEmpty()) {
                    PrdFileFolderDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    prdFileRefRepo.save(entity);
                }
            });
        }
    }


}
