package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.PrdUserMessageQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserMessageService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 个消息管理
 *
 * @author wangding
 */
@Api("个消息管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_SYSTEM)
@RequestMapping("/api/my")
@Slf4j
public class PrdUserMessageController {

    private final PrdUserMessageService service;

    /**
     * 查询未读消息总数
     *
     * @return result
     */
    @ApiOperation("查询未读消息总数")
    @PutMapping("/message/queryTotal")
    public TwOutputUtil queryTotal() {
        return TwOutputUtil.ok(service.queryTotal());
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/message/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("主键查询")
    @GetMapping("/message/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdUserMessageVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 分页查询
     *
     * @return result
     */
    @ApiOperation("分页查询")
    @GetMapping("/message/paging")
    public TwOutputUtil paging(PrdUserMessageQuery query) {

        log.error("--------------消息接口 暂时返回空------");
        return TwOutputUtil.ok(PagingVO.empty());
        //return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 一键已读
     *
     * @param keys 主键
     * @return result
     */
    @ApiOperation("一键已读")
    @PutMapping("/message/onKeyUpdateStatus")
    public TwOutputUtil onKeyUpdateStatus(Long[] keys) {
        service.onKeyUpdateStatus(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }
}
