package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.ProjShPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjShQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ProjShService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
* 项目成员
*
* @author duh
* @date 2022-12-16
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/projSh")
@Slf4j
public class ProjShController {

    private final ProjShService projShService;

    /**
    * 新增
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PostMapping
    public TwOutputUtil insert(@RequestBody ProjShPayload payload){
        return TwOutputUtil.ok(projShService.insert(payload));
    }

    /**
    * 更新
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PutMapping
    public TwOutputUtil update(@RequestBody ProjShPayload payload){
        return TwOutputUtil.ok(projShService.update(payload));
    }

    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(projShService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(ProjShQuery query) {
        return TwOutputUtil.ok(projShService.paging(query));
    }

    /**
    * 查询列表
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(ProjShQuery query) {
        return TwOutputUtil.ok(projShService.queryList(query));
    }

    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        projShService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
