package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TaskAuthorizedPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
* 任务包授权主表
*
* @author duwh
* @date 2022-12-16
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/taskAuthorized")
@Slf4j
public class TaskAuthorizedController {

    private final TaskAuthorizedService taskAuthorizedService;

    /**
    * 新增
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PostMapping
    public TwOutputUtil insert(@RequestBody TaskAuthorizedPayload payload){
        return TwOutputUtil.ok(taskAuthorizedService.insert(payload));
    }

    /**
    * 更新
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PutMapping
    public TwOutputUtil update(@RequestBody TaskAuthorizedPayload payload){
        return TwOutputUtil.ok(taskAuthorizedService.update(payload));
    }

    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskAuthorizedService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(TaskAuthorizedQuery query) {
        return TwOutputUtil.ok(taskAuthorizedService.paging(query));
    }

    /**
    * 查询列表
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(TaskAuthorizedQuery query) {
        return TwOutputUtil.ok(taskAuthorizedService.queryList(query));
    }

    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskAuthorizedService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
