package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TaskAuthorizedDetailsPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedDetailsQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedDetailsService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
* 任务包授权主表
*
* @author duwh
* @date 2022-12-16
*/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/taskAuthorizedDetails")
@Slf4j
public class TaskAuthorizedDetailsController {

    private final TaskAuthorizedDetailsService taskAuthorizedDetailsService;

    /**
    * 新增
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PostMapping
    public TwOutputUtil insert(@RequestBody TaskAuthorizedDetailsPayload payload){
        return TwOutputUtil.ok(taskAuthorizedDetailsService.insert(payload));
    }

    /**
    * 更新
    *
    * @param payload 有效载荷
    * @return {@link TwOutputUtil}
    */
    @PutMapping
    public TwOutputUtil update(@RequestBody TaskAuthorizedDetailsPayload payload){
        return TwOutputUtil.ok(taskAuthorizedDetailsService.update(payload));
    }

    /**
    * 主键查询
    *
    * @param key 关键
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskAuthorizedDetailsService.queryByKey(key));
    }

    /**
    * 分页
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(TaskAuthorizedDetailsQuery query) {
        return TwOutputUtil.ok(taskAuthorizedDetailsService.paging(query));
    }

    /**
    * 查询列表
    *
    * @param query 查询
    * @return {@link TwOutputUtil}
    */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(TaskAuthorizedDetailsQuery query) {
        return TwOutputUtil.ok(taskAuthorizedDetailsService.queryList(query));
    }

    /**
    * 删除
    *
    * @param keys 主键id
    * @return result
    */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskAuthorizedDetailsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
