package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetBiweeklyService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 双周计划
 *
 * @author duwh
 * @date 2022-12-21
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/timesheetBiweekly")
@Slf4j
public class TimesheetBiweeklyController {

    private final TimesheetBiweeklyService timesheetBiweeklyService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody TimesheetBiweeklyPayload payload) {
        return TwOutputUtil.ok(timesheetBiweeklyService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetBiweeklyPayload payload) {
        return TwOutputUtil.ok(timesheetBiweeklyService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(timesheetBiweeklyService.queryByKey(key));
    }

    /**
     * 提交给我的周报分页、我提交的周报 数据权限
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    //@ReSubmitCheck(argExpressions = {"[0].createUserId", "[0].tsbBuId"}, interval = 1, message = "请勿重复提交")
    public TwOutputUtil paging(TimesheetBiweeklyQuery query) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        query.setUserId(loginUserId);
        return TwOutputUtil.ok(timesheetBiweeklyService.paging(query));
    }

    /**
     * 我提交的周报分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging/my")
    @UdcNameClass
    public TwOutputUtil pagingMy(TimesheetBiweeklyQuery query) {
        query.setCreateUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok(timesheetBiweeklyService.paging(query));
    }

    /**
     * 查询列表 数据权限
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    public TwOutputUtil queryList(TimesheetBiweeklyQuery query) {
        query.setReceiveUserIds(GlobalUtil.getLoginUserId() + "");
        return TwOutputUtil.ok(timesheetBiweeklyService.queryList(query));
    }


    /**
     * 我提交的周报 查询列表 数据权限
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list/my")
    @UdcNameClass
    public TwOutputUtil queryListMy(TimesheetBiweeklyQuery query) {
        query.setCreateUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok(timesheetBiweeklyService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        timesheetBiweeklyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
