package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetPlanService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 工时-工作计划
 *
 * @author duwh
 * @date 2022-12-09
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/my/timesheetPlan")
@Slf4j
public class TimesheetPlanController {

    private final TimesheetPlanService timesheetPlanService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody TimesheetPlanPayload payload) {
        return TwOutputUtil.ok(timesheetPlanService.insert(payload));
    }

    /**
     * 批量新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/batchInsert")
    public TwOutputUtil batchInsert(@RequestBody TimesheetPlanListPayload payload) {
        return TwOutputUtil.ok(timesheetPlanService.batchInsert(payload));
    }

    /**
     * 复制上周计划
     *
     * @param date 日期  "2022-12-24"
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/copyLastWeek")
    public TwOutputUtil copyLastWeek(String date) {
        return TwOutputUtil.ok(timesheetPlanService.copyLastWeek(date));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetPlanPayload payload) {
        return TwOutputUtil.ok(timesheetPlanService.update(payload));
    }

    /**
     * 项目和任务列表
     *
     * @param keyword 关键字
     * @param type  PROJ 查项目 TASK 查任务
     * @param test  true 可以查看接宝人不是自己的数据
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/listProjAndTask")
    // @UdcNameClass
    public TwOutputUtil listProjAndTask(String keyword,String type,boolean test) {
        test = false;
        return TwOutputUtil.ok(timesheetPlanService.listProjAndTask(keyword,type,test));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(timesheetPlanService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    public TwOutputUtil paging(TimesheetPlanQuery query) {
        query.setTsUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok(timesheetPlanService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    public TwOutputUtil queryList(TimesheetPlanQuery query) {
        query.setTsUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok(timesheetPlanService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        timesheetPlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
