package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QProjectDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTaskDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

/**
 * @author zoey
 * @Description:
 * @date 2023/2/17 - 15:12
 */
@Repository
@RequiredArgsConstructor
public class TimesheetDAO {
    private static final QTimesheetDO qdo = QTimesheetDO.timesheetDO;
    private static final QPrdOrgEmployeeDO edo = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private static final QTaskDO tdo = QTaskDO.taskDO;
    private static final QProjectDO pdo = QProjectDO.projectDO;
    private static final QPrdOrgOrganizationDO odo = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TimesheetVO> getJpaQuerySelect() {
        JPAQuery<TimesheetVO> jpaQuery = jpaQueryFactory.select(Projections.bean(TimesheetVO.class,
                qdo.id,
                qdo.tsUserId,
                qdo.tsUserBuId,
                qdo.tsUserBuName,
                qdo.tsStatus,
                qdo.type,
                qdo.apprUserId,
                qdo.operPlanId,
                qdo.operPlanName,
                qdo.projId,
                qdo.projName,
                qdo.taskId,
                qdo.taskNo,
                qdo.taskName,
                qdo.taskApplyStatus,
                qdo.actId,
                qdo.actName,
                qdo.actNo,
                qdo.eqva,
                qdo.workType,
                qdo.workDate,
                qdo.workHour,
                qdo.workDesc,
                qdo.weekStartDate,
                qdo.yearWeek,
                qdo.totalManday,
                qdo.totalWorkHour,
                qdo.apprStatus,
                qdo.tsTaskIden,
                qdo.tsActIden,
                qdo.settleStatus,
                qdo.apprResult,
                qdo.workFlag,
                qdo.workDayOff,
                qdo.workRelId,
                qdo.workDayOffStatus,
                qdo.workPlanId,
                qdo.approvalTime,
                qdo.submitTime,
                qdo.autoSaveFlag,
                qdo.autoUpdateFlag,
                qdo.procId,
                qdo.ext1,
                qdo.ext2,
                qdo.ext3,
                qdo.ext4,
                qdo.ext5,
                edo.extString5.as("baseCityId"),
                pdo.productNo,
                odo.id.as("expenseBuId")
        )).from(qdo)
                .leftJoin(edo).on(qdo.tsUserId.longValue().eq(edo.userId.longValue()))
                .leftJoin(pdo).on(qdo.projId.longValue().eq(pdo.projIdV4.longValue()))
                .leftJoin(tdo).on(qdo.taskId.longValue().eq(tdo.taskIdV4.longValue()))
                .leftJoin(odo).on(odo.orgIdV4.longValue().eq(tdo.expenseBuId.longValue()));
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TimesheetVO> getJpaQueryWhere(TimesheetQuery query) {
        JPAQuery<TimesheetVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getActName())) {
            jpaQuery.where(qdo.actName.like(query.getActName()));
        }
        if (!ObjectUtils.isEmpty(query.getTaskName())) {
            jpaQuery.where(qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())));
        }
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            jpaQuery.where(qdo.projId.eq(query.getProjId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsUserId())) {
            jpaQuery.where(qdo.tsUserId.eq(query.getTsUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsUserBuId())) {
            jpaQuery.where(qdo.tsUserBuId.eq(query.getTsUserBuId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsStatus())) {
            jpaQuery.where(qdo.tsStatus.eq(query.getTsStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getApprUserId())) {
            jpaQuery.where(qdo.apprUserId.eq(query.getApprUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsUserIdList())) {
            jpaQuery.where(qdo.tsUserId.in(query.getTsUserIdList()));
        }
        if (!ObjectUtils.isEmpty(query.getBaseCityId())) {
            jpaQuery.where(edo.extString5.eq(query.getBaseCityId().toString()));
        }
        if (!ObjectUtils.isEmpty(query.getApprUserId())) {
            jpaQuery.where(qdo.apprUserId.eq(query.getApprUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getTsUserIdList())) {
            jpaQuery.where(qdo.tsUserId.in(query.getTsUserIdList()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TimesheetVO> queryPaging(TimesheetQuery query) {
        JPAQuery<TimesheetVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<TimesheetVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<TimesheetVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }
}
