package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 工时用-项目表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Entity
@Table(name = "t_project", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_project", comment = "工时用-项目表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProjectDO extends BaseModel {
    /**
     * 4.0项目主键
     */
    @Comment("4.0项目主键")
    @Column(name = "proj_id_v4")
    private Long projIdV4;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projName;
    /**
     * 项目编号
     */
    @Comment("项目编号")
    @Column()
    private String projNo;
    /**
     * 项目状态
     */
    @Comment("项目状态")
    @Column()
    private String projStatus;
    /**
     * 合同id
     */
    @Comment("合同id")
    @Column()
    private Integer contractId;
    /**
     * 合同id
     */
    @Comment("4.0合同id")
    @Column(name = "contract_id_v4")
    private Long contractIdV4;
    /**
     * 关联项目编号
     */
    @Comment("关联项目编号")
    @Column()
    private String relatedProjNo;
    /**
     * 产品编号
     */
    @Comment("产品编号")
    @Column()
    private String productNo;

    /**
     * 项目经理
     */
    @Comment("项目经理")
    @Column()
    private Long pmUserId;

    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /**
     * 拓展4
     */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /**
     * 拓展5
     */
    @Comment("拓展5")
    @Column()
    private String ext5;

    public void copy(ProjectDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }


}
