package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务包授权主表
 *
 * @author duwh
 * @date 2022-12-16
 */
@Entity
@Table(name = "t_task_authorized", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_task_authorized", comment = "任务包授权主表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskAuthorizedDO extends BaseModel {

    /**
     * 4.0的授权id
     */
    @Comment("名称")
    @Column()
    private Long taskAuthorizedV4;

    /**
     * 名称
     */
    @Comment("名称")
    @Column()
    private String name;
    /**
     * 编号
     */
    @Comment("编号")
    @Column()
    private String authorizedNo;
    /**
     * 派发资源resid
     */
    @Comment("派发资源resid")
    @Column()
    private Long disterResId;
    /**
     * 派发资源userId v5
     */
    @Comment("派发资源userId v5")
    @Column()
    private Long disterUserId;
    /**
     * 接收资源resid
     */
    @Comment("接收资源resid")
    @Column()
    private Long receiverResId;
    /**
     * 接收资源userId v5
     */
    @Comment("接收资源userId v5")
    @Column()
    private Long receiverUserId;
    /**
     * 接收资源buid
     */
    @Comment("接收资源buid")
    @Column()
    private Long receiverBuId;
    /**
     * 接收资源组织id v5
     */
    @Comment("接收资源组织id v5")
    @Column()
    private Long receiverOrgId;
    /**
     * 资源来源类型(合作类型)
     */
    @Comment("资源来源类型(合作类型)")
    @Column()
    private String resSourceType;
    /**
     * 验收方式
     */
    @Comment("验收方式")
    @Column()
    private String acceptMethod;
    /**
     * 计价方式
     */
    @Comment("计价方式")
    @Column()
    private String pricingMethod;
    /**
     * 事由类型
     */
    @Comment("事由类型")
    @Column()
    private String reasonType;
    /**
     * 事由号
     */
    @Comment("事由号")
    @Column()
    private Long reasonId;
    /**
     * 事由号5.0主键
     */
    @Comment("事由号5.0主键")
    @Column()
    private Long reasonIdV5;
    /**
     * 费用承担bu
     */
    @Comment("费用承担bu")
    @Column()
    private Long expenseBuId;
    /**
     * 费用承担组织id v5
     */
    @Comment("费用承担组织id v5")
    @Column()
    private Long expenseOrgId;
    /**
     * 授权总当量
     */
    @Comment("授权总当量")
    @Column()
    private BigDecimal authEqva;
    /**
     * 已发当量
     */
    @Comment("已发当量")
    @Column()
    private BigDecimal useEqva;
    /**
     * 已发任务包数
     */
    @Comment("已发任务包数")
    @Column()
    private Integer useCount;
    /**
     * 工时、结算审批人是项目经理[pm]or授权资源[pl]
     */
    @Comment("工时、结算审批人是项目经理[pm]or授权资源[pl]")
    @Column()
    private String approvedType;
    /**
     * 计划开始时间
     */
    @Comment("计划开始时间")
    @Column()
    private LocalDate planStartDate;
    /**
     * 计划结束时间
     */
    @Comment("计划结束时间")
    @Column()
    private LocalDate planEndDate;
    /**
     * 完工附件上传方法
     */
    @Comment("完工附件上传方法")
    @Column()
    private String attachuploadMethod;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 申请状态
     */
    @Comment("申请状态")
    @Column()
    private String applyStatus;
    /**
     * 是否授权接收人操作资源规划标志 0:不可操作,1:可操作
     */
    @Comment("是否授权接收人操作资源规划标志 0:不可操作,1:可操作")
    @Column()
    private Boolean authResPlanFlag;

    public void copy(TaskAuthorizedDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
