package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 任务包授权主表
 *
 * @author duwh
 * @date 2022-12-16
 */
@Entity
@Table(name = "t_task_authorized_details", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_task_authorized_details", comment = "任务包授权主表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskAuthorizedDetailsDO extends BaseModel {
    /**
     * 4.0的授权详情id
     */
    @Comment("名称")
    @Column()
    private Long taskAuthorizedDetailIdV4;

    /**
     * 授权主键 t_task_authorized.id
     */
    @Comment("授权主键 t_task_authorized.id")
    @Column()
    private Long authId;
    /**
     * 授权主键 t_task_authorized.id
     */
    @Comment("授权主键 t_task_authorized.id")
    @Column()
    private Long authIdV5;
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column()
    private Long taskId;
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column()
    private Long taskIdV5;
    /**
     * 接收资源resid
     */
    @Comment("接收资源resid")
    @Column()
    private Long receiverResId;
    /**
     * 接收资源userId v5
     */
    @Comment("接收资源userId v5")
    @Column()
    private Long receiverUserId;
    /**
     * 接收资源buid
     */
    @Comment("接收资源buid")
    @Column()
    private Long receiverBuId;
    /**
     * 接收资源buid
     */
    @Comment("接收资源buid")
    @Column()
    private Long receiverOrgId;

    public void copy(TaskAuthorizedDetailsDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
