package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDate;

/**
 * 工时-双周计划表
 *
 * @author carl
 * @date 2022-12-19
 */
@Entity
@Table(name = "t_timesheet_biweekly", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_timesheet_biweekly", comment = "工时表-双周计划表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TimesheetBiweeklyDO extends BaseModel {

    /**
     * 填报用户id
     */
    @Comment("填报用户id")
    @Column()
    private Long tsUserId;
    /**
     * 标题
     */
    @Comment("标题")
    @Column()
    private String title;
    /**
     * 双周计划类型
     */
    @Comment("双周计划类型")
    @Column()
    private String tsbType;
    /**
     * 双周计划buid
     */
    @Comment("双周计划Buid")
    @Column()
    private Long tsbBuId;
    /**
     * 发送对象
     */
    @Comment("发送对象")
    @Column()
    private String receiveUserIds;
    /**
     * 本周开始日期
     */
    @Comment("本周开始日期")
    @Column()
    private LocalDate startWeekDate;
    /**
     * 本周结束日期
     */
    @Comment("本周结束日期")
    @Column()
    private LocalDate endWeekDate;
    /**
     * 是否已读
     */
    @Comment("是否已读 0未读  1已读")
    @Column()
    private Integer isRead;

    /**
     * 所在年周
     */
    @Comment("所在年周")
    @Column()
    private Integer yearWeek;

    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;


    public void copy(TimesheetBiweeklyDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
