package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 工时-工作计划
 *
 * @author duwh
 * @date 2022-12-09
 */
@Entity
@Table(name = "t_timesheet_plan", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_timesheet_plan", comment = "工时-工作计划")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TimesheetPlanDO extends BaseModel {
    /**
     * 填报用户id
     */
    @Comment("填报用户id")
    @Column()
    private Long tsUserId;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String tsStatus;
    /**
     * 类型
     */
    @Comment("类型")
    @Column()
    private String type;
    /**
     * 审批用户id
     */
    @Comment("审批用户id")
    @Column()
    private Long apprUserId;
    /**
     * 客户经营计划主键
     */
    @Comment("客户经营计划主键")
    @Column()
    private Long operPlanId;
    /**
     * 客户经营计划名称冗余
     */
    @Comment("客户经营计划名称冗余")
    @Column()
    private String operPlanName;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /**
     * 项目编号冗余
     */
    @Comment("项目编号冗余")
    @Column()
    private String projNo;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projName;
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column()
    private Long taskId;
    /**
     * 任务编号冗余
     */
    @Comment("任务编号冗余")
    @Column()
    private String taskNo;
    /**
     * 任务名称冗余
     */
    @Comment("任务名称冗余")
    @Column()
    private String taskName;
    /**
     * 任务包申请状态
     */
    @Comment("任务包申请状态")
    @Column()
    private String taskApplyStatus;
    /**
     * 活动id
     */
    @Comment("活动id")
    @Column()
    private Long actId;
    /**
     * 活动名称冗余
     */
    @Comment("活动名称冗余")
    @Column()
    private String actName;
    /**
     * 活动编号冗余
     */
    @Comment("活动编号冗余")
    @Column()
    private String actNo;
    /**
     * 当量
     */
    @Comment("当量")
    @Column()
    private BigDecimal eqva;
    /**
     * 11上午、22下午、33全天、44自定义
     */
    @Comment("11上午、22下午、33全天、44自定义")
    @Column()
    private String workType;
    /**
     * 工作日期
     */
    @Comment("工作日期")
    @Column()
    private LocalDate workDate;
    /**
     * 工时
     */
    @Comment("工时")
    @Column()
    private BigDecimal workHour;
    /**
     * 工作说明
     */
    @Comment("工作说明")
    @Column()
    private String workDesc;
    /**
     * 本周开始日期
     */
    @Comment("本周开始日期")
    @Column()
    private LocalDate weekStartDate;
    /**
     * 所在年周
     */
    @Comment("所在年周")
    @Column()
    private Integer yearWeek;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 任务标识
     */
    @Comment("任务标识")
    @Column()
    private String tsTaskIden;
    /**
     * 活动标识
     */
    @Comment("活动标识")
    @Column()
    private String tsActIden;
    /**
     * 结算状态
     */
    @Comment("结算状态")
    @Column()
    private String settleStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprResult;
    /**
     * 是否加班、udc >> yesno
     */
    @Comment("是否加班、udc >> yesno")
    @Column()
    private String workFlag;
    /**
     * 可生成调休天数
     */
    @Comment("可生成调休天数")
    @Column()
    private Float workDayOff;
    /**
     * 相关加班安排id
     */
    @Comment("相关加班安排id")
    @Column()
    private Integer workRelId;
    /**
     * 可生成调休天数的状态
     */
    @Comment("可生成调休天数的状态")
    @Column()
    private String workDayOffStatus;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDate approvalTime;
    /**
     * 提交时间
     */
    @Comment("提交时间")
    @Column()
    private LocalDate submitTime;
    /**
     * 是否是系统自动生成，0：否，1：是
     */
    @Comment("是否是系统自动生成，0：否，1：是")
    @Column()
    private Integer autoSaveFlag;
    /**
     * 请假流程覆盖已填写工时标记 默认0 已覆盖拆分 1
     */
    @Comment("请假流程覆盖已填写工时标记 默认0 已覆盖拆分 1")
    @Column()
    private Integer autoUpdateFlag;
    /**
     * 流程实例id
     */
    @Comment("流程实例id")
    @Column()
    private String procId;
    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /**
     * 拓展4
     */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /**
     * 拓展5
     */
    @Comment("拓展5")
    @Column()
    private String ext5;

    @Transient
    private Long workPlanId;

    /**
     * 工时id,仅用于类型转换
     */
    @Transient
    private Long timesheetId;

    /**
     * 上午or下午
     */
    private String vInterval;

    public void copy(TimesheetPlanDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
