package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 工作计划模板
 *
 * @author duwh
 * @date 2022-12-15
 */
@Entity
@Table(name = "t_timesheet_plan_temp", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_timesheet_plan_temp", comment = "工作计划模板")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TimesheetPlanTempDO extends BaseModel {

    /**
     * 工作计划主键
     */
    @Comment("工作计划主键")
    @Column()
    private Long planId;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String status;
    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /**
     * 拓展4
     */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /**
     * 拓展5
     */
    @Comment("拓展5")
    @Column()
    private String ext5;
    /**
     * 类型 PROJ 项目 TASK 任务 OPER 经营类项目
     */
    @Comment("类型 PROJ 项目 TASK 任务 OPER 经营类项目")
    @Column()
    private String type;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /** 4.0项目id */
    //@Comment("4.0项目id")
    //@Column()
    //private Long projIdV4;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projName;
    /**
     * 项目编号
     */
    @Comment("项目编号")
    @Column()
    private String projNo;
    /** 4.0任务id */
    //@Comment("4.0任务id")
    //@Column()
    //private Long taskIdV4;
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column()
    private Long taskId;
    /**
     * 任务编号
     */
    @Comment("任务编号")
    @Column()
    private String taskNo;
    /**
     * 任务编号
     */
    @Comment("任务编号")
    @Column()
    private String taskName;
    /**
     * 任务包申请状态
     */
    @Comment("任务包申请状态")
    @Column()
    private String taskApplyStatus;
    /**
     * 任务当量
     */
    @Comment("任务当量")
    @Column()
    private BigDecimal eqvaQty;
    /**
     * 活动id
     */
    @Comment("活动id")
    @Column()
    private Long actId;
    /**
     * 活动名称冗余
     */
    @Comment("活动名称冗余")
    @Column()
    private String actName;
    /**
     * 活动编号冗余
     */
    @Comment("活动编号冗余")
    @Column()
    private String actNo;

    public void copy(TimesheetPlanTempDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
