package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.ProjectDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 工时用-项目表
 *
 * @author duwh
 * @date 2022-12-09
 */
public interface ProjectRepo extends JpaRepository<ProjectDO, Long>, JpaSpecificationExecutor<ProjectDO> {

    List<ProjectDO> queryByProjIdV4In(List<Long> v4ProjectIds);

    @Query("select p.id from ProjectDO p where p.projIdV4=?1 and p.deleteFlag=0")
    Long queryProjectIdByV4(Long reasonId);

    @Query("select p.projIdV4 from ProjectDO p where p.id=?1 and p.deleteFlag=0")
    Long queryByProjectIdV4(Long reasonId);

    Optional<ProjectDO> findByProjIdV4(Long projIdV4);

    @Query("select id as projectId,projIdV4 as projectIdV4 from ProjectDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5ProjectIds();


    ProjectDO getByProjIdV4(Long projIdV4);
}
