package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.TaskAuthorizedDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Map;

/**
* 任务包授权主表
*
* @author duwh
* @date 2022-12-16
*/
public interface TaskAuthorizedRepo extends JpaRepository<TaskAuthorizedDO, Long>, JpaSpecificationExecutor<TaskAuthorizedDO> {

    List<TaskAuthorizedDO> queryByTaskAuthorizedV4In(List<Long> tw4TaskAuthorizedIds);

    @Query("select id as authId,taskAuthorizedV4 as authIdV4 from TaskAuthorizedDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5AuthIds();
}
