package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
* 工时表
*
* @author duwh
* @date 2022-12-09
*/
public interface TimesheetRepo extends JpaRepository<TimesheetDO, Long>, JpaSpecificationExecutor<TimesheetDO> {

    @Query(value = "update TimesheetDO set taskId = ?2,taskNo= ?3,taskName = ?4,actId=?5,actNo=?6,actName=?7 where  id =?1")
    @Modifying
    void updateByTaskId(Long timesheetId, Long taskIdV4,String taskNo,String taskName,Long actIdV4,String actNo,String actName);

    //特别注意：必须使用List<Object[]>接收
    @Query(value = "SELECT GROUP_CONCAT(id) AS groupIds,SUM(work_hour) as workHour," +
        " proj_id as projId, proj_no as projNo,proj_name as projName, " +
        " ts_status as tsStatus, appr_user_id as apprUserId,week_start_date as weekStartDate, " +
        " task_id as taskId,task_no as taskNo, task_name as taskName, " +
        " ts_user_id as tsUserId,ts_user_bu_id as tsUserBuId, ts_user_bu_name as tsUserBuName " +
        " FROM t_timesheet where delete_flag = 0 " +
        " and  if(?1 != NULL or ?1!='',ts_user_id=?1,1=1) " +
        " and  if(?2 != NULL or ?2!='',appr_user_id=?2,1=1) " +
        " and  if(?3 != NULL or ?3!='',ts_status=?3,1=1) " +
        " and  if(?4 != NULL or ?4!='',ts_user_bu_id=?4,1=1) " +
        " and  if(?5 != NULL ,timesheet_id_v4 is null,1=1) " +
        "  GROUP BY proj_id,year_week,ts_user_id,ts_status " +
        "  order by year_week desc,ts_user_id asc " ,
        countQuery = "select count(*) " +
            " FROM t_timesheet  where delete_flag = 0 " +
                " and  if(?1 != NULL or ?1!='',ts_user_id=?1,1=1) " +
            " and  if(?2 != NULL or ?2!='',appr_user_id=?2,1=1) " +
            " and  if(?3 != NULL or ?3!='',ts_status=?3,1=1) " +
            " and  if(?4 != NULL or ?4!='',ts_user_bu_id=?4,1=1) " +
            " and  if(?5 != NULL,timesheet_id_v4 is null,1=1) " +
            "  GROUP BY proj_id,year_week,ts_user_id,ts_status " ,
        nativeQuery = true)
    Page<Object[]> pagingGroup(Long tsUserId, Long apprUserId, String tsStatus,Long tsUserBuId,Boolean timesheetIdV4IsNull,Pageable pageable);

    @Query(value = "select * from t_timesheet e where e.modify_time>?1 and (e.ts_task_iden is null or e.ts_task_iden <> 'VACATION')", nativeQuery = true)
    List<TimesheetDO> findByModifyTimeAfter(LocalDateTime time);

    @Query(value = "select * from t_timesheet e where e.modify_time>?1 and e.proj_id=?2 and e.delete_flag = 0 and e.ts_status<>'CREATE'", nativeQuery = true)
    List<TimesheetDO> findByProjectIdAndModifyTimeAfter(LocalDateTime time,Long projectId);

    List<TimesheetDO> queryByTimesheetIdV4In(List<Long> tw4TimesheetIds);

    @Query("select id as timesheetId,workPlanId as workPlanId from TimesheetDO where deleteFlag=0")
    List<Map<String, Object>> getTimesheetAndPlanIds();

    @Query(value = "update TimesheetDO set workPlanId = ?2 where  id =?1")
    @Modifying
    void updatePlan(Long timesheetId,Long planId);

    @Query("select id as timesheetId,timesheetIdV4 as timesheetIdV4 from TimesheetDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5TimesheetIds();
}
