package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.query.PrdUserMessageQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserMessageService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.system.service.PrdMessageConfigServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserMessageDAO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 菜单管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdUserMessageServiceImpl implements PrdUserMessageService {
    private final PrdUserMessageDAO dao;
    private final CacheUtil cacheUtil;
    private final PrdMessageConfigServiceImpl service;

    @Override
    public Long queryTotal() {
        return dao.queryTotal(GlobalUtil.getLoginUserId());
    }

    @Transactional
    @Override
    public boolean deleteSoft(List<Long> keys) {

        dao.deleteSoft(keys, GlobalUtil.getLoginUserId());
        return true;
    }

    @Transactional
    @Override
    public PrdUserMessageVO queryByKey(Long key) {
        PrdUserMessageVO messageVO = dao.queryByKey(key);
        transferSystemSelection(messageVO);
        String name = service.getNoticeSourceName(messageVO.getMessageId(), messageVO.getNoticeScope(), messageVO.getNoticeSource());
        messageVO.setNoticeSourceName(name);
        if (messageVO.getMessageStatus() == 0) {
            List<Long> keys = new ArrayList<>();
            keys.add(key);

            dao.updateStatus(keys, GlobalUtil.getLoginUserId());
        }
        return messageVO;
    }

    @Override
    public PagingVO<PrdUserMessageVO> paging(PrdUserMessageQuery query) {

        PagingVO<PrdUserMessageVO> messageVOPagingVO = dao.queryPaging(query, GlobalUtil.getLoginUserId());
        List<PrdUserMessageVO> configVOS = messageVOPagingVO.getRecords();
        configVOS.forEach(configVO -> transferSystemSelection(configVO));
        return messageVOPagingVO;
    }

    @Transactional
    @Override
    public boolean onKeyUpdateStatus(List<Long> keys) {
        dao.updateStatus(keys, GlobalUtil.getLoginUserId());
        return true;
    }

    void transferSystemSelection(PrdUserMessageVO vo) {
        vo.setContentTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentType.getCode(), vo.getContentType()));
        vo.setContentBigTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.ContentBigType.getCode(), vo.getContentBigType()));
        vo.setMessageTagName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.MessageTag.getCode(), vo.getMessageTag()));
        vo.setNoticeScopeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.NoticeScope.getCode(), vo.getNoticeScope()));
    }
}
