package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.param.SysPasswordUpdate;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserRemindVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TwRecentWorkVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.SpelUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RemindTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationChanceDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5crm.api.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskEvalStatusEnum;
import com.elitesland.tw.tw5crm.server.common.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5crm.server.visit.dao.VisitTaskDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 菜单管理service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdUserServiceImpl implements PrdUserService {
    private final PrdUserDAO dao;
    private final CrmCustomerOperationChanceDAO customerOperationChanceDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PrdSystemProblemFeedbackService prdSystemProblemFeedbackService;
    private final CrmActActivityService activityservice;
    private final CrmLeadsService crmLeadsService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final VisitTaskDAO visitTaskDAO;
    private final PrdSystemRoleDAO systemRoleDAO;
    @Autowired
    private SysUserRpcService sysUserService;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    @Value("${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;


    @Transactional
    @Override
    public PrdUserDataVO queryUserDetail() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataVO vo = dao.queryUserDetail(userId);
        vo.setHeadDatas(fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setOrgRoles(dao.queryRolesById(userId + ""));
        List<PrdSystemShortcutVO> shortcutVOs = dao.queryShortcutList();
        if (!CollectionUtils.isEmpty(shortcutVOs)) {
            if (StringUtils.hasText(vo.getShortcutIds())) {
                shortcutVOs.forEach(shortcutVO -> {
                        if (vo.getShortcutIds().contains(shortcutVO.getId() + "")) {
                            shortcutVO.setIsMy(0);
                        }
                    }
                );
            }
            vo.setShortcutVOs(shortcutVOs);
        }
        String ticket = UUID.randomUUID().toString();
        vo.setTicket(new String(Base64.encodeBase64(ticket.getBytes())));
        transferSystemSelection(vo);
        dao.updateTicket(vo.getId(), ticket);
        vo.setWorkflowEnabled(workflow_enabled);
        return vo;
    }

    @Transactional
    @Override
    public Long updateShortcut(String shortcutIds) {
        Long userId = GlobalUtil.getLoginUserId();
        return dao.updateShortcut(userId, shortcutIds);
    }

    @Override
    public void updatePassword(String oldPassword, String newPassword) {
        if (StringUtils.hasText(oldPassword) && StringUtils.hasText(newPassword)) {
            Long userId = GlobalUtil.getLoginUserId();
            SysPasswordUpdate passwordUpdate = new SysPasswordUpdate();
            passwordUpdate.setUserId(userId);
            passwordUpdate.setCurrentPassword(new String(Base64.encodeBase64(oldPassword.getBytes())));
            passwordUpdate.setNewPassword(new String(Base64.encodeBase64(newPassword.getBytes())));
            sysUserService.updatePassword(passwordUpdate);
        } else {
            throw TwException.error("", "无效的密码");
        }

    }

    @Override
    public List<TwRecentWorkVO> findMyWork() {
        Long userId = GlobalUtil.getLoginUserId();
        List<TwRecentWorkVO> recentWorkVOList = new ArrayList<>();
        //TODO 具体的配置
        //经营机会点待跟踪
        customerOperationChance(recentWorkVOList, userId);
        //活动待发布
        activityRelease(recentWorkVOList, userId);
        //问题反馈
        problemFeedback(recentWorkVOList, userId);
        //待领取线索
        leadsToReceive(recentWorkVOList, userId);
        //待分配线索
        leadsToDistribute(recentWorkVOList, userId);
        //经营计划待执行  执行者为当量登录人 未读的经营计划任务
        operationPlanDetail(recentWorkVOList, userId);
        // 待办拜访任务
        visitTask(recentWorkVOList, userId);
        // 待办拜访评价
        visitTaskEval(recentWorkVOList, userId);

        return recentWorkVOList;
    }


    @Override
    public List<PrdUserRemindVO> findMyRemind() {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();

        List<PrdUserRemindVO> resRemindVOS = new ArrayList<>();
        List<PrdUserRemindVO> remindVOS = dao.queryReminds(userId);
        for (PrdUserRemindVO remindVO : remindVOS) {
            if (remindVO.getNoRemindDate() == null || !remindVO.getNoRemindDate().equals(newDate)) {
                String remindType = remindVO.getRemindType();
                //待领取线索
                if (remindType.equals(RemindTypeEnum.RECEIVED_LEAD.getCode())) {
                    long num = crmLeadsService.countNotReceivedLeadsByUserId(userId);
                    if (num > 0) {
                        Map<String, Object> map = new HashMap<>();
                        map.put("num", num);
                        String remindContent = SpelUtil.parseStringExpression(remindVO.getRemindContent(), map);
                        remindVO.setRemindContent(remindContent);
                        resRemindVOS.add(remindVO);
                    }
                }
                //待发布活动
                if (remindType.equals(RemindTypeEnum.ACTIVITY_UNRELEASE.getCode())) {
                    Map<String, Object> objectMap = activityservice.findActivityUnReleaseByUserId(userId);
                    Long num = (Long) objectMap.get("num");
                    if (num > 0) {
                        Map<String, Object> map = new HashMap<>();
                        map.put("num", num);
                        String remindContent = SpelUtil.parseStringExpression(remindVO.getRemindContent(), map);
                        remindVO.setRemindContent(remindContent);
                        remindVO.setSurplusTime(objectMap.get("time") + "");
                        resRemindVOS.add(remindVO);

                    }

                }

            }
        }
        return resRemindVOS;
    }

    @Transactional
    @Override
    public Boolean updateMyRemind(String remindType) {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();
        PrdUserRemindDO userRemindDO = dao.queryUserRemind(userId, remindType);
        if (userRemindDO == null) {
            userRemindDO = new PrdUserRemindDO();
            userRemindDO.setRemindType(remindType);
            userRemindDO.setUserId(userId);
        }
        userRemindDO.setNoRemindDate(newDate);
        dao.saveUserRemind(userRemindDO);
        return true;
    }

    @Override
    public void queryUserByTicket(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter("ticket");
        //对获取的加密的token进行解密：使用 Base64
        if (ticket != null && !ticket.isEmpty()) {
            ticket = new String(Base64.decodeBase64(ticket.getBytes()));
        }
        Map<String, Object> paramMap = new HashMap<>();
        JSONObject jsonObject = null;
        HttpSession session = request.getSession();
//        通过ticket查询用户信息
        PrdUserDataVO info = dao.queryUserByTicket(ticket);
        try {
            if (info == null) {
                paramMap.put("el-result-cod", "NG_UNSUPPORTED");
                paramMap.put("statusCode", "401");
                jsonObject = new JSONObject(paramMap);
                response.setStatus(401);
                session.setAttribute("paramMap", paramMap);
            }
            paramMap.put("app_login_type", "SSO");
            paramMap.put("app_login_id", info.getId());
            paramMap.put("app_login_email", info.getEmail());
            paramMap.put("app_login_ticket", ticket);
            paramMap.put("el-result-cod", "OK");
            paramMap.put("statusCode", "200");
            jsonObject = new JSONObject(paramMap);
            response.setStatus(200);
            session.setAttribute("paramMap", paramMap);
            response.getWriter().print(jsonObject);
        } catch (NullPointerException e) {
            try {
                response.getWriter().print(jsonObject);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<PrdOrgDataRefVO> queryOrgList() {
        Long userId = GlobalUtil.getLoginUserId();
        return dao.queryOrgListByKey(userId);
    }

    @Override
    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId) {
        Long userId = GlobalUtil.getLoginUserId();
        return dao.queryLowListByKey(orgId, userId);
    }

    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @Override
    public List<PrdSystemMenuVO> queryMenus() {
        List<PrdSystemMenuVO> menuVOS = dao.queryUsableList();

        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();

        //List<Long> saleAdminUserIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
        // Boolean sysRole = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (loginGeneralUser.isSystemAdmin()) {
            return menuVOS;
        }
        if (loginGeneralUser.isTenantAdmin()) {
            return menuVOS.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        List<Long> userMenuIds = dao.queryUserMenuIds(loginGeneralUser.getUserId());
//        if (userId.longValue() == 356948235909079040L) {
//            return menuVOS;
//        }
        return menuVOS.stream().filter(menuVO -> userMenuIds.indexOf(menuVO.getId()) >= 0).collect(Collectors.toList());
    }

    private void customerOperationChance(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        CrmCustomerOperationChanceQuery query = new CrmCustomerOperationChanceQuery();
        query.setTrackerUserId(userId);

        query.setIsRead(0);
        query.setNoPermissionFlag(true);
        PagingVO<CrmCustomerOperationChanceVO> paging = customerOperationChanceDAO.paging(query);
        final Long total = paging.getTotal();
        if (total.compareTo(0L) != 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("经营机会点待跟踪", total, TwRecentWorkVO.RecentWorkType.OPERATION_CHANCE_DETAIL.getCode()));
        }
    }

    //活动待发布
    private void activityRelease(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        Map<String, Object> objectMap = activityservice.findActivityUnReleaseByUserId(userId);
        final long num = (Long) objectMap.get("num");
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("活动待发布", num, TwRecentWorkVO.RecentWorkType.ACTIVITY_RELEASE.getCode()));
        }
    }

    //问题反馈
    private void problemFeedback(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        final long num = prdSystemProblemFeedbackService.findWorkProblemFeedbackByUserId(userId);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("问题反馈", num, TwRecentWorkVO.RecentWorkType.FEED_BACK.getCode()));
        }
    }

    //待接收线索
    private void leadsToReceive(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        final long num = crmLeadsService.countNotReceivedLeadsByUserId(userId);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("待领取线索", num, TwRecentWorkVO.RecentWorkType.LEADS_TO_RECEIVE.getCode()));
        }
    }

    //待分配线索
    private void leadsToDistribute(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        final long num = crmLeadsService.countNotDistributedLeadsByUserId(userId);
        if (num > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of("线索待分配", num, TwRecentWorkVO.RecentWorkType.LEADS_TO_DISTRIBUTE.getCode(), "/leadsManager/offshore"));
        }
    }

    /**
     * 经营计划待执行  执行者为当量登录人 未读的经营计划任务
     *
     * @param recentWorkVOList 待办集合
     * @param userId           用户id
     */
    private void operationPlanDetail(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        CrmOperationPlanDetailQuery planDetailQuery = new CrmOperationPlanDetailQuery();
        // 执行者
        planDetailQuery.setPerformerId(userId);
        // 未读
        planDetailQuery.setReadFlag(0);
        final long count = crmOperationPlanDetailService.count(planDetailQuery);
        if (count > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.OPERATION_PLAN_DETAIL.getDesc(), count, TwRecentWorkVO.RecentWorkType.OPERATION_PLAN_DETAIL.getCode(), "/leadsManager/offshore"));
        }
    }

    /**
     * 待办拜访任务
     *
     * @param recentWorkVOList 待办集合
     * @param userId           用户id
     */
    private void visitTask(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        taskQuery.setVisitMemberId(userId);
        List<String> statusList = new ArrayList<>();
        statusList.add(VisitTaskStatusEnum.NEW.getCode());
        statusList.add(VisitTaskStatusEnum.READY.getCode());
        taskQuery.setStatusList(statusList);
        taskQuery.setRemindTime(LocalDateTime.now());
        final long count = visitTaskDAO.done(taskQuery);
        if (count > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.VISIT_TASK.getDesc(), count, TwRecentWorkVO.RecentWorkType.VISIT_TASK.getCode(), "/visit/task"));
        }
    }

    /**
     * 待办拜访评价
     *
     * @param recentWorkVOList 待办集合
     * @param userId           用户id
     */
    private void visitTaskEval(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();

        // 实时查询下级
        // 查找下级
        final Set<Long> subordinatesIdsByUserId = prdOrgEmployeeService.queryOneSubordinatesIdsByUserId(userId);
        if (CollectionUtils.isEmpty(subordinatesIdsByUserId)) {
            return;
        }
        taskQuery.setEvalSubordinatesIds(subordinatesIdsByUserId);

        // 冗余方式查询  上级更换后，不会生效
        //taskQuery.setVisitMemberParentId(userId);

        taskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
        taskQuery.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
        final long count = visitTaskDAO.count(taskQuery);
        if (count > 0) {
            recentWorkVOList.add(TwRecentWorkVO.of(TwRecentWorkVO.RecentWorkType.VISIT_TASK_EVAL.getDesc(), count, TwRecentWorkVO.RecentWorkType.VISIT_TASK_EVAL.getCode(), "/visit/task?eval=true"));
        }
    }

    //全局翻译
    void transferSystemSelection(PrdUserDataVO vo) {
        vo.setJobsName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
    }


}
