package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.ProjShPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjShQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ProjShService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjShVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.ProjShConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.ProjShDO;
import com.elitesland.tw.tw5.server.prd.my.repo.ProjShRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * 项目成员
 *
 * @author duh
 * @date 2022-12-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ProjShServiceImpl implements ProjShService {

    private final ProjShRepo projShRepo;

    @Override
    public PagingVO<ProjShVO> paging(ProjShQuery query) {
        Page<ProjShDO> page = projShRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(ProjShConvert.INSTANCE::toVo));
    }

    @Override
    public List<ProjShVO> queryList(ProjShQuery query) {
        return ProjShConvert.INSTANCE.toVoList(projShRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public ProjShVO queryByKey(Long key) {
        ProjShDO entity = projShRepo.findById(key).orElseGet(ProjShDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ProjShVO vo = ProjShConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProjShVO insert(ProjShPayload payload) {
        ProjShDO entityDo = ProjShConvert.INSTANCE.toDo(payload);
        return ProjShConvert.INSTANCE.toVo(projShRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ProjShVO update(ProjShPayload payload) {
        ProjShDO entity = projShRepo.findById(payload.getId()).orElseGet(ProjShDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ProjShDO entityDo = ProjShConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ProjShConvert.INSTANCE.toVo(projShRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<ProjShDO> optional = projShRepo.findById(id);
                if (!optional.isEmpty()) {
                    ProjShDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    projShRepo.save(entity);
                }
            });
        }
    }

    @Override
    public void download(List<ProjShVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (ProjShVO projSh : all) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("项目id", projSh.getProjId());
            map.put("项目id v5", projSh.getProjIdV5());
            map.put("角色", projSh.getRole());
            map.put("复合能力id", projSh.getCapasetLevelId());
            map.put("资源id", projSh.getResId());
            map.put("用户id v5", projSh.getUserId());
            map.put("预计开始日期", projSh.getPlanStartDate());
            map.put("预计结束日期", projSh.getPlanEndDate());
            map.put("规划当量", projSh.getPlanEqva());
            map.put("工作台默认显示", projSh.getWorkbenchFlag());
            map.put("客户结算价", projSh.getCustomerPrice());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}
