package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskAuthorizedPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedService;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TaskAuthorizedConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TaskAuthorizedDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskAuthorizedRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * 任务包授权主表
 *
 * @author duwh
 * @date 2022-12-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskAuthorizedServiceImpl implements TaskAuthorizedService {

    private final TaskAuthorizedRepo taskAuthorizedRepo;

    @Override
    public PagingVO<TaskAuthorizedVO> paging(TaskAuthorizedQuery query) {
        Page<TaskAuthorizedDO> page = taskAuthorizedRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TaskAuthorizedConvert.INSTANCE::toVo));
    }

    @Override
    public List<TaskAuthorizedVO> queryList(TaskAuthorizedQuery query) {
        return TaskAuthorizedConvert.INSTANCE.toVoList(taskAuthorizedRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public TaskAuthorizedVO queryByKey(Long key) {
        TaskAuthorizedDO entity = taskAuthorizedRepo.findById(key).orElseGet(TaskAuthorizedDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskAuthorizedVO vo = TaskAuthorizedConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskAuthorizedVO insert(TaskAuthorizedPayload payload) {
        TaskAuthorizedDO entityDo = TaskAuthorizedConvert.INSTANCE.toDo(payload);
        return TaskAuthorizedConvert.INSTANCE.toVo(taskAuthorizedRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskAuthorizedVO update(TaskAuthorizedPayload payload) {
        TaskAuthorizedDO entity = taskAuthorizedRepo.findById(payload.getId()).orElseGet(TaskAuthorizedDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskAuthorizedDO entityDo = TaskAuthorizedConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskAuthorizedConvert.INSTANCE.toVo(taskAuthorizedRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TaskAuthorizedDO> optional = taskAuthorizedRepo.findById(id);
                if (!optional.isEmpty()) {
                    TaskAuthorizedDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    taskAuthorizedRepo.save(entity);
                }
            });
        }
    }

    @Override
    public void download(List<TaskAuthorizedVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (TaskAuthorizedVO taskAuthorized : all) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("名称", taskAuthorized.getName());
            map.put("编号", taskAuthorized.getAuthorizedNo());
            map.put("派发资源resid", taskAuthorized.getDisterResId());
            map.put("派发资源userId v5", taskAuthorized.getDisterUserId());
            map.put("接收资源resid", taskAuthorized.getReceiverResId());
            map.put("接收资源userId v5", taskAuthorized.getReceiverUserId());
            map.put("接收资源buid", taskAuthorized.getReceiverBuId());
            map.put("接收资源组织id v5", taskAuthorized.getReceiverOrgId());
            map.put("资源来源类型(合作类型)", taskAuthorized.getResSourceType());
            map.put("验收方式", taskAuthorized.getAcceptMethod());
            map.put("计价方式", taskAuthorized.getPricingMethod());
            map.put("事由类型", taskAuthorized.getReasonType());
            map.put("事由号", taskAuthorized.getReasonId());
            map.put("事由号5.0主键", taskAuthorized.getReasonIdV5());
            map.put("费用承担bu", taskAuthorized.getExpenseBuId());
            map.put("费用承担组织id v5", taskAuthorized.getExpenseOrgId());
            map.put("授权总当量", taskAuthorized.getAuthEqva());
            map.put("已发当量", taskAuthorized.getUseEqva());
            map.put("已发任务包数", taskAuthorized.getUseCount());
            map.put("工时、结算审批人是项目经理[pm]or授权资源[pl]", taskAuthorized.getApprovedType());
            map.put("计划开始时间", taskAuthorized.getPlanStartDate());
            map.put("计划结束时间", taskAuthorized.getPlanEndDate());
            map.put("完工附件上传方法", taskAuthorized.getAttachuploadMethod());
            map.put("审批状态", taskAuthorized.getApprStatus());
            map.put("申请状态", taskAuthorized.getApplyStatus());
            map.put("是否授权接收人操作资源规划标志 0:不可操作,1:可操作", taskAuthorized.getAuthResPlanFlag());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }


    @Override
    public Map<Long, Long> getV4AndV5AuthIds() {
        Map<Long, Long> authMap = new HashMap<>();
        //查询用户列表
        List<Map<String, Object>> v4AndV5AuthIds = taskAuthorizedRepo.getV4AndV5AuthIds();
        for (Map<String, Object> v4AndV5AuthId : v4AndV5AuthIds) {
            Long authId = (Long) v4AndV5AuthId.get("authId");
            Long authIdV4 = (Long) v4AndV5AuthId.get("authIdV4");
            authMap.put(authIdV4, authId);
        }
        return authMap;
    }
}
