package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetBiweeklyDetailService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetBiweeklyDetailVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetBiweeklyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetBiweeklyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetBiweeklyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyDetailRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * 双周计划明细
 *
 * @author duwh
 * @date 2022-12-21
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TimesheetBiweeklyDetailServiceImpl implements TimesheetBiweeklyDetailService {

    private final TimesheetBiweeklyDetailRepo timesheetBiweeklyDetailRepo;
    private final JPAQueryFactory jpaQueryFactory;

    @Override
    public PagingVO<TimesheetBiweeklyDetailVO> paging(TimesheetBiweeklyDetailQuery query) {
        Page<TimesheetBiweeklyDetailDO> page = timesheetBiweeklyDetailRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetBiweeklyDetailConvert.INSTANCE::toVo));
    }

    @Override
    public List<TimesheetBiweeklyDetailVO> queryList(TimesheetBiweeklyDetailQuery query) {
        return TimesheetBiweeklyDetailConvert.INSTANCE.toVoList(timesheetBiweeklyDetailRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public TimesheetBiweeklyDetailVO queryByKey(Long key) {
        TimesheetBiweeklyDetailDO entity = timesheetBiweeklyDetailRepo.findById(key).orElseGet(TimesheetBiweeklyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TimesheetBiweeklyDetailVO vo = TimesheetBiweeklyDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetBiweeklyDetailVO insert(TimesheetBiweeklyDetailPayload payload) {
        TimesheetBiweeklyDetailDO entityDo = TimesheetBiweeklyDetailConvert.INSTANCE.toDo(payload);
        return TimesheetBiweeklyDetailConvert.INSTANCE.toVo(timesheetBiweeklyDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetBiweeklyDetailVO update(TimesheetBiweeklyDetailPayload payload) {
        TimesheetBiweeklyDetailDO entity = timesheetBiweeklyDetailRepo.findById(payload.getId()).orElseGet(TimesheetBiweeklyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TimesheetBiweeklyDetailDO entityDo = TimesheetBiweeklyDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetBiweeklyDetailConvert.INSTANCE.toVo(timesheetBiweeklyDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetBiweeklyDetailDO> optional = timesheetBiweeklyDetailRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetBiweeklyDetailDO entity = optional.get();
                    entity.setDeleteFlag(1);
                    timesheetBiweeklyDetailRepo.save(entity);
                }
            });
        }
    }

    @Override
    public void download(List<TimesheetBiweeklyDetailVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (TimesheetBiweeklyDetailVO timesheetBiweeklyDetail : all) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("双周计划id", timesheetBiweeklyDetail.getTsbId());
            map.put("项目名称", timesheetBiweeklyDetail.getProjectName());
            map.put("任务名称", timesheetBiweeklyDetail.getTaskName());
            map.put("活动名称", timesheetBiweeklyDetail.getActName());
            map.put("工作说明", timesheetBiweeklyDetail.getWorkDesc());
            map.put("所属日期", timesheetBiweeklyDetail.getTsbDate());
            map.put("拓展1", timesheetBiweeklyDetail.getExt1());
            map.put("拓展2", timesheetBiweeklyDetail.getExt2());
            map.put("拓展3", timesheetBiweeklyDetail.getExt3());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }

    /**
     * 根据主表id集合 逻辑删除数据
     *
     * @param tsbIds 双周计划主键集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByTsbIds(List<Long> tsbIds, String type) {
        if (!tsbIds.isEmpty()) {
            QTimesheetBiweeklyDetailDO qTimesheetBiweeklyDetailDO = QTimesheetBiweeklyDetailDO.timesheetBiweeklyDetailDO;
            JPAUpdateClause update = jpaQueryFactory.update(qTimesheetBiweeklyDetailDO)
                    .set(qTimesheetBiweeklyDetailDO.deleteFlag, 1)
                    .where(qTimesheetBiweeklyDetailDO.tsbId.in(tsbIds))
                    .where(qTimesheetBiweeklyDetailDO.type.eq(type));
            update.execute();
        }
    }


}
