package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.ProjectEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.querydsl.core.QueryResults;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TimesheetServiceImpl implements TimesheetService {

    private final TimesheetRepo timesheetRepo;
    private final TaskService taskService;
    private final TaskRepo taskRepo;
    private final ResActivityService resActivityService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final ProjectService projectService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdUserService prdUserService;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserDAO daoUser;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final TimesheetDAO timesheetDAO;

    @Value("${tw4.url}")
    private String tw4_url;
    @Value("${tw4.sync.getProjectEqvaInfo:api/openReport/v1/sync/getProjectEqvaInfo}")
    private String getProjectEqvaInfo;


    /**
     * 工时分页查询
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    @Override
    public PagingVO<TimesheetVO> paging(TimesheetQuery query) {
        getPermissionParams(query);
        return timesheetDAO.queryPaging(query);
//        Page<TimesheetDO> page = timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
//        return PageUtil.toPageVo(page.map(TimesheetConvert.INSTANCE::toVo));
    }


    private void getPermissionParams(TimesheetQuery query) {
        if (query.getIsPermission()) {
            final Long loginUserId = GlobalUtil.getLoginUserId();
            // 判断 管理员
            final boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (!isSystemAdmin) {
                // 判断当前登录人是否是系统管理员or 拥有角色【客户经营管理员	CUST_OPER_MANAGER】
                List<Long> userIdsByPlatRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
                // BU级权限（查看当前登录人是否是部门负责人）
                final List<PrdOrgOrganizationDO> organizationDOList = prdOrgOrganizationDAO.queryByManagerId(loginUserId);
                Set<Long> orgIdList = null;
                if (!CollectionUtils.isEmpty(organizationDOList)) {
                    orgIdList = organizationDOList.stream().map(PrdOrgOrganizationDO::getId).collect(Collectors.toSet());
                }
                // 上下级权限
                //查出来userId的所有下级userId
                final List<PrdOrgEmployeeRefVO> empRef = daoUser.queryLowListByKey(null, loginUserId);
                final Set<Long> empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                // 有没有平台级权限
                if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                    Set<Long> queryUserIds = new HashSet<>();
                    //最基础的权限要查看自己
                    queryUserIds.add(loginUserId);
                    //有没有部门级别权限
                    if (orgIdList != null && !orgIdList.isEmpty()) {
                        // 部门成员
                        //查询部门下的成员
                        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                        Set<Long> collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                        queryUserIds.addAll(collect);
                    }
                    if (empRefUserIdList != null && empRefUserIdList.isEmpty()) {
                        // 查询下级
                        queryUserIds.addAll(empRefUserIdList);
                    }
                    query.setTsUserIdList(queryUserIds);
                }
            }
        }
    }


    /**
     * 工时审批分页查询
     *
     * @param query 查询
     * @return {@link PagingVO}<{@link TimesheetVO}>
     */
    @Override
    public PagingVO<TimesheetVO> pagingSingle(TimesheetQuery query) {
        Page<TimesheetDO> page = timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetConvert.INSTANCE::toVo));
    }


    @Override
    public PagingVO pagingGroup(TimesheetQuery query) {
        query.setOrders(null);
        final Page<Object[]> page = timesheetRepo.pagingGroup(query.getTsUserId(), query.getApprUserId(), query.getTsStatus(), query.getTsUserBuId(), query.getTimesheetIdV4IsNull(), query.getPageRequest());
        final List<Object[]> content = page.getContent();
        final List<TimesheetVO> all = getAll(content);
        // 理论支出当量
        setTheoryGetEqva(all);
        return PagingVO.<TimesheetVO>builder().records(all).total(page.getTotalElements()).build();
    }


    /**
     * 理论支出当量
     *
     * @param list 列表
     */
    public void setTheoryGetEqva(List<TimesheetVO> list) {
        if (list != null && list.size() > 0) {
            for (TimesheetVO timeView : list) {
                String[] groupIdsArr = timeView.getGroupIds().split(",");
                BigDecimal bd = new BigDecimal("0");
                for (int i = 0; i < groupIdsArr.length; i++) {
                    final TimesheetVO data = queryByKey(Long.valueOf(groupIdsArr[i]));
                    if (data.getTaskId() != null && data.getTaskId() > 0) {
                        final TaskVO task = taskService.queryByTaskIdV4(data.getTaskId());
                        if (task != null && "04".equals(task.getAcceptMethod())) {
                            bd = bd.add(data.getWorkHour().divide(new BigDecimal("8"), 1, RoundingMode.UP).multiply(task.getEqvaRatio()));
                        }
                    }
                }
                timeView.setTheoryGetEqva(bd);
            }
        }
    }

    public List<TimesheetVO> getAll(List<Object[]> objects) {
        List<TimesheetVO> list = new ArrayList<>();
        for (Object[] obj : objects) {
            TimesheetVO timesheetVO = new TimesheetVO();
            timesheetVO.setGroupIds(String.valueOf(obj[0]));
            timesheetVO.setWorkHour(BigDecimal.valueOf(Double.parseDouble(String.valueOf(obj[1]))));
            timesheetVO.setProjId(obj[2] != null ? Long.valueOf(String.valueOf(obj[2])) : null);
            timesheetVO.setProjNo(String.valueOf(obj[3]));
            timesheetVO.setProjName(String.valueOf(obj[4]));
            timesheetVO.setTsStatus(String.valueOf(obj[5]));
            timesheetVO.setApprUserId(obj[6] != null ? Long.valueOf(String.valueOf(obj[6])) : null);
            timesheetVO.setWeekStartDate(obj[7] != null ? LocalDate.parse(String.valueOf(obj[7])) : null);
            timesheetVO.setTaskId(obj[8] != null ? Long.valueOf(String.valueOf(obj[8])) : null);
            timesheetVO.setTaskNo(String.valueOf(obj[9]));
            timesheetVO.setTaskName(String.valueOf(obj[10]));
            timesheetVO.setTsUserId(obj[11] != null ? Long.valueOf(String.valueOf(obj[11])) : null);
            timesheetVO.setTsUserBuId(obj[12] != null ? Long.valueOf(String.valueOf(obj[12])) : null);
            timesheetVO.setTsUserBuName(obj[13] != null ? String.valueOf(obj[13]) : "");
            list.add(timesheetVO);
        }
        return list;
    }

    @Override
    public List<TimesheetVO> listGroup(TimesheetQuery query) {
        QTimesheetDO qTimesheetDO = QTimesheetDO.timesheetDO;
        final JPAQuery<TimesheetDO> jpaQuery = jpaQueryFactory.select(qTimesheetDO)
                .from(qTimesheetDO)
                .where(qTimesheetDO.deleteFlag.eq(0));
        if (null != query.getTsUserId()) {
            jpaQuery.where(qTimesheetDO.tsUserId.eq(query.getTsUserId()));
        }
        if (null != query.getApprUserId()) {
            jpaQuery.where(qTimesheetDO.apprUserId.eq(query.getApprUserId()));
        }
        if (StringUtils.hasText(query.getTsStatus())) {
            jpaQuery.where(qTimesheetDO.tsStatus.eq(query.getTsStatus()));
        }
        final QueryResults<TimesheetDO> queryResults = jpaQuery.groupBy(qTimesheetDO.projId, qTimesheetDO.yearWeek, qTimesheetDO.tsUserId)
                .orderBy(qTimesheetDO.yearWeek.desc(), qTimesheetDO.tsUserId.desc())
                .fetchResults();
        final List<TimesheetVO> timesheetVOList = TimesheetConvert.INSTANCE.toVoList(queryResults.getResults());
        return timesheetVOList;
    }

    /**
     * 工时查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link TimesheetVO}>
     */
    @Override
    public List<TimesheetVO> queryList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.toVoList(timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public List<TimesheetSyncDataVO> querySyncDataList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.doListToSyncVo(timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public long count(TimesheetQuery query) {
        return timesheetRepo.count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    @Override
    public TimesheetVO queryByKey(Long key) {
        TimesheetDO entity = timesheetRepo.findById(key).orElseGet(TimesheetDO::new);
        Assert.notNull(entity.getId(), "工时不存在");
        TimesheetVO vo = TimesheetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    /**
     * 插入
     * <p>
     * 待补4.0逻辑 ：// 新建工时时,将对应的活动修改为进行中的状态(未开始和延迟状态的才修改)
     *
     * @param payload 有效载荷
     * @return {@link TimesheetVO}
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetVO insert(TimesheetPayload payload) {
        // 参数校验
        // 提交验证
        check(payload);
        //  根据日期查询已审批、审批中、已结算状态的工作小时，验证是否大于8
        // 校验任务包当量
        initData(payload);
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        return TimesheetConvert.INSTANCE.toVo(timesheetRepo.save(entityDo));
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(TimesheetPayload payload) {
        if (payload.isSubmitted()) {
            if (payload.getId() != null && payload.getId() > 0) {
                final TimesheetVO timesheetVO = queryByKey(payload.getId());
                // 提交单据状态校验 只能提交新建或已退回的单据
                if (!TimesheetStatus.CREATE.getCode().equals(timesheetVO.getTsStatus()) &&
                        !TimesheetStatus.REJECTED.getCode().equals(timesheetVO.getTsStatus())) {
                    throw TwException.error("", "只能提交新建或已退回的单据");
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            // 项目id、 必填   --任务id、活动id
            // 工作日期、工时、工作说明
            // 字段必填验证
            if (null == payload.getProjId()) {
                throw TwException.error("", "请选择项目");
            }
            if (null == payload.getWorkDate()) {
                throw TwException.error("", "请选择工作日期");
            }
            if (!StringUtils.hasText(payload.getWorkDesc())) {
                throw TwException.error("", "请输入工作日志");
            }
            if (null == payload.getWorkHour()) {
                throw TwException.error("", "请填写工时");
            }
            if (null != payload.getTaskId()) {
                final TaskVO taskVO = taskService.queryByTaskIdV4(payload.getTaskId());
                if (null == taskVO) {
                    throw TwException.error("", "任务包不存在");
                }
                if (!taskVO.getTaskStatus().equals("IN PROCESS") && !taskVO.getTaskIdV4().equals(0L)) {
                    throw TwException.error("", "请选择【激活】状态的任务包");
                }
            }

        }
    }

    /**
     * 批量插入
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link TimesheetVO}>
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<TimesheetVO> batchInsert(TimesheetListPayload payload) {
        List<TimesheetVO> timesheetVOList = new ArrayList<>();
        final List<TimesheetPayload> timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty(timesheetList)) {
            // 待更新工时剩余当量的 任务数据集合
            Map<Long, BigDecimal> taskUpdateEffectiveEqvaMap = new HashMap<>();
            // 待更新 工时已填写使用当量的 任务数据集合
            Map<Long, BigDecimal> taskUpdateUsedEqvaMap = new HashMap<>();
            Set<Long> taskIdUpdateList = null;

            // 因前端不好传值问题，这里特殊处理下，为了同步4.0数据兼容
            timesheetList.forEach(timesheetPayload -> {
                final Long taskId = timesheetPayload.getTaskId();
                if (taskId != null && taskId.equals(0L)) {
                    timesheetPayload.setTaskId(null);
                }
            });
            if (payload.isSubmitted()) {
                // 6851 【工作日志】增加校验 不允许填写今天之后的工时，可以进行保存
                checkWorkDate(payload);

                // 校验工时是否超过8小时
                if (!workHourValidate(payload)) {
                    throw TwException.error("", "同一天的工作小时小于等于8");
                }
                // 运维类项目 当量校验
                String msgDevOps = validateDevOpsEqva(payload);
                if (StringUtils.hasText(msgDevOps)) {
                    throw TwException.error("", msgDevOps);
                }
                // 工时提交时校验工时占用任务包的当量是否充足
                String msg = validateEqvaPro(payload, taskUpdateEffectiveEqvaMap, taskUpdateUsedEqvaMap);
                if (StringUtils.hasText(msg)) {
                    throw TwException.error("", msg);
                }
                taskIdUpdateList = timesheetList.stream()
                        .filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0)
                        .map(TimesheetPayload::getTaskId)
                        .collect(Collectors.toSet());
            }
            timesheetList.forEach(timesheetPayload ->
                    timesheetVOList.add(insert(timesheetPayload))
            );

            // 更新任务包工时当量信息
            if (!CollectionUtils.isEmpty(taskIdUpdateList)) {
                taskIdUpdateList.forEach(taskId -> {
                    updateTaskEffectiveEqvaAndUsedEqva(taskUpdateUsedEqvaMap, taskUpdateEffectiveEqvaMap, taskId);
                });

            }

        }

        // 需要删除的数据
        final List<Long> deleteIdList = payload.getDeleteIdList();
        if (!CollectionUtils.isEmpty(deleteIdList)) {
            deleteSoft(deleteIdList);
        }
        return timesheetVOList;
    }

    /**
     * 不允许填写今天之后的工时
     *
     * @param payload 有效载荷
     */
    private void checkWorkDate(TimesheetListPayload payload) {
        LocalDate now = LocalDate.now();
        final List<TimesheetPayload> timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty(timesheetList)) {
            final long count = timesheetList.stream().filter(timesheetPayload -> timesheetPayload.getWorkDate().isAfter(now)).count();
            if (count > 0) {
                throw TwException.error("", "不允许提前提交工时");
            }
        }
    }

    /**
     * 运维类项目当量校验
     * 项目剩余当量 = 已拨付 - 工时占用当量
     *
     * @param payload 有效载荷
     * @return {@link String}
     */
    private String validateDevOpsEqva(TimesheetListPayload payload) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        final List<TimesheetPayload> timesheetPayloadList = payload.getTimesheetList().stream()
                .filter(timesheetPayload ->
                        // 根据工时状态过滤
                        tsStatusCheck(timesheetPayload)
                                // 过滤无项目
                                && timesheetPayload.getProjId() > 0
                                // 取出 运维类项目工时
                                && (
                                StringUtils.hasText(timesheetPayload.getType())
                                        && timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode()
                                )
                        )
                ).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(timesheetPayloadList)) {
            return null;
        }

        //final List<Long> projIdList = timesheetPayloadList.stream()
        //    .map(timesheetPayload -> timesheetPayload.getProjId())
        //    .collect(Collectors.toList());
        // 5.0临时方案 只要一个最新的当量
        final PrdOrgEmployeeDO prdOrgEmployeeDO = employeeDAO.queryByUserId(loginUserId);
        final BigDecimal eqvaRatio = prdOrgEmployeeDO.getEqvaRatio();
        Map<Long, BigDecimal> tsEqvaMap = null;
        // 取到运维项目所占用当量
        if (!CollectionUtils.isEmpty(timesheetPayloadList)) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<>();
            }
            for (TimesheetPayload ts : timesheetPayloadList) {
                // 根据工时日期、填报工时的人员、选择的项目 计算占用当量
                BigDecimal eqva = calProjTsUsedEqvasByTsDetail(ts.getWorkDate(), eqvaRatio, ts.getProjId(), ts.getWorkHour());
                tsEqvaMap.put(ts.getProjId(), eqva);
            }
        }
        Map<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;
        // 按项目汇总，每个项目下工时占用的总当量
        Map<Long, List<TimesheetPayload>> taskTsMap = timesheetPayloadList.stream().collect(Collectors.groupingBy(TimesheetPayload::getProjId));
        Set<Long> projIdSet = taskTsMap.keySet();
        // 4.0系统实时查询项目可用当量信息
        //Map<String, Object> map = new HashMap<>(16);
        //map.put("projIdSet", projIdSet);
        //String result = httpUtil.sendPost(tw4_url + getProjectEqvaInfo, map);
        //Map<String, Object> data = (Map) JSONObject.parse(result);
        //String syncData = "";
        //PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        //String syncType = "getProjectEqvaInfo";
        //Map<Long, List<ProjectEqvaInfoDTO>> projInfoMap = new HashMap<>(16);
        //if ((data.get("ok") + "").equals("true")) {
        //    if (!ObjectUtils.isEmpty(data.get("datum"))) {
        //        final Object datum = data.get("datum");
        //        final List<ProjectEqvaInfoDTO> projectEqvaInfoList = JSONArray.parseArray(datum.toString(), ProjectEqvaInfoDTO.class);
        //        projInfoMap = projectEqvaInfoList.stream()
        //                .collect(Collectors.groupingBy(ProjectEqvaInfoDTO::getProjId));
        //    } else {
        //        log.error("未查询到项目当量信息；projIdSet：{}", projIdSet);
        //        syncData = "项目未设置当量，联系项目经理";
        //    }
        //} else {
        //    syncData = data.get("reason") + "";
        //}
        //logDO.setSyncType(syncType);
        //logDO.setSyncData(syncData);
        //daoLog.save(logDO);
        //if (StringUtils.hasText(syncData)) {
        //    return syncData;
        //}
        //for (Long projId : projIdSet) {
        //    BigDecimal tsSubmitEqva = taskTsMap.get(projId).stream()
        //            // 当前项目下所有工时上报的总当量
        //            .map(ts -> tsEqvaMapTemp.get(ts.getProjId()) == null ? BigDecimal.ZERO : tsEqvaMapTemp.get(ts.getProjId())).reduce(BigDecimal::add).get();
        //    //TODO  去4.0实时获取运维项目剩余可用当量信息
        //    final List<ProjectEqvaInfoDTO> projectEqvaInfoDTOS = projInfoMap.get(projId);
        //    BigDecimal availableEqva = null;
        //    BigDecimal timesheetEqvaTotal = BigDecimal.ZERO;
        //    if (!CollectionUtils.isEmpty(projectEqvaInfoDTOS)) {
        //        log.info("项目:{}", projId);
        //        final ProjectEqvaInfoDTO projEqva = projectEqvaInfoDTOS.get(0);
        //        //a、项目总当量 = 项目已拨付预算 - 项目已结算和结算中的当量 T_PROJ_BUDGET.eqva_released_qty - sql
        //        final BigDecimal totalEqvaActual = projEqva.getTotalEqvaActual() == null ? BigDecimal.ZERO : projEqva.getTotalEqvaActual();
        //        log.info("项目总当量:{}", totalEqvaActual);
        //        //项目已结算和结算中的当量
        //        final BigDecimal usedEQVA = projEqva.getUsedEQVA() == null ? BigDecimal.ZERO : projEqva.getUsedEQVA();
        //        log.info("项目已结算和结算中的当量:{}", usedEQVA);
        //        //已拨付当量
        //        final BigDecimal eqvaReleasedQty = projEqva.getEqvaReleasedQty() == null ? BigDecimal.ZERO : projEqva.getEqvaReleasedQty();
        //        //已派发当量
        //        final BigDecimal distributedEqva = projEqva.getDistributedEqva() == null ? BigDecimal.ZERO : projEqva.getDistributedEqva();
        //        //已填工时当量
        //        final BigDecimal usedWorkHourEqva = projEqva.getUsedWorkHourEqva() == null ? BigDecimal.ZERO : projEqva.getUsedWorkHourEqva();
        //        // 项目剩余当量 = 已拨付 - 工时占用当量
        //        availableEqva = eqvaReleasedQty.subtract(usedWorkHourEqva);
        //        // 上一次工时同步时间后提交项目下的工时的当量总数+本次提交当量
        //        LocalDateTime localDateTime = daoLog.queryOrgSyncLog("timesheet");
        //        if (localDateTime == null) {
        //            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        //        }
        //        List<TimesheetDO> timesheetDoList = timesheetRepo.findByProjectIdAndModifyTimeAfter(localDateTime, projId);
        //        for (TimesheetDO timesheetDO : timesheetDoList) {
        //            //获取用户当量系数
        //            Long tsUserId = timesheetDO.getTsUserId();
        //            PrdOrgEmployeeDO currentEmployee = employeeDAO.queryByUserId(tsUserId);
        //            BigDecimal eqva = currentEmployee.getEqvaRatio().multiply(timesheetDO.getWorkHour().divide(BigDecimal.valueOf(8L)));
        //            timesheetEqvaTotal = timesheetEqvaTotal.add(eqva);
        //        }
        //    }
        //    //BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(projId);
        //    log.info("当前项目下所有工时上报的总当量:" + tsSubmitEqva);
        //    log.info("计算项目剩余可用于填报工时的当量:" + availableEqva.subtract(timesheetEqvaTotal));
        //    if (tsSubmitEqva != null && availableEqva != null && tsSubmitEqva.doubleValue() > availableEqva.subtract(timesheetEqvaTotal).doubleValue()) {
        //        final ProjectVO projectVO = projectService.queryByProjIdV4(projId);
        //        return "项目当量不足！本次填报的项目【" + projectVO.getProjName() + "】总的工时当量【" + tsSubmitEqva + "】大于项目剩余可用于工时填报的当量【" + availableEqva.subtract(timesheetEqvaTotal) + "】，请填报其他项目或联系项目经理";
        //    }
        //}

        return null;
    }

    /**
     * 校验当量
     *
     * @param payload 有效载荷
     * @return {@link String}
     */
    private String validateEqva(TimesheetListPayload payload) {
        final List<TimesheetPayload> timesheetPayloadList = payload.getTimesheetList().stream()
                .filter(timesheetPayload -> tsStatusCheck(timesheetPayload)
                ).collect(Collectors.toList());

        // 过滤掉没有填选任务包的工时
        List<TimesheetPayload> tsListTmp = timesheetPayloadList.stream()
                .filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }
        //要提交工时关联的任务包id
        List<Long> taskIdList = tsListTmp.stream().map(t -> t.getTaskId()).collect(Collectors.toList());
        //计算任务包当量 原始发包当量、追加当量、被工时用掉的当量、剩余还可以用来填报的当量
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setTaskIdV4List(taskIdList);
        final List<TaskVO> taskVOList = taskService.queryList(taskQuery);
        // 任务包已经被工时用掉的当量
        Map<Long, BigDecimal> tsUsedEqvaMap = calTsUsedEqvasByIds(taskIdList);
        Map<Long, BigDecimal> tsEffectiveEqva = taskVOList.stream().map(t -> {
            if (tsUsedEqvaMap != null) {
                t.setTsUsedEqva(tsUsedEqvaMap.get(t.getTaskIdV4()));
            }
            return t;
        }).collect(Collectors.toMap(TaskVO::getTaskIdV4, TaskVO::getTsEffectiveEqva));// 计算任务包剩余可用于填报工时的当量

        //给工时id给一个初始值
        tsListTmp.stream().forEach(ts -> {
            if (ts.getId() == null) {
                ts.setId(Math.round(Math.random() * 100000000) * -1);
            }
        });
        // 计算每条工时的当量  任务主键集合
        List<Long> tsIds = tsListTmp.stream().map(ts -> ts.getId()).collect(Collectors.toList());
        // 计算工时占用任务包的当量
        Map<Long, BigDecimal> tsEqvaMap = calTsUsedEqvasByTsIds(tsIds);// 仅计算工时id大于0的值
        //计算工时id小于0的工时占用的当量
        List<TimesheetPayload> tsTemp = tsListTmp.stream().filter(ts -> ts.getId() < 0).collect(Collectors.toList());
        if (tsTemp != null || tsTemp.size() > 0) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<>();
            }
            for (TimesheetPayload ts : tsTemp) {
                // 根据工时日期、填报工时的人员、选择的任务包 计算占用当量
                BigDecimal eqva = calTsUsedEqvasByTsDetail(ts.getWorkDate(), ts.getTsUserId(), ts.getTaskId(), ts.getWorkHour());
                tsEqvaMap.put(ts.getId(), eqva);
            }
        }
        Map<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;

        // 按任务包汇总，每个任务包下工时占用的总当量
        Map<Long, List<TimesheetPayload>> taskTsMap = tsListTmp.stream().collect(Collectors.groupingBy(TimesheetPayload::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            BigDecimal tsSubmitEqva = taskTsMap.get(taskId).stream()
                    // 当前任务包下所有工时上报的总当量
                    .map(ts -> tsEqvaMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : tsEqvaMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
            //计算任务包剩余可用于填报工时的当量
            BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
            System.out.println("当前任务包下所有工时上报的总当量:" + tsSubmitEqva);
            System.out.println("计算任务包剩余可用于填报工时的当量:" + tsEffecttiveEqva);
            if (tsSubmitEqva != null && tsEffecttiveEqva != null && tsSubmitEqva.doubleValue() > tsEffecttiveEqva.doubleValue()) {
                String taskName = taskVOList.stream().filter(t -> t.getTaskIdV4().longValue() == taskId).map(t -> t.getTaskName()).findAny().get();
                return "任务包当量不足！本次填报的任务包【" + taskName + "】总的工时当量【" + tsSubmitEqva + "】大于任务包剩余可用于工时填报的当量【" + tsEffecttiveEqva + "】，请填报其他任务包或向发包人申请给任务包追加当量";
            }
        }
        return null;
    }

    /**
     * 校验当量-升级版
     * 每次读取任务包里的工时剩余可用当量字段（保持任务包里的工时剩余可用当量及时更新同步很重要！！！）
     *
     * @param payload               有效载荷
     * @param taskUpdateMap         需要更新 工时填写剩余可用当量的任务包集合
     * @param taskUpdateUsedEqvaMap 需要更新 已用当量的任务包集合
     * @return {@link String}
     */
    private String validateEqvaPro(TimesheetListPayload payload, Map<Long, BigDecimal> taskUpdateMap, Map<Long, BigDecimal> taskUpdateUsedEqvaMap) {
        final List<TimesheetPayload> timesheetPayloadList = payload.getTimesheetList().stream()
                .filter(timesheetPayload -> tsStatusCheck(timesheetPayload)
                ).collect(Collectors.toList());

        // 过滤掉没有填选任务包的工时
        List<TimesheetPayload> tsListTmp = timesheetPayloadList.stream()
                .filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }
        //要提交工时关联的任务包id
        List<Long> taskIdList = tsListTmp.stream().map(t -> t.getTaskId()).collect(Collectors.toList());
        //计算任务包当量 原始发包当量、追加当量、被工时用掉的当量、剩余还可以用来填报的当量
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setTaskIdV4List(taskIdList);
        final List<TaskVO> taskVOList = taskService.queryList(taskQuery);
        // 任务包已经被工时用掉的当量
        //Map<Long, BigDecimal> tsUsedEqvaMap = calTsUsedEqvasByIds(taskIdList);
        // !!!!  Pro 这里取值不一样
        Map<Long, BigDecimal> tsEffectiveEqva = taskVOList.stream()
                .collect(Collectors.toMap(TaskVO::getTaskIdV4, TaskVO::getEffectiveEqva));// 计算任务包剩余可用于填报工时的当量

        //给工时id给一个初始值
        tsListTmp.stream().forEach(ts -> {
            if (ts.getId() == null) {
                ts.setId(Math.round(Math.random() * 100000000) * -1);
            }
        });
        // 计算每条工时的当量  工时主键集合
        List<Long> tsIds = tsListTmp.stream().map(ts -> ts.getId()).collect(Collectors.toList());
        // 计算工时占用任务包的当量
        Map<Long, BigDecimal> tsEqvaMap = calTsUsedEqvasByTsIds(tsIds);// 仅计算工时id大于0的值
        //计算工时id小于0的工时占用的当量
        List<TimesheetPayload> tsTemp = tsListTmp.stream().filter(ts -> ts.getId() < 0).collect(Collectors.toList());
        if (tsTemp != null || tsTemp.size() > 0) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<>();
            }
            for (TimesheetPayload ts : tsTemp) {
                // 根据工时日期、填报工时的人员、选择的任务包 计算占用当量
                BigDecimal eqva = calTsUsedEqvasByTsDetail(ts.getWorkDate(), ts.getTsUserId(), ts.getTaskId(), ts.getWorkHour());
                tsEqvaMap.put(ts.getId(), eqva);
            }
        }
        Map<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;

        // 按任务包汇总，每个任务包下工时占用的总当量
        Map<Long, List<TimesheetPayload>> taskTsMap = tsListTmp.stream().collect(Collectors.groupingBy(TimesheetPayload::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            BigDecimal tsSubmitEqva = taskTsMap.get(taskId).stream()
                    // 当前任务包下所有工时上报的总当量
                    .map(ts -> tsEqvaMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : tsEqvaMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
            //计算任务包剩余可用于填报工时的当量
            BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
            log.info("当前任务包下所有工时上报的总当量:" + tsSubmitEqva);
            log.info("计算任务包剩余可用于填报工时的当量:" + tsEffecttiveEqva);
            if (tsSubmitEqva != null && tsEffecttiveEqva != null && tsSubmitEqva.doubleValue() > tsEffecttiveEqva.doubleValue()) {
                String taskName = taskVOList.stream().filter(t -> t.getTaskIdV4().longValue() == taskId).map(t -> t.getTaskName()).findAny().get();
                return "任务包当量不足！本次填报的任务包【" + taskName + "】总的工时当量【" + tsSubmitEqva + "】大于任务包剩余可用于工时填报的当量【" + tsEffecttiveEqva + "】，请填报其他任务包或向发包人申请给任务包追加当量";
            }

            // 更新 任务包字段 计算任务包剩余可用于填报工时的当量  程序直接算好
            taskUpdateMap.put(taskId, tsEffecttiveEqva.subtract(tsSubmitEqva));
            // 数据库层面累加
            taskUpdateUsedEqvaMap.put(taskId, tsSubmitEqva == null ? BigDecimal.ZERO : tsSubmitEqva);
        }
        return null;
    }

    /**
     * 更新任务 工时填报剩余可用当量
     *
     * @param taskUpdateMap 任务更新地图
     * @param taskId        任务id  (tw5的主键！！！)
     */
    private void updateTaskEffectiveEqvaAndUsedEqva(Map<Long, BigDecimal> taskUpdateUsedEqvaMap, Map<Long, BigDecimal> taskUpdateMap, Long taskId) {
        if (null != taskId && taskId > 0) {
            if (null != taskUpdateMap.get(taskId)) {
                taskRepo.updateTaskEffectiveEqvaAndUsedEqva(taskId, taskUpdateUsedEqvaMap.get(taskId), taskUpdateMap.get(taskId));
            }
        }
    }


    /**
     * 工时状态检查
     *
     * @param timesheetPayload 时间表有效载荷
     * @return boolean
     */
    private boolean tsStatusCheck(TimesheetPayload timesheetPayload) {
        timesheetPayload.setTsUserId(GlobalUtil.getLoginUserId());
        final boolean flag = timesheetPayload.getTsStatus() != null &&
                (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()));
        return flag;
    }

    /**
     * 根据工时日期、填报工时的人员、选择的任务包 计算占用当量
     *
     * @param workDate 工时填报日期
     * @param tsUserId 填报人userId
     * @param taskId   任务包id
     * @param workHour 工时小时数
     * @return
     */
    private BigDecimal calTsUsedEqvasByTsDetail(LocalDate workDate, Long tsUserId, Long taskId, BigDecimal workHour) {
        if (workDate == null || taskId == null) {
            return null;
        }
        if (tsUserId == null) {
            tsUserId = GlobalUtil.getLoginUserId();
        }
        TaskVO task = taskService.queryByTaskIdV4(taskId);
        if (task == null) {
            return null;
        }
        //计算当量系数
        BigDecimal eqvaRatio = null;
        if ("04".equals(task.getAcceptMethod()) && task.getEqvaRatio() != null) {// 人天任务包使用任务包的派发当量系数，跳过计算当量系数，节约系统资源
            eqvaRatio = task.getEqvaRatio();
        } else {
            final PrdOrgEmployeeDO prdOrgEmployeeDO = employeeDAO.queryByUserId(tsUserId);
            eqvaRatio = null != prdOrgEmployeeDO ? prdOrgEmployeeDO.getEqvaRatio() : null;
            // 4.0老逻辑
            //TwEqvaRationQuery query = TwEqvaRationQuery.builder().resId(tsUserId).build();// 先查出任务包关联的所有人的当量系数
            //List<TwEqvaRatioView> ratioList = eqvaRatioMapper.getRatioList(query);//当量系数：查询指定资源当量系数维护记录
            //if (ratioList == null || ratioList.size() == 0) {
            //    return null;
            //}
            //TwEqvaRatioView view = ratioList.stream().filter(r ->
            //    (r.getStartDate() == null || !r.getStartDate().isAfter(workDate))
            //        && (r.getEndDate() == null || !r.getEndDate().isBefore(workDate))
            //).sorted(new Comparator<TwEqvaRatioView>() {
            //    @Override
            //    public int compare(TwEqvaRatioView o1, TwEqvaRatioView o2) {
            //        return o2.getStartDate() != null && o1.getStartDate() != null ? (int) (o2.getStartDate().toEpochDay() - o1.getStartDate().toEpochDay()) : 0;
            //    }
            //}).findFirst().orElse(null);
            //if (view == null || view.getEqvaRatio() == null) {
            //    // 查员工最新的当量系数
            //    eqvaRatio = ratioList.get(0).getEqvaRatio();
            //} else {
            //    eqvaRatio = view.getEqvaRatio();//设置当量系数
            //}
        }
        if (eqvaRatio == null) {
            return null;
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8);
        }
        // TODO【工时当量-自动结算】小数点保留 see 自动结算当量逻辑不统一 待确定 com/el/tw/app/baseinfo/service/TwEqvaSettleServiceImpl.java:646
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8), 2, RoundingMode.DOWN);//向下取整数
    }


    /**
     * 根据工时日期、填报工时的人员、选择的项目 计算占用当量
     *
     * @param workDate  工时填报日期
     * @param eqvaRatio 当量系数
     * @param projId    任务包id
     * @param workHour  工时小时数
     * @return
     */
    private BigDecimal calProjTsUsedEqvasByTsDetail(LocalDate workDate, BigDecimal eqvaRatio, Long projId, BigDecimal workHour) {
        if (workDate == null || projId == null) {
            return null;
        }

        //计算当量系数
        if (eqvaRatio == null) {
            return null;
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8), 2, RoundingMode.DOWN);//向下取整数
    }

    /**
     * 计算多个任务包的已填工时当量
     *
     * @param taskIdList 任务v4主键集合
     * @return 任务包id，已填工时当量 map
     */
    private Map<Long, BigDecimal> calTsUsedEqvasByIds(List<Long> taskIdList) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTaskIdList(taskIdList);
        List<String> tsStatusList = new ArrayList<>();
        tsStatusList.add(TimesheetStatus.APPROVED.getCode());
        tsStatusList.add(TimesheetStatus.APPROVING.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        // 查询工时列表信息 人、日期、工时、baseBu
        // 根据任务包查询工时
        List<TimesheetVO> tsViews = queryList(timesheetQuery);

        if (tsViews == null || tsViews.size() == 0) {// 任务包没有关联任何工时
            return null;
        }

        //计算每条工时占用的当量
        Map<Long, BigDecimal> tsEqvaMap = calTsUsedEqvasByTsIds(tsViews.stream()
                .map(ts -> ts.getId()).collect(Collectors.toList()));
        tsViews = tsViews.stream().map(ts -> {
            ts.setEqvaTimeSheet(tsEqvaMap.get(ts.getId()));
            return ts;
        }).collect(Collectors.toList());

        //按任务包对工时进行分组，并求当量和
        Map<Long, BigDecimal> returnMap = new HashMap<>();
        Map<Long, List<TimesheetVO>> taskTsMap = tsViews.stream().collect(Collectors.groupingBy(TimesheetVO::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            returnMap.put(taskId, taskTsMap.get(taskId).stream().
                    map(ts -> ts.getEqvaTimeSheet() == null ? BigDecimal.ZERO : ts.getEqvaTimeSheet())
                    .reduce(BigDecimal::add).get());
        }
        return returnMap;
    }

    /**
     * 计算工时占用任务包的当量
     *
     * @param timeSheetIds 工时id
     * @return 工时id 工时占用当量
     */
    private Map<Long, BigDecimal> calTsUsedEqvasByTsIds(List<Long> timeSheetIds) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setIdList(timeSheetIds);
        // 查询工时列表信息 人、日期、工时、baseBu
        //根据id查询工时List
        final List<TimesheetVO> tsViews = queryList(timesheetQuery);
        List<Long> tsUserIdList = tsViews.stream().map(v -> v.getTsUserId()).collect(Collectors.toList());
        // 5.0临时方案 只要一个最新的当量
        final List<PrdOrgEmployeeDO> prdOrgEmployeeDOS = employeeDAO.queryListByUserIdList(tsUserIdList);
        final Map<Long, BigDecimal> eqvaRatioMap = prdOrgEmployeeDOS.stream()
                .collect(Collectors.toMap(PrdOrgEmployeeDO::getUserId, PrdOrgEmployeeDO::getEqvaRatio));
        log.warn("debug::::" + "开始计算当量系数：：：" + eqvaRatioMap.toString());
        for (TimesheetVO v : tsViews) {
            // 查询任务包的信息
            final TaskVO taskVO = taskService.queryByTaskIdV4(v.getTaskId());
            if ("04".equals(taskVO.getAcceptMethod()) && taskVO.getEqvaRatio() != null) {// 人天任务包使用任务包的派发当量系数，跳过计算当量系数，节约系统资源
                continue;
            }
            // 计算工时的当量系数
            // 非人天任务包，不能用任务包的派发当量系数当做计算当量的系数
            v.setEqvaRatio(null);
            final BigDecimal eqvaRatio = eqvaRatioMap.get(v.getTsUserId());
            v.setEqvaRatio(eqvaRatio);
        }
        // 计算工时占用的当量
        // 工时当量系数计算完成后，直接调用v.getEqvaTimeSheet()方法即可
        return tsViews.stream().collect(Collectors.toMap(TimesheetVO::getId, TimesheetVO::getEqvaTimeSheet));

        // 原有4.0逻辑
        //TwEqvaRationQuery query = TwEqvaRationQuery.builder().resIds(tsUserIdList).build();// 先查出任务包关联的所有人的当量系数
        //List<TwEqvaRatioView> ratioList = eqvaRatioMapper.getRatioList(query);//当量系数：查询指定资源当量系数维护记录
        // 计算每条工时的当量系数、占用当量
//        for (TwTimesheetListView v : tsViews) {
//            if ("04".equals(v.getAcceptMethod()) && v.getEqvaRatio() != null) {// 人天任务包使用任务包的派发当量系数，跳过计算当量系数，节约系统资源
//                continue;
//            }
//            //计算工时的当量系数
//            v.setEqvaRatio(null);// 非人天任务包，不能用任务包的派发当量系数当做计算当量的系数
//            if (!CollectionUtils.isEmpty(ratioList)) {
//                TwEqvaRatioView view = ratioList.stream().filter(r ->
//                        (r.getResId() != null && v.getTsResId() != null && r.getResId().longValue() == v.getTsResId().longValue())
////                            有的资源的任务包跨度很大，有可能任务包存在两个当量系数
////                        && (r.getBuId() != null && v.getBaseBuId() != null && r.getBuId().longValue() == v.getBaseBuId().longValue())
//                            && (r.getStartDate() == null || !r.getStartDate().isAfter(v.getWorkDate()))
//                            && (r.getEndDate() == null || !r.getEndDate().isBefore(v.getWorkDate()))
//                ).sorted(new Comparator<TwEqvaRatioView>() {
//                    @Override
//                    public int compare(TwEqvaRatioView o1, TwEqvaRatioView o2) {
//                        return o2.getStartDate() != null && o1.getStartDate() != null ? (int) (o2.getStartDate().toEpochDay() - o1.getStartDate().toEpochDay()) : 0;
//                    }
//                }).findFirst().orElse(null);// 仅查basebu的话，会导致发生bu变更的时候，变更前的人找不到当量系数，导致工时不占用任务包当量；应该用最新的当量系数兜底
//                if (view == null || view.getEqvaRatio() == null) {
//                    // 查员工最新的当量系数
//                    TwEqvaRationQuery queryTmp = TwEqvaRationQuery.builder().resId(ratioList.get(0).getResId()).build();
//                    List<TwEqvaRatioView> ratioListTmp = eqvaRatioMapper.getRatioList(queryTmp);
//                    if (ratioListTmp != null && ratioListTmp.size() > 0 && ratioListTmp.get(0) != null) {
//                        v.setEqvaRatio(ratioListTmp.get(0).getEqvaRatio());
//                    }
//                } else {
//                    v.setEqvaRatio(view.getEqvaRatio());//设置当量系数
//                }
//            }
//            //计算工时占用的当量
//            // 工时当量系数计算完成后，直接调用v.getEqva()方法即可
//        }
//        return tsViews.stream().collect(Collectors.toMap(TwTimesheetListView::getId, TwTimesheetListView::getEqva));
    }

    /**
     * 校验工作时间
     *
     * @param payload 有效载荷
     * @return boolean
     */
    private boolean workHourValidate(TimesheetListPayload payload) {
        //  过滤已审批、审批中状态的数据 用于校验工作小时
        Map<LocalDate, Double> resultMap =
                payload.getTimesheetList().stream()
                        .filter(timesheetPayload -> timesheetPayload.getTsStatus() != null &&
                                (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()))
                        ).collect(
                        Collectors.groupingBy(TimesheetPayload::getWorkDate,
                                Collectors.summingDouble(TimesheetPayload::getDoubleWorkHour)
                        )
                );
        List<Boolean> isValid = new ArrayList<>();

        resultMap.forEach((date, workHour) -> {
            // 根据日期查询已审批、审批中、已结算状态的工作小时，验证是否大于8
            TimesheetQuery query = new TimesheetQuery();
            query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
            query.setTsUserId(GlobalUtil.getLoginUserId());
            query.setWorkDateQuery(date);
            final List<TimesheetVO> timesheetVOList = queryList(query);
            // 已提交的工作小时
            Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
            if (workHour + wh > 8d) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    /**
     * 初始化数据
     *
     * @param payload 有效载荷
     */
    private void initData(TimesheetPayload payload) {
        // 新增情况
        //if (null == payload.getId()) {
        payload.setWorkDayOffStatus("UNGEN");
        payload.setWorkFlag("NO");
        payload.setSettleStatus("NONE");
        payload.setAutoSaveFlag(0);
        // 设置填写人为当前登录人
        payload.setTsUserId(GlobalUtil.getLoginUserId());
        // TODO 获取当前用户的组织信息
        final List<PrdOrgDataRefVO> prdOrgDataRefVOS = prdUserService.queryOrgList();
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS)) {
            final List<PrdOrgDataRefVO> list = prdOrgDataRefVOS.stream()
                    .filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                final Long orgId = list.get(0).getOrgId();
                final String orgName = list.get(0).getOrgName();
                payload.setTsUserBuId(orgId);
                payload.setTsUserBuName(orgName);
            }
        }
        //}
        if (null != payload.getProjId()) {
            final ProjectVO projectVO = projectService.queryByProjIdV4(payload.getProjId());
            if (!StringUtils.hasText(payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText(payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        // 任务 冗余翻译
        if (null != payload.getTaskId()) {
            final TaskVO taskVO = taskService.queryByTaskIdV4(payload.getTaskId());
            if (!StringUtils.hasText(payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getEqvaQty() : null);
            }
        }
        // 活动 冗余翻译
        if (null != payload.getActId()) {
            final ResActivityVO resActivityVO = resActivityService.queryByActivityIdV4(payload.getActId());
            if (!StringUtils.hasText(payload.getActNo())) {
                payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
            }
            if (!StringUtils.hasText(payload.getActName())) {
                payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
            }
        }
        // 经营计划冗余翻译
        if (null != payload.getOperPlanId()) {
            final CrmOperationPlanDetailVO planDetailVO = crmOperationPlanDetailService.queryByKey(payload.getOperPlanId());
            if (!StringUtils.hasText(payload.getOperPlanName())) {
                payload.setOperPlanName(null != planDetailVO ? planDetailVO.getPlanName() : "");
            }
        }
        payload.setApprResult(null);
        if (payload.isSubmitted()) {
            // 设置为审批中状态
            payload.setTsStatus(TimesheetStatus.APPROVING.getCode());
            // ！！！！审批资源Id
            payload.setApprUserId(findApprUserId(payload));
            // 提交时间
            if (payload.getId() != null && payload.getId() > 0) {
                TimesheetDO entity = timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull(entity.getId(), "工时不存在");
                payload.setSubmitTime(entity.getSubmitTime());
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }

        } else {
            if (payload.getId() != null && payload.getId() > 0) {
                // 非新建时，设置为原单据状态
                TimesheetDO entity = timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull(entity.getId(), "工时不存在");
                payload.setSubmitTime(entity.getSubmitTime());
                payload.setTsStatus(entity.getTsStatus());
            } else {
                // 设置为创建状态
                payload.setTsStatus(TimesheetStatus.CREATE.getCode());
            }
        }
        if (payload.getWorkDate() != null) {
            // 设置当前年周
            payload.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate())));
            // entity.setWeekStartDate(entity.getWorkDate().with(TemporalAdjusters.previousOrSame( DayOfWeek.MONDAY)));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
    }

    /**
     * 工时的审批资源ID取值 (无详设) 业务描述者:曹继旺、张勇强、薛老师
     * <p>
     * desc:
     * 1、选择了任务包，并且任务包的发包人存在，则任务包的发包人为审批人
     * 1、1 选择了任务包，如果是基于授权方法的任务包，则根据授权配置中指定的审批角色判断（PM:项目经理 PL:授权接收人）
     * 2、如果没选择任务包或者任务包的发包人为空，则项目经理作为审批人
     * 3、项目、任务包都没有选或项目经理、任务包的发包人都是空，则资源上级为审批人
     *
     * @param payload 工时
     * @return
     */
    private Long findApprUserId(TimesheetPayload payload) {
        //选择了任务包，并且任务包的发包人存在，则任务包的发包人为审批人
        if (payload.getTaskId() != null) {
            // 选择了任务包，如果是基于授权方法的任务包，则根据授权配置中指定的审批角色判断（PM:项目经理 PL:授权接收人）
            final Long apprResIdByAuthInfo = taskService.getApprResIdByAuthInfo(payload.getTaskId());
            if (null != apprResIdByAuthInfo) {
                return apprResIdByAuthInfo;
            }

            // 根据4.0任务id查询
            Long taskDister = taskService.queryByTaskIdV4(payload.getTaskId()).getDisterUserId();//任务包的发包人
            if (taskDister != null && taskDister >= 0) {
                return taskDister;
            }
        }
        //如果没选择任务包或者任务包的发包人为空，则项目经理作为审批人
        if (payload.getProjId() != null) {
            ProjectQuery twProjectQuery = new ProjectQuery();
            twProjectQuery.setProjIdV4(payload.getProjId());
            final List<ProjectVO> projects = projectService.queryList(twProjectQuery);
            if (projects != null && projects.size() > 0) {
                Long pmId = projects.get(0).getPmUserId();
                if (pmId != null && pmId > 0) {
                    return pmId;
                }
            }
        }

        /*if (entity.getTaskId() != null) {//选了任务包，审批人为任务包的发包者
            return taskMapper.findTask(entity.getTaskId()).getDisterResId();
        }*/
        //项目、任务包都没有选或项目经理、任务包的发包人都是空，则资源上级为审批人
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(payload.getTsUserId());
        if (null == prdOrgEmployeeRefVO) {
            log.error("【匹配不到审批人】：工时填报用户主键：{} ; 工时数据：{}", payload.getTsUserId(), payload);
            throw TwException.error("", "匹配不到审批人，请联系管理员");
            //  查找自己的上级、管理员没有上级的情况就是自己
            //return payload.getTsUserId();
        }
        //查找资源的父id
        Long parentId = prdOrgEmployeeRefVO.getParentId();
        return parentId;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetVO update(TimesheetPayload payload) {
        if (payload.getProjId() != null) {
            final ProjectVO projectVO = projectService.queryByProjIdV4(payload.getProjId());
            if (StringUtils.hasText(payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (StringUtils.hasText(payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (payload.getTaskId() != null) {
            final TaskVO taskVO = taskService.queryByTaskIdV4(payload.getTaskId());
            if (StringUtils.hasText(payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (StringUtils.hasText(payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getEqvaQty() : null);
            }
        }
        TimesheetDO entity = timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
        Assert.notNull(entity.getId(), "工时不存在");
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetConvert.INSTANCE.toVo(timesheetRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    // 判断状态是否为创建
                    if (!TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus()) &&
                            !TimesheetStatus.REJECTED.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只能删除状态为创建或者退回的工时");
                    }
                    entity.setDeleteFlag(1);
                    timesheetRepo.save(entity);
                }
            });
        }
    }

    /**
     * 审批通过
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void toApproved(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中的单据才允许审批通过");
                    }
                    if (!GlobalUtil.getLoginUserId().equals(entity.getApprUserId())) {
                        throw TwException.error("", "审批人错误");
                    }
                    entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                    entity.setApprResult("审批通过");
                    timesheetRepo.save(entity);
                }
            });
        }
    }

    /**
     * 高级审批
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void toAdvanced(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中或新建的单据才允许审批通过");
                    }
                    entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                    entity.setApprResult("审批通过");
                    timesheetRepo.save(entity);

                }
            });
        }
    }

    /**
     * 审批拒绝
     *
     * @param keys       键
     * @param apprResult 从结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void rejected(List<Long> keys, String apprResult) {
        if (!keys.isEmpty()) {
            List<Long> taskIdList = new ArrayList<>();
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中的单据才允许审批拒绝");
                    }
                    if (!GlobalUtil.getLoginUserId().equals(entity.getApprUserId())) {
                        throw TwException.error("", "审批人错误");
                    }
                    entity.setTsStatus(TimesheetStatus.REJECTED.getCode());
                    entity.setApprResult(apprResult);
                    timesheetRepo.save(entity);

                    // 更新任务包工时当量信息
                    final Long taskId = entity.getTaskId();
                    if (null != taskId && taskId > 0) {
                        taskIdList.add(taskId);
                    }

                }
            });
            if (!CollectionUtils.isEmpty(taskIdList)) {
                updateTaskTimesheetEqva(taskIdList);
            }
        }
    }

    /**
     * 撤回
     *
     * @param keys 键
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void revoked(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<Long> taskIdList = new ArrayList<>();
            keys.stream().forEach(id -> {
                Optional<TimesheetDO> optional = timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = optional.get();
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "只有审批中的单据才允许撤回");
                    }

                    entity.setTsStatus(TimesheetStatus.CREATE.getCode());
                    entity.setApprUserId(null);
                    entity.setApprResult("审批撤回");
                    timesheetRepo.save(entity);

                    // 更新任务包工时当量信息
                    final Long taskId = entity.getTaskId();
                    if (null != taskId && taskId > 0) {
                        taskIdList.add(taskId);
                    }

                }
            });

            if (!CollectionUtils.isEmpty(taskIdList)) {
                updateTaskTimesheetEqva(taskIdList);
            }
        }
    }

    /**
     * 更新任务包工时当量信息
     *
     * @param taskIdList 任务id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateTaskTimesheetEqva(List<Long> taskIdList) {
        if (!CollectionUtils.isEmpty(taskIdList)) {
            //计算任务包当量 原始发包当量、追加当量、被工时用掉的当量、剩余还可以用来填报的当量
            TaskQuery query = new TaskQuery();
            query.setTaskIdV4List(taskIdList);

            final List<TaskVO> taskList = taskService.queryList(query);
            Map<Long, BigDecimal> tsUsedEqvaMap = calTsUsedEqvasByIds(taskIdList);//任务包已经被工时用掉的当量
            Map<Long, BigDecimal> tsEffectiveEqva = taskList.stream().map(t -> {
                if (tsUsedEqvaMap != null) {
                    t.setTsUsedEqva(tsUsedEqvaMap.get(t.getTaskIdV4()));
                }
                return t;
            }).collect(Collectors.toMap(TaskVO::getTaskIdV4, TaskVO::getTsEffectiveEqva));// 计算任务包剩余可用于填报工时的当量
            // 去重
            Set<Long> taskIdsSet = new HashSet<>();
            taskIdsSet.addAll(taskIdList);
            for (Long taskId : taskIdsSet) {
                //计算任务包剩余可用于填报工时的当量
                BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
                if (null != tsEffecttiveEqva) {
                    taskRepo.updateTaskEffectiveEqva(taskId, tsEffecttiveEqva);
                }
                //计算任务包已填工时当量
                BigDecimal usedEqva = BigDecimal.ZERO;
                if (null != tsUsedEqvaMap) {
                    usedEqva = tsUsedEqvaMap.get(taskId) != null ? tsUsedEqvaMap.get(taskId) : BigDecimal.ZERO;
                }
                taskRepo.updateUsedEqva(taskId, usedEqva);
            }
        }
    }

    @Override
    public Map<Long, Long> getTimesheetAndPlanIds() {
        Map<Long, Long> orgMap = new HashMap<>();
        List<Map<String, Object>> timeSheetAndPlanIds = timesheetRepo.getTimesheetAndPlanIds();
        for (Map<String, Object> timesheetAndPlanId : timeSheetAndPlanIds) {
            Long timesheetId = (Long) timesheetAndPlanId.get("timesheetId");
            Long workPlanId = (Long) timesheetAndPlanId.get("workPlanId");
            if (timesheetId != null && workPlanId != null) {
                orgMap.put(timesheetId, workPlanId);
            }
        }
        return orgMap;
    }

    @Override
    public Map<Long, Long> getV4AndV5TimesheetIds() {
        Map<Long, Long> timesheetMap = new HashMap<>();
        List<Map<String, Object>> v4AndV5TimesheetIds = timesheetRepo.getV4AndV5TimesheetIds();
        for (Map<String, Object> v4AndV5TimesheetId : v4AndV5TimesheetIds) {
            Long timesheetId = (Long) v4AndV5TimesheetId.get("timesheetId");
            Long timesheetIdV4 = (Long) v4AndV5TimesheetId.get("timesheetIdV4");
            if (timesheetId != null && timesheetIdV4 != null) {
                timesheetMap.put(timesheetIdV4, timesheetId);
            }
        }
        return timesheetMap;
    }

    ;

}
