package com.elitesland.tw.tw5.server.prd.org.controller;

import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgSyncDataService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * 同步数据测试
 *
 * @author wangding
 */
@Api("维度版本管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_ORG)
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgTestController {

    private final PrdOrgSyncDataService service;
    private final CrmOpportunityDAO opportunityDAO;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    @Value("${tw4.opportunity.operation}")
    private String opportunity_operation;

    /**
     * 同步用户数据
     *
     * @return result
     */
    @GetMapping("/test/syncUsers")


    public TwOutputUtil syncUsers() {
        service.syncUsers();
        return TwOutputUtil.ok();
    }

    /**
     * 同组织数据
     *
     * @return result
     */
    @GetMapping("/test/syncOrgs")
    public TwOutputUtil syncOrgs() {
        service.syncOrgs();
        return TwOutputUtil.ok();
    }

    /**
     * 同步组织员工关系数据
     *
     * @return result
     */
    @GetMapping("/test/syncOrgRefUsers")
    public TwOutputUtil syncOrgRefUsers() {
        service.syncOrgRefUsers();
        return TwOutputUtil.ok();
    }


    /**
     * 同步组织员工关系数据
     *
     * @return result
     */
    @GetMapping("/test/syncTasks")
    public TwOutputUtil syncTasks(String param) {
        service.syncTasks(param);
        return TwOutputUtil.ok();
    }

    /**
     * 同步活动
     *
     * @return result
     */
    @GetMapping("/test/syncActivity")
    public TwOutputUtil syncActivity() {
        service.syncActivity();
        return TwOutputUtil.ok();
    }


    /**
     * 任务包授权同步
     *
     * @return result
     */
    @GetMapping("/test/syncTaskAuthorized")
    public TwOutputUtil syncTaskAuthorized() {
        service.syncTaskAuthorized();
        return TwOutputUtil.ok();
    }

    /**
     * 任务包授权明细
     *
     * @return result
     */
    @GetMapping("/test/syncTaskAuthorizedDetails")
    public TwOutputUtil syncTaskAuthorizedDetails() {
        service.syncTaskAuthorizedDetails();
        return TwOutputUtil.ok();
    }

    /**
     * 项目同步
     *
     * @return result
     */
    @GetMapping("/test/syncProject")
    public TwOutputUtil syncProject() {
        service.syncProjects();
        return TwOutputUtil.ok();
    }

    /**
     * 项目成员同步
     *
     * @return result
     */
    @GetMapping("/test/syncProjSh")
    public TwOutputUtil syncProjSh() {
        service.syncProjSh();
        return TwOutputUtil.ok();
    }

    /**
     * 工时同步
     *
     * @return result
     */
    @GetMapping("/test/syncTimesheet")
    public TwOutputUtil syncTimesheet() {
        service.syncTimesheetDataTo4();
        return TwOutputUtil.ok();
    }


    /**
     * 工时定时任务
     *
     * @return 定时任务执行结果
     */
    @GetMapping("/test/syncVacationTimesheetTo5")
    public TwOutputUtil syncTimesheetTo5() {
        service.syncVacationTimesheetDataTo5();
        return TwOutputUtil.ok();
    }


    /**
     * 商机数据修复
     *
     * @return result
     */
    @GetMapping("/test/syncOppoFix")
    public TwOutputUtil syncOppoFix() {
        CrmOpportunityQuery query = new CrmOpportunityQuery();
//        query.setOppoIdsV4(Arrays.asList(2267L,2271L,2272L,2273L,2275L,2276L,2277L,2278L,2281L,2284L,2293L,2298L,2299L,2304L,2317L,2318L,2320L,2323L,2324L,2329L,2341L,2344L,2345L,2482L,2483L,2485L,2486L,2488L,2489L,2492L,2493L,2495L,2496L,2497L,2498L,2501L,2502L,2503L,2504L,2505L,2506L,2507L,2508L,2509L));//更新4.0错误数据
        query.setOppoIdsV4(Arrays.asList(32L,983L,1044L,1123L,1248L,1595L,1696L,1720L,1749L,1754L,2073L,2116L,2159L,2250L,2311L,2313L,2317L,2385L,2390L,2426L,2457L,2489L,2517L,2563L,2575L,2602L,2635L,2647L,2655L,2658L,2661L,2685L,2707L,2734L,2735L,2750L,2753L,2754L,2755L,2768L,2769L,2771L,2789L,2793L,2798L,2801L,2817L,2819L,2834L,2842L,2844L,2849L,2852L,2860L,2873L,2878L,2882L,2894L,2895L,2896L,2897L,2912L,2922L,2926L,2927L,2930L,2931L,2932L,2941L,2945L,2954L,2955L,2956L,2961L,2966L,2976L,2979L,2981L,2988L,2990L,2993L,2999L,3004L,3007L,3012L,3014L,3023L,3035L,3038L,3043L,3050L,3052L,3055L,3057L,3066L,3068L,3071L,3078L,3079L,3080L,3081L,3083L,3084L,3086L,3088L,3093L,3099L,3105L,3110L,3111L,3113L,3114L,3115L,3116L,3118L,3119L,3121L,3123L,3126L,3127L,3130L,3133L,3135L,3136L,3141L,3143L,3147L,3148L,3149L,3151L,3153L,3155L,3157L,3161L,3162L,3164L,3166L,3168L,3171L,3172L,3173L,3176L,3177L,3178L,3181L,3182L,3184L,3186L,3194L,3196L,3197L,3200L,3204L,3205L,3206L,3207L,3208L,3209L,3210L,3213L,3215L,3216L,3217L,3219L,3224L,3225L,3227L,3229L,3230L,3231L,3247L,3248L,3249L,3251L,3252L,3253L,3257L,3259L,3260L,3264L,3269L,3270L,3272L,3278L,3279L,3281L,3289L,3290L,3292L,3298L,3299L,3304L,3305L,3306L,3310L,3316L,3320L,3321L,3323L,3324L,3326L,3327L,3331L,3337L,3339L,3341L,3342L,3347L,3351L,3353L,3356L,3358L,3361L,3370L,3376L,3377L,3379L,3385L,3386L,3390L,3391L,3392L,3397L,3398L,3400L,3405L,3409L,3410L,3414L,3419L,3420L,3421L,3424L,3429L,3433L,3434L,3437L,3442L,3444L,3450L,3456L,3458L,3463L,3470L,3472L,3475L,3479L,3480L,3486L,3487L,3488L,3489L,3493L,3494L,3495L,3508L,3511L,3515L,3516L,3517L,3520L,3525L,3526L,3531L,3533L,3534L,3537L,3587L,3588L,3604L));
        List<CrmOpportunityVO> opportunityVOList = opportunityDAO.queryList(query,null,null);
//        List<CrmOpportunityPayload> collect = opportunityVOList.stream().map(e -> CrmOpportunityConvert.INSTANCE.toPayload(e)).collect(Collectors.toList());
//        for (CrmOpportunityVO crmOpportunityPayload : opportunityVOList) {
//            //同步到4.0
//            Map<String, Object> map = transferUtilService.beanToMap(crmOpportunityPayload);
//            CrmActProjectVO project = opportunityDAO.queryProjectBykey(crmOpportunityPayload.getId());
//            map.put("id", project.getOppoIdV4());
//            httpUtil.sendSyncPost(opportunity_operation, map);
//        }
        return TwOutputUtil.ok();
    }


}
