package com.elitesland.tw.tw5.server.prd.org.repo;

import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Repository
public interface PrdOrgOrganizationRepo extends JpaRepository<PrdOrgOrganizationDO, Long>, QuerydslPredicateExecutor<PrdOrgOrganizationDO> {

    @Query(value = "select id from PrdOrgOrganizationDO where orgIdV4 = ?1 and deleteFlag=0 and changeId=0")
    Long getOrgIdByV4(Long orgIdV4);

    Optional<PrdOrgOrganizationDO> queryByOrgCodeAndDeleteFlagAndIsCopy(String code, Integer flag,Integer isCopy);

    Optional<PrdOrgOrganizationDO> queryByIdAndDeleteFlagAndIsCopy(Long id, Integer flag,Integer isCopy);


    /**
     * 查询组织数据
     *
     * @param orgIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id ,org_name as orgName FROM prd_org_organization  where id in (?1) and delete_flag=0")
    List<Map<String, Object>> queryOrgs(List<Long> orgIds);

    @Query("select id as orgId,orgIdV4 as orgIdV4 from PrdOrgOrganizationDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5OrgIds();
}
